/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.spdy.SpdyDataFrame;
import org.jboss.netty.util.internal.StringUtil;

public class DefaultSpdyDataFrame
implements SpdyDataFrame {
    private int streamID;
    private boolean last;
    private boolean compressed;
    private ChannelBuffer data = ChannelBuffers.EMPTY_BUFFER;

    public DefaultSpdyDataFrame(int streamID) {
        this.setStreamID(streamID);
    }

    public int getStreamID() {
        return this.streamID;
    }

    public void setStreamID(int streamID) {
        if (streamID <= 0) {
            throw new IllegalArgumentException("Stream-ID must be positive: " + streamID);
        }
        this.streamID = streamID;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last2) {
        this.last = last2;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public ChannelBuffer getData() {
        return this.data;
    }

    public void setData(ChannelBuffer data2) {
        if (data2 == null) {
            data2 = ChannelBuffers.EMPTY_BUFFER;
        }
        if (data2.readableBytes() > 0xFFFFFF) {
            throw new IllegalArgumentException("data payload cannot exceed 16777215 bytes");
        }
        this.data = data2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(last: ");
        buf.append(this.isLast());
        buf.append("; compressed: ");
        buf.append(this.isCompressed());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Stream-ID = ");
        buf.append(this.streamID);
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Size = ");
        buf.append(this.data.readableBytes());
        return buf.toString();
    }
}

