/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.serialization;

import java.util.Map;
import org.jboss.netty.handler.codec.serialization.ClassResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CachingClassResolver
implements ClassResolver {
    private final Map<String, Class<?>> classCache;
    private final ClassResolver delegate;

    CachingClassResolver(ClassResolver delegate, Map<String, Class<?>> classCache) {
        this.delegate = delegate;
        this.classCache = classCache;
    }

    @Override
    public Class<?> resolve(String className) throws ClassNotFoundException {
        Class<?> clazz2 = this.classCache.get(className);
        if (clazz2 != null) {
            return clazz2;
        }
        clazz2 = this.delegate.resolve(className);
        this.classCache.put(className, clazz2);
        return clazz2;
    }
}

