/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.replay;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBufferIndexFinder;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.replay.ReplayError;
import org.jboss.netty.handler.codec.replay.UnreplayableOperationException;

class ReplayingDecoderBuffer
implements ChannelBuffer {
    private static final Error REPLAY = new ReplayError();
    private final ChannelBuffer buffer;
    private boolean terminated;
    public static ReplayingDecoderBuffer EMPTY_BUFFER = new ReplayingDecoderBuffer(ChannelBuffers.EMPTY_BUFFER);

    ReplayingDecoderBuffer(ChannelBuffer buffer2) {
        this.buffer = buffer2;
    }

    void terminate() {
        this.terminated = true;
    }

    public int capacity() {
        if (this.terminated) {
            return this.buffer.capacity();
        }
        return Integer.MAX_VALUE;
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnreplayableOperationException();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int compareTo(ChannelBuffer buffer2) {
        throw new UnreplayableOperationException();
    }

    public ChannelBuffer copy() {
        throw new UnreplayableOperationException();
    }

    public ChannelBuffer copy(int index2, int length) {
        this.checkIndex(index2, length);
        return this.buffer.copy(index2, length);
    }

    public void discardReadBytes() {
        throw new UnreplayableOperationException();
    }

    public void ensureWritableBytes(int writableBytes) {
        throw new UnreplayableOperationException();
    }

    public ChannelBuffer duplicate() {
        throw new UnreplayableOperationException();
    }

    public byte getByte(int index2) {
        this.checkIndex(index2);
        return this.buffer.getByte(index2);
    }

    public short getUnsignedByte(int index2) {
        this.checkIndex(index2);
        return this.buffer.getUnsignedByte(index2);
    }

    public void getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index2, length);
        this.buffer.getBytes(index2, dst, dstIndex, length);
    }

    public void getBytes(int index2, byte[] dst) {
        this.checkIndex(index2, dst.length);
        this.buffer.getBytes(index2, dst);
    }

    public void getBytes(int index2, ByteBuffer dst) {
        throw new UnreplayableOperationException();
    }

    public void getBytes(int index2, ChannelBuffer dst, int dstIndex, int length) {
        this.checkIndex(index2, length);
        this.buffer.getBytes(index2, dst, dstIndex, length);
    }

    public void getBytes(int index2, ChannelBuffer dst, int length) {
        throw new UnreplayableOperationException();
    }

    public void getBytes(int index2, ChannelBuffer dst) {
        throw new UnreplayableOperationException();
    }

    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    public void getBytes(int index2, OutputStream out, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    public int getInt(int index2) {
        this.checkIndex(index2, 4);
        return this.buffer.getInt(index2);
    }

    public long getUnsignedInt(int index2) {
        this.checkIndex(index2, 4);
        return this.buffer.getUnsignedInt(index2);
    }

    public long getLong(int index2) {
        this.checkIndex(index2, 8);
        return this.buffer.getLong(index2);
    }

    public int getMedium(int index2) {
        this.checkIndex(index2, 3);
        return this.buffer.getMedium(index2);
    }

    public int getUnsignedMedium(int index2) {
        this.checkIndex(index2, 3);
        return this.buffer.getUnsignedMedium(index2);
    }

    public short getShort(int index2) {
        this.checkIndex(index2, 2);
        return this.buffer.getShort(index2);
    }

    public int getUnsignedShort(int index2) {
        this.checkIndex(index2, 2);
        return this.buffer.getUnsignedShort(index2);
    }

    public char getChar(int index2) {
        this.checkIndex(index2, 2);
        return this.buffer.getChar(index2);
    }

    public float getFloat(int index2) {
        this.checkIndex(index2, 4);
        return this.buffer.getFloat(index2);
    }

    public double getDouble(int index2) {
        this.checkIndex(index2, 8);
        return this.buffer.getDouble(index2);
    }

    public int hashCode() {
        throw new UnreplayableOperationException();
    }

    public int indexOf(int fromIndex, int toIndex, byte value2) {
        int endIndex = this.buffer.indexOf(fromIndex, toIndex, value2);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return endIndex;
    }

    public int indexOf(int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        int endIndex = this.buffer.indexOf(fromIndex, toIndex, indexFinder);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return endIndex;
    }

    public int bytesBefore(byte value2) {
        int bytes2 = this.buffer.bytesBefore(value2);
        if (bytes2 < 0) {
            throw REPLAY;
        }
        return bytes2;
    }

    public int bytesBefore(ChannelBufferIndexFinder indexFinder) {
        int bytes2 = this.buffer.bytesBefore(indexFinder);
        if (bytes2 < 0) {
            throw REPLAY;
        }
        return bytes2;
    }

    public int bytesBefore(int length, byte value2) {
        this.checkReadableBytes(length);
        int bytes2 = this.buffer.bytesBefore(length, value2);
        if (bytes2 < 0) {
            throw REPLAY;
        }
        return bytes2;
    }

    public int bytesBefore(int length, ChannelBufferIndexFinder indexFinder) {
        this.checkReadableBytes(length);
        int bytes2 = this.buffer.bytesBefore(length, indexFinder);
        if (bytes2 < 0) {
            throw REPLAY;
        }
        return bytes2;
    }

    public int bytesBefore(int index2, int length, byte value2) {
        int bytes2 = this.buffer.bytesBefore(index2, length, value2);
        if (bytes2 < 0) {
            throw REPLAY;
        }
        return bytes2;
    }

    public int bytesBefore(int index2, int length, ChannelBufferIndexFinder indexFinder) {
        int bytes2 = this.buffer.bytesBefore(index2, length, indexFinder);
        if (bytes2 < 0) {
            throw REPLAY;
        }
        return bytes2;
    }

    public void markReaderIndex() {
        this.buffer.markReaderIndex();
    }

    public void markWriterIndex() {
        throw new UnreplayableOperationException();
    }

    public ChannelBufferFactory factory() {
        return this.buffer.factory();
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public boolean readable() {
        return this.terminated ? this.buffer.readable() : true;
    }

    public int readableBytes() {
        if (this.terminated) {
            return this.buffer.readableBytes();
        }
        return Integer.MAX_VALUE - this.buffer.readerIndex();
    }

    public byte readByte() {
        this.checkReadableBytes(1);
        return this.buffer.readByte();
    }

    public short readUnsignedByte() {
        this.checkReadableBytes(1);
        return this.buffer.readUnsignedByte();
    }

    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.buffer.readBytes(dst, dstIndex, length);
    }

    public void readBytes(byte[] dst) {
        this.checkReadableBytes(dst.length);
        this.buffer.readBytes(dst);
    }

    public void readBytes(ByteBuffer dst) {
        throw new UnreplayableOperationException();
    }

    public void readBytes(ChannelBuffer dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.buffer.readBytes(dst, dstIndex, length);
    }

    public void readBytes(ChannelBuffer dst, int length) {
        throw new UnreplayableOperationException();
    }

    public void readBytes(ChannelBuffer dst) {
        throw new UnreplayableOperationException();
    }

    @Deprecated
    public ChannelBuffer readBytes(ChannelBufferIndexFinder endIndexFinder) {
        int endIndex = this.buffer.indexOf(this.buffer.readerIndex(), this.buffer.writerIndex(), endIndexFinder);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return this.buffer.readBytes(endIndex - this.buffer.readerIndex());
    }

    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    public ChannelBuffer readBytes(int length) {
        this.checkReadableBytes(length);
        return this.buffer.readBytes(length);
    }

    @Deprecated
    public ChannelBuffer readSlice(ChannelBufferIndexFinder endIndexFinder) {
        int endIndex = this.buffer.indexOf(this.buffer.readerIndex(), this.buffer.writerIndex(), endIndexFinder);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return this.buffer.readSlice(endIndex - this.buffer.readerIndex());
    }

    public ChannelBuffer readSlice(int length) {
        this.checkReadableBytes(length);
        return this.buffer.readSlice(length);
    }

    public void readBytes(OutputStream out, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    public void readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
    }

    public int readInt() {
        this.checkReadableBytes(4);
        return this.buffer.readInt();
    }

    public long readUnsignedInt() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedInt();
    }

    public long readLong() {
        this.checkReadableBytes(8);
        return this.buffer.readLong();
    }

    public int readMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readMedium();
    }

    public int readUnsignedMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMedium();
    }

    public short readShort() {
        this.checkReadableBytes(2);
        return this.buffer.readShort();
    }

    public int readUnsignedShort() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShort();
    }

    public char readChar() {
        this.checkReadableBytes(2);
        return this.buffer.readChar();
    }

    public float readFloat() {
        this.checkReadableBytes(4);
        return this.buffer.readFloat();
    }

    public double readDouble() {
        this.checkReadableBytes(8);
        return this.buffer.readDouble();
    }

    public void resetReaderIndex() {
        this.buffer.resetReaderIndex();
    }

    public void resetWriterIndex() {
        throw new UnreplayableOperationException();
    }

    public void setByte(int index2, int value2) {
        throw new UnreplayableOperationException();
    }

    public void setBytes(int index2, byte[] src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    public void setBytes(int index2, byte[] src) {
        throw new UnreplayableOperationException();
    }

    public void setBytes(int index2, ByteBuffer src) {
        throw new UnreplayableOperationException();
    }

    public void setBytes(int index2, ChannelBuffer src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    public void setBytes(int index2, ChannelBuffer src, int length) {
        throw new UnreplayableOperationException();
    }

    public void setBytes(int index2, ChannelBuffer src) {
        throw new UnreplayableOperationException();
    }

    public int setBytes(int index2, InputStream in, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    public void setZero(int index2, int length) {
        throw new UnreplayableOperationException();
    }

    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    public void setIndex(int readerIndex, int writerIndex) {
        throw new UnreplayableOperationException();
    }

    public void setInt(int index2, int value2) {
        throw new UnreplayableOperationException();
    }

    public void setLong(int index2, long value2) {
        throw new UnreplayableOperationException();
    }

    public void setMedium(int index2, int value2) {
        throw new UnreplayableOperationException();
    }

    public void setShort(int index2, int value2) {
        throw new UnreplayableOperationException();
    }

    public void setChar(int index2, int value2) {
        throw new UnreplayableOperationException();
    }

    public void setFloat(int index2, float value2) {
        throw new UnreplayableOperationException();
    }

    public void setDouble(int index2, double value2) {
        throw new UnreplayableOperationException();
    }

    @Deprecated
    public int skipBytes(ChannelBufferIndexFinder firstIndexFinder) {
        int oldReaderIndex = this.buffer.readerIndex();
        int newReaderIndex = this.buffer.indexOf(oldReaderIndex, this.buffer.writerIndex(), firstIndexFinder);
        if (newReaderIndex < 0) {
            throw REPLAY;
        }
        this.buffer.readerIndex(newReaderIndex);
        return newReaderIndex - oldReaderIndex;
    }

    public void skipBytes(int length) {
        this.checkReadableBytes(length);
        this.buffer.skipBytes(length);
    }

    public ChannelBuffer slice() {
        throw new UnreplayableOperationException();
    }

    public ChannelBuffer slice(int index2, int length) {
        this.checkIndex(index2, length);
        return this.buffer.slice(index2, length);
    }

    public ByteBuffer toByteBuffer() {
        throw new UnreplayableOperationException();
    }

    public ByteBuffer toByteBuffer(int index2, int length) {
        this.checkIndex(index2, length);
        return this.buffer.toByteBuffer(index2, length);
    }

    public ByteBuffer[] toByteBuffers() {
        throw new UnreplayableOperationException();
    }

    public ByteBuffer[] toByteBuffers(int index2, int length) {
        this.checkIndex(index2, length);
        return this.buffer.toByteBuffers(index2, length);
    }

    public String toString(int index2, int length, Charset charset) {
        this.checkIndex(index2, length);
        return this.buffer.toString(index2, length, charset);
    }

    public String toString(Charset charsetName) {
        throw new UnreplayableOperationException();
    }

    @Deprecated
    public String toString(int index2, int length, String charsetName) {
        this.checkIndex(index2, length);
        return this.buffer.toString(index2, length, charsetName);
    }

    @Deprecated
    public String toString(int index2, int length, String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        this.checkIndex(index2, length);
        return this.buffer.toString(index2, length, charsetName, terminatorFinder);
    }

    @Deprecated
    public String toString(String charsetName) {
        throw new UnreplayableOperationException();
    }

    @Deprecated
    public String toString(String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        throw new UnreplayableOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + "ridx=" + this.readerIndex() + ", " + "widx=" + this.writerIndex() + ')';
    }

    public boolean writable() {
        return false;
    }

    public int writableBytes() {
        return 0;
    }

    public void writeByte(int value2) {
        throw new UnreplayableOperationException();
    }

    public void writeBytes(byte[] src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    public void writeBytes(byte[] src) {
        throw new UnreplayableOperationException();
    }

    public void writeBytes(ByteBuffer src) {
        throw new UnreplayableOperationException();
    }

    public void writeBytes(ChannelBuffer src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    public void writeBytes(ChannelBuffer src, int length) {
        throw new UnreplayableOperationException();
    }

    public void writeBytes(ChannelBuffer src) {
        throw new UnreplayableOperationException();
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    public void writeInt(int value2) {
        throw new UnreplayableOperationException();
    }

    public void writeLong(long value2) {
        throw new UnreplayableOperationException();
    }

    public void writeMedium(int value2) {
        throw new UnreplayableOperationException();
    }

    public void writeZero(int length) {
        throw new UnreplayableOperationException();
    }

    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    public void writerIndex(int writerIndex) {
        throw new UnreplayableOperationException();
    }

    public void writeShort(int value2) {
        throw new UnreplayableOperationException();
    }

    public void writeChar(int value2) {
        throw new UnreplayableOperationException();
    }

    public void writeFloat(float value2) {
        throw new UnreplayableOperationException();
    }

    public void writeDouble(double value2) {
        throw new UnreplayableOperationException();
    }

    private void checkIndex(int index2) {
        if (index2 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkIndex(int index2, int length) {
        if (index2 + length > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkReadableBytes(int readableBytes) {
        if (this.buffer.readableBytes() < readableBytes) {
            throw REPLAY;
        }
    }

    static {
        EMPTY_BUFFER.terminate();
    }
}

