/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.replay;

import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.replay.ReplayError;
import org.jboss.netty.handler.codec.replay.ReplayingDecoderBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReplayingDecoder<T extends Enum<T>>
extends SimpleChannelUpstreamHandler {
    private ChannelBuffer cumulation;
    private final boolean unfold;
    private ReplayingDecoderBuffer replayable;
    private T state;
    private int checkpoint;

    protected ReplayingDecoder() {
        this(null);
    }

    protected ReplayingDecoder(boolean unfold) {
        this(null, unfold);
    }

    protected ReplayingDecoder(T initialState) {
        this(initialState, false);
    }

    protected ReplayingDecoder(T initialState, boolean unfold) {
        this.state = initialState;
        this.unfold = unfold;
    }

    protected void checkpoint() {
        ChannelBuffer cumulation = this.cumulation;
        this.checkpoint = cumulation != null ? cumulation.readerIndex() : -1;
    }

    protected void checkpoint(T state) {
        this.checkpoint();
        this.setState(state);
    }

    protected T getState() {
        return this.state;
    }

    protected T setState(T newState) {
        T oldState = this.state;
        this.state = newState;
        return oldState;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ChannelBuffer internalBuffer() {
        ChannelBuffer buf = this.cumulation;
        if (buf == null) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return buf;
    }

    protected abstract Object decode(ChannelHandlerContext var1, Channel var2, ChannelBuffer var3, T var4) throws Exception;

    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer2, T state) throws Exception {
        return this.decode(ctx, channel, buffer2, state);
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object m = e.getMessage();
        if (!(m instanceof ChannelBuffer)) {
            ctx.sendUpstream(e);
            return;
        }
        ChannelBuffer input2 = (ChannelBuffer)m;
        if (!input2.readable()) {
            return;
        }
        if (this.cumulation == null) {
            this.cumulation = input2;
            this.replayable = new ReplayingDecoderBuffer(input2);
            int oldReaderIndex = input2.readerIndex();
            int inputSize = input2.readableBytes();
            this.callDecode(ctx, e.getChannel(), input2, this.replayable, e.getRemoteAddress());
            if (input2.readable()) {
                ChannelBuffer cumulation;
                if (this.checkpoint > 0) {
                    int bytesToPreserve = inputSize - (this.checkpoint - oldReaderIndex);
                    cumulation = this.cumulation = this.newCumulationBuffer(ctx, bytesToPreserve);
                    cumulation.writeBytes(input2, this.checkpoint, bytesToPreserve);
                } else if (this.checkpoint == 0) {
                    cumulation = this.cumulation = this.newCumulationBuffer(ctx, inputSize);
                    cumulation.writeBytes(input2, oldReaderIndex, inputSize);
                    cumulation.readerIndex(input2.readerIndex());
                } else {
                    cumulation = this.cumulation = this.newCumulationBuffer(ctx, input2.readableBytes());
                    cumulation.writeBytes(input2);
                }
                this.replayable = new ReplayingDecoderBuffer(cumulation);
            } else {
                this.cumulation = null;
                this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
            }
        } else {
            ChannelBuffer cumulation = this.cumulation;
            assert (cumulation.readable());
            if (cumulation.writableBytes() < input2.readableBytes()) {
                cumulation.discardReadBytes();
            }
            cumulation.writeBytes(input2);
            this.callDecode(ctx, e.getChannel(), cumulation, this.replayable, e.getRemoteAddress());
            if (!cumulation.readable()) {
                this.cumulation = null;
                this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
            }
        }
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.cleanup(ctx, e);
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.cleanup(ctx, e);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    private void callDecode(ChannelHandlerContext context, Channel channel, ChannelBuffer input2, ChannelBuffer replayableInput, SocketAddress remoteAddress) throws Exception {
        while (input2.readable()) {
            T oldState;
            Object result2;
            int oldReaderIndex;
            block5: {
                oldReaderIndex = this.checkpoint = input2.readerIndex();
                result2 = null;
                oldState = this.state;
                try {
                    result2 = this.decode(context, channel, replayableInput, this.state);
                    if (result2 == null) {
                        if (oldReaderIndex != input2.readerIndex() || oldState != this.state) continue;
                        throw new IllegalStateException("null cannot be returned if no data is consumed and state didn't change.");
                    }
                }
                catch (ReplayError replay) {
                    int checkpoint = this.checkpoint;
                    if (checkpoint < 0) break block5;
                    input2.readerIndex(checkpoint);
                }
            }
            if (result2 == null) break;
            if (oldReaderIndex == input2.readerIndex() && oldState == this.state) {
                throw new IllegalStateException("decode() method must consume at least one byte if it returned a decoded message (caused by: " + this.getClass() + ")");
            }
            this.unfoldAndFireMessageReceived(context, result2, remoteAddress);
        }
    }

    private void unfoldAndFireMessageReceived(ChannelHandlerContext context, Object result2, SocketAddress remoteAddress) {
        if (this.unfold) {
            if (result2 instanceof Object[]) {
                for (Object r : (Object[])result2) {
                    Channels.fireMessageReceived(context, r, remoteAddress);
                }
            } else if (result2 instanceof Iterable) {
                for (Object r : (Iterable)result2) {
                    Channels.fireMessageReceived(context, r, remoteAddress);
                }
            } else {
                Channels.fireMessageReceived(context, result2, remoteAddress);
            }
        } else {
            Channels.fireMessageReceived(context, result2, remoteAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            Object partiallyDecoded;
            ChannelBuffer cumulation = this.cumulation;
            if (cumulation == null) {
                return;
            }
            this.cumulation = null;
            this.replayable.terminate();
            if (cumulation != null && cumulation.readable()) {
                this.callDecode(ctx, e.getChannel(), cumulation, this.replayable, null);
            }
            if ((partiallyDecoded = this.decodeLast(ctx, e.getChannel(), this.replayable, this.state)) != null) {
                this.unfoldAndFireMessageReceived(ctx, partiallyDecoded, null);
            }
        }
        catch (ReplayError replayError) {
        }
        finally {
            this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
            ctx.sendUpstream(e);
        }
    }

    protected ChannelBuffer newCumulationBuffer(ChannelHandlerContext ctx, int minimumCapacity) {
        ChannelBufferFactory factory = ctx.getChannel().getConfig().getBufferFactory();
        return ChannelBuffers.dynamicBuffer(factory.getDefaultOrder(), Math.max(minimumCapacity, 256), factory);
    }
}

