/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.websocketx;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.base64.Base64;
import org.jboss.netty.util.CharsetUtil;

final class WebSocketUtil {
    static byte[] md5(byte[] bytes2) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(bytes2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("MD5 not supported on this platform");
        }
    }

    static byte[] sha1(byte[] bytes2) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            return md.digest(bytes2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("SHA-1 not supported on this platform");
        }
    }

    static String base64(byte[] bytes2) {
        ChannelBuffer hashed = ChannelBuffers.wrappedBuffer(bytes2);
        return Base64.encode(hashed).toString(CharsetUtil.UTF_8);
    }

    static byte[] randomBytes(int size2) {
        byte[] bytes2 = new byte[size2];
        for (int i = 0; i < size2; ++i) {
            bytes2[i] = (byte)WebSocketUtil.randomNumber(0, 255);
        }
        return bytes2;
    }

    static int randomNumber(int min2, int max2) {
        return (int)(Math.random() * (double)max2 + (double)min2);
    }

    private WebSocketUtil() {
    }
}

