/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.handler.codec.PrematureChannelClosureException;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMessageDecoder;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.util.internal.QueueFactory;

public class HttpClientCodec
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    final Queue<HttpMethod> queue = QueueFactory.createQueue(HttpMethod.class);
    volatile boolean done;
    private final HttpRequestEncoder encoder = new Encoder();
    private final HttpResponseDecoder decoder;
    private final AtomicLong requestResponseCounter = new AtomicLong(0L);

    public HttpClientCodec() {
        this(4096, 8192, 8192);
    }

    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
        this.decoder = new Decoder(maxInitialLineLength, maxHeaderSize, maxChunkSize);
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.decoder.handleUpstream(ctx, e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.encoder.handleDownstream(ctx, e);
    }

    private final class Decoder
    extends HttpResponseDecoder {
        Decoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
            super(maxInitialLineLength, maxHeaderSize, maxChunkSize);
        }

        protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer2, HttpMessageDecoder.State state) throws Exception {
            if (HttpClientCodec.this.done) {
                return buffer2.readBytes(this.actualReadableBytes());
            }
            Object msg = super.decode(ctx, channel, buffer2, state);
            if (msg != null) {
                if (msg instanceof HttpMessage && !((HttpMessage)msg).isChunked()) {
                    HttpClientCodec.this.requestResponseCounter.decrementAndGet();
                } else if (msg instanceof HttpChunk && ((HttpChunk)msg).isLast()) {
                    HttpClientCodec.this.requestResponseCounter.decrementAndGet();
                }
            }
            return msg;
        }

        protected boolean isContentAlwaysEmpty(HttpMessage msg) {
            int statusCode = ((HttpResponse)msg).getStatus().getCode();
            if (statusCode == 100) {
                return true;
            }
            HttpMethod method = HttpClientCodec.this.queue.poll();
            char firstChar = method.getName().charAt(0);
            switch (firstChar) {
                case 'H': {
                    if (!HttpMethod.HEAD.equals(method)) break;
                    return true;
                }
                case 'C': {
                    if (statusCode != 200 || !HttpMethod.CONNECT.equals(method)) break;
                    HttpClientCodec.this.done = true;
                    HttpClientCodec.this.queue.clear();
                    return true;
                }
            }
            return super.isContentAlwaysEmpty(msg);
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            super.channelClosed(ctx, e);
            long missingResponses = HttpClientCodec.this.requestResponseCounter.get();
            if (missingResponses > 0L) {
                throw new PrematureChannelClosureException("Channel closed but still missing " + missingResponses + " response(s)");
            }
        }
    }

    private final class Encoder
    extends HttpRequestEncoder {
        Encoder() {
        }

        protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
            if (msg instanceof HttpRequest && !HttpClientCodec.this.done) {
                HttpClientCodec.this.queue.offer(((HttpRequest)msg).getMethod());
            }
            Object obj = super.encode(ctx, channel, msg);
            if (msg instanceof HttpRequest && !((HttpRequest)msg).isChunked()) {
                HttpClientCodec.this.requestResponseCounter.incrementAndGet();
            } else if (msg instanceof HttpChunk && ((HttpChunk)msg).isLast()) {
                HttpClientCodec.this.requestResponseCounter.incrementAndGet();
            }
            return obj;
        }
    }
}

