/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDateFormat;
import org.jboss.netty.handler.codec.http.DefaultCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieDecoder {
    private static final Pattern PATTERN = Pattern.compile("(?:\\s|[;,])*\\$*([^;=]+)(?:=(?:[\"']((?:\\\\.|[^\"])*)[\"']|([^;,]*)))?(\\s*(?:[;,]+\\s*|$))");
    private static final String COMMA = ",";
    private final boolean lenient;

    public CookieDecoder() {
        this(false);
    }

    public CookieDecoder(boolean lenient) {
        this.lenient = lenient;
    }

    public Set<Cookie> decode(String header) {
        int i;
        ArrayList<String> names2 = new ArrayList<String>(8);
        ArrayList<String> values2 = new ArrayList<String>(8);
        this.extractKeyValuePairs(header, names2, values2);
        if (names2.isEmpty()) {
            return Collections.emptySet();
        }
        int version = 0;
        if (((String)names2.get(0)).equalsIgnoreCase("Version")) {
            try {
                version = Integer.parseInt((String)values2.get(0));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            i = 1;
        } else {
            i = 0;
        }
        if (names2.size() <= i) {
            return Collections.emptySet();
        }
        TreeSet<Cookie> cookies = new TreeSet<Cookie>();
        while (i < names2.size()) {
            String name2 = (String)names2.get(i);
            if (!this.lenient || !"HTTPOnly".equalsIgnoreCase(name2)) {
                String value2 = (String)values2.get(i);
                if (value2 == null) {
                    value2 = "";
                }
                DefaultCookie c = new DefaultCookie(name2, value2);
                cookies.add(c);
                boolean discard = false;
                boolean secure = false;
                boolean httpOnly = false;
                String comment2 = null;
                String commentURL = null;
                String domain = null;
                String path = null;
                int maxAge = -1;
                ArrayList<Integer> ports = new ArrayList<Integer>(2);
                int j = i + 1;
                while (j < names2.size()) {
                    block38: {
                        name2 = (String)names2.get(j);
                        value2 = (String)values2.get(j);
                        if ("Discard".equalsIgnoreCase(name2)) {
                            discard = true;
                        } else if ("Secure".equalsIgnoreCase(name2)) {
                            secure = true;
                        } else if ("HTTPOnly".equalsIgnoreCase(name2)) {
                            httpOnly = true;
                        } else if ("Comment".equalsIgnoreCase(name2)) {
                            comment2 = value2;
                        } else if ("CommentURL".equalsIgnoreCase(name2)) {
                            commentURL = value2;
                        } else if ("Domain".equalsIgnoreCase(name2)) {
                            domain = value2;
                        } else if ("Path".equalsIgnoreCase(name2)) {
                            path = value2;
                        } else if ("Expires".equalsIgnoreCase(name2)) {
                            try {
                                long maxAgeMillis = new CookieDateFormat().parse(value2).getTime() - System.currentTimeMillis();
                                if (maxAgeMillis <= 0L) {
                                    maxAge = 0;
                                    break block38;
                                }
                                maxAge = (int)(maxAgeMillis / 1000L) + (maxAgeMillis % 1000L != 0L ? 1 : 0);
                            }
                            catch (ParseException e) {}
                        } else if ("Max-Age".equalsIgnoreCase(name2)) {
                            maxAge = Integer.parseInt(value2);
                        } else if ("Version".equalsIgnoreCase(name2)) {
                            version = Integer.parseInt(value2);
                        } else {
                            String[] portList;
                            if (!"Port".equalsIgnoreCase(name2)) break;
                            for (String s1 : portList = value2.split(COMMA)) {
                                try {
                                    ports.add(Integer.valueOf(s1));
                                }
                                catch (NumberFormatException e) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    ++j;
                    ++i;
                }
                c.setVersion(version);
                c.setMaxAge(maxAge);
                c.setPath(path);
                c.setDomain(domain);
                c.setSecure(secure);
                c.setHttpOnly(httpOnly);
                if (version > 0) {
                    c.setComment(comment2);
                }
                if (version > 1) {
                    c.setCommentUrl(commentURL);
                    c.setPorts(ports);
                    c.setDiscard(discard);
                }
            }
            ++i;
        }
        return cookies;
    }

    private void extractKeyValuePairs(String header, List<String> names2, List<String> values2) {
        Matcher m = PATTERN.matcher(header);
        int pos = 0;
        String name2 = null;
        String value2 = null;
        String separator = null;
        while (m.find(pos)) {
            pos = m.end();
            String newName = m.group(1);
            String newValue = m.group(3);
            if (newValue == null) {
                newValue = this.decodeValue(m.group(2));
            }
            String newSeparator = m.group(4);
            if (name2 == null) {
                name2 = newName;
                value2 = newValue == null ? "" : newValue;
                separator = newSeparator;
                continue;
            }
            if (!(newValue != null || "Discard".equalsIgnoreCase(newName) || "Secure".equalsIgnoreCase(newName) || "HTTPOnly".equalsIgnoreCase(newName))) {
                value2 = value2 + separator + newName;
                separator = newSeparator;
                continue;
            }
            names2.add(name2);
            values2.add(value2);
            name2 = newName;
            value2 = newValue;
            separator = newSeparator;
        }
        if (name2 != null) {
            names2.add(name2);
            values2.add(value2);
        }
    }

    private String decodeValue(String value2) {
        if (value2 == null) {
            return value2;
        }
        return value2.replace("\\\"", "\"").replace("\\\\", "\\");
    }
}

