/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.nio.AbstractNioChannel;
import org.jboss.netty.channel.socket.nio.DefaultNioSocketChannelConfig;
import org.jboss.netty.channel.socket.nio.NioSocketChannelConfig;
import org.jboss.netty.channel.socket.nio.NioWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioSocketChannel
extends AbstractNioChannel<java.nio.channels.SocketChannel>
implements SocketChannel {
    private static final int ST_OPEN = 0;
    private static final int ST_BOUND = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_CLOSED = -1;
    volatile int state = 0;
    private final NioSocketChannelConfig config;

    public NioSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink2, java.nio.channels.SocketChannel socket, NioWorker worker) {
        super(parent, factory, pipeline, sink2, worker, socket);
        this.config = new DefaultNioSocketChannelConfig(socket.socket());
    }

    @Override
    public NioWorker getWorker() {
        return (NioWorker)super.getWorker();
    }

    @Override
    public NioSocketChannelConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state >= 0;
    }

    @Override
    public boolean isBound() {
        return this.state >= 1;
    }

    @Override
    public boolean isConnected() {
        return this.state == 2;
    }

    final void setBound() {
        assert (this.state == 0) : "Invalid state: " + this.state;
        this.state = 1;
    }

    final void setConnected() {
        if (this.state != -1) {
            this.state = 2;
        }
    }

    @Override
    protected boolean setClosed() {
        this.state = -1;
        return super.setClosed();
    }

    @Override
    InetSocketAddress getLocalSocketAddress() throws Exception {
        return (InetSocketAddress)((java.nio.channels.SocketChannel)this.channel).socket().getLocalSocketAddress();
    }

    @Override
    InetSocketAddress getRemoteSocketAddress() throws Exception {
        return (InetSocketAddress)((java.nio.channels.SocketChannel)this.channel).socket().getRemoteSocketAddress();
    }

    @Override
    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return this.getUnsupportedOperationFuture();
    }
}

