/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.SocketAddress;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.local.DefaultLocalClientChannelFactory;
import org.jboss.netty.channel.local.LocalAddress;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public class HttpTunnelingServlet
extends HttpServlet {
    private static final long serialVersionUID = 4259910275899756070L;
    private static final String ENDPOINT = "endpoint";
    static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpTunnelingServlet.class);
    private volatile SocketAddress remoteAddress;
    private volatile ChannelFactory channelFactory;

    public void init() throws ServletException {
        ServletConfig config2 = this.getServletConfig();
        String endpoint = config2.getInitParameter(ENDPOINT);
        if (endpoint == null) {
            throw new ServletException("init-param 'endpoint' must be specified.");
        }
        try {
            this.remoteAddress = this.parseEndpoint(endpoint.trim());
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Failed to parse an endpoint.", e);
        }
        try {
            this.channelFactory = this.createChannelFactory(this.remoteAddress);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Failed to create a channel factory.", e);
        }
    }

    protected SocketAddress parseEndpoint(String endpoint) throws Exception {
        if (endpoint.startsWith("local:")) {
            return new LocalAddress(endpoint.substring(6).trim());
        }
        throw new ServletException("Invalid or unknown endpoint: " + endpoint);
    }

    protected ChannelFactory createChannelFactory(SocketAddress remoteAddress) throws Exception {
        if (remoteAddress instanceof LocalAddress) {
            return new DefaultLocalClientChannelFactory();
        }
        throw new ServletException("Unsupported remote address type: " + remoteAddress.getClass().getName());
    }

    public void destroy() {
        block2: {
            try {
                this.destroyChannelFactory(this.channelFactory);
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to destroy a channel factory.", e);
            }
        }
    }

    protected void destroyChannelFactory(ChannelFactory factory) throws Exception {
        factory.releaseExternalResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!"POST".equalsIgnoreCase(req.getMethod())) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unallowed method: " + req.getMethod());
            }
            res.sendError(405);
            return;
        }
        ChannelPipeline pipeline = Channels.pipeline();
        ServletOutputStream out = res.getOutputStream();
        OutboundConnectionHandler handler = new OutboundConnectionHandler(out);
        pipeline.addLast("handler", handler);
        Channel channel = this.channelFactory.newChannel(pipeline);
        ChannelFuture future = channel.connect(this.remoteAddress).awaitUninterruptibly();
        if (!future.isSuccess()) {
            if (logger.isWarnEnabled()) {
                Throwable cause = future.getCause();
                logger.warn("Endpoint unavailable: " + cause.getMessage(), cause);
            }
            res.sendError(503);
            return;
        }
        ChannelFuture lastWriteFuture = null;
        try {
            res.setStatus(200);
            res.setHeader("Content-Type", "application/octet-stream");
            res.setHeader("Content-Transfer-Encoding", "binary");
            out.flush();
            PushbackInputStream in = new PushbackInputStream(req.getInputStream());
            while (channel.isConnected()) {
                ChannelBuffer buffer2;
                try {
                    buffer2 = HttpTunnelingServlet.read(in);
                }
                catch (EOFException e) {
                    break;
                }
                if (buffer2 == null) {
                    break;
                }
                lastWriteFuture = channel.write(buffer2);
            }
        }
        finally {
            if (lastWriteFuture == null) {
                channel.close();
            } else {
                lastWriteFuture.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    private static ChannelBuffer read(PushbackInputStream in) throws IOException {
        int readBytes;
        byte[] buf;
        int bytesToRead = in.available();
        if (bytesToRead > 0) {
            buf = new byte[bytesToRead];
            readBytes = in.read(buf);
        } else if (bytesToRead == 0) {
            int b = in.read();
            if (b < 0 || in.available() < 0) {
                return null;
            }
            in.unread(b);
            bytesToRead = in.available();
            buf = new byte[bytesToRead];
            readBytes = in.read(buf);
        } else {
            return null;
        }
        assert (readBytes > 0);
        ChannelBuffer buffer2 = readBytes == buf.length ? ChannelBuffers.wrappedBuffer(buf) : ChannelBuffers.wrappedBuffer(buf, 0, readBytes);
        return buffer2;
    }

    private static final class OutboundConnectionHandler
    extends SimpleChannelUpstreamHandler {
        private final ServletOutputStream out;

        public OutboundConnectionHandler(ServletOutputStream out) {
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            ChannelBuffer buffer2 = (ChannelBuffer)e.getMessage();
            OutboundConnectionHandler outboundConnectionHandler = this;
            synchronized (outboundConnectionHandler) {
                buffer2.readBytes(this.out, buffer2.readableBytes());
                this.out.flush();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception while HTTP tunneling", e.getCause());
            }
            e.getChannel().close();
        }
    }
}

