/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library {
    static final String SLASH = System.getProperty("file.separator");
    private final String name;
    private final String version;
    private final ClassLoader classLoader;
    private boolean loaded;

    public Library(String name2) {
        this(name2, null, null);
    }

    public Library(String name2, Class<?> clazz2) {
        this(name2, Library.version(clazz2), clazz2.getClassLoader());
    }

    public Library(String name2, String version) {
        this(name2, version, null);
    }

    public Library(String name2, String version, ClassLoader classLoader) {
        if (name2 == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name2;
        this.version = version;
        this.classLoader = classLoader;
    }

    private static String version(Class<?> clazz2) {
        try {
            return clazz2.getPackage().getImplementationVersion();
        }
        catch (Throwable throwable2) {
            return null;
        }
    }

    public static String getOperatingSystem() {
        String name2 = System.getProperty("os.name").toLowerCase().trim();
        if (name2.startsWith("linux")) {
            return "linux";
        }
        if (name2.startsWith("mac os x")) {
            return "osx";
        }
        if (name2.startsWith("win")) {
            return "windows";
        }
        return name2.replaceAll("\\W+", "_");
    }

    public static String getPlatform() {
        return Library.getOperatingSystem() + Library.getBitModel();
    }

    public static int getBitModel() {
        String prop = System.getProperty("sun.arch.data.model");
        if (prop == null) {
            prop = System.getProperty("com.ibm.vm.bitmode");
        }
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        return -1;
    }

    public synchronized void load() {
        if (this.loaded) {
            return;
        }
        this.doLoad();
        this.loaded = true;
    }

    private void doLoad() {
        String version = System.getProperty("library." + this.name + ".version");
        if (version == null) {
            version = this.version;
        }
        ArrayList<String> errors = new ArrayList<String>();
        String customPath = System.getProperty("library." + this.name + ".path");
        if (customPath != null) {
            if (version != null && this.load(errors, this.file(customPath, this.map(this.name + "-" + version)))) {
                return;
            }
            if (this.load(errors, this.file(customPath, this.map(this.name)))) {
                return;
            }
        }
        if (version != null && this.load(errors, this.name + Library.getBitModel() + "-" + version)) {
            return;
        }
        if (version != null && this.load(errors, this.name + "-" + version)) {
            return;
        }
        if (this.load(errors, this.name)) {
            return;
        }
        if (this.classLoader != null) {
            if (this.exractAndLoad(errors, version, customPath, this.getPlatformSpecifcResourcePath())) {
                return;
            }
            if (this.exractAndLoad(errors, version, customPath, this.getOperatingSystemSpecifcResourcePath())) {
                return;
            }
            if (this.exractAndLoad(errors, version, customPath, this.getResorucePath())) {
                return;
            }
        }
        throw new UnsatisfiedLinkError("Could not load library. Reasons: " + errors.toString());
    }

    public final String getOperatingSystemSpecifcResourcePath() {
        return this.getPlatformSpecifcResourcePath(Library.getOperatingSystem());
    }

    public final String getPlatformSpecifcResourcePath() {
        return this.getPlatformSpecifcResourcePath(Library.getPlatform());
    }

    public final String getPlatformSpecifcResourcePath(String platform) {
        return "META-INF/native/" + platform + "/" + this.map(this.name);
    }

    public final String getResorucePath() {
        return "META-INF/native/" + this.map(this.name);
    }

    public final String getLibraryFileName() {
        return this.map(this.name);
    }

    private boolean exractAndLoad(ArrayList<String> errors, String version, String customPath, String resourcePath) {
        URL resource = this.classLoader.getResource(resourcePath);
        if (resource != null) {
            File target;
            String libName = this.name + "-" + Library.getBitModel();
            if (version != null) {
                libName = libName + "-" + version;
            }
            if (customPath != null && this.extract(errors, resource, target = this.file(customPath, this.map(libName))) && this.load(errors, target)) {
                return true;
            }
            customPath = System.getProperty("java.io.tmpdir");
            target = this.file(customPath, this.map(libName));
            if (this.extract(errors, resource, target) && this.load(errors, target)) {
                return true;
            }
        }
        return false;
    }

    private File file(String ... paths) {
        File rc = null;
        for (String path : paths) {
            rc = rc == null ? new File(path) : new File(rc, path);
        }
        return rc;
    }

    private String map(String libName) {
        String ext;
        if ((libName = System.mapLibraryName(libName)).endsWith(ext = ".dylib")) {
            libName = libName.substring(0, libName.length() - ext.length()) + ".jnilib";
        }
        return libName;
    }

    private boolean extract(ArrayList<String> errors, URL source2, File target) {
        FileOutputStream os = null;
        InputStream is = null;
        boolean extracting = false;
        try {
            if ((!target.exists() || this.isStale(source2, target)) && (is = source2.openStream()) != null) {
                int read2;
                byte[] buffer2 = new byte[4096];
                os = new FileOutputStream(target);
                extracting = true;
                while ((read2 = is.read(buffer2)) != -1) {
                    os.write(buffer2, 0, read2);
                }
                os.close();
                is.close();
                this.chmod("755", target);
            }
        }
        catch (Throwable e) {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            if (extracting && target.exists()) {
                target.delete();
            }
            errors.add(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean isStale(URL source2, File target) {
        if (source2.getProtocol().equals("jar")) {
            try {
                String[] parts = source2.getFile().split(Pattern.quote("!"));
                source2 = new URL(parts[0]);
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        File sourceFile2 = null;
        if (source2.getProtocol().equals("file")) {
            sourceFile2 = new File(source2.getFile());
        }
        return sourceFile2 != null && sourceFile2.exists() && sourceFile2.lastModified() > target.lastModified();
    }

    private void chmod(String permision, File path) {
        if (Library.getPlatform().startsWith("windows")) {
            return;
        }
        try {
            Runtime.getRuntime().exec(new String[]{"chmod", permision, path.getCanonicalPath()}).waitFor();
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    private boolean load(ArrayList<String> errors, File lib) {
        try {
            System.load(lib.getPath());
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            errors.add(e.getMessage());
            return false;
        }
    }

    private boolean load(ArrayList<String> errors, String lib) {
        try {
            System.loadLibrary(lib);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            errors.add(e.getMessage());
            return false;
        }
    }
}

