/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.resource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.ZipFile;
import org.codehaus.janino.util.iterator.TransformingIterator;
import org.codehaus.janino.util.resource.DirectoryResourceFinder;
import org.codehaus.janino.util.resource.LazyMultiResourceFinder;
import org.codehaus.janino.util.resource.ResourceFinder;
import org.codehaus.janino.util.resource.ZipFileResourceFinder;

public class PathResourceFinder
extends LazyMultiResourceFinder {
    public PathResourceFinder(File[] entries) {
        super(PathResourceFinder.createIterator(Arrays.asList(entries).iterator()));
    }

    public PathResourceFinder(Iterator<ResourceFinder> entries) {
        super(entries);
    }

    public PathResourceFinder(String path) {
        this(PathResourceFinder.parsePath(path));
    }

    private static Iterator<ResourceFinder> createIterator(Iterator<File> entries) {
        return new TransformingIterator(entries){

            protected Object transform(Object o) {
                return PathResourceFinder.createResourceFinder((File)o);
            }
        };
    }

    public static File[] parsePath(String s2) {
        int from2 = 0;
        ArrayList<File> l = new ArrayList<File>();
        while (true) {
            int to2;
            if ((to2 = s2.indexOf(File.pathSeparatorChar, from2)) == -1) {
                if (from2 == s2.length()) break;
                l.add(new File(s2.substring(from2)));
                break;
            }
            if (to2 != from2) {
                l.add(new File(s2.substring(from2, to2)));
            }
            from2 = to2 + 1;
        }
        return l.toArray(new File[l.size()]);
    }

    private static ResourceFinder createResourceFinder(File entry2) {
        if ((entry2.getName().endsWith(".jar") || entry2.getName().endsWith(".zip")) && entry2.isFile()) {
            try {
                return new ZipFileResourceFinder(new ZipFile(entry2));
            }
            catch (IOException e) {
                return ResourceFinder.EMPTY_RESOURCE_FINDER;
            }
        }
        if (entry2.isDirectory()) {
            return new DirectoryResourceFinder(entry2);
        }
        return ResourceFinder.EMPTY_RESOURCE_FINDER;
    }
}

