/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.enumerator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.janino.util.enumerator.EnumeratorFormatException;

public abstract class Enumerator {
    private final String name;
    private static final Map<Class, Map<String, Enumerator>> INSTANCES = Collections.synchronizedMap(new HashMap());

    protected Enumerator(String name2) {
        if (name2 == null) {
            throw new NullPointerException();
        }
        this.name = name2;
        Enumerator.getInstances(this.getClass()).put(name2, this);
    }

    public final boolean equals(Object that) {
        return this == that;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    static Map<String, Enumerator> getInstances(Class enumeratorClass) {
        Map<String, Enumerator> m = INSTANCES.get(enumeratorClass);
        if (m != null) {
            return m;
        }
        m = new HashMap<String, Enumerator>();
        INSTANCES.put(enumeratorClass, m);
        return m;
    }

    protected static final Enumerator fromString(String name2, Class enumeratorClass) throws EnumeratorFormatException {
        Enumerator value2 = Enumerator.getInstances(enumeratorClass).get(name2);
        if (value2 == null) {
            throw new EnumeratorFormatException(name2);
        }
        return value2;
    }

    public String toString() {
        return this.name;
    }
}

