/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.UncheckedCompileException;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.janino.Access;
import org.codehaus.janino.CodeContext;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.Java;
import org.codehaus.janino.MethodDescriptor;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.util.ClassFile;

public class UnitCompiler {
    private static final boolean DEBUG = false;
    private static final int STRING_CONCAT_LIMIT = 3;
    public static final boolean JUMP_IF_TRUE = true;
    public static final boolean JUMP_IF_FALSE = false;
    public static final Object NOT_CONSTANT = IClass.NOT_CONSTANT;
    private Map<String, String[]> singleTypeImports;
    private Collection<String[]> typeImportsOnDemand;
    private final Map<String, IClass> onDemandImportableTypes = new HashMap<String, IClass>();
    private static final Map<String, byte[]> PRIMITIVE_WIDENING_CONVERSIONS = new HashMap<String, byte[]>();
    private static final Map<String, byte[]> PRIMITIVE_NARROWING_CONVERSIONS;
    private CodeContext codeContext;
    private ErrorHandler optionalCompileErrorHandler;
    private int compileErrorCount;
    private WarningHandler optionalWarningHandler;
    private final Java.CompilationUnit compilationUnit;
    private final IClassLoader iClassLoader;
    private List<ClassFile> generatedClassFiles;
    private boolean debugSource;
    private boolean debugLines;
    private boolean debugVars;
    private final Map<String, List<Object>> singleStaticImports = new HashMap<String, List<Object>>();
    private final Collection<IClass> staticImportsOnDemand = new ArrayList<IClass>();

    public UnitCompiler(Java.CompilationUnit compilationUnit2, IClassLoader iClassLoader) {
        this.compilationUnit = compilationUnit2;
        this.iClassLoader = iClassLoader;
    }

    public Java.CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    private void import2(Java.CompilationUnit.SingleStaticImportDeclaration ssid) throws CompileException {
        IClass iClass;
        String name2 = UnitCompiler.last(ssid.identifiers);
        List<Object> importedObjects = this.singleStaticImports.get(name2);
        if (importedObjects == null) {
            importedObjects = new ArrayList<Object>();
            this.singleStaticImports.put(name2, importedObjects);
        }
        if ((iClass = this.findTypeByFullyQualifiedName(ssid.getLocation(), ssid.identifiers)) != null) {
            importedObjects.add(iClass);
            return;
        }
        Object[] typeName = UnitCompiler.allButLast(ssid.identifiers);
        IClass iClass2 = this.findTypeByFullyQualifiedName(ssid.getLocation(), (String[])typeName);
        if (iClass2 == null) {
            this.compileError("Could not load \"" + Java.join(typeName, ".") + "\"", ssid.getLocation());
            return;
        }
        IClass.IField iField = iClass2.getDeclaredIField(name2);
        if (iField != null) {
            if (!iField.isStatic()) {
                this.compileError("Field \"" + name2 + "\" of \"" + Java.join(typeName, ".") + "\" must be static", ssid.getLocation());
            }
            importedObjects.add(iField);
            return;
        }
        IClass.IMethod[] ms = iClass2.getDeclaredIMethods(name2);
        if (ms.length > 0) {
            importedObjects.addAll(Arrays.asList(ms));
            return;
        }
        this.compileError("\"" + Java.join(typeName, ".") + "\" has no static member \"" + name2 + "\"", ssid.getLocation());
    }

    private void import2(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) throws CompileException {
        IClass iClass = this.findTypeByFullyQualifiedName(siodd.getLocation(), siodd.identifiers);
        if (iClass == null) {
            this.compileError("Could not load \"" + Java.join(siodd.identifiers, ".") + "\"", siodd.getLocation());
            return;
        }
        this.staticImportsOnDemand.add(iClass);
    }

    public ClassFile[] compileUnit(boolean debugSource, boolean debugLines, boolean debugVars) throws CompileException {
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
        for (Java.CompilationUnit.ImportDeclaration id : this.compilationUnit.importDeclarations) {
            try {
                id.accept(new Visitor.ImportVisitor(){

                    @Override
                    public void visitSingleTypeImportDeclaration(Java.CompilationUnit.SingleTypeImportDeclaration stid) {
                    }

                    @Override
                    public void visitTypeImportOnDemandDeclaration(Java.CompilationUnit.TypeImportOnDemandDeclaration tiodd) {
                    }

                    @Override
                    public void visitSingleStaticImportDeclaration(Java.CompilationUnit.SingleStaticImportDeclaration ssid) {
                        try {
                            UnitCompiler.this.import2(ssid);
                        }
                        catch (CompileException e) {
                            throw new UncheckedCompileException(e);
                        }
                    }

                    @Override
                    public void visitStaticImportOnDemandDeclaration(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) {
                        try {
                            UnitCompiler.this.import2(siodd);
                        }
                        catch (CompileException e) {
                            throw new UncheckedCompileException(e);
                        }
                    }
                });
            }
            catch (UncheckedCompileException uce) {
                throw uce.compileException;
            }
        }
        this.generatedClassFiles = new ArrayList<ClassFile>();
        for (Java.PackageMemberTypeDeclaration pmtd : this.compilationUnit.packageMemberTypeDeclarations) {
            this.compile(pmtd);
        }
        if (this.compileErrorCount > 0) {
            throw new CompileException(this.compileErrorCount + " error(s) while compiling unit \"" + this.compilationUnit.optionalFileName + "\"", null);
        }
        List<ClassFile> l = this.generatedClassFiles;
        return l.toArray(new ClassFile[l.size()]);
    }

    private void compile(Java.TypeDeclaration td) throws CompileException {
        Visitor.TypeDeclarationVisitor tdv = new Visitor.TypeDeclarationVisitor(){

            @Override
            public void visitAnonymousClassDeclaration(Java.AnonymousClassDeclaration acd) {
                try {
                    UnitCompiler.this.compile2(acd);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLocalClassDeclaration(Java.LocalClassDeclaration lcd) {
                try {
                    UnitCompiler.this.compile2(lcd);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitPackageMemberClassDeclaration(Java.PackageMemberClassDeclaration pmcd) {
                try {
                    UnitCompiler.this.compile2(pmcd);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitMemberInterfaceDeclaration(Java.MemberInterfaceDeclaration mid) {
                try {
                    UnitCompiler.this.compile2(mid);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitPackageMemberInterfaceDeclaration(Java.PackageMemberInterfaceDeclaration pmid) {
                try {
                    UnitCompiler.this.compile2(pmid);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitMemberClassDeclaration(Java.MemberClassDeclaration mcd) {
                try {
                    UnitCompiler.this.compile2(mcd);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }
        };
        try {
            td.accept(tdv);
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
    }

    private void compile2(Java.PackageMemberTypeDeclaration pmtd) throws CompileException {
        Java.PackageMemberTypeDeclaration otherPmtd;
        Java.CompilationUnit declaringCompilationUnit = pmtd.getDeclaringCompilationUnit();
        Object[] ss = this.getSingleTypeImport(pmtd.getName(), pmtd.getLocation());
        if (ss != null) {
            this.compileError("Package member type declaration \"" + pmtd.getName() + "\" conflicts with single-type-import \"" + Java.join(ss, ".") + "\"", pmtd.getLocation());
        }
        if ((otherPmtd = declaringCompilationUnit.getPackageMemberTypeDeclaration(pmtd.getName())) != pmtd) {
            this.compileError("Redeclaration of type \"" + pmtd.getName() + "\", previously declared in " + otherPmtd.getLocation(), pmtd.getLocation());
        }
        if (pmtd instanceof Java.NamedClassDeclaration) {
            this.compile2((Java.NamedClassDeclaration)((Object)pmtd));
        } else if (pmtd instanceof Java.InterfaceDeclaration) {
            this.compile2((Java.InterfaceDeclaration)((Object)pmtd));
        } else {
            throw new JaninoRuntimeException("PMTD of unexpected type " + pmtd.getClass().getName());
        }
    }

    private void compile2(Java.ClassDeclaration cd) throws CompileException {
        IClass.IMethod[] ms;
        Java.ConstructorDeclarator[] ctords;
        IClass iClass = this.resolve(cd);
        if (!Mod.isAbstract(cd.getModifierFlags())) {
            IClass.IMethod[] ms2;
            for (IClass.IMethod base : ms2 = iClass.getIMethods()) {
                IClass.IMethod override;
                if (!base.isAbstract() || (override = iClass.findIMethod(base.getName(), base.getParameterTypes())) != null && !override.isAbstract() && base.getReturnType().isAssignableFrom(override.getReturnType())) continue;
                this.compileError("Non-abstract class \"" + iClass + "\" must implement method \"" + base + "\"", cd.getLocation());
            }
        }
        ClassFile cf = new ClassFile((short)(cd.getModifierFlags() | 0x20), iClass.getDescriptor(), iClass.getSuperclass().getDescriptor(), IClass.getDescriptors(iClass.getInterfaces()));
        if (!(cd.getEnclosingScope() instanceof Java.CompilationUnit)) {
            if (cd.getEnclosingScope() instanceof Java.Block) {
                short innerNameIndex;
                short innerClassInfoIndex = cf.addConstantClassInfo(iClass.getDescriptor());
                short s2 = innerNameIndex = this instanceof Java.NamedTypeDeclaration ? cf.addConstantUtf8Info(((Java.NamedTypeDeclaration)((Object)this)).getName()) : (short)0;
                assert (cd.getAnnotations().length == 0) : "NYI";
                cf.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(innerClassInfoIndex, 0, innerNameIndex, cd.getModifierFlags()));
            } else if (cd.getEnclosingScope() instanceof Java.TypeDeclaration) {
                short innerClassInfoIndex = cf.addConstantClassInfo(iClass.getDescriptor());
                short outerClassInfoIndex = cf.addConstantClassInfo(this.resolve((Java.TypeDeclaration)cd.getEnclosingScope()).getDescriptor());
                short innerNameIndex = cf.addConstantUtf8Info(((Java.MemberTypeDeclaration)((Object)cd)).getName());
                assert (cd.getAnnotations().length == 0) : "NYI";
                cf.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(innerClassInfoIndex, outerClassInfoIndex, innerNameIndex, cd.getModifierFlags()));
            }
        }
        if (this.debugSource) {
            String s3 = cd.getLocation().getFileName();
            String sourceFileName = s3 != null ? new File(s3).getName() : (cd instanceof Java.NamedTypeDeclaration ? ((Java.NamedTypeDeclaration)((Object)cd)).getName() + ".java" : "ANONYMOUS.java");
            cf.addSourceFileAttribute(sourceFileName);
        }
        if (cd instanceof Java.DocCommentable && ((Java.DocCommentable)((Object)cd)).hasDeprecatedDocTag()) {
            cf.addDeprecatedAttribute();
        }
        ArrayList<Java.BlockStatement> statements = new ArrayList<Java.BlockStatement>();
        for (Java.BlockStatement vdoi : cd.variableDeclaratorsAndInitializers) {
            if (!((Java.TypeBodyDeclaration)((Object)vdoi)).isStatic()) continue;
            statements.add(vdoi);
        }
        this.maybeCreateInitMethod(cd, cf, statements);
        this.compileDeclaredMethods(cd, cf);
        int declaredMethodCount = cd.getMethodDeclarations().size();
        int syntheticFieldCount = cd.syntheticFields.size();
        for (Java.ConstructorDeclarator ctord : ctords = cd.getConstructors()) {
            this.compile(ctord, cf);
            if (syntheticFieldCount == cd.syntheticFields.size()) continue;
            throw new JaninoRuntimeException("SNO: Compilation of constructor \"" + ctord + "\" (" + ctord.getLocation() + ") added synthetic fields!?");
        }
        this.compileDeclaredMemberTypes(cd, cf);
        this.compileDeclaredMethods(cd, cf, declaredMethodCount);
        for (IClass.IMethod base : ms = iClass.getIMethods()) {
            IClass.IMethod override;
            if (base.isStatic() || (override = iClass.findIMethod(base.getName(), base.getParameterTypes())) == null || base.getReturnType().equals(override.getReturnType())) continue;
            this.compileBridgeMethod(cf, base, override);
        }
        for (Java.BlockStatement vdoi : cd.variableDeclaratorsAndInitializers) {
            if (!(vdoi instanceof Java.FieldDeclaration)) continue;
            this.addFields((Java.FieldDeclaration)vdoi, cf);
        }
        for (IClass.IField f2 : cd.syntheticFields.values()) {
            cf.addFieldInfo(new Java.Modifiers(0), f2.getName(), f2.getType().getDescriptor(), null);
        }
        this.generatedClassFiles.add(cf);
    }

    private void addFields(Java.FieldDeclaration fd, ClassFile cf) throws CompileException {
        for (Java.VariableDeclarator vd : fd.variableDeclarators) {
            ClassFile.FieldInfo fi;
            Java.Type type = fd.type;
            for (int i = 0; i < vd.brackets; ++i) {
                type = new Java.ArrayType(type);
            }
            Object ocv = NOT_CONSTANT;
            if (Mod.isFinal(fd.modifiers.flags) && vd.optionalInitializer instanceof Java.Rvalue) {
                ocv = this.getConstantValue((Java.Rvalue)vd.optionalInitializer);
            }
            if (Mod.isPrivateAccess(fd.modifiers.flags)) {
                assert (fd.modifiers.annotations.length == 0) : "NYI";
                fi = cf.addFieldInfo(fd.modifiers.changeAccess(0), vd.name, this.getType(type).getDescriptor(), ocv == NOT_CONSTANT ? null : ocv);
            } else {
                assert (fd.modifiers.annotations.length == 0) : "NYI";
                fi = cf.addFieldInfo(fd.modifiers, vd.name, this.getType(type).getDescriptor(), ocv == NOT_CONSTANT ? null : ocv);
            }
            if (!fd.hasDeprecatedDocTag()) continue;
            fi.addAttribute(new ClassFile.DeprecatedAttribute(cf.addConstantUtf8Info("Deprecated")));
        }
    }

    private void compile2(Java.AnonymousClassDeclaration acd) throws CompileException {
        this.compile2((Java.InnerClassDeclaration)acd);
    }

    private void compile2(Java.LocalClassDeclaration lcd) throws CompileException {
        this.compile2((Java.InnerClassDeclaration)lcd);
    }

    private void compile2(Java.InnerClassDeclaration icd) throws CompileException {
        List<Java.TypeDeclaration> ocs = UnitCompiler.getOuterClasses(icd);
        int nesting = ocs.size();
        if (nesting >= 2) {
            icd.defineSyntheticField(new SimpleIField(this.resolve(icd), "this$" + (nesting - 2), this.resolve(ocs.get(1))));
        }
        if (icd instanceof Java.AnonymousClassDeclaration || icd instanceof Java.LocalClassDeclaration) {
            Java.ClassDeclaration cd = (Java.ClassDeclaration)((Object)icd);
            for (Java.BlockStatement vdoi : cd.variableDeclaratorsAndInitializers) {
                if (!(vdoi instanceof Java.FieldDeclaration)) continue;
                Java.FieldDeclaration fd = (Java.FieldDeclaration)vdoi;
                for (Java.VariableDeclarator vd : fd.variableDeclarators) {
                    if (vd.optionalInitializer == null) continue;
                    this.fakeCompile(vd.optionalInitializer);
                }
            }
        }
        this.compile2((Java.ClassDeclaration)((Object)icd));
    }

    private void compile2(Java.MemberClassDeclaration mcd) throws CompileException {
        this.compile2((Java.InnerClassDeclaration)mcd);
    }

    private void compile2(Java.InterfaceDeclaration id) throws CompileException {
        IClass iClass = this.resolve(id);
        id.interfaces = new IClass[id.extendedTypes.length];
        String[] interfaceDescriptors = new String[id.interfaces.length];
        for (int i = 0; i < id.extendedTypes.length; ++i) {
            id.interfaces[i] = this.getType(id.extendedTypes[i]);
            interfaceDescriptors[i] = id.interfaces[i].getDescriptor();
        }
        ClassFile cf = new ClassFile((short)(id.getModifierFlags() | 0x20 | 0x200 | 0x400), iClass.getDescriptor(), "Ljava/lang/Object;", interfaceDescriptors);
        if (this.debugSource) {
            String s2 = id.getLocation().getFileName();
            String sourceFileName = s2 != null ? new File(s2).getName() : id.getName() + ".java";
            cf.addSourceFileAttribute(sourceFileName);
        }
        if (id.hasDeprecatedDocTag()) {
            cf.addDeprecatedAttribute();
        }
        if (!id.constantDeclarations.isEmpty()) {
            ArrayList<Java.BlockStatement> statements = new ArrayList<Java.BlockStatement>();
            statements.addAll(id.constantDeclarations);
            this.maybeCreateInitMethod(id, cf, statements);
        }
        this.compileDeclaredMethods(id, cf);
        for (Java.FieldDeclaration constantDeclaration : id.constantDeclarations) {
            this.addFields(constantDeclaration, cf);
        }
        this.compileDeclaredMemberTypes(id, cf);
        this.generatedClassFiles.add(cf);
    }

    private void maybeCreateInitMethod(Java.AbstractTypeDeclaration decl, ClassFile cf, List<Java.BlockStatement> statements) throws CompileException {
        if (this.generatesCode2(statements)) {
            Java.MethodDeclarator md = new Java.MethodDeclarator(decl.getLocation(), null, new Java.Modifiers(9), new Java.BasicType(decl.getLocation(), 0), "<clinit>", new Java.FunctionDeclarator.FormalParameters(), new Java.ReferenceType[0], statements);
            md.setDeclaringType(decl);
            this.compile(md, cf);
        }
    }

    private void compileDeclaredMemberTypes(Java.TypeDeclaration decl, ClassFile cf) throws CompileException {
        for (Java.MemberTypeDeclaration mtd : decl.getMemberTypeDeclarations()) {
            this.compile(mtd);
            short innerClassInfoIndex = cf.addConstantClassInfo(this.resolve(mtd).getDescriptor());
            short outerClassInfoIndex = cf.addConstantClassInfo(this.resolve(decl).getDescriptor());
            short innerNameIndex = cf.addConstantUtf8Info(mtd.getName());
            assert (mtd.getAnnotations().length == 0);
            cf.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(innerClassInfoIndex, outerClassInfoIndex, innerNameIndex, mtd.getModifierFlags()));
        }
    }

    private void compileDeclaredMethods(Java.AbstractTypeDeclaration typeDeclaration, ClassFile cf) throws CompileException {
        this.compileDeclaredMethods(typeDeclaration, cf, 0);
    }

    private void compileDeclaredMethods(Java.TypeDeclaration typeDeclaration, ClassFile cf, int startPos) throws CompileException {
        for (int i = startPos; i < typeDeclaration.getMethodDeclarations().size(); ++i) {
            Java.MethodDeclarator md = typeDeclaration.getMethodDeclarations().get(i);
            IClass.IMethod m = this.toIMethod(md);
            boolean overrides = this.overridesMethodFromSupertype(m, this.resolve(md.getDeclaringType()));
            boolean hasOverrideAnnotation = this.hasAnnotation(md, this.iClassLoader.ANNO_java_lang_Override);
            if (overrides && !hasOverrideAnnotation && !(typeDeclaration instanceof Java.InterfaceDeclaration)) {
                this.warning("MO", "Missing @Override", md.getLocation());
            } else if (!overrides && hasOverrideAnnotation) {
                this.compileError("Method does not override a method declared in a supertype", md.getLocation());
            }
            this.compile(md, cf);
        }
    }

    private boolean hasAnnotation(Java.FunctionDeclarator fd, IClass methodAnnotation) throws CompileException {
        Java.Annotation[] methodAnnotations;
        for (Java.Annotation ma : methodAnnotations = fd.modifiers.annotations) {
            if (this.getType(ma.getType()) != methodAnnotation) continue;
            return true;
        }
        return false;
    }

    private boolean overridesMethodFromSupertype(IClass.IMethod m, IClass type) throws CompileException {
        IClass[] ifs;
        IClass superclass = type.getSuperclass();
        if (superclass != null && this.overridesMethod(m, superclass)) {
            return true;
        }
        for (IClass i : ifs = type.getInterfaces()) {
            if (!this.overridesMethod(m, i)) continue;
            return true;
        }
        if (ifs.length == 0 && type.isInterface()) {
            return this.overridesMethod(m, this.iClassLoader.TYPE_java_lang_Object);
        }
        return false;
    }

    private boolean overridesMethod(IClass.IMethod method, IClass type) throws CompileException {
        IClass.IMethod[] ms;
        for (IClass.IMethod m : ms = type.getDeclaredIMethods(method.getName())) {
            if (!Arrays.equals(method.getParameterTypes(), m.getParameterTypes())) continue;
            return true;
        }
        return this.overridesMethodFromSupertype(method, type);
    }

    private void compileBridgeMethod(ClassFile cf, IClass.IMethod base, IClass.IMethod override) throws CompileException {
        ClassFile.MethodInfo mi = cf.addMethodInfo(new Java.Modifiers(4097), base.getName(), base.getDescriptor());
        IClass[] thrownExceptions = base.getThrownExceptions();
        if (thrownExceptions.length > 0) {
            short eani = cf.addConstantUtf8Info("Exceptions");
            short[] tecciis = new short[thrownExceptions.length];
            for (int i = 0; i < thrownExceptions.length; ++i) {
                tecciis[i] = cf.addConstantClassInfo(thrownExceptions[i].getDescriptor());
            }
            mi.addAttribute(new ClassFile.ExceptionsAttribute(eani, tecciis));
        }
        final CodeContext codeContext = new CodeContext(mi.getClassFile());
        CodeContext savedCodeContext = this.replaceCodeContext(codeContext);
        codeContext.saveLocalVariables();
        codeContext.allocateLocalVariable((short)1, "this", override.getDeclaringIClass());
        IClass[] paramTypes2 = override.getParameterTypes();
        Java.LocalVariableSlot[] locals2 = new Java.LocalVariableSlot[paramTypes2.length];
        for (int i = 0; i < paramTypes2.length; ++i) {
            locals2[i] = codeContext.allocateLocalVariable(Descriptor.size(paramTypes2[i].getDescriptor()), "param" + i, paramTypes2[i]);
        }
        this.writeOpcode(Java.Located.NOWHERE, 42);
        for (Java.LocalVariableSlot l : locals2) {
            this.load(Java.Located.NOWHERE, l.getType(), l.getSlotIndex());
        }
        this.invoke((Java.Locatable)Java.Located.NOWHERE, override);
        this.writeOpcode(Java.Located.NOWHERE, -80);
        this.replaceCodeContext(savedCodeContext);
        codeContext.flowAnalysis(override.getName());
        mi.addAttribute(new ClassFile.AttributeInfo(cf.addConstantUtf8Info("Code")){

            @Override
            protected void storeBody(DataOutputStream dos) throws IOException {
                codeContext.storeCodeAttributeBody(dos, (short)0, (short)0);
            }
        });
    }

    private boolean compile(Java.BlockStatement bs) throws CompileException {
        final boolean[] res = new boolean[1];
        Visitor.BlockStatementVisitor bsv = new Visitor.BlockStatementVisitor(){

            @Override
            public void visitInitializer(Java.Initializer i) {
                try {
                    res[0] = UnitCompiler.this.compile2(i);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldDeclaration(Java.FieldDeclaration fd) {
                try {
                    res[0] = UnitCompiler.this.compile2(fd);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLabeledStatement(Java.LabeledStatement ls) {
                try {
                    res[0] = UnitCompiler.this.compile2(ls);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBlock(Java.Block b) {
                try {
                    res[0] = UnitCompiler.this.compile2(b);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitExpressionStatement(Java.ExpressionStatement es) {
                try {
                    res[0] = UnitCompiler.this.compile2(es);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitIfStatement(Java.IfStatement is) {
                try {
                    res[0] = UnitCompiler.this.compile2(is);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitForStatement(Java.ForStatement fs) {
                try {
                    res[0] = UnitCompiler.this.compile2(fs);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitForEachStatement(Java.ForEachStatement fes) {
                try {
                    res[0] = UnitCompiler.this.compile2(fes);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitWhileStatement(Java.WhileStatement ws) {
                try {
                    res[0] = UnitCompiler.this.compile2(ws);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitTryStatement(Java.TryStatement ts) {
                try {
                    res[0] = UnitCompiler.this.compile2(ts);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSwitchStatement(Java.SwitchStatement ss) {
                try {
                    res[0] = UnitCompiler.this.compile2(ss);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSynchronizedStatement(Java.SynchronizedStatement ss) {
                try {
                    res[0] = UnitCompiler.this.compile2(ss);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitDoStatement(Java.DoStatement ds) {
                try {
                    res[0] = UnitCompiler.this.compile2(ds);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                try {
                    res[0] = UnitCompiler.this.compile2(lvds);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitReturnStatement(Java.ReturnStatement rs) {
                try {
                    res[0] = UnitCompiler.this.compile2(rs);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitThrowStatement(Java.ThrowStatement ts) {
                try {
                    res[0] = UnitCompiler.this.compile2(ts);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBreakStatement(Java.BreakStatement bs) {
                try {
                    res[0] = UnitCompiler.this.compile2(bs);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitContinueStatement(Java.ContinueStatement cs) {
                try {
                    res[0] = UnitCompiler.this.compile2(cs);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitAssertStatement(Java.AssertStatement as) {
                try {
                    res[0] = UnitCompiler.this.compile2(as);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitEmptyStatement(Java.EmptyStatement es) {
                res[0] = UnitCompiler.this.compile2(es);
            }

            @Override
            public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) {
                try {
                    res[0] = UnitCompiler.this.compile2(lcds);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) {
                try {
                    res[0] = UnitCompiler.this.compile2(aci);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) {
                try {
                    res[0] = UnitCompiler.this.compile2(sci);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }
        };
        try {
            bs.accept(bsv);
            return res[0];
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fakeCompile(Java.BlockStatement bs) throws CompileException {
        CodeContext savedCodeContext = this.replaceCodeContext(this.createDummyCodeContext());
        try {
            boolean bl = this.compile(bs);
            return bl;
        }
        finally {
            this.replaceCodeContext(savedCodeContext);
        }
    }

    private boolean compile2(Java.Initializer i) throws CompileException {
        return this.compile(i.block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.Block b) throws CompileException {
        this.codeContext.saveLocalVariables();
        try {
            boolean bl = this.compileStatements(b.statements);
            return bl;
        }
        finally {
            this.codeContext.restoreLocalVariables();
        }
    }

    private boolean compileStatements(List<? extends Java.BlockStatement> statements) throws CompileException {
        boolean previousStatementCanCompleteNormally = true;
        for (Java.BlockStatement blockStatement : statements) {
            if (!previousStatementCanCompleteNormally && this.generatesCode(blockStatement)) {
                this.compileError("Statement is unreachable", blockStatement.getLocation());
                break;
            }
            previousStatementCanCompleteNormally = this.compile(blockStatement);
        }
        return previousStatementCanCompleteNormally;
    }

    private boolean compile2(Java.DoStatement ds) throws CompileException {
        Object cvc = this.getConstantValue(ds.condition);
        if (cvc != NOT_CONSTANT) {
            if (Boolean.TRUE.equals(cvc)) {
                this.warning("DSTC", "Condition of DO statement is always TRUE; the proper way of declaring an unconditional loop is \"for (;;)\"", ds.getLocation());
                return this.compileUnconditionalLoop(ds, ds.body, null);
            }
            this.warning("DSNR", "DO statement never repeats", ds.getLocation());
        }
        CodeContext.Offset bodyOffset = this.codeContext.newOffset();
        ds.whereToContinue = null;
        if (!this.compile(ds.body) && ds.whereToContinue == null) {
            this.warning("DSNTC", "\"do\" statement never tests its condition", ds.getLocation());
            if (ds.whereToBreak == null) {
                return false;
            }
            ds.whereToBreak.set();
            ds.whereToBreak = null;
            return true;
        }
        if (ds.whereToContinue != null) {
            ds.whereToContinue.set();
            ds.whereToContinue = null;
        }
        this.compileBoolean(ds.condition, bodyOffset, true);
        if (ds.whereToBreak != null) {
            ds.whereToBreak.set();
            ds.whereToBreak = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.ForStatement fs) throws CompileException {
        this.codeContext.saveLocalVariables();
        try {
            if (fs.optionalInit != null) {
                this.compile(fs.optionalInit);
            }
            if (fs.optionalCondition == null) {
                boolean bl = this.compileUnconditionalLoop(fs, fs.body, fs.optionalUpdate);
                return bl;
            }
            Object cvc = this.getConstantValue(fs.optionalCondition);
            if (cvc != NOT_CONSTANT) {
                if (Boolean.TRUE.equals(cvc)) {
                    this.warning("FSTC", "Condition of FOR statement is always TRUE; the proper way of declaring an unconditional loop is \"for (;;)\"", fs.getLocation());
                    boolean bl = this.compileUnconditionalLoop(fs, fs.body, fs.optionalUpdate);
                    return bl;
                }
                this.warning("FSNR", "FOR statement never repeats", fs.getLocation());
            }
            CodeContext.Offset toCondition = this.codeContext.new CodeContext.Offset();
            this.writeBranch(fs, -89, toCondition);
            fs.whereToContinue = null;
            CodeContext.Offset bodyOffset = this.codeContext.newOffset();
            boolean bodyCcn = this.compile(fs.body);
            if (fs.whereToContinue != null) {
                fs.whereToContinue.set();
            }
            if (fs.optionalUpdate != null) {
                if (!bodyCcn && fs.whereToContinue == null) {
                    this.warning("FUUR", "For update is unreachable", fs.getLocation());
                } else {
                    for (Java.Rvalue rv : fs.optionalUpdate) {
                        this.compile(rv);
                    }
                }
            }
            fs.whereToContinue = null;
            toCondition.set();
            this.compileBoolean(fs.optionalCondition, bodyOffset, true);
        }
        finally {
            this.codeContext.restoreLocalVariables();
        }
        if (fs.whereToBreak != null) {
            fs.whereToBreak.set();
            fs.whereToBreak = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.ForEachStatement fes) throws CompileException {
        IClass expressionType = this.getType(fes.expression);
        if (expressionType.isArray()) {
            this.codeContext.saveLocalVariables();
            try {
                Java.LocalVariable elementLv = this.getLocalVariable(fes.currentElement, false);
                elementLv.setSlot(this.codeContext.allocateLocalVariable(Descriptor.size(elementLv.type.getDescriptor()), fes.currentElement.name, elementLv.type));
                this.compileGetValue(fes.expression);
                short expressionLv = this.codeContext.allocateLocalVariable((short)1);
                this.store(fes.expression, expressionType, expressionLv);
                this.pushConstant(fes, 0);
                Java.LocalVariable indexLv = new Java.LocalVariable(false, IClass.INT);
                indexLv.setSlot(this.codeContext.allocateLocalVariable((short)1, null, indexLv.type));
                this.store(fes, indexLv);
                CodeContext.Offset toCondition = this.codeContext.new CodeContext.Offset();
                this.writeBranch(fes, -89, toCondition);
                fes.whereToContinue = null;
                CodeContext.Offset bodyOffset = this.codeContext.newOffset();
                this.load(fes, expressionType, expressionLv);
                this.load(fes, indexLv);
                this.writeOpcode(fes, 46 + UnitCompiler.ilfdabcs(expressionType.getComponentType()));
                this.assignmentConversion(fes.currentElement, expressionType.getComponentType(), elementLv.type, null);
                this.store(fes, elementLv);
                boolean bodyCcn = this.compile(fes.body);
                if (fes.whereToContinue != null) {
                    fes.whereToContinue.set();
                }
                if (!bodyCcn && fes.whereToContinue == null) {
                    this.warning("FUUR", "For update is unreachable", fes.getLocation());
                } else {
                    this.crement(fes, indexLv, "++");
                }
                fes.whereToContinue = null;
                toCondition.set();
                this.load(fes, indexLv);
                this.load(fes, expressionType, expressionLv);
                this.writeOpcode(fes, -66);
                this.writeBranch(fes, -95, bodyOffset);
            }
            finally {
                this.codeContext.restoreLocalVariables();
            }
            if (fes.whereToBreak != null) {
                fes.whereToBreak.set();
                fes.whereToBreak = null;
            }
        } else if (this.iClassLoader.TYPE_java_lang_Iterable.isAssignableFrom(expressionType)) {
            this.codeContext.saveLocalVariables();
            try {
                Java.LocalVariable elementLv = this.getLocalVariable(fes.currentElement, false);
                elementLv.setSlot(this.codeContext.allocateLocalVariable((short)1, fes.currentElement.name, elementLv.type));
                this.compileGetValue(fes.expression);
                this.invoke((Java.Locatable)fes.expression, this.iClassLoader.METH_java_lang_Iterable__iterator);
                Java.LocalVariable iteratorLv = new Java.LocalVariable(false, this.iClassLoader.TYPE_java_util_Iterator);
                iteratorLv.setSlot(this.codeContext.allocateLocalVariable((short)1, null, iteratorLv.type));
                this.store(fes, iteratorLv);
                CodeContext.Offset toCondition = this.codeContext.new CodeContext.Offset();
                this.writeBranch(fes, -89, toCondition);
                fes.whereToContinue = null;
                CodeContext.Offset bodyOffset = this.codeContext.newOffset();
                this.load(fes, iteratorLv);
                this.invoke((Java.Locatable)fes.expression, this.iClassLoader.METH_java_util_Iterator__next);
                if (!this.tryAssignmentConversion(fes.currentElement, this.iClassLoader.TYPE_java_lang_Object, elementLv.type, null) && !this.tryNarrowingReferenceConversion(fes.currentElement, this.iClassLoader.TYPE_java_lang_Object, elementLv.type)) {
                    throw new AssertionError();
                }
                this.store(fes, elementLv);
                boolean bodyCcn = this.compile(fes.body);
                if (fes.whereToContinue != null) {
                    fes.whereToContinue.set();
                }
                if (!bodyCcn && fes.whereToContinue == null) {
                    this.warning("FUUR", "For update is unreachable", fes.getLocation());
                }
                fes.whereToContinue = null;
                toCondition.set();
                this.load(fes, iteratorLv);
                this.invoke((Java.Locatable)fes.expression, this.iClassLoader.METH_java_util_Iterator__hasNext);
                this.writeBranch(fes, -102, bodyOffset);
            }
            finally {
                this.codeContext.restoreLocalVariables();
            }
            if (fes.whereToBreak != null) {
                fes.whereToBreak.set();
                fes.whereToBreak = null;
            }
        } else {
            this.compileError("Cannot iterate over '" + expressionType + "'");
        }
        return true;
    }

    private boolean compile2(Java.WhileStatement ws) throws CompileException {
        Object cvc = this.getConstantValue(ws.condition);
        if (cvc != NOT_CONSTANT) {
            if (Boolean.TRUE.equals(cvc)) {
                this.warning("WSTC", "Condition of WHILE statement is always TRUE; the proper way of declaring an unconditional loop is \"for (;;)\"", ws.getLocation());
                return this.compileUnconditionalLoop(ws, ws.body, null);
            }
            this.warning("WSNR", "WHILE statement never repeats", ws.getLocation());
        }
        ws.whereToContinue = this.codeContext.new CodeContext.Offset();
        this.writeBranch(ws, -89, ws.whereToContinue);
        CodeContext.Offset bodyOffset = this.codeContext.newOffset();
        this.compile(ws.body);
        ws.whereToContinue.set();
        ws.whereToContinue = null;
        this.compileBoolean(ws.condition, bodyOffset, true);
        if (ws.whereToBreak != null) {
            ws.whereToBreak.set();
            ws.whereToBreak = null;
        }
        return true;
    }

    private boolean compileUnconditionalLoop(Java.ContinuableStatement cs, Java.BlockStatement body2, Java.Rvalue[] optionalUpdate) throws CompileException {
        if (optionalUpdate != null) {
            return this.compileUnconditionalLoopWithUpdate(cs, body2, optionalUpdate);
        }
        cs.whereToContinue = this.codeContext.newOffset();
        if (this.compile(body2)) {
            this.writeBranch(cs, -89, cs.whereToContinue);
        }
        cs.whereToContinue = null;
        if (cs.whereToBreak == null) {
            return false;
        }
        cs.whereToBreak.set();
        cs.whereToBreak = null;
        return true;
    }

    private boolean compileUnconditionalLoopWithUpdate(Java.ContinuableStatement cs, Java.BlockStatement body2, Java.Rvalue[] update2) throws CompileException {
        cs.whereToContinue = null;
        CodeContext.Offset bodyOffset = this.codeContext.newOffset();
        boolean bodyCcn = this.compile(body2);
        if (cs.whereToContinue != null) {
            cs.whereToContinue.set();
        }
        if (!bodyCcn && cs.whereToContinue == null) {
            this.warning("LUUR", "Loop update is unreachable", update2[0].getLocation());
        } else {
            for (Java.Rvalue rv : update2) {
                this.compile(rv);
            }
            this.writeBranch(cs, -89, bodyOffset);
        }
        cs.whereToContinue = null;
        if (cs.whereToBreak == null) {
            return false;
        }
        cs.whereToBreak.set();
        cs.whereToBreak = null;
        return true;
    }

    private boolean compile2(Java.LabeledStatement ls) throws CompileException {
        boolean canCompleteNormally = this.compile(ls.body);
        if (ls.whereToBreak == null) {
            return canCompleteNormally;
        }
        ls.whereToBreak.set();
        ls.whereToBreak = null;
        return true;
    }

    private boolean compile2(Java.SwitchStatement ss) throws CompileException {
        IClass switchExpressionType = this.compileGetValue(ss.condition);
        this.assignmentConversion(ss, switchExpressionType, IClass.INT, null);
        TreeMap<Integer, CodeContext.Offset> caseLabelMap = new TreeMap<Integer, CodeContext.Offset>();
        CodeContext.Offset defaultLabelOffset = null;
        CodeContext.Offset[] sbsgOffsets = new CodeContext.Offset[ss.sbsgs.size()];
        for (int i = 0; i < ss.sbsgs.size(); ++i) {
            Java.SwitchStatement.SwitchBlockStatementGroup sbsg = ss.sbsgs.get(i);
            sbsgOffsets[i] = this.codeContext.new CodeContext.Offset();
            for (Java.Rvalue caseLabel : sbsg.caseLabels) {
                Integer civ;
                Object cv = this.getConstantValue(caseLabel);
                if (cv == NOT_CONSTANT) {
                    this.compileError("Value of 'case' label does not pose a constant value", caseLabel.getLocation());
                    cv = new Integer(99);
                }
                IClass iClass = this.getType(caseLabel);
                this.assignmentConversion(ss, iClass, switchExpressionType, cv);
                if (cv instanceof Integer) {
                    civ = (Integer)cv;
                } else if (cv instanceof Number) {
                    civ = new Integer(((Number)cv).intValue());
                } else if (cv instanceof Character) {
                    civ = new Integer(((Character)cv).charValue());
                } else {
                    this.compileError("Value of case label must be a char, byte, short or int constant", caseLabel.getLocation());
                    civ = new Integer(99);
                }
                if (caseLabelMap.containsKey(civ)) {
                    this.compileError("Duplicate \"case\" switch label value", caseLabel.getLocation());
                }
                caseLabelMap.put(civ, sbsgOffsets[i]);
            }
            if (!sbsg.hasDefaultLabel) continue;
            if (defaultLabelOffset != null) {
                this.compileError("Duplicate \"default\" switch label", sbsg.getLocation());
            }
            defaultLabelOffset = sbsgOffsets[i];
        }
        if (defaultLabelOffset == null) {
            defaultLabelOffset = this.getWhereToBreak(ss);
        }
        CodeContext.Offset switchOffset = this.codeContext.newOffset();
        if (!caseLabelMap.isEmpty()) {
            if ((Integer)caseLabelMap.firstKey() + caseLabelMap.size() >= (Integer)caseLabelMap.lastKey() - caseLabelMap.size()) {
                int low = (Integer)caseLabelMap.firstKey();
                int high = (Integer)caseLabelMap.lastKey();
                this.writeOpcode(ss, -86);
                new Java.Padder(this.codeContext).set();
                this.writeOffset(switchOffset, defaultLabelOffset);
                this.writeInt(low);
                this.writeInt(high);
                int cur = low;
                for (Map.Entry entry2 : caseLabelMap.entrySet()) {
                    int caseLabelValue = (Integer)entry2.getKey();
                    CodeContext.Offset caseLabelOffset = (CodeContext.Offset)entry2.getValue();
                    while (cur < caseLabelValue) {
                        this.writeOffset(switchOffset, defaultLabelOffset);
                        ++cur;
                    }
                    this.writeOffset(switchOffset, caseLabelOffset);
                    ++cur;
                }
            } else {
                this.writeOpcode(ss, -85);
                new Java.Padder(this.codeContext).set();
                this.writeOffset(switchOffset, defaultLabelOffset);
                this.writeInt(caseLabelMap.size());
                for (Map.Entry me : caseLabelMap.entrySet()) {
                    this.writeInt((Integer)me.getKey());
                    this.writeOffset(switchOffset, (CodeContext.Offset)me.getValue());
                }
            }
        }
        boolean canCompleteNormally = true;
        block5: for (int i = 0; i < ss.sbsgs.size(); ++i) {
            Java.SwitchStatement.SwitchBlockStatementGroup sbsg = ss.sbsgs.get(i);
            sbsgOffsets[i].set();
            canCompleteNormally = true;
            for (Java.BlockStatement blockStatement : sbsg.blockStatements) {
                if (!canCompleteNormally) {
                    this.compileError("Statement is unreachable", blockStatement.getLocation());
                    continue block5;
                }
                canCompleteNormally = this.compile(blockStatement);
            }
        }
        if (ss.whereToBreak == null) {
            return canCompleteNormally;
        }
        ss.whereToBreak.set();
        ss.whereToBreak = null;
        return true;
    }

    private boolean compile2(Java.BreakStatement bs) throws CompileException {
        Java.BreakableStatement brokenStatement = null;
        if (bs.optionalLabel == null) {
            Java.Scope s2 = bs.getEnclosingScope();
            while (s2 instanceof Java.Statement || s2 instanceof Java.CatchClause) {
                if (s2 instanceof Java.BreakableStatement) {
                    brokenStatement = (Java.BreakableStatement)s2;
                    break;
                }
                s2 = s2.getEnclosingScope();
            }
            if (brokenStatement == null) {
                this.compileError("\"break\" statement is not enclosed by a breakable statement", bs.getLocation());
                return false;
            }
        } else {
            Java.Scope s3 = bs.getEnclosingScope();
            while (s3 instanceof Java.Statement || s3 instanceof Java.CatchClause) {
                if (s3 instanceof Java.LabeledStatement) {
                    Java.LabeledStatement ls = (Java.LabeledStatement)s3;
                    if (ls.label.equals(bs.optionalLabel)) {
                        brokenStatement = ls;
                        break;
                    }
                }
                s3 = s3.getEnclosingScope();
            }
            if (brokenStatement == null) {
                this.compileError("Statement \"break " + bs.optionalLabel + "\" is not enclosed by a breakable statement with label \"" + bs.optionalLabel + "\"", bs.getLocation());
                return false;
            }
        }
        this.leaveStatements(bs.getEnclosingScope(), brokenStatement.getEnclosingScope(), null);
        this.writeBranch(bs, -89, this.getWhereToBreak(brokenStatement));
        return false;
    }

    private boolean compile2(Java.ContinueStatement cs) throws CompileException {
        Java.ContinuableStatement continuedStatement = null;
        if (cs.optionalLabel == null) {
            Java.Scope s2 = cs.getEnclosingScope();
            while (s2 instanceof Java.Statement || s2 instanceof Java.CatchClause) {
                if (s2 instanceof Java.ContinuableStatement) {
                    continuedStatement = (Java.ContinuableStatement)s2;
                    break;
                }
                s2 = s2.getEnclosingScope();
            }
            if (continuedStatement == null) {
                this.compileError("\"continue\" statement is not enclosed by a continuable statement", cs.getLocation());
                return false;
            }
        } else {
            Java.Scope s3 = cs.getEnclosingScope();
            while (s3 instanceof Java.Statement || s3 instanceof Java.CatchClause) {
                if (s3 instanceof Java.LabeledStatement) {
                    Java.LabeledStatement ls = (Java.LabeledStatement)s3;
                    if (ls.label.equals(cs.optionalLabel)) {
                        Java.Statement st = ls.body;
                        while (st instanceof Java.LabeledStatement) {
                            st = ((Java.LabeledStatement)st).body;
                        }
                        if (!(st instanceof Java.ContinuableStatement)) {
                            this.compileError("Labeled statement is not continuable", st.getLocation());
                            return false;
                        }
                        continuedStatement = (Java.ContinuableStatement)st;
                        break;
                    }
                }
                s3 = s3.getEnclosingScope();
            }
            if (continuedStatement == null) {
                this.compileError("Statement \"continue " + cs.optionalLabel + "\" is not enclosed by a continuable statement with label \"" + cs.optionalLabel + "\"", cs.getLocation());
                return false;
            }
        }
        if (continuedStatement.whereToContinue == null) {
            continuedStatement.whereToContinue = this.codeContext.new CodeContext.Offset();
        }
        this.leaveStatements(cs.getEnclosingScope(), continuedStatement.getEnclosingScope(), null);
        this.writeBranch(cs, -89, continuedStatement.whereToContinue);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.AssertStatement as) throws CompileException {
        CodeContext.Offset end = this.codeContext.new CodeContext.Offset();
        try {
            Java.Rvalue[] rvalueArray;
            this.compileBoolean(as.expression1, end, true);
            this.writeOpcode(as, -69);
            this.writeConstantClassInfo("Ljava/lang/AssertionError;");
            this.writeOpcode(as, 89);
            if (as.optionalExpression2 == null) {
                rvalueArray = new Java.Rvalue[]{};
            } else {
                Java.Rvalue[] rvalueArray2 = new Java.Rvalue[1];
                rvalueArray = rvalueArray2;
                rvalueArray2[0] = as.optionalExpression2;
            }
            Java.Rvalue[] arguments = rvalueArray;
            this.invokeConstructor(as, as, null, this.iClassLoader.TYPE_java_lang_AssertionError, arguments);
            this.writeOpcode(as, -65);
        }
        finally {
            end.set();
        }
        return true;
    }

    private boolean compile2(Java.EmptyStatement es) {
        return true;
    }

    private boolean compile2(Java.ExpressionStatement ee) throws CompileException {
        this.compile(ee.rvalue);
        return true;
    }

    private boolean compile2(Java.FieldDeclaration fd) throws CompileException {
        for (Java.VariableDeclarator vd : fd.variableDeclarators) {
            Java.ArrayInitializerOrRvalue initializer = this.getNonConstantFinalInitializer(fd, vd);
            if (initializer == null) continue;
            assert (fd.modifiers.annotations.length == 0);
            if (!Mod.isStatic(fd.modifiers.flags)) {
                this.writeOpcode(fd, 42);
            }
            IClass fieldType = this.getType(fd.type);
            if (initializer instanceof Java.Rvalue) {
                Java.Rvalue rvalue = (Java.Rvalue)initializer;
                IClass initializerType = this.compileGetValue(rvalue);
                fieldType = fieldType.getArrayIClass(vd.brackets, this.iClassLoader.TYPE_java_lang_Object);
                this.assignmentConversion(fd, initializerType, fieldType, this.getConstantValue(rvalue));
            } else if (initializer instanceof Java.ArrayInitializer) {
                this.compileGetValue((Java.ArrayInitializer)initializer, fieldType);
            } else {
                throw new JaninoRuntimeException("Unexpected array initializer or rvalue class " + initializer.getClass().getName());
            }
            assert (fd.modifiers.annotations.length == 0);
            this.putfield(fd, this.resolve(fd.getDeclaringType()).getDeclaredIField(vd.name));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.IfStatement is) throws CompileException {
        Java.BlockStatement es;
        Object cv = this.getConstantValue(is.condition);
        Java.BlockStatement blockStatement = es = is.optionalElseStatement != null ? is.optionalElseStatement : new Java.EmptyStatement(is.thenStatement.getLocation());
        if (cv instanceof Boolean) {
            Java.BlockStatement blindStatement;
            Java.BlockStatement seeingStatement;
            this.fakeCompile(is.condition);
            if (((Boolean)cv).booleanValue()) {
                seeingStatement = is.thenStatement;
                blindStatement = es;
            } else {
                seeingStatement = es;
                blindStatement = is.thenStatement;
            }
            CodeContext.Inserter ins = this.codeContext.newInserter();
            boolean ssccn = this.compile(seeingStatement);
            boolean bsccn = this.fakeCompile(blindStatement);
            if (ssccn) {
                return true;
            }
            if (!bsccn) {
                return false;
            }
            CodeContext.Offset off = this.codeContext.newOffset();
            this.codeContext.pushInserter(ins);
            try {
                this.pushConstant(is, Boolean.FALSE);
                this.writeBranch(is, -102, off);
            }
            finally {
                this.codeContext.popInserter();
            }
            return true;
        }
        if (this.generatesCode(is.thenStatement)) {
            if (this.generatesCode(es)) {
                CodeContext.Offset eso = this.codeContext.new CodeContext.Offset();
                CodeContext.Offset end = this.codeContext.new CodeContext.Offset();
                this.compileBoolean(is.condition, eso, false);
                boolean tsccn = this.compile(is.thenStatement);
                if (tsccn) {
                    this.writeBranch(is, -89, end);
                }
                eso.set();
                boolean esccn = this.compile(es);
                end.set();
                return tsccn || esccn;
            }
            CodeContext.Offset end = this.codeContext.new CodeContext.Offset();
            this.compileBoolean(is.condition, end, false);
            this.compile(is.thenStatement);
            end.set();
            return true;
        }
        if (this.generatesCode(es)) {
            CodeContext.Offset end = this.codeContext.new CodeContext.Offset();
            this.compileBoolean(is.condition, end, true);
            this.compile(es);
            end.set();
            return true;
        }
        IClass conditionType = this.compileGetValue(is.condition);
        if (conditionType != IClass.BOOLEAN) {
            this.compileError("Not a boolean expression", is.getLocation());
        }
        this.pop(is, conditionType);
        return true;
    }

    private boolean compile2(Java.LocalClassDeclarationStatement lcds) throws CompileException {
        Java.LocalClassDeclaration otherLcd = UnitCompiler.findLocalClassDeclaration(lcds, lcds.lcd.name);
        if (otherLcd != lcds.lcd) {
            this.compileError("Redeclaration of local class \"" + lcds.lcd.name + "\"; previously declared in " + otherLcd.getLocation());
        }
        this.compile(lcds.lcd);
        return true;
    }

    private static Java.LocalClassDeclaration findLocalClassDeclaration(Java.Scope s2, String name2) {
        Java.Scope es;
        while (!((es = s2.getEnclosingScope()) instanceof Java.CompilationUnit)) {
            if (s2 instanceof Java.BlockStatement && (es instanceof Java.Block || es instanceof Java.FunctionDeclarator)) {
                Java.BlockStatement bs = (Java.BlockStatement)s2;
                List<Java.BlockStatement> statements = es instanceof Java.BlockStatement ? ((Java.Block)es).statements : ((Java.FunctionDeclarator)es).optionalStatements;
                for (Java.BlockStatement bs2 : statements) {
                    if (bs2 instanceof Java.LocalClassDeclarationStatement) {
                        Java.LocalClassDeclarationStatement lcds = (Java.LocalClassDeclarationStatement)bs2;
                        if (lcds.lcd.name.equals(name2)) {
                            return lcds.lcd;
                        }
                    }
                    if (bs2 != bs) continue;
                    break;
                }
            }
            s2 = es;
        }
        return null;
    }

    private boolean compile2(Java.LocalVariableDeclarationStatement lvds) throws CompileException {
        assert (lvds.modifiers.annotations.length == 0);
        if ((lvds.modifiers.flags & 0xFFFFFFEF) != 0) {
            this.compileError("The only allowed modifier in local variable declarations is \"final\"", lvds.getLocation());
        }
        for (Java.VariableDeclarator vd : lvds.variableDeclarators) {
            Java.LocalVariable lv = this.getLocalVariable(lvds, vd);
            lv.setSlot(this.codeContext.allocateLocalVariable(Descriptor.size(lv.type.getDescriptor()), vd.name, lv.type));
            if (vd.optionalInitializer == null) continue;
            if (vd.optionalInitializer instanceof Java.Rvalue) {
                Java.Rvalue rhs = (Java.Rvalue)vd.optionalInitializer;
                this.assignmentConversion(lvds, this.compileGetValue(rhs), lv.type, this.getConstantValue(rhs));
            } else if (vd.optionalInitializer instanceof Java.ArrayInitializer) {
                this.compileGetValue((Java.ArrayInitializer)vd.optionalInitializer, lv.type);
            } else {
                throw new JaninoRuntimeException("Unexpected rvalue or array initialized class " + vd.optionalInitializer.getClass().getName());
            }
            this.store(lvds, lv);
        }
        return true;
    }

    public Java.LocalVariable getLocalVariable(Java.LocalVariableDeclarationStatement lvds, Java.VariableDeclarator vd) throws CompileException {
        if (vd.localVariable == null) {
            Java.Type variableType = lvds.type;
            for (int k = 0; k < vd.brackets; ++k) {
                variableType = new Java.ArrayType(variableType);
            }
            assert (lvds.modifiers.annotations.length == 0);
            vd.localVariable = new Java.LocalVariable(Mod.isFinal(lvds.modifiers.flags), this.getType(variableType));
        }
        return vd.localVariable;
    }

    private boolean compile2(Java.ReturnStatement rs) throws CompileException {
        Java.FunctionDeclarator enclosingFunction = null;
        Java.Scope s2 = rs.getEnclosingScope();
        while (s2 instanceof Java.Statement || s2 instanceof Java.CatchClause) {
            s2 = s2.getEnclosingScope();
        }
        enclosingFunction = (Java.FunctionDeclarator)s2;
        IClass returnType = this.getReturnType(enclosingFunction);
        if (returnType == IClass.VOID) {
            if (rs.optionalReturnValue != null) {
                this.compileError("Method must not return a value", rs.getLocation());
            }
            this.leaveStatements(rs.getEnclosingScope(), enclosingFunction, null);
            this.writeOpcode(rs, -79);
            return false;
        }
        if (rs.optionalReturnValue == null) {
            this.compileError("Method must return a value", rs.getLocation());
            return false;
        }
        IClass type = this.compileGetValue(rs.optionalReturnValue);
        this.assignmentConversion(rs, type, returnType, this.getConstantValue(rs.optionalReturnValue));
        this.leaveStatements(rs.getEnclosingScope(), enclosingFunction, returnType);
        this.writeOpcode(rs, -84 + UnitCompiler.ilfda(returnType));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.SynchronizedStatement ss) throws CompileException {
        if (!this.iClassLoader.TYPE_java_lang_Object.isAssignableFrom(this.compileGetValue(ss.expression))) {
            this.compileError("Monitor object of \"synchronized\" statement is not a subclass of \"Object\"", ss.getLocation());
        }
        this.codeContext.saveLocalVariables();
        boolean canCompleteNormally = false;
        try {
            ss.monitorLvIndex = this.codeContext.allocateLocalVariable((short)1);
            this.writeOpcode(ss, 89);
            this.store(ss, this.iClassLoader.TYPE_java_lang_Object, ss.monitorLvIndex);
            this.writeOpcode(ss, -62);
            CodeContext.Offset monitorExitOffset = this.codeContext.new CodeContext.Offset();
            CodeContext.Offset beginningOfBody = this.codeContext.newOffset();
            canCompleteNormally = this.compile(ss.body);
            if (canCompleteNormally) {
                this.writeBranch(ss, -89, monitorExitOffset);
            }
            CodeContext.Offset here = this.codeContext.newOffset();
            this.codeContext.addExceptionTableEntry(beginningOfBody, here, here, null);
            this.leave(ss, this.iClassLoader.TYPE_java_lang_Throwable);
            this.writeOpcode(ss, -65);
            if (canCompleteNormally) {
                monitorExitOffset.set();
                this.leave(ss, null);
            }
        }
        finally {
            this.codeContext.restoreLocalVariables();
        }
        return canCompleteNormally;
    }

    private boolean compile2(Java.ThrowStatement ts) throws CompileException {
        IClass expressionType = this.compileGetValue(ts.expression);
        this.checkThrownException(ts, expressionType, ts.getEnclosingScope());
        this.writeOpcode(ts, -65);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.TryStatement ts) throws CompileException {
        if (ts.optionalFinally != null) {
            ts.finallyOffset = this.codeContext.new CodeContext.Offset();
        }
        CodeContext.Offset beginningOfBody = this.codeContext.newOffset();
        CodeContext.Offset afterStatement = this.codeContext.new CodeContext.Offset();
        this.codeContext.saveLocalVariables();
        try {
            short pcLvIndex = ts.optionalFinally != null ? this.codeContext.allocateLocalVariable((short)1) : (short)0;
            for (Java.CatchClause catchClause : ts.catchClauses) {
                IClass caughtExceptionType = this.getType(catchClause.caughtException.type);
                catchClause.reachable = this.iClassLoader.TYPE_java_lang_Error.isAssignableFrom(caughtExceptionType) || caughtExceptionType.isAssignableFrom(this.iClassLoader.TYPE_java_lang_Error) || this.iClassLoader.TYPE_java_lang_RuntimeException.isAssignableFrom(caughtExceptionType) || caughtExceptionType.isAssignableFrom(this.iClassLoader.TYPE_java_lang_RuntimeException);
            }
            boolean canCompleteNormally = this.compile(ts.body);
            CodeContext.Offset afterBody = this.codeContext.newOffset();
            if (canCompleteNormally) {
                this.writeBranch(ts, -89, afterStatement);
            }
            if (beginningOfBody.offset != afterBody.offset) {
                this.codeContext.saveLocalVariables();
                try {
                    for (int i = 0; i < ts.catchClauses.size(); ++i) {
                        try {
                            this.codeContext.saveLocalVariables();
                            Java.CatchClause catchClause = ts.catchClauses.get(i);
                            IClass caughtExceptionType = this.getType(catchClause.caughtException.type);
                            if (!catchClause.reachable) {
                                this.compileError("Catch clause is unreachable", catchClause.getLocation());
                            }
                            Java.LocalVariableSlot exceptionVarSlot = this.codeContext.allocateLocalVariable((short)1, catchClause.caughtException.name, caughtExceptionType);
                            short evi = exceptionVarSlot.getSlotIndex();
                            this.getLocalVariable(catchClause.caughtException).setSlot(exceptionVarSlot);
                            this.codeContext.addExceptionTableEntry(beginningOfBody, afterBody, this.codeContext.newOffset(), caughtExceptionType.getDescriptor());
                            this.store(catchClause, caughtExceptionType, evi);
                            if (!this.compile(catchClause.body)) continue;
                            canCompleteNormally = true;
                            if (i >= ts.catchClauses.size() - 1 && ts.optionalFinally == null) continue;
                            this.writeBranch(catchClause, -89, afterStatement);
                            continue;
                        }
                        finally {
                            this.codeContext.restoreLocalVariables();
                        }
                    }
                }
                finally {
                    this.codeContext.restoreLocalVariables();
                }
            }
            if (ts.optionalFinally != null) {
                CodeContext.Offset here = this.codeContext.newOffset();
                this.codeContext.addExceptionTableEntry(beginningOfBody, here, here, null);
                this.codeContext.saveLocalVariables();
                try {
                    short evi = this.codeContext.allocateLocalVariable((short)1);
                    this.store(ts.optionalFinally, this.iClassLoader.TYPE_java_lang_Object, evi);
                    this.writeBranch(ts.optionalFinally, -88, ts.finallyOffset);
                    this.load(ts.optionalFinally, this.iClassLoader.TYPE_java_lang_Object, evi);
                    this.writeOpcode(ts.optionalFinally, -65);
                    ts.finallyOffset.set();
                    this.store(ts.optionalFinally, this.iClassLoader.TYPE_java_lang_Object, pcLvIndex);
                    if (this.compile(ts.optionalFinally)) {
                        if (pcLvIndex > 255) {
                            this.writeOpcode(ts.optionalFinally, -60);
                            this.writeOpcode(ts.optionalFinally, -87);
                            this.writeShort(pcLvIndex);
                        } else {
                            this.writeOpcode(ts.optionalFinally, -87);
                            this.writeByte(pcLvIndex);
                        }
                    }
                }
                finally {
                    this.codeContext.restoreLocalVariables();
                }
            }
            afterStatement.set();
            if (canCompleteNormally) {
                this.leave(ts, null);
            }
            boolean bl = canCompleteNormally;
            return bl;
        }
        finally {
            this.codeContext.restoreLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(Java.FunctionDeclarator fd, ClassFile classFile) throws CompileException {
        short lvtani;
        ClassFile.MethodInfo mi;
        if (Mod.isPrivateAccess(fd.modifiers.flags)) {
            short modifiers;
            if (fd instanceof Java.MethodDeclarator && !fd.isStatic()) {
                modifiers = Mod.changeAccess(fd.modifiers.flags, (short)0);
                modifiers = (short)(modifiers | 8);
                mi = classFile.addMethodInfo(new Java.Modifiers(modifiers, fd.modifiers.annotations), fd.name + '$', MethodDescriptor.prependParameter(this.toIMethod((Java.MethodDeclarator)fd).getDescriptor(), this.resolve(fd.getDeclaringType()).getDescriptor()));
            } else {
                assert (fd.modifiers.annotations.length == 0) : "NYI";
                modifiers = Mod.changeAccess(fd.modifiers.flags, (short)0);
                mi = classFile.addMethodInfo(new Java.Modifiers(modifiers, fd.modifiers.annotations), fd.name, this.toIInvocable(fd).getDescriptor());
            }
        } else {
            mi = classFile.addMethodInfo(fd.modifiers, fd.name, this.toIInvocable(fd).getDescriptor());
        }
        if (fd.thrownExceptions.length > 0) {
            short eani = classFile.addConstantUtf8Info("Exceptions");
            short[] tecciis = new short[fd.thrownExceptions.length];
            for (int i = 0; i < fd.thrownExceptions.length; ++i) {
                tecciis[i] = classFile.addConstantClassInfo(this.getType(fd.thrownExceptions[i]).getDescriptor());
            }
            mi.addAttribute(new ClassFile.ExceptionsAttribute(eani, tecciis));
        }
        if (fd.hasDeprecatedDocTag()) {
            mi.addAttribute(new ClassFile.DeprecatedAttribute(classFile.addConstantUtf8Info("Deprecated")));
        }
        if (Mod.isAbstract(fd.modifiers.flags) || Mod.isNative(fd.modifiers.flags)) {
            return;
        }
        final CodeContext codeContext = new CodeContext(mi.getClassFile());
        CodeContext savedCodeContext = this.replaceCodeContext(codeContext);
        try {
            this.codeContext.saveLocalVariables();
            if (!Mod.isStatic(fd.modifiers.flags)) {
                this.codeContext.allocateLocalVariable((short)1, "this", this.resolve(fd.getDeclaringType()));
            }
            if (fd instanceof Java.ConstructorDeclarator) {
                Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)fd;
                for (IClass.IField sf : constructorDeclarator.getDeclaringClass().syntheticFields.values()) {
                    Java.LocalVariable lv = new Java.LocalVariable(true, sf.getType());
                    lv.setSlot(this.codeContext.allocateLocalVariable(Descriptor.size(sf.getDescriptor()), null, null));
                    constructorDeclarator.syntheticParameters.put(sf.getName(), lv);
                }
            }
            this.buildLocalVariableMap(fd);
            if (fd instanceof Java.ConstructorDeclarator) {
                Java.ConstructorDeclarator cd = (Java.ConstructorDeclarator)fd;
                if (cd.optionalConstructorInvocation != null) {
                    this.compile(cd.optionalConstructorInvocation);
                    if (cd.optionalConstructorInvocation instanceof Java.SuperConstructorInvocation) {
                        this.assignSyntheticParametersToSyntheticFields(cd);
                        this.initializeInstanceVariablesAndInvokeInstanceInitializers(cd);
                    }
                } else {
                    IClass outerClassOfSuperclass = this.resolve(cd.getDeclaringClass()).getSuperclass().getOuterIClass();
                    Java.QualifiedThisReference qualification = null;
                    if (outerClassOfSuperclass != null) {
                        qualification = new Java.QualifiedThisReference(cd.getLocation(), new Java.SimpleType(cd.getLocation(), outerClassOfSuperclass));
                    }
                    Java.SuperConstructorInvocation sci = new Java.SuperConstructorInvocation(cd.getLocation(), qualification, new Java.Rvalue[0]);
                    sci.setEnclosingScope(fd);
                    this.compile(sci);
                    this.assignSyntheticParametersToSyntheticFields(cd);
                    this.initializeInstanceVariablesAndInvokeInstanceInitializers(cd);
                }
            }
            if (fd.optionalStatements == null) {
                this.compileError("Method must have a body", fd.getLocation());
                return;
            }
            if (this.compileStatements(fd.optionalStatements)) {
                if (this.getReturnType(fd) != IClass.VOID) {
                    this.compileError("Method must return a value", fd.getLocation());
                }
                this.writeOpcode(fd, -79);
            }
        }
        finally {
            this.codeContext.restoreLocalVariables();
            this.replaceCodeContext(savedCodeContext);
        }
        if (this.compileErrorCount > 0) {
            return;
        }
        codeContext.fixUpAndRelocate();
        codeContext.flowAnalysis(fd.toString());
        final short lntani = this.debugLines ? classFile.addConstantUtf8Info("LineNumberTable") : (short)0;
        if (this.debugVars) {
            UnitCompiler.makeLocalVariableNames(codeContext, mi);
            lvtani = classFile.addConstantUtf8Info("LocalVariableTable");
        } else {
            lvtani = 0;
        }
        mi.addAttribute(new ClassFile.AttributeInfo(classFile.addConstantUtf8Info("Code")){

            @Override
            protected void storeBody(DataOutputStream dos) throws IOException {
                codeContext.storeCodeAttributeBody(dos, lntani, lvtani);
            }
        });
    }

    private static void makeLocalVariableNames(CodeContext cc, ClassFile.MethodInfo mi) {
        ClassFile cf = mi.getClassFile();
        cf.addConstantUtf8Info("LocalVariableTable");
        for (Java.LocalVariableSlot slot : cc.getAllLocalVars()) {
            if (slot.getName() == null) continue;
            String typeName = slot.getType().getDescriptor();
            cf.addConstantUtf8Info(typeName);
            cf.addConstantUtf8Info(slot.getName());
        }
    }

    private void buildLocalVariableMap(Java.FunctionDeclarator fd) throws CompileException {
        Map<String, Java.LocalVariable> localVars = new HashMap<String, Java.LocalVariable>();
        for (int i = 0; i < fd.formalParameters.parameters.length; ++i) {
            Java.FunctionDeclarator.FormalParameter formalParameter = fd.formalParameters.parameters[i];
            IClass parameterIClass = this.getType(formalParameter.type);
            Java.LocalVariable lv = this.getLocalVariable(formalParameter, i == fd.formalParameters.parameters.length - 1 && fd.formalParameters.variableArity);
            lv.setSlot(this.codeContext.allocateLocalVariable(Descriptor.size(lv.type.getDescriptor()), formalParameter.name, parameterIClass));
            if (localVars.put(formalParameter.name, lv) == null) continue;
            this.compileError("Redefinition of parameter \"" + formalParameter.name + "\"", fd.getLocation());
        }
        fd.localVariables = localVars;
        if (fd instanceof Java.ConstructorDeclarator) {
            Java.ConstructorDeclarator cd = (Java.ConstructorDeclarator)fd;
            if (cd.optionalConstructorInvocation != null) {
                UnitCompiler.buildLocalVariableMap(cd.optionalConstructorInvocation, localVars);
            }
        }
        if (fd.optionalStatements != null) {
            for (Java.BlockStatement blockStatement : fd.optionalStatements) {
                localVars = this.buildLocalVariableMap(blockStatement, localVars);
            }
        }
    }

    private Map<String, Java.LocalVariable> buildLocalVariableMap(Java.BlockStatement blockStatement, final Map<String, Java.LocalVariable> localVars) throws CompileException {
        final Map[] resVars = new Map[]{localVars};
        Visitor.BlockStatementVisitor bsv = new Visitor.BlockStatementVisitor(){

            @Override
            public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) {
                UnitCompiler.buildLocalVariableMap(aci, (Map<String, Java.LocalVariable>)localVars);
            }

            @Override
            public void visitBreakStatement(Java.BreakStatement bs) {
                UnitCompiler.buildLocalVariableMap(bs, (Map<String, Java.LocalVariable>)localVars);
            }

            @Override
            public void visitContinueStatement(Java.ContinueStatement cs) {
                UnitCompiler.buildLocalVariableMap(cs, (Map<String, Java.LocalVariable>)localVars);
            }

            @Override
            public void visitAssertStatement(Java.AssertStatement as) {
                UnitCompiler.buildLocalVariableMap(as, (Map<String, Java.LocalVariable>)localVars);
            }

            @Override
            public void visitEmptyStatement(Java.EmptyStatement es) {
                UnitCompiler.buildLocalVariableMap(es, (Map<String, Java.LocalVariable>)localVars);
            }

            @Override
            public void visitExpressionStatement(Java.ExpressionStatement es) {
                UnitCompiler.buildLocalVariableMap(es, (Map<String, Java.LocalVariable>)localVars);
            }

            @Override
            public void visitFieldDeclaration(Java.FieldDeclaration fd) {
                UnitCompiler.buildLocalVariableMap(fd, (Map<String, Java.LocalVariable>)localVars);
            }

            @Override
            public void visitReturnStatement(Java.ReturnStatement rs) {
                UnitCompiler.buildLocalVariableMap(rs, (Map<String, Java.LocalVariable>)localVars);
            }

            @Override
            public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) {
                UnitCompiler.buildLocalVariableMap(sci, (Map<String, Java.LocalVariable>)localVars);
            }

            @Override
            public void visitThrowStatement(Java.ThrowStatement ts) {
                UnitCompiler.buildLocalVariableMap(ts, (Map<String, Java.LocalVariable>)localVars);
            }

            @Override
            public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) {
                UnitCompiler.buildLocalVariableMap(lcds, (Map<String, Java.LocalVariable>)localVars);
            }

            @Override
            public void visitBlock(Java.Block b) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(b, (Map<String, Java.LocalVariable>)localVars);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitDoStatement(Java.DoStatement ds) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(ds, (Map<String, Java.LocalVariable>)localVars);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitForStatement(Java.ForStatement fs) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(fs, (Map<String, Java.LocalVariable>)localVars);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitForEachStatement(Java.ForEachStatement fes) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(fes, (Map<String, Java.LocalVariable>)localVars);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitIfStatement(Java.IfStatement is) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(is, (Map<String, Java.LocalVariable>)localVars);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitInitializer(Java.Initializer i) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(i, (Map<String, Java.LocalVariable>)localVars);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSwitchStatement(Java.SwitchStatement ss) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(ss, (Map<String, Java.LocalVariable>)localVars);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSynchronizedStatement(Java.SynchronizedStatement ss) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(ss, (Map<String, Java.LocalVariable>)localVars);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitTryStatement(Java.TryStatement ts) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(ts, (Map<String, Java.LocalVariable>)localVars);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitWhileStatement(Java.WhileStatement ws) {
                try {
                    UnitCompiler.this.buildLocalVariableMap(ws, (Map<String, Java.LocalVariable>)localVars);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLabeledStatement(Java.LabeledStatement ls) {
                try {
                    resVars[0] = UnitCompiler.this.buildLocalVariableMap(ls, (Map<String, Java.LocalVariable>)localVars);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                try {
                    resVars[0] = UnitCompiler.this.buildLocalVariableMap(lvds, (Map<String, Java.LocalVariable>)localVars);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }
        };
        try {
            blockStatement.accept(bsv);
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
        return resVars[0];
    }

    private static Map<String, Java.LocalVariable> buildLocalVariableMap(Java.Statement s2, Map<String, Java.LocalVariable> localVars) {
        s2.localVariables = localVars;
        return s2.localVariables;
    }

    private static Map<String, Java.LocalVariable> buildLocalVariableMap(Java.ConstructorInvocation ci, Map<String, Java.LocalVariable> localVars) {
        ci.localVariables = localVars;
        return ci.localVariables;
    }

    private void buildLocalVariableMap(Java.Block block, Map<String, Java.LocalVariable> localVars) throws CompileException {
        block.localVariables = localVars;
        for (Java.BlockStatement bs : block.statements) {
            localVars = this.buildLocalVariableMap(bs, localVars);
        }
    }

    private void buildLocalVariableMap(Java.DoStatement ds, Map<String, Java.LocalVariable> localVars) throws CompileException {
        ds.localVariables = localVars;
        this.buildLocalVariableMap(ds.body, localVars);
    }

    private void buildLocalVariableMap(Java.ForStatement fs, Map<String, Java.LocalVariable> localVars) throws CompileException {
        Map<String, Java.LocalVariable> inner3 = localVars;
        if (fs.optionalInit != null) {
            inner3 = this.buildLocalVariableMap(fs.optionalInit, localVars);
        }
        fs.localVariables = inner3;
        this.buildLocalVariableMap(fs.body, inner3);
    }

    private void buildLocalVariableMap(Java.ForEachStatement fes, Map<String, Java.LocalVariable> localVars) throws CompileException {
        HashMap<String, Java.LocalVariable> vars = new HashMap<String, Java.LocalVariable>();
        vars.putAll(localVars);
        Java.LocalVariable elementLv = this.getLocalVariable(fes.currentElement, false);
        vars.put(fes.currentElement.name, elementLv);
        fes.localVariables = vars;
        this.buildLocalVariableMap(fes.body, vars);
    }

    private void buildLocalVariableMap(Java.IfStatement is, Map<String, Java.LocalVariable> localVars) throws CompileException {
        is.localVariables = localVars;
        this.buildLocalVariableMap(is.thenStatement, localVars);
        if (is.optionalElseStatement != null) {
            this.buildLocalVariableMap(is.optionalElseStatement, localVars);
        }
    }

    private void buildLocalVariableMap(Java.Initializer i, Map<String, Java.LocalVariable> localVars) throws CompileException {
        this.buildLocalVariableMap(i.block, localVars);
    }

    private void buildLocalVariableMap(Java.SwitchStatement ss, Map<String, Java.LocalVariable> localVars) throws CompileException {
        ss.localVariables = localVars;
        Map<String, Java.LocalVariable> vars = localVars;
        for (Java.SwitchStatement.SwitchBlockStatementGroup sbsg : ss.sbsgs) {
            for (Java.BlockStatement bs : sbsg.blockStatements) {
                vars = this.buildLocalVariableMap(bs, vars);
            }
        }
    }

    private void buildLocalVariableMap(Java.SynchronizedStatement ss, Map<String, Java.LocalVariable> localVars) throws CompileException {
        ss.localVariables = localVars;
        this.buildLocalVariableMap(ss.body, localVars);
    }

    private void buildLocalVariableMap(Java.TryStatement ts, Map<String, Java.LocalVariable> localVars) throws CompileException {
        ts.localVariables = localVars;
        this.buildLocalVariableMap(ts.body, localVars);
        for (Java.CatchClause cc : ts.catchClauses) {
            this.buildLocalVariableMap(cc, localVars);
        }
        if (ts.optionalFinally != null) {
            this.buildLocalVariableMap(ts.optionalFinally, localVars);
        }
    }

    private void buildLocalVariableMap(Java.WhileStatement ws, Map<String, Java.LocalVariable> localVars) throws CompileException {
        ws.localVariables = localVars;
        this.buildLocalVariableMap(ws.body, localVars);
    }

    private Map<String, Java.LocalVariable> buildLocalVariableMap(Java.LabeledStatement ls, Map<String, Java.LocalVariable> localVars) throws CompileException {
        ls.localVariables = localVars;
        return this.buildLocalVariableMap(ls.body, localVars);
    }

    private Map<String, Java.LocalVariable> buildLocalVariableMap(Java.LocalVariableDeclarationStatement lvds, Map<String, Java.LocalVariable> localVars) throws CompileException {
        HashMap<String, Java.LocalVariable> newVars = new HashMap<String, Java.LocalVariable>();
        newVars.putAll(localVars);
        for (Java.VariableDeclarator vd : lvds.variableDeclarators) {
            Java.LocalVariable lv = this.getLocalVariable(lvds, vd);
            if (newVars.put(vd.name, lv) == null) continue;
            this.compileError("Redefinition of local variable \"" + vd.name + "\" ", vd.getLocation());
        }
        lvds.localVariables = newVars;
        return newVars;
    }

    protected void buildLocalVariableMap(Java.CatchClause catchClause, Map<String, Java.LocalVariable> localVars) throws CompileException {
        HashMap<String, Java.LocalVariable> vars = new HashMap<String, Java.LocalVariable>();
        vars.putAll(localVars);
        Java.LocalVariable lv = this.getLocalVariable(catchClause.caughtException);
        vars.put(catchClause.caughtException.name, lv);
        this.buildLocalVariableMap(catchClause.body, vars);
    }

    public Java.LocalVariable getLocalVariable(Java.FunctionDeclarator.FormalParameter parameter) throws CompileException {
        return this.getLocalVariable(parameter, false);
    }

    public Java.LocalVariable getLocalVariable(Java.FunctionDeclarator.FormalParameter parameter, boolean isVariableArityParameter) throws CompileException {
        if (parameter.localVariable == null) {
            assert (parameter.type != null);
            IClass parameterType = this.getType(parameter.type);
            if (isVariableArityParameter) {
                parameterType = parameterType.getArrayIClass(this.iClassLoader.TYPE_java_lang_Object);
            }
            parameter.localVariable = new Java.LocalVariable(parameter.finaL, parameterType);
        }
        return parameter.localVariable;
    }

    private void fakeCompile(Java.ArrayInitializerOrRvalue aior) throws CompileException {
        if (aior instanceof Java.Rvalue) {
            this.fakeCompile((Java.Rvalue)aior);
        }
        if (aior instanceof Java.ArrayInitializer) {
            for (Java.ArrayInitializerOrRvalue v : ((Java.ArrayInitializer)aior).values) {
                this.fakeCompile(v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fakeCompile(Java.Rvalue rv) throws CompileException {
        CodeContext savedCodeContext = this.replaceCodeContext(this.createDummyCodeContext());
        try {
            this.compileContext(rv);
            this.compileGet(rv);
        }
        finally {
            this.replaceCodeContext(savedCodeContext);
        }
    }

    private void compile(Java.Rvalue rv) throws CompileException {
        Visitor.RvalueVisitor rvv = new Visitor.RvalueVisitor(){

            @Override
            public void visitArrayLength(Java.ArrayLength al) {
                try {
                    UnitCompiler.this.compile2(al);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitAssignment(Java.Assignment a) {
                try {
                    UnitCompiler.this.compile2(a);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitUnaryOperation(Java.UnaryOperation uo) {
                try {
                    UnitCompiler.this.compile2(uo);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBinaryOperation(Java.BinaryOperation bo) {
                try {
                    UnitCompiler.this.compile2(bo);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCast(Java.Cast c) {
                try {
                    UnitCompiler.this.compile2(c);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitClassLiteral(Java.ClassLiteral cl) {
                try {
                    UnitCompiler.this.compile2(cl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                try {
                    UnitCompiler.this.compile2(ce);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCrement(Java.Crement c) {
                try {
                    UnitCompiler.this.compile2(c);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitInstanceof(Java.Instanceof io) {
                try {
                    UnitCompiler.this.compile2(io);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitMethodInvocation(Java.MethodInvocation mi) {
                try {
                    UnitCompiler.this.compile2(mi);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                try {
                    UnitCompiler.this.compile2(smi);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitIntegerLiteral(Java.IntegerLiteral il) {
                try {
                    UnitCompiler.this.compile2(il);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) {
                try {
                    UnitCompiler.this.compile2(fpl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBooleanLiteral(Java.BooleanLiteral bl) {
                try {
                    UnitCompiler.this.compile2(bl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCharacterLiteral(Java.CharacterLiteral cl) {
                try {
                    UnitCompiler.this.compile2(cl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitStringLiteral(Java.StringLiteral sl) {
                try {
                    UnitCompiler.this.compile2(sl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNullLiteral(Java.NullLiteral nl) {
                try {
                    UnitCompiler.this.compile2(nl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSimpleConstant(Java.SimpleConstant sl) {
                try {
                    UnitCompiler.this.compile2(sl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                try {
                    UnitCompiler.this.compile2(naci);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewArray(Java.NewArray na) {
                try {
                    UnitCompiler.this.compile2(na);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                try {
                    UnitCompiler.this.compile2(nia);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewClassInstance(Java.NewClassInstance nci) {
                try {
                    UnitCompiler.this.compile2(nci);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitParameterAccess(Java.ParameterAccess pa) {
                try {
                    UnitCompiler.this.compile2(pa);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                try {
                    UnitCompiler.this.compile2(qtr);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitThisReference(Java.ThisReference tr) {
                try {
                    UnitCompiler.this.compile2(tr);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    UnitCompiler.this.compile2(an);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    UnitCompiler.this.compile2(aae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    UnitCompiler.this.compile2(fa);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    UnitCompiler.this.compile2(fae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    UnitCompiler.this.compile2(scfae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                try {
                    UnitCompiler.this.compile2(lva);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    UnitCompiler.this.compile2(pe);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }
        };
        try {
            rv.accept(rvv);
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
    }

    private void compile2(Java.Rvalue rv) throws CompileException {
        this.pop(rv, this.compileGetValue(rv));
    }

    private void compile2(Java.Assignment a) throws CompileException {
        if (a.operator == "=") {
            this.compileContext(a.lhs);
            this.assignmentConversion(a, this.compileGetValue(a.rhs), this.getType(a.lhs), this.getConstantValue(a.rhs));
            this.compileSet(a.lhs);
            return;
        }
        int lhsCs = this.compileContext(a.lhs);
        this.dup(a, lhsCs);
        IClass lhsType = this.compileGet(a.lhs);
        IClass resultType = this.compileArithmeticBinaryOperation(a, lhsType, a.operator.substring(0, a.operator.length() - 1).intern(), a.rhs);
        if (!(this.tryIdentityConversion(resultType, lhsType) || this.tryNarrowingPrimitiveConversion(a, resultType, lhsType) || this.tryBoxingConversion(a, resultType, lhsType))) {
            this.compileError("Operand types unsuitable for '" + a.operator + "'", a.getLocation());
        }
        this.compileSet(a.lhs);
    }

    private void compile2(Java.Crement c) throws CompileException {
        Java.LocalVariable lv = this.isIntLv(c);
        if (lv != null) {
            this.compileLocalVariableCrement(c, lv);
            return;
        }
        int cs = this.compileContext(c.operand);
        this.dup(c, cs);
        IClass type = this.compileGet(c.operand);
        IClass promotedType = this.unaryNumericPromotion(c, type);
        this.writeOpcode(c, UnitCompiler.ilfd(promotedType, 4, 10, 12, 15));
        if (c.operator == "++") {
            this.writeOpcode(c, 96 + UnitCompiler.ilfd(promotedType));
        } else if (c.operator == "--") {
            this.writeOpcode(c, 100 + UnitCompiler.ilfd(promotedType));
        } else {
            this.compileError("Unexpected operator \"" + c.operator + "\"", c.getLocation());
        }
        this.reverseUnaryNumericPromotion(c, promotedType, type);
        this.compileSet(c.operand);
    }

    private void compile2(Java.ParenthesizedExpression pe) throws CompileException {
        this.compile(pe.value);
    }

    private boolean compile2(Java.AlternateConstructorInvocation aci) throws CompileException {
        Java.ConstructorDeclarator declaringConstructor = (Java.ConstructorDeclarator)aci.getEnclosingScope();
        IClass declaringIClass = this.resolve(declaringConstructor.getDeclaringClass());
        this.writeOpcode(aci, 42);
        if (declaringIClass.getOuterIClass() != null) {
            this.writeOpcode(aci, 43);
        }
        this.invokeConstructor(aci, declaringConstructor, null, declaringIClass, aci.arguments);
        return true;
    }

    private boolean compile2(Java.SuperConstructorInvocation sci) throws CompileException {
        Java.Rvalue optionalEnclosingInstance;
        Java.ConstructorDeclarator declaringConstructor = (Java.ConstructorDeclarator)sci.getEnclosingScope();
        this.writeOpcode(sci, 42);
        Java.ClassDeclaration declaringClass = declaringConstructor.getDeclaringClass();
        IClass superclass = this.resolve(declaringClass).getSuperclass();
        if (sci.optionalQualification != null) {
            optionalEnclosingInstance = sci.optionalQualification;
        } else {
            IClass outerIClassOfSuperclass = superclass.getOuterIClass();
            if (outerIClassOfSuperclass == null) {
                optionalEnclosingInstance = null;
            } else {
                optionalEnclosingInstance = new Java.QualifiedThisReference(sci.getLocation(), new Java.SimpleType(sci.getLocation(), outerIClassOfSuperclass));
                optionalEnclosingInstance.setEnclosingBlockStatement(sci);
            }
        }
        this.invokeConstructor(sci, declaringConstructor, optionalEnclosingInstance, superclass, sci.arguments);
        return true;
    }

    private void compileBoolean(Java.Rvalue rv, final CodeContext.Offset dst, final boolean orientation) throws CompileException {
        Visitor.RvalueVisitor rvv = new Visitor.RvalueVisitor(){

            @Override
            public void visitArrayLength(Java.ArrayLength al) {
                try {
                    UnitCompiler.this.compileBoolean2(al, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitAssignment(Java.Assignment a) {
                try {
                    UnitCompiler.this.compileBoolean2(a, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitUnaryOperation(Java.UnaryOperation uo) {
                try {
                    UnitCompiler.this.compileBoolean2(uo, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBinaryOperation(Java.BinaryOperation bo) {
                try {
                    UnitCompiler.this.compileBoolean2(bo, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCast(Java.Cast c) {
                try {
                    UnitCompiler.this.compileBoolean2(c, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitClassLiteral(Java.ClassLiteral cl) {
                try {
                    UnitCompiler.this.compileBoolean2(cl, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                try {
                    UnitCompiler.this.compileBoolean2(ce, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCrement(Java.Crement c) {
                try {
                    UnitCompiler.this.compileBoolean2(c, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitInstanceof(Java.Instanceof io) {
                try {
                    UnitCompiler.this.compileBoolean2(io, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitMethodInvocation(Java.MethodInvocation mi) {
                try {
                    UnitCompiler.this.compileBoolean2(mi, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                try {
                    UnitCompiler.this.compileBoolean2(smi, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitIntegerLiteral(Java.IntegerLiteral il) {
                try {
                    UnitCompiler.this.compileBoolean2(il, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) {
                try {
                    UnitCompiler.this.compileBoolean2(fpl, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBooleanLiteral(Java.BooleanLiteral bl) {
                try {
                    UnitCompiler.this.compileBoolean2(bl, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCharacterLiteral(Java.CharacterLiteral cl) {
                try {
                    UnitCompiler.this.compileBoolean2(cl, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitStringLiteral(Java.StringLiteral sl) {
                try {
                    UnitCompiler.this.compileBoolean2(sl, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNullLiteral(Java.NullLiteral nl) {
                try {
                    UnitCompiler.this.compileBoolean2(nl, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSimpleConstant(Java.SimpleConstant sl) {
                try {
                    UnitCompiler.this.compileBoolean2(sl, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                try {
                    UnitCompiler.this.compileBoolean2(naci, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewArray(Java.NewArray na) {
                try {
                    UnitCompiler.this.compileBoolean2(na, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                try {
                    UnitCompiler.this.compileBoolean2(nia, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewClassInstance(Java.NewClassInstance nci) {
                try {
                    UnitCompiler.this.compileBoolean2(nci, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitParameterAccess(Java.ParameterAccess pa) {
                try {
                    UnitCompiler.this.compileBoolean2(pa, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                try {
                    UnitCompiler.this.compileBoolean2(qtr, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitThisReference(Java.ThisReference tr) {
                try {
                    UnitCompiler.this.compileBoolean2(tr, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    UnitCompiler.this.compileBoolean2(an, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    UnitCompiler.this.compileBoolean2(aae, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    UnitCompiler.this.compileBoolean2(fa, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    UnitCompiler.this.compileBoolean2(fae, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    UnitCompiler.this.compileBoolean2(scfae, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                try {
                    UnitCompiler.this.compileBoolean2(lva, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    UnitCompiler.this.compileBoolean2(pe, dst, orientation);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }
        };
        try {
            rv.accept(rvv);
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
    }

    private void compileBoolean2(Java.Rvalue rv, CodeContext.Offset dst, boolean orientation) throws CompileException {
        IClass type = this.compileGetValue(rv);
        IClassLoader icl = this.iClassLoader;
        if (type == icl.TYPE_java_lang_Boolean) {
            this.unboxingConversion(rv, icl.TYPE_java_lang_Boolean, IClass.BOOLEAN);
        } else if (type != IClass.BOOLEAN) {
            this.compileError("Not a boolean expression", rv.getLocation());
        }
        this.writeBranch(rv, orientation ? -102 : -103, dst);
    }

    private void compileBoolean2(Java.UnaryOperation ue, CodeContext.Offset dst, boolean orientation) throws CompileException {
        if (ue.operator == "!") {
            this.compileBoolean(ue.operand, dst, !orientation);
            return;
        }
        this.compileError("Boolean expression expected", ue.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileBoolean2(Java.BinaryOperation bo, CodeContext.Offset dst, boolean orientation) throws CompileException {
        if (bo.op == "|" || bo.op == "^" || bo.op == "&") {
            this.compileBoolean2((Java.Rvalue)bo, dst, orientation);
            return;
        }
        if (bo.op == "||" || bo.op == "&&") {
            Object lhsCv = this.getConstantValue(bo.lhs);
            if (lhsCv instanceof Boolean) {
                if ((Boolean)lhsCv ^ bo.op == "||") {
                    this.compileBoolean(bo.rhs, dst, true ^ !orientation);
                } else {
                    this.compileBoolean(bo.lhs, dst, true ^ !orientation);
                    this.fakeCompile(bo.rhs);
                }
                return;
            }
            Object rhsCv = this.getConstantValue(bo.rhs);
            if (rhsCv instanceof Boolean) {
                if ((Boolean)rhsCv ^ bo.op == "||") {
                    this.compileBoolean(bo.lhs, dst, true ^ !orientation);
                } else {
                    this.pop(bo.lhs, this.compileGetValue(bo.lhs));
                    this.compileBoolean(bo.rhs, dst, true ^ !orientation);
                }
                return;
            }
            if (bo.op == "||" ^ !orientation) {
                this.compileBoolean(bo.lhs, dst, true ^ !orientation);
                this.compileBoolean(bo.rhs, dst, true ^ !orientation);
            } else {
                CodeContext.Offset end = this.codeContext.new CodeContext.Offset();
                this.compileBoolean(bo.lhs, end, false ^ !orientation);
                this.compileBoolean(bo.rhs, dst, true ^ !orientation);
                end.set();
            }
            return;
        }
        if (bo.op == "==" || bo.op == "!=" || bo.op == "<=" || bo.op == ">=" || bo.op == "<" || bo.op == ">") {
            boolean rhsIsNull;
            int opIdx;
            int n = bo.op == "==" ? 0 : (bo.op == "!=" ? 1 : (bo.op == "<" ? 2 : (bo.op == ">=" ? 3 : (bo.op == ">" ? 4 : (opIdx = bo.op == "<=" ? 5 : Integer.MIN_VALUE)))));
            if (!orientation) {
                opIdx ^= 1;
            }
            boolean lhsIsNull = this.getConstantValue(bo.lhs) == null;
            boolean bl = rhsIsNull = this.getConstantValue(bo.rhs) == null;
            if (lhsIsNull || rhsIsNull) {
                if (bo.op != "==" && bo.op != "!=") {
                    this.compileError("Operator \"" + bo.op + "\" not allowed on operand \"null\"", bo.getLocation());
                }
                if (!lhsIsNull) {
                    IClass lhsType = this.compileGetValue(bo.lhs);
                    if (lhsType.isPrimitive()) {
                        this.compileError("Cannot compare primitive type \"" + lhsType.toString() + "\" with \"null\"", bo.getLocation());
                    }
                } else if (!rhsIsNull) {
                    IClass rhsType = this.compileGetValue(bo.rhs);
                    if (rhsType.isPrimitive()) {
                        this.compileError("Cannot compare \"null\" with primitive type \"" + rhsType.toString() + "\"", bo.getLocation());
                    }
                } else {
                    this.pushConstant(bo, null);
                }
                this.writeBranch(bo, -58 + opIdx, dst);
                return;
            }
            IClass lhsType = this.compileGetValue(bo.lhs);
            CodeContext.Inserter convertLhsInserter = this.codeContext.newInserter();
            IClass rhsType = this.compileGetValue(bo.rhs);
            if (this.getUnboxedType(lhsType).isPrimitiveNumeric() && this.getUnboxedType(rhsType).isPrimitiveNumeric() && (bo.op != "==" && bo.op != "!=" || lhsType.isPrimitive() || rhsType.isPrimitive())) {
                IClass promotedType = this.binaryNumericPromotion(bo, lhsType, convertLhsInserter, rhsType);
                if (promotedType == IClass.INT) {
                    this.writeBranch(bo, -97 + opIdx, dst);
                } else if (promotedType == IClass.LONG) {
                    this.writeOpcode(bo, -108);
                    this.writeBranch(bo, -103 + opIdx, dst);
                } else if (promotedType == IClass.FLOAT) {
                    if (bo.op == ">" || bo.op == ">=") {
                        this.writeOpcode(bo, -107);
                    } else {
                        this.writeOpcode(bo, -106);
                    }
                    this.writeBranch(bo, -103 + opIdx, dst);
                } else if (promotedType == IClass.DOUBLE) {
                    if (bo.op == ">" || bo.op == ">=") {
                        this.writeOpcode(bo, -105);
                    } else {
                        this.writeOpcode(bo, -104);
                    }
                    this.writeBranch(bo, -103 + opIdx, dst);
                } else {
                    throw new JaninoRuntimeException("Unexpected promoted type \"" + promotedType + "\"");
                }
                return;
            }
            if (lhsType == IClass.BOOLEAN && this.getUnboxedType(rhsType) == IClass.BOOLEAN || rhsType == IClass.BOOLEAN && this.getUnboxedType(lhsType) == IClass.BOOLEAN) {
                if (bo.op != "==" && bo.op != "!=") {
                    this.compileError("Operator \"" + bo.op + "\" not allowed on boolean operands", bo.getLocation());
                }
                IClassLoader icl = this.iClassLoader;
                if (lhsType == icl.TYPE_java_lang_Boolean) {
                    this.codeContext.pushInserter(convertLhsInserter);
                    try {
                        this.unboxingConversion(bo, icl.TYPE_java_lang_Boolean, IClass.BOOLEAN);
                    }
                    finally {
                        this.codeContext.popInserter();
                    }
                }
                if (rhsType == icl.TYPE_java_lang_Boolean) {
                    this.unboxingConversion(bo, icl.TYPE_java_lang_Boolean, IClass.BOOLEAN);
                }
                this.writeBranch(bo, -97 + opIdx, dst);
                return;
            }
            if (!lhsType.isPrimitive() && !rhsType.isPrimitive()) {
                if (bo.op != "==" && bo.op != "!=") {
                    this.compileError("Operator \"" + bo.op + "\" not allowed on reference operands", bo.getLocation());
                }
                if (!this.isCastReferenceConvertible(lhsType, rhsType) || !this.isCastReferenceConvertible(rhsType, lhsType)) {
                    this.compileError("Incomparable types '" + lhsType + "' and '" + rhsType + "'", bo.getLocation());
                }
                this.writeBranch(bo, -91 + opIdx, dst);
                return;
            }
            this.compileError("Cannot compare types \"" + lhsType + "\" and \"" + rhsType + "\"", bo.getLocation());
        }
        this.compileError("Boolean expression expected", bo.getLocation());
    }

    private void compileBoolean2(Java.ParenthesizedExpression pe, CodeContext.Offset dst, boolean orientation) throws CompileException {
        this.compileBoolean(pe.value, dst, orientation);
    }

    private int compileContext(Java.Rvalue rv) throws CompileException {
        final int[] res = new int[1];
        Visitor.RvalueVisitor rvv = new Visitor.RvalueVisitor(){

            @Override
            public void visitArrayLength(Java.ArrayLength al) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(al);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitAssignment(Java.Assignment a) {
                res[0] = UnitCompiler.this.compileContext2(a);
            }

            @Override
            public void visitUnaryOperation(Java.UnaryOperation uo) {
                res[0] = UnitCompiler.this.compileContext2(uo);
            }

            @Override
            public void visitBinaryOperation(Java.BinaryOperation bo) {
                res[0] = UnitCompiler.this.compileContext2(bo);
            }

            @Override
            public void visitCast(Java.Cast c) {
                res[0] = UnitCompiler.this.compileContext2(c);
            }

            @Override
            public void visitClassLiteral(Java.ClassLiteral cl) {
                res[0] = UnitCompiler.this.compileContext2(cl);
            }

            @Override
            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                res[0] = UnitCompiler.this.compileContext2(ce);
            }

            @Override
            public void visitCrement(Java.Crement c) {
                res[0] = UnitCompiler.this.compileContext2(c);
            }

            @Override
            public void visitInstanceof(Java.Instanceof io) {
                res[0] = UnitCompiler.this.compileContext2(io);
            }

            @Override
            public void visitMethodInvocation(Java.MethodInvocation mi) {
                res[0] = UnitCompiler.this.compileContext2(mi);
            }

            @Override
            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                res[0] = UnitCompiler.this.compileContext2(smi);
            }

            @Override
            public void visitIntegerLiteral(Java.IntegerLiteral il) {
                res[0] = UnitCompiler.this.compileContext2(il);
            }

            @Override
            public void visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) {
                res[0] = UnitCompiler.this.compileContext2(fpl);
            }

            @Override
            public void visitBooleanLiteral(Java.BooleanLiteral bl) {
                res[0] = UnitCompiler.this.compileContext2(bl);
            }

            @Override
            public void visitCharacterLiteral(Java.CharacterLiteral cl) {
                res[0] = UnitCompiler.this.compileContext2(cl);
            }

            @Override
            public void visitStringLiteral(Java.StringLiteral sl) {
                res[0] = UnitCompiler.this.compileContext2(sl);
            }

            @Override
            public void visitNullLiteral(Java.NullLiteral nl) {
                res[0] = UnitCompiler.this.compileContext2(nl);
            }

            @Override
            public void visitSimpleConstant(Java.SimpleConstant sl) {
                res[0] = UnitCompiler.this.compileContext2(sl);
            }

            @Override
            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                res[0] = UnitCompiler.this.compileContext2(naci);
            }

            @Override
            public void visitNewArray(Java.NewArray na) {
                res[0] = UnitCompiler.this.compileContext2(na);
            }

            @Override
            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                res[0] = UnitCompiler.this.compileContext2(nia);
            }

            @Override
            public void visitNewClassInstance(Java.NewClassInstance nci) {
                res[0] = UnitCompiler.this.compileContext2(nci);
            }

            @Override
            public void visitParameterAccess(Java.ParameterAccess pa) {
                res[0] = UnitCompiler.this.compileContext2(pa);
            }

            @Override
            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                res[0] = UnitCompiler.this.compileContext2(qtr);
            }

            @Override
            public void visitThisReference(Java.ThisReference tr) {
                res[0] = UnitCompiler.this.compileContext2(tr);
            }

            @Override
            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(an);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(aae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(fa);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(fae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(scfae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                res[0] = UnitCompiler.this.compileContext2(lva);
            }

            @Override
            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    res[0] = UnitCompiler.this.compileContext2(pe);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }
        };
        try {
            rv.accept(rvv);
            return res[0];
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
    }

    private int compileContext2(Java.Rvalue rv) {
        return 0;
    }

    private int compileContext2(Java.AmbiguousName an) throws CompileException {
        return this.compileContext(this.toRvalueOrCompileException(this.reclassify(an)));
    }

    private int compileContext2(Java.FieldAccess fa) throws CompileException {
        if (fa.field.isStatic()) {
            Java.Rvalue rv = fa.lhs.toRvalue();
            if (rv != null) {
                this.warning("CNSFA", "Left-hand side of static field access should be a type, not an rvalue", fa.lhs.getLocation());
                this.pop(fa.lhs, this.compileGetValue(rv));
            }
            return 0;
        }
        this.compileGetValue(this.toRvalueOrCompileException(fa.lhs));
        return 1;
    }

    private int compileContext2(Java.ArrayLength al) throws CompileException {
        if (!this.compileGetValue(al.lhs).isArray()) {
            this.compileError("Cannot determine length of non-array type", al.getLocation());
        }
        return 1;
    }

    private int compileContext2(Java.ArrayAccessExpression aae) throws CompileException {
        IClass indexType;
        IClass lhsType = this.compileGetValue(aae.lhs);
        if (!lhsType.isArray()) {
            this.compileError("Subscript not allowed on non-array type \"" + lhsType.toString() + "\"", aae.getLocation());
        }
        if (!this.tryIdentityConversion(indexType = this.compileGetValue(aae.index), IClass.INT) && !this.tryWideningPrimitiveConversion(aae, indexType, IClass.INT)) {
            this.compileError("Index expression of type \"" + indexType + "\" cannot be widened to \"int\"", aae.getLocation());
        }
        return 2;
    }

    private int compileContext2(Java.FieldAccessExpression fae) throws CompileException {
        this.determineValue(fae);
        return this.compileContext(fae.value);
    }

    private int compileContext2(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        this.determineValue(scfae);
        return this.compileContext(scfae.value);
    }

    private int compileContext2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.compileContext(pe.value);
    }

    private IClass compileGet(Java.Rvalue rv) throws CompileException {
        final IClass[] res = new IClass[1];
        Visitor.RvalueVisitor rvv = new Visitor.RvalueVisitor(){

            @Override
            public void visitArrayLength(Java.ArrayLength al) {
                res[0] = UnitCompiler.this.compileGet2(al);
            }

            @Override
            public void visitAssignment(Java.Assignment a) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(a);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitUnaryOperation(Java.UnaryOperation uo) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(uo);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBinaryOperation(Java.BinaryOperation bo) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(bo);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCast(Java.Cast c) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(c);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitClassLiteral(Java.ClassLiteral cl) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(cl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(ce);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCrement(Java.Crement c) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(c);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitInstanceof(Java.Instanceof io) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(io);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitMethodInvocation(Java.MethodInvocation mi) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(mi);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(smi);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitIntegerLiteral(Java.IntegerLiteral il) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(il);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(fpl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBooleanLiteral(Java.BooleanLiteral bl) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(bl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCharacterLiteral(Java.CharacterLiteral cl) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(cl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitStringLiteral(Java.StringLiteral sl) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(sl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNullLiteral(Java.NullLiteral nl) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(nl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSimpleConstant(Java.SimpleConstant sl) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(sl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(naci);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewArray(Java.NewArray na) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(na);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(nia);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewClassInstance(Java.NewClassInstance nci) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(nci);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitParameterAccess(Java.ParameterAccess pa) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(pa);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(qtr);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitThisReference(Java.ThisReference tr) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(tr);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(an);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(aae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(fa);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(fae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(scfae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                res[0] = UnitCompiler.this.compileGet2(lva);
            }

            @Override
            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    res[0] = UnitCompiler.this.compileGet2(pe);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }
        };
        try {
            rv.accept(rvv);
            return res[0];
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
    }

    private IClass compileGet2(Java.BooleanRvalue brv) throws CompileException {
        CodeContext.Offset isTrue2 = this.codeContext.new CodeContext.Offset();
        this.compileBoolean(brv, isTrue2, true);
        this.writeOpcode(brv, 3);
        CodeContext.Offset end = this.codeContext.new CodeContext.Offset();
        this.writeBranch(brv, -89, end);
        isTrue2.set();
        this.writeOpcode(brv, 4);
        end.set();
        return IClass.BOOLEAN;
    }

    private IClass compileGet2(Java.AmbiguousName an) throws CompileException {
        return this.compileGet(this.toRvalueOrCompileException(this.reclassify(an)));
    }

    private IClass compileGet2(Java.LocalVariableAccess lva) {
        return this.load(lva, lva.localVariable);
    }

    private IClass compileGet2(Java.FieldAccess fa) throws CompileException {
        this.checkAccessible(fa.field, fa.getEnclosingBlockStatement());
        this.getfield(fa, fa.field);
        return fa.field.getType();
    }

    private IClass compileGet2(Java.ArrayLength al) {
        this.writeOpcode(al, -66);
        return IClass.INT;
    }

    private IClass compileGet2(Java.ThisReference tr) throws CompileException {
        this.referenceThis(tr);
        return this.getIClass(tr);
    }

    private IClass compileGet2(Java.QualifiedThisReference qtr) throws CompileException {
        this.referenceThis(qtr, this.getDeclaringClass(qtr), this.getDeclaringTypeBodyDeclaration(qtr), this.getTargetIClass(qtr));
        return this.getTargetIClass(qtr);
    }

    private IClass compileGet2(Java.ClassLiteral cl) throws CompileException {
        String classDollarFieldName;
        String className;
        Java.AbstractTypeDeclaration declaringType;
        Location loc;
        block18: {
            List<Java.BlockStatement> statics;
            loc = cl.getLocation();
            IClassLoader icl = this.iClassLoader;
            IClass iClass = this.getType(cl.type);
            if (iClass.isPrimitive()) {
                String wrapperClassDescriptor;
                this.writeOpcode(cl, -78);
                String string2 = iClass == IClass.VOID ? "Ljava/lang/Void;" : (iClass == IClass.BYTE ? "Ljava/lang/Byte;" : (iClass == IClass.CHAR ? "Ljava/lang/Character;" : (iClass == IClass.DOUBLE ? "Ljava/lang/Double;" : (iClass == IClass.FLOAT ? "Ljava/lang/Float;" : (iClass == IClass.INT ? "Ljava/lang/Integer;" : (iClass == IClass.LONG ? "Ljava/lang/Long;" : (iClass == IClass.SHORT ? "Ljava/lang/Short;" : (wrapperClassDescriptor = iClass == IClass.BOOLEAN ? "Ljava/lang/Boolean;" : null))))))));
                if (wrapperClassDescriptor == null) {
                    throw new JaninoRuntimeException("SNO: Unidentifiable primitive type \"" + iClass + "\"");
                }
                this.writeConstantFieldrefInfo(wrapperClassDescriptor, "TYPE", "Ljava/lang/Class;");
                return icl.TYPE_java_lang_Class;
            }
            Java.Scope s2 = cl.getEnclosingBlockStatement();
            while (true) {
                if (s2 instanceof Java.TypeDeclaration) break;
                s2 = s2.getEnclosingScope();
            }
            declaringType = (Java.AbstractTypeDeclaration)s2;
            if (declaringType.getMethodDeclaration("class$") == null) {
                this.declareClassDollarMethod(cl);
            }
            if (declaringType instanceof Java.ClassDeclaration) {
                statics = ((Java.ClassDeclaration)declaringType).variableDeclaratorsAndInitializers;
            } else if (declaringType instanceof Java.InterfaceDeclaration) {
                statics = ((Java.InterfaceDeclaration)declaringType).constantDeclarations;
            } else {
                throw new JaninoRuntimeException("SNO: AbstractTypeDeclaration is neither ClassDeclaration nor InterfaceDeclaration");
            }
            className = Descriptor.toClassName(iClass.getDescriptor());
            if (className.startsWith("[")) {
                classDollarFieldName = "array" + className.replace('.', '$').replace('[', '$');
                if (classDollarFieldName.endsWith(";")) {
                    classDollarFieldName = classDollarFieldName.substring(0, classDollarFieldName.length() - 1);
                }
            } else {
                classDollarFieldName = "class$" + className.replace('.', '$');
            }
            for (Java.BlockStatement bs : statics) {
                if (!((Java.TypeBodyDeclaration)((Object)bs)).isStatic() || !(bs instanceof Java.FieldDeclaration)) continue;
                for (Java.VariableDeclarator vd : ((Java.FieldDeclaration)bs).variableDeclarators) {
                    if (!vd.name.equals(classDollarFieldName)) {
                        continue;
                    }
                    break block18;
                }
            }
            Java.SimpleType classType2 = new Java.SimpleType(loc, icl.TYPE_java_lang_Class);
            Java.FieldDeclaration fd = new Java.FieldDeclaration(loc, null, new Java.Modifiers(8), classType2, new Java.VariableDeclarator[]{new Java.VariableDeclarator(loc, classDollarFieldName, 0, null)});
            if (declaringType instanceof Java.ClassDeclaration) {
                ((Java.ClassDeclaration)declaringType).addFieldDeclaration(fd);
            } else if (declaringType instanceof Java.InterfaceDeclaration) {
                ((Java.InterfaceDeclaration)declaringType).addConstantDeclaration(fd);
            } else {
                throw new JaninoRuntimeException("SNO: AbstractTypeDeclaration is neither ClassDeclaration nor InterfaceDeclaration");
            }
        }
        Java.SimpleType declaringClassOrInterfaceType = new Java.SimpleType(loc, this.resolve(declaringType));
        Java.FieldAccessExpression classDollarFieldAccess = new Java.FieldAccessExpression(loc, declaringClassOrInterfaceType, classDollarFieldName);
        Java.ConditionalExpression ce = new Java.ConditionalExpression(loc, new Java.BinaryOperation(loc, classDollarFieldAccess, "!=", new Java.NullLiteral(loc, "null")), classDollarFieldAccess, new Java.Assignment(loc, classDollarFieldAccess, "=", new Java.MethodInvocation(loc, declaringClassOrInterfaceType, "class$", new Java.Rvalue[]{new Java.StringLiteral(loc, '\"' + className + '\"')})));
        ce.setEnclosingBlockStatement(cl.getEnclosingBlockStatement());
        return this.compileGet(ce);
    }

    private IClass compileGet2(Java.Assignment a) throws CompileException {
        if (a.operator == "=") {
            int lhsCs = this.compileContext(a.lhs);
            IClass rhsType = this.compileGetValue(a.rhs);
            IClass lhsType = this.getType(a.lhs);
            Object rhsCv = this.getConstantValue(a.rhs);
            this.assignmentConversion(a, rhsType, lhsType, rhsCv);
            this.dupx(a, lhsType, lhsCs);
            this.compileSet(a.lhs);
            return lhsType;
        }
        int lhsCs = this.compileContext(a.lhs);
        this.dup(a, lhsCs);
        IClass lhsType = this.compileGet(a.lhs);
        IClass resultType = this.compileArithmeticBinaryOperation(a, lhsType, a.operator.substring(0, a.operator.length() - 1).intern(), a.rhs);
        if (!this.tryIdentityConversion(resultType, lhsType) && !this.tryNarrowingPrimitiveConversion(a, resultType, lhsType)) {
            throw new JaninoRuntimeException("SNO: \"" + a.operator + "\" reconversion failed");
        }
        this.dupx(a, lhsType, lhsCs);
        this.compileSet(a.lhs);
        return lhsType;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IClass compileGet2(Java.ConditionalExpression ce) throws CompileException {
        IClass expressionType;
        CodeContext.Inserter rhsConvertInserter;
        IClass rhsType;
        CodeContext.Inserter mhsConvertInserter;
        IClass mhsType;
        CodeContext.Offset toEnd = this.codeContext.new CodeContext.Offset();
        Object cv = this.getConstantValue(ce.lhs);
        if (cv instanceof Boolean) {
            if (((Boolean)cv).booleanValue()) {
                mhsType = this.compileGetValue(ce.mhs);
                mhsConvertInserter = this.codeContext.newInserter();
                rhsType = this.getType(ce.rhs);
                rhsConvertInserter = null;
            } else {
                mhsType = this.getType(ce.mhs);
                mhsConvertInserter = null;
                rhsType = this.compileGetValue(ce.rhs);
                rhsConvertInserter = this.codeContext.currentInserter();
            }
        } else {
            CodeContext.Offset toRhs = this.codeContext.new CodeContext.Offset();
            this.compileBoolean(ce.lhs, toRhs, false);
            mhsType = this.compileGetValue(ce.mhs);
            mhsConvertInserter = this.codeContext.newInserter();
            this.writeBranch(ce, -89, toEnd);
            toRhs.set();
            rhsType = this.compileGetValue(ce.rhs);
            rhsConvertInserter = this.codeContext.currentInserter();
        }
        if (mhsType == rhsType) {
            expressionType = mhsType;
        } else if (mhsType.isPrimitiveNumeric() && rhsType.isPrimitiveNumeric()) {
            expressionType = this.binaryNumericPromotion(ce, mhsType, mhsConvertInserter, rhsType, rhsConvertInserter);
        } else if (this.getConstantValue(ce.mhs) == null && !rhsType.isPrimitive()) {
            expressionType = rhsType;
        } else if (!mhsType.isPrimitive() && this.getConstantValue(ce.rhs) == null) {
            expressionType = mhsType;
        } else if (!mhsType.isPrimitive() && !rhsType.isPrimitive()) {
            if (mhsType.isAssignableFrom(rhsType)) {
                expressionType = mhsType;
            } else {
                if (!rhsType.isAssignableFrom(mhsType)) {
                    this.compileError("Reference types \"" + mhsType + "\" and \"" + rhsType + "\" don't match", ce.getLocation());
                    return this.iClassLoader.TYPE_java_lang_Object;
                }
                expressionType = rhsType;
            }
        } else {
            this.compileError("Incompatible expression types \"" + mhsType + "\" and \"" + rhsType + "\"", ce.getLocation());
            return this.iClassLoader.TYPE_java_lang_Object;
        }
        toEnd.set();
        return expressionType;
    }

    private IClass compileGet2(Java.Crement c) throws CompileException {
        Java.LocalVariable lv = this.isIntLv(c);
        if (lv != null) {
            if (!c.pre) {
                this.load(c, lv);
            }
            this.compileLocalVariableCrement(c, lv);
            if (c.pre) {
                this.load(c, lv);
            }
            return lv.type;
        }
        int cs = this.compileContext(c.operand);
        this.dup(c, cs);
        IClass type = this.compileGet(c.operand);
        if (!c.pre) {
            this.dupx(c, type, cs);
        }
        IClass promotedType = this.unaryNumericPromotion(c, type);
        this.writeOpcode(c, UnitCompiler.ilfd(promotedType, 4, 10, 12, 15));
        if (c.operator == "++") {
            this.writeOpcode(c, 96 + UnitCompiler.ilfd(promotedType));
        } else if (c.operator == "--") {
            this.writeOpcode(c, 100 + UnitCompiler.ilfd(promotedType));
        } else {
            this.compileError("Unexpected operator \"" + c.operator + "\"", c.getLocation());
        }
        this.reverseUnaryNumericPromotion(c, promotedType, type);
        if (c.pre) {
            this.dupx(c, type, cs);
        }
        this.compileSet(c.operand);
        return type;
    }

    private void compileLocalVariableCrement(Java.Crement c, Java.LocalVariable lv) {
        this.crement(c, lv, c.operator);
    }

    private void crement(Java.Locatable locatable, Java.LocalVariable lv, String operator) {
        if (lv.getSlotIndex() > 255) {
            this.writeOpcode(locatable, -60);
            this.writeOpcode(locatable, -124);
            this.writeShort(lv.getSlotIndex());
            this.writeShort(operator == "++" ? 1 : -1);
        } else {
            this.writeOpcode(locatable, -124);
            this.writeByte(lv.getSlotIndex());
            this.writeByte(operator == "++" ? 1 : -1);
        }
    }

    private IClass compileGet2(Java.ArrayAccessExpression aae) throws CompileException {
        IClass lhsComponentType = this.getType(aae);
        this.writeOpcode(aae, 46 + UnitCompiler.ilfdabcs(lhsComponentType));
        return lhsComponentType;
    }

    private IClass compileGet2(Java.FieldAccessExpression fae) throws CompileException {
        this.determineValue(fae);
        return this.compileGet(fae.value);
    }

    private IClass compileGet2(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        this.determineValue(scfae);
        return this.compileGet(scfae.value);
    }

    private IClass compileGet2(Java.UnaryOperation uo) throws CompileException {
        if (uo.operator == "!") {
            return this.compileGet2((Java.BooleanRvalue)uo);
        }
        if (uo.operator == "+") {
            return this.unaryNumericPromotion(uo, this.convertToPrimitiveNumericType(uo, this.compileGetValue(uo.operand)));
        }
        if (uo.operator == "-") {
            Object ncv = this.getNegatedConstantValue(uo.operand);
            if (ncv != NOT_CONSTANT) {
                return this.unaryNumericPromotion(uo, this.pushConstant(uo, ncv));
            }
            IClass promotedType = this.unaryNumericPromotion(uo, this.convertToPrimitiveNumericType(uo, this.compileGetValue(uo.operand)));
            this.writeOpcode(uo, 116 + UnitCompiler.ilfd(promotedType));
            return promotedType;
        }
        if (uo.operator == "~") {
            IClass operandType = this.compileGetValue(uo.operand);
            IClass promotedType = this.unaryNumericPromotion(uo, operandType);
            if (promotedType == IClass.INT) {
                this.writeOpcode(uo, 2);
                this.writeOpcode(uo, -126);
                return IClass.INT;
            }
            if (promotedType == IClass.LONG) {
                this.writeOpcode(uo, 20);
                this.writeConstantLongInfo(-1L);
                this.writeOpcode(uo, -125);
                return IClass.LONG;
            }
            this.compileError("Operator \"~\" not applicable to type \"" + promotedType + "\"", uo.getLocation());
        }
        this.compileError("Unexpected operator \"" + uo.operator + "\"", uo.getLocation());
        return this.iClassLoader.TYPE_java_lang_Object;
    }

    private IClass compileGet2(Java.Instanceof io) throws CompileException {
        IClass lhsType = this.compileGetValue(io.lhs);
        IClass rhsType = this.getType(io.rhs);
        if (lhsType.isInterface() || rhsType.isInterface() || lhsType.isAssignableFrom(rhsType) || rhsType.isAssignableFrom(lhsType)) {
            this.writeOpcode(io, -63);
            this.writeConstantClassInfo(rhsType.getDescriptor());
        } else {
            this.compileError("\"" + lhsType + "\" can never be an instance of \"" + rhsType + "\"", io.getLocation());
        }
        return IClass.BOOLEAN;
    }

    private IClass compileGet2(Java.BinaryOperation bo) throws CompileException {
        if (bo.op == "||" || bo.op == "&&" || bo.op == "==" || bo.op == "!=" || bo.op == "<" || bo.op == ">" || bo.op == "<=" || bo.op == ">=") {
            return this.compileGet2((Java.BooleanRvalue)bo);
        }
        return this.compileArithmeticOperation(bo, null, bo.unrollLeftAssociation(), bo.op);
    }

    private IClass compileGet2(Java.Cast c) throws CompileException {
        IClass tt = this.getType(c.targetType);
        IClass vt = this.compileGetValue(c.value);
        if (this.tryIdentityConversion(vt, tt) || this.tryWideningPrimitiveConversion(c, vt, tt) || this.tryNarrowingPrimitiveConversion(c, vt, tt) || this.tryWideningReferenceConversion(vt, tt) || this.tryNarrowingReferenceConversion(c, vt, tt) || this.tryBoxingConversion(c, vt, tt) || this.tryUnboxingConversion(c, vt, tt)) {
            return tt;
        }
        IClass boxedType = this.isBoxingConvertible(vt);
        if (boxedType != null && this.isWideningReferenceConvertible(boxedType, tt)) {
            this.boxingConversion(c, vt, boxedType);
            return tt;
        }
        IClass unboxedType = this.isUnboxingConvertible(vt);
        if (unboxedType != null && this.isWideningPrimitiveConvertible(unboxedType, tt)) {
            this.unboxingConversion(c, vt, unboxedType);
            this.tryWideningPrimitiveConversion(c, unboxedType, tt);
            return tt;
        }
        this.compileError("Cannot cast \"" + vt + "\" to \"" + tt + "\"", c.getLocation());
        return tt;
    }

    private IClass compileGet2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.compileGet(pe.value);
    }

    private IClass compileGet2(Java.MethodInvocation mi) throws CompileException {
        IClass.IMethod iMethod = this.findIMethod(mi);
        if (mi.optionalTarget == null) {
            Java.Scope s2 = mi.getEnclosingBlockStatement();
            while (!(s2 instanceof Java.TypeBodyDeclaration)) {
                s2 = s2.getEnclosingScope();
            }
            Java.TypeBodyDeclaration scopeTbd = (Java.TypeBodyDeclaration)s2;
            if (!(s2 instanceof Java.ClassDeclaration)) {
                s2 = s2.getEnclosingScope();
            }
            Java.ClassDeclaration scopeClassDeclaration = (Java.ClassDeclaration)s2;
            if (iMethod.isStatic()) {
                this.warning("IASM", "Implicit access to static method \"" + iMethod.toString() + "\"", mi.getLocation());
            } else {
                this.warning("IANSM", "Implicit access to non-static method \"" + iMethod.toString() + "\"", mi.getLocation());
                if (scopeTbd.isStatic()) {
                    this.compileError("Instance method \"" + iMethod.toString() + "\" cannot be invoked in static context", mi.getLocation());
                }
                this.referenceThis(mi, scopeClassDeclaration, scopeTbd, iMethod.getDeclaringIClass());
            }
        } else {
            boolean staticContext = this.isType(mi.optionalTarget);
            if (staticContext) {
                this.getType(this.toTypeOrCompileException(mi.optionalTarget));
            } else {
                this.compileGetValue(this.toRvalueOrCompileException(mi.optionalTarget));
            }
            if (iMethod.isStatic()) {
                if (!staticContext) {
                    this.pop(mi.optionalTarget, this.getType(mi.optionalTarget));
                }
            } else if (staticContext) {
                this.compileError("Instance method \"" + mi.methodName + "\" cannot be invoked in static context", mi.getLocation());
            }
        }
        IClass[] parameterTypes = iMethod.getParameterTypes();
        Java.Rvalue[] adjustedArgs = null;
        int actualSize = mi.arguments.length;
        if (iMethod.isVarargs() && iMethod.argsNeedAdjust()) {
            int i;
            adjustedArgs = new Java.Rvalue[parameterTypes.length];
            Java.ArrayInitializerOrRvalue[] lastArgs = new Java.Rvalue[actualSize - parameterTypes.length + 1];
            Location loc = mi.getLocation();
            if (lastArgs.length > 0) {
                i = 0;
                int j = parameterTypes.length - 1;
                while (i < lastArgs.length) {
                    lastArgs[i] = mi.arguments[j];
                    ++i;
                    ++j;
                }
            }
            for (i = parameterTypes.length - 2; i >= 0; --i) {
                adjustedArgs[i] = mi.arguments[i];
            }
            adjustedArgs[adjustedArgs.length - 1] = new Java.NewInitializedArray(loc, parameterTypes[parameterTypes.length - 1], new Java.ArrayInitializer(loc, lastArgs));
        } else {
            adjustedArgs = mi.arguments;
        }
        for (int i = 0; i < adjustedArgs.length; ++i) {
            this.assignmentConversion(mi, this.compileGetValue(adjustedArgs[i]), parameterTypes[i], this.getConstantValue(adjustedArgs[i]));
        }
        this.checkAccessible(iMethod, mi.getEnclosingBlockStatement());
        if (iMethod.getDeclaringIClass().isInterface()) {
            this.invoke((Java.Locatable)mi, iMethod);
        } else if (!iMethod.isStatic() && iMethod.getAccess() == Access.PRIVATE) {
            this.writeOpcode(mi, -72);
            this.writeConstantMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName() + '$', MethodDescriptor.prependParameter(iMethod.getDescriptor(), iMethod.getDeclaringIClass().getDescriptor()));
        } else {
            this.invoke((Java.Locatable)mi, iMethod);
        }
        return iMethod.getReturnType();
    }

    private IClass compileGet2(Java.SuperclassMethodInvocation scmi) throws CompileException {
        Java.FunctionDeclarator fd;
        IClass.IMethod iMethod = this.findIMethod(scmi);
        Java.Scope s2 = scmi.getEnclosingBlockStatement();
        while (s2 instanceof Java.Statement || s2 instanceof Java.CatchClause) {
            s2 = s2.getEnclosingScope();
        }
        Java.FunctionDeclarator functionDeclarator = fd = s2 instanceof Java.FunctionDeclarator ? (Java.FunctionDeclarator)s2 : null;
        if (fd == null) {
            this.compileError("Cannot invoke superclass method in non-method scope", scmi.getLocation());
            return IClass.INT;
        }
        if (Mod.isStatic(fd.modifiers.flags)) {
            this.compileError("Cannot invoke superclass method in static context", scmi.getLocation());
        }
        this.load(scmi, this.resolve(fd.getDeclaringType()), 0);
        IClass[] parameterTypes = iMethod.getParameterTypes();
        for (int i = 0; i < scmi.arguments.length; ++i) {
            this.assignmentConversion(scmi, this.compileGetValue(scmi.arguments[i]), parameterTypes[i], this.getConstantValue(scmi.arguments[i]));
        }
        this.writeOpcode(scmi, -73);
        this.writeConstantMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), scmi.methodName, iMethod.getDescriptor());
        return iMethod.getReturnType();
    }

    private IClass compileGet2(Java.NewClassInstance nci) throws CompileException {
        Java.Rvalue optionalEnclosingInstance;
        if (nci.iClass == null) {
            nci.iClass = this.getType(nci.type);
        }
        this.writeOpcode(nci, -69);
        this.writeConstantClassInfo(nci.iClass.getDescriptor());
        this.writeOpcode(nci, 89);
        if (nci.iClass.isInterface()) {
            this.compileError("Cannot instantiate \"" + nci.iClass + "\"", nci.getLocation());
        }
        this.checkAccessible(nci.iClass, nci.getEnclosingBlockStatement());
        if (nci.iClass.isAbstract()) {
            this.compileError("Cannot instantiate abstract \"" + nci.iClass + "\"", nci.getLocation());
        }
        if (nci.optionalQualification != null) {
            if (nci.iClass.getOuterIClass() == null) {
                this.compileError("Static member class cannot be instantiated with qualified NEW");
            }
            optionalEnclosingInstance = nci.optionalQualification;
        } else {
            Java.Scope s2 = nci.getEnclosingBlockStatement();
            while (!(s2 instanceof Java.TypeBodyDeclaration)) {
                s2 = s2.getEnclosingScope();
            }
            Java.TypeBodyDeclaration enclosingTypeBodyDeclaration = (Java.TypeBodyDeclaration)s2;
            Java.TypeDeclaration enclosingTypeDeclaration = (Java.TypeDeclaration)s2.getEnclosingScope();
            if (!(enclosingTypeDeclaration instanceof Java.ClassDeclaration) || enclosingTypeBodyDeclaration.isStatic()) {
                if (nci.iClass.getOuterIClass() != null) {
                    this.compileError("Instantiation of \"" + nci.type + "\" requires an enclosing instance", nci.getLocation());
                }
                optionalEnclosingInstance = null;
            } else {
                IClass optionalOuterIClass = nci.iClass.getDeclaringIClass();
                if (optionalOuterIClass == null) {
                    optionalEnclosingInstance = null;
                } else {
                    optionalEnclosingInstance = new Java.QualifiedThisReference(nci.getLocation(), new Java.SimpleType(nci.getLocation(), optionalOuterIClass));
                    optionalEnclosingInstance.setEnclosingBlockStatement(nci.getEnclosingBlockStatement());
                }
            }
        }
        this.invokeConstructor(nci, nci.getEnclosingBlockStatement(), optionalEnclosingInstance, nci.iClass, nci.arguments);
        return nci.iClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClass compileGet2(Java.NewAnonymousClassInstance naci) throws CompileException {
        Java.AnonymousClassDeclaration acd = naci.anonymousClassDeclaration;
        IClass sc = this.resolve(acd).getSuperclass();
        IClass.IInvocable[] iConstructors = sc.getDeclaredIConstructors();
        if (iConstructors.length == 0) {
            throw new JaninoRuntimeException("SNO: Base class has no constructors");
        }
        IClass.IConstructor iConstructor = (IClass.IConstructor)this.findMostSpecificIInvocable(naci, iConstructors, naci.arguments, acd);
        IClass[] pts = iConstructor.getParameterTypes();
        Location loc = naci.getLocation();
        ArrayList<Java.FunctionDeclarator.FormalParameter> l = new ArrayList<Java.FunctionDeclarator.FormalParameter>();
        if (naci.optionalQualification != null) {
            l.add(new Java.FunctionDeclarator.FormalParameter(loc, true, new Java.SimpleType(loc, this.getType(naci.optionalQualification)), "this$base"));
        }
        for (int i = 0; i < pts.length; ++i) {
            l.add(new Java.FunctionDeclarator.FormalParameter(loc, true, new Java.SimpleType(loc, pts[i]), "p" + i));
        }
        Java.FunctionDeclarator.FormalParameters parameters = new Java.FunctionDeclarator.FormalParameters(loc, l.toArray(new Java.FunctionDeclarator.FormalParameter[l.size()]), false);
        IClass[] tes = iConstructor.getThrownExceptions();
        Java.Type[] tets = new Java.Type[tes.length];
        for (int i = 0; i < tes.length; ++i) {
            tets[i] = new Java.SimpleType(loc, tes[i]);
        }
        int j = 0;
        Java.ParameterAccess optionalQualificationAccess = naci.optionalQualification == null ? null : new Java.ParameterAccess(loc, parameters.parameters[j++]);
        Java.Rvalue[] parameterAccesses = new Java.Rvalue[pts.length];
        for (int i = 0; i < pts.length; ++i) {
            parameterAccesses[i] = new Java.ParameterAccess(loc, parameters.parameters[j++]);
        }
        Java.ConstructorDeclarator anonymousConstructor = new Java.ConstructorDeclarator(loc, null, new Java.Modifiers(0), parameters, tets, new Java.SuperConstructorInvocation(loc, optionalQualificationAccess, parameterAccesses), Collections.EMPTY_LIST);
        acd.addConstructor(anonymousConstructor);
        try {
            Java.ThisReference oei;
            Java.Rvalue[] arguments2;
            this.compile(acd);
            this.writeOpcode(naci, -69);
            this.writeConstantClassInfo(this.resolve(naci.anonymousClassDeclaration).getDescriptor());
            this.writeOpcode(naci, 89);
            if (naci.optionalQualification == null) {
                arguments2 = naci.arguments;
            } else {
                arguments2 = new Java.Rvalue[naci.arguments.length + 1];
                arguments2[0] = naci.optionalQualification;
                System.arraycopy(naci.arguments, 0, arguments2, 1, naci.arguments.length);
            }
            Java.Scope s2 = naci.getEnclosingBlockStatement();
            while (!(s2 instanceof Java.TypeBodyDeclaration)) {
                s2 = s2.getEnclosingScope();
            }
            if (((Java.TypeBodyDeclaration)s2).isStatic()) {
                oei = null;
            } else {
                oei = new Java.ThisReference(loc);
                oei.setEnclosingBlockStatement(naci.getEnclosingBlockStatement());
            }
            this.invokeConstructor(naci, naci.getEnclosingBlockStatement(), oei, this.resolve(naci.anonymousClassDeclaration), arguments2);
        }
        finally {
            acd.constructors.remove(acd.constructors.size() - 1);
        }
        return this.resolve(naci.anonymousClassDeclaration);
    }

    private IClass compileGet2(Java.ParameterAccess pa) throws CompileException {
        Java.LocalVariable lv = this.getLocalVariable(pa.formalParameter);
        this.load(pa, lv);
        return lv.type;
    }

    private IClass compileGet2(Java.NewArray na) throws CompileException {
        for (Java.Rvalue dimExpr : na.dimExprs) {
            IClass dimType = this.compileGetValue(dimExpr);
            if (dimType == IClass.INT || this.unaryNumericPromotion(na, dimType) == IClass.INT) continue;
            this.compileError("Invalid array size expression type", na.getLocation());
        }
        return this.newArray(na, na.dimExprs.length, na.dims, this.getType(na.type));
    }

    private IClass compileGet2(Java.NewInitializedArray nia) throws CompileException {
        IClass at = nia.arrayType == null ? nia.arrayIClass : this.getType(nia.arrayType);
        this.compileGetValue(nia.arrayInitializer, at);
        return at;
    }

    private void compileGetValue(Java.ArrayInitializer ai, IClass arrayType) throws CompileException {
        if (!arrayType.isArray()) {
            this.compileError("Array initializer not allowed for non-array type \"" + arrayType.toString() + "\"");
        }
        IClass ct = arrayType.getComponentType();
        this.pushConstant(ai, new Integer(ai.values.length));
        this.newArray(ai, 1, 0, ct);
        for (int i = 0; i < ai.values.length; ++i) {
            this.writeOpcode(ai, 89);
            this.pushConstant(ai, new Integer(i));
            Java.ArrayInitializerOrRvalue aiorv = ai.values[i];
            if (aiorv instanceof Java.Rvalue) {
                Java.Rvalue rv = (Java.Rvalue)aiorv;
                this.assignmentConversion(ai, this.compileGetValue(rv), ct, this.getConstantValue(rv));
            } else if (aiorv instanceof Java.ArrayInitializer) {
                this.compileGetValue((Java.ArrayInitializer)aiorv, ct);
            } else {
                throw new JaninoRuntimeException("Unexpected array initializer or rvalue class " + aiorv.getClass().getName());
            }
            this.writeOpcode(ai, 79 + UnitCompiler.ilfdabcs(ct));
        }
    }

    private IClass compileGet2(Java.Literal l) throws CompileException {
        return this.pushConstant(l, this.getConstantValue(l));
    }

    private IClass compileGet2(Java.SimpleConstant sl) throws CompileException {
        return this.pushConstant(sl, sl.value);
    }

    private IClass compileGetValue(Java.Rvalue rv) throws CompileException {
        Object cv = this.getConstantValue(rv);
        if (cv != NOT_CONSTANT) {
            this.fakeCompile(rv);
            this.pushConstant(rv, cv);
            return this.getType(rv);
        }
        this.compileContext(rv);
        return this.compileGet(rv);
    }

    public final Object getConstantValue(Java.Rvalue rv) throws CompileException {
        if (rv.constantValue != Java.Rvalue.CONSTANT_VALUE_UNKNOWN) {
            return rv.constantValue;
        }
        final Object[] res = new Object[1];
        Visitor.RvalueVisitor rvv = new Visitor.RvalueVisitor(){

            @Override
            public void visitArrayLength(Java.ArrayLength al) {
                res[0] = UnitCompiler.this.getConstantValue2(al);
            }

            @Override
            public void visitAssignment(Java.Assignment a) {
                res[0] = UnitCompiler.this.getConstantValue2(a);
            }

            @Override
            public void visitUnaryOperation(Java.UnaryOperation uo) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(uo);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBinaryOperation(Java.BinaryOperation bo) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(bo);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCast(Java.Cast c) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(c);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitClassLiteral(Java.ClassLiteral cl) {
                res[0] = UnitCompiler.this.getConstantValue2(cl);
            }

            @Override
            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(ce);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCrement(Java.Crement c) {
                res[0] = UnitCompiler.this.getConstantValue2(c);
            }

            @Override
            public void visitInstanceof(Java.Instanceof io) {
                res[0] = UnitCompiler.this.getConstantValue2(io);
            }

            @Override
            public void visitMethodInvocation(Java.MethodInvocation mi) {
                res[0] = UnitCompiler.this.getConstantValue2(mi);
            }

            @Override
            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                res[0] = UnitCompiler.this.getConstantValue2(smi);
            }

            @Override
            public void visitIntegerLiteral(Java.IntegerLiteral il) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(il);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(fpl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBooleanLiteral(Java.BooleanLiteral bl) {
                res[0] = UnitCompiler.this.getConstantValue2(bl);
            }

            @Override
            public void visitCharacterLiteral(Java.CharacterLiteral cl) {
                res[0] = UnitCompiler.this.getConstantValue2(cl);
            }

            @Override
            public void visitStringLiteral(Java.StringLiteral sl) {
                res[0] = UnitCompiler.this.getConstantValue2(sl);
            }

            @Override
            public void visitNullLiteral(Java.NullLiteral nl) {
                res[0] = UnitCompiler.this.getConstantValue2(nl);
            }

            @Override
            public void visitSimpleConstant(Java.SimpleConstant sl) {
                res[0] = UnitCompiler.this.getConstantValue2(sl);
            }

            @Override
            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                res[0] = UnitCompiler.this.getConstantValue2(naci);
            }

            @Override
            public void visitNewArray(Java.NewArray na) {
                res[0] = UnitCompiler.this.getConstantValue2(na);
            }

            @Override
            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                res[0] = UnitCompiler.this.getConstantValue2(nia);
            }

            @Override
            public void visitNewClassInstance(Java.NewClassInstance nci) {
                res[0] = UnitCompiler.this.getConstantValue2(nci);
            }

            @Override
            public void visitParameterAccess(Java.ParameterAccess pa) {
                res[0] = UnitCompiler.this.getConstantValue2(pa);
            }

            @Override
            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                res[0] = UnitCompiler.this.getConstantValue2(qtr);
            }

            @Override
            public void visitThisReference(Java.ThisReference tr) {
                res[0] = UnitCompiler.this.getConstantValue2(tr);
            }

            @Override
            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(an);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                res[0] = UnitCompiler.this.getConstantValue2(aae);
            }

            @Override
            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(fa);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                res[0] = UnitCompiler.this.getConstantValue2(fae);
            }

            @Override
            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                res[0] = UnitCompiler.this.getConstantValue2(scfae);
            }

            @Override
            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                res[0] = UnitCompiler.this.getConstantValue2(lva);
            }

            @Override
            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    res[0] = UnitCompiler.this.getConstantValue2(pe);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }
        };
        try {
            rv.accept(rvv);
            rv.constantValue = res[0];
            return rv.constantValue;
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
    }

    private Object getConstantValue2(Java.Rvalue rv) {
        return NOT_CONSTANT;
    }

    private Object getConstantValue2(Java.AmbiguousName an) throws CompileException {
        return this.getConstantValue(this.toRvalueOrCompileException(this.reclassify(an)));
    }

    private Object getConstantValue2(Java.FieldAccess fa) throws CompileException {
        return fa.field.getConstantValue();
    }

    private Object getConstantValue2(Java.UnaryOperation uo) throws CompileException {
        if (uo.operator.equals("+")) {
            return this.getConstantValue(uo.operand);
        }
        if (uo.operator.equals("-")) {
            return this.getNegatedConstantValue(uo.operand);
        }
        if (uo.operator.equals("!")) {
            Object cv = this.getConstantValue(uo.operand);
            return cv == Boolean.TRUE ? Boolean.FALSE : (cv == Boolean.FALSE ? Boolean.TRUE : NOT_CONSTANT);
        }
        return NOT_CONSTANT;
    }

    private Object getConstantValue2(Java.ConditionalExpression ce) throws CompileException {
        Object lhsValue = this.getConstantValue(ce.lhs);
        if (lhsValue instanceof Boolean) {
            return (Boolean)lhsValue != false ? this.getConstantValue(ce.mhs) : this.getConstantValue(ce.rhs);
        }
        return NOT_CONSTANT;
    }

    private Object getConstantValue2(Java.BinaryOperation bo) throws CompileException {
        Object lhsValue;
        if (bo.op == "|" || bo.op == "^" || bo.op == "&" || bo.op == "*" || bo.op == "/" || bo.op == "%" || bo.op == "+" || bo.op == "-" || bo.op == "==" || bo.op == "!=") {
            ArrayList<Object> cvs = new ArrayList<Object>();
            Iterator<Java.Rvalue> it = bo.unrollLeftAssociation();
            while (it.hasNext()) {
                Object cv = this.getConstantValue(it.next());
                if (cv == NOT_CONSTANT) {
                    return NOT_CONSTANT;
                }
                cvs.add(cv);
            }
            it = cvs.iterator();
            Object lhs = it.next();
            while (it.hasNext()) {
                if (lhs == NOT_CONSTANT) {
                    return NOT_CONSTANT;
                }
                Java.Rvalue rhs = it.next();
                if (bo.op == "+" && (lhs instanceof String || rhs instanceof String)) {
                    StringBuilder sb = new StringBuilder(lhs.toString()).append(rhs);
                    while (it.hasNext()) {
                        sb.append(((Object)it.next()).toString());
                    }
                    return sb.toString();
                }
                if (lhs instanceof Number && rhs instanceof Number) {
                    try {
                        if (lhs instanceof Double || rhs instanceof Double) {
                            double lhsD = ((Number)lhs).doubleValue();
                            double rhsD = ((Number)((Object)rhs)).doubleValue();
                            lhs = bo.op == "*" ? new Double(lhsD * rhsD) : (bo.op == "/" ? new Double(lhsD / rhsD) : (bo.op == "%" ? new Double(lhsD % rhsD) : (bo.op == "+" ? new Double(lhsD + rhsD) : (bo.op == "-" ? new Double(lhsD - rhsD) : (bo.op == "==" ? Boolean.valueOf(lhsD == rhsD) : (bo.op == "!=" ? Boolean.valueOf(lhsD != rhsD) : NOT_CONSTANT))))));
                            continue;
                        }
                        if (lhs instanceof Float || rhs instanceof Float) {
                            float lhsF = ((Number)lhs).floatValue();
                            float rhsF = ((Number)((Object)rhs)).floatValue();
                            lhs = bo.op == "*" ? new Float(lhsF * rhsF) : (bo.op == "/" ? new Float(lhsF / rhsF) : (bo.op == "%" ? new Float(lhsF % rhsF) : (bo.op == "+" ? new Float(lhsF + rhsF) : (bo.op == "-" ? new Float(lhsF - rhsF) : (bo.op == "==" ? Boolean.valueOf(lhsF == rhsF) : (bo.op == "!=" ? Boolean.valueOf(lhsF != rhsF) : NOT_CONSTANT))))));
                            continue;
                        }
                        if (lhs instanceof Long || rhs instanceof Long) {
                            long lhsL = ((Number)lhs).longValue();
                            long rhsL = ((Number)((Object)rhs)).longValue();
                            lhs = bo.op == "|" ? new Long(lhsL | rhsL) : (bo.op == "^" ? new Long(lhsL ^ rhsL) : (bo.op == "&" ? new Long(lhsL & rhsL) : (bo.op == "*" ? new Long(lhsL * rhsL) : (bo.op == "/" ? new Long(lhsL / rhsL) : (bo.op == "%" ? new Long(lhsL % rhsL) : (bo.op == "+" ? new Long(lhsL + rhsL) : (bo.op == "-" ? new Long(lhsL - rhsL) : (bo.op == "==" ? Boolean.valueOf(lhsL == rhsL) : (bo.op == "!=" ? Boolean.valueOf(lhsL != rhsL) : NOT_CONSTANT)))))))));
                            continue;
                        }
                        if (lhs instanceof Integer || lhs instanceof Byte || lhs instanceof Short || rhs instanceof Integer || lhs instanceof Byte || lhs instanceof Short) {
                            int lhsI = ((Number)lhs).intValue();
                            int rhsI = ((Number)((Object)rhs)).intValue();
                            lhs = bo.op == "|" ? new Integer(lhsI | rhsI) : (bo.op == "^" ? new Integer(lhsI ^ rhsI) : (bo.op == "&" ? new Integer(lhsI & rhsI) : (bo.op == "*" ? new Integer(lhsI * rhsI) : (bo.op == "/" ? new Integer(lhsI / rhsI) : (bo.op == "%" ? new Integer(lhsI % rhsI) : (bo.op == "+" ? new Integer(lhsI + rhsI) : (bo.op == "-" ? new Integer(lhsI - rhsI) : (bo.op == "==" ? Boolean.valueOf(lhsI == rhsI) : (bo.op == "!=" ? Boolean.valueOf(lhsI != rhsI) : NOT_CONSTANT)))))))));
                            continue;
                        }
                    }
                    catch (ArithmeticException ae) {
                        return NOT_CONSTANT;
                    }
                    throw new IllegalStateException();
                }
                if (lhs instanceof Character && rhs instanceof Character) {
                    char lhsC = ((Character)lhs).charValue();
                    char rhsC = ((Character)((Object)rhs)).charValue();
                    lhs = bo.op == "==" ? Boolean.valueOf(lhsC == rhsC) : (bo.op == "!=" ? Boolean.valueOf(lhsC != rhsC) : NOT_CONSTANT);
                    continue;
                }
                if (lhs == null || rhs == null) {
                    lhs = bo.op == "==" ? Boolean.valueOf(lhs == rhs) : (bo.op == "!=" ? Boolean.valueOf(lhs != rhs) : NOT_CONSTANT);
                    continue;
                }
                return NOT_CONSTANT;
            }
            return lhs;
        }
        if ((bo.op == "&&" || bo.op == "||") && (lhsValue = this.getConstantValue(bo.lhs)) instanceof Boolean) {
            boolean lhsBv = (Boolean)lhsValue;
            return bo.op == "&&" ? (lhsBv ? this.getConstantValue(bo.rhs) : Boolean.FALSE) : (lhsBv ? Boolean.TRUE : this.getConstantValue(bo.rhs));
        }
        return NOT_CONSTANT;
    }

    private Object getConstantValue2(Java.Cast c) throws CompileException {
        Object cv = this.getConstantValue(c.value);
        if (cv == NOT_CONSTANT) {
            return NOT_CONSTANT;
        }
        if (cv instanceof Number) {
            IClass tt = this.getType(c.targetType);
            if (tt == IClass.BYTE) {
                return new Byte(((Number)cv).byteValue());
            }
            if (tt == IClass.SHORT) {
                return new Short(((Number)cv).shortValue());
            }
            if (tt == IClass.INT) {
                return new Integer(((Number)cv).intValue());
            }
            if (tt == IClass.LONG) {
                return new Long(((Number)cv).longValue());
            }
            if (tt == IClass.FLOAT) {
                return new Float(((Number)cv).floatValue());
            }
            if (tt == IClass.DOUBLE) {
                return new Double(((Number)cv).doubleValue());
            }
        }
        return NOT_CONSTANT;
    }

    private Object getConstantValue2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.getConstantValue(pe.value);
    }

    private Object getConstantValue2(Java.IntegerLiteral il) throws CompileException {
        String v = il.value;
        if (v.startsWith("0x")) {
            return v.endsWith("L") || v.endsWith("l") ? (Number)UnitCompiler.hex2Long(il, v.substring(2, v.length() - 1)) : (Number)UnitCompiler.hex2Int(il, v.substring(2));
        }
        if (v.startsWith("0")) {
            return v.endsWith("L") || v.endsWith("l") ? (Number)UnitCompiler.oct2Long(il, v.substring(0, v.length() - 1)) : (Number)UnitCompiler.oct2Int(il, v);
        }
        try {
            return v.endsWith("L") || v.endsWith("l") ? (Number)new Long(v.substring(0, v.length() - 1)) : (Number)new Integer(v);
        }
        catch (NumberFormatException e) {
            throw UnitCompiler.compileException(il, "Value of decimal integer literal '" + v + "' is out of range");
        }
    }

    private Object getConstantValue2(Java.FloatingPointLiteral fpl) throws CompileException {
        double dv;
        String v = fpl.value;
        char lastChar = v.charAt(v.length() - 1);
        if (lastChar == 'f' || lastChar == 'F') {
            float fv;
            v = v.substring(0, v.length() - 1);
            try {
                fv = Float.parseFloat(v);
            }
            catch (NumberFormatException e) {
                throw new JaninoRuntimeException("SNO: parsing float literal '" + v + "': " + e.getMessage(), e);
            }
            if (Float.isInfinite(fv)) {
                throw UnitCompiler.compileException(fpl, "Value of float literal '" + v + "' is out of range");
            }
            if (Float.isNaN(fv)) {
                throw new JaninoRuntimeException("SNO: parsing float literal '" + v + "' results in NaN");
            }
            if (fv == 0.0f) {
                for (int i = 0; i < v.length(); ++i) {
                    char c = v.charAt(i);
                    if ("123456789".indexOf(c) != -1) {
                        throw UnitCompiler.compileException(fpl, "Literal '" + v + "' is too small to be represented as a float");
                    }
                    if (c != '0' && c != '.') break;
                }
            }
            return new Float(fv);
        }
        if (lastChar == 'd' || lastChar == 'D') {
            v = v.substring(0, v.length() - 1);
        }
        try {
            dv = Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            throw new JaninoRuntimeException("SNO: parsing double literal '" + v + "': " + e.getMessage(), e);
        }
        if (Double.isInfinite(dv)) {
            throw UnitCompiler.compileException(fpl, "Value of double literal '" + v + "' is out of range");
        }
        if (Double.isNaN(dv)) {
            throw new JaninoRuntimeException("SNO: parsing double literal '" + v + "' results is NaN");
        }
        if (dv == 0.0) {
            for (int i = 0; i < v.length(); ++i) {
                char c = v.charAt(i);
                if ("123456789".indexOf(c) != -1) {
                    throw UnitCompiler.compileException(fpl, "Literal '" + v + "' is too small to be represented as a double");
                }
                if (c != '0' && c != '.') break;
            }
        }
        return new Double(dv);
    }

    private Object getConstantValue2(Java.BooleanLiteral bl) {
        if (bl.value == "true") {
            return Boolean.TRUE;
        }
        if (bl.value == "false") {
            return Boolean.FALSE;
        }
        throw new JaninoRuntimeException(bl.value);
    }

    private Object getConstantValue2(Java.CharacterLiteral cl) {
        String v = cl.value;
        return Character.valueOf(UnitCompiler.unescape(v.substring(1, v.length() - 1)).charAt(0));
    }

    private Object getConstantValue2(Java.StringLiteral sl) {
        if (sl == null || sl.value == null) {
            return "";
        }
        String v = sl.value;
        return UnitCompiler.unescape(v.substring(1, v.length() - 1));
    }

    private Object getConstantValue2(Java.NullLiteral nl) {
        return null;
    }

    private Object getConstantValue2(Java.SimpleConstant sl) {
        return sl.value;
    }

    private Object getNegatedConstantValue(Java.Rvalue rv) throws CompileException {
        final Object[] res = new Object[1];
        Visitor.RvalueVisitor rvv = new Visitor.RvalueVisitor(){

            @Override
            public void visitArrayLength(Java.ArrayLength al) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(al);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitAssignment(Java.Assignment a) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(a);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitUnaryOperation(Java.UnaryOperation uo) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(uo);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBinaryOperation(Java.BinaryOperation bo) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(bo);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCast(Java.Cast c) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(c);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitClassLiteral(Java.ClassLiteral cl) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(cl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(ce);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCrement(Java.Crement c) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(c);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitInstanceof(Java.Instanceof io) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(io);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitMethodInvocation(Java.MethodInvocation mi) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(mi);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(smi);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitIntegerLiteral(Java.IntegerLiteral il) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(il);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(fpl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBooleanLiteral(Java.BooleanLiteral bl) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(bl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCharacterLiteral(Java.CharacterLiteral cl) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(cl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitStringLiteral(Java.StringLiteral sl) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(sl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNullLiteral(Java.NullLiteral nl) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(nl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSimpleConstant(Java.SimpleConstant sl) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(sl);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(naci);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewArray(Java.NewArray na) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(na);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(nia);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewClassInstance(Java.NewClassInstance nci) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(nci);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitParameterAccess(Java.ParameterAccess pa) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(pa);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(qtr);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitThisReference(Java.ThisReference tr) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(tr);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(an);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(aae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(fa);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(fae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(scfae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(lva);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    res[0] = UnitCompiler.this.getNegatedConstantValue2(pe);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }
        };
        try {
            rv.accept(rvv);
            return res[0];
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
    }

    private Object getNegatedConstantValue2(Java.Rvalue rv) throws CompileException {
        Object cv = this.getConstantValue(rv);
        if (cv instanceof Byte) {
            return new Byte(-((Byte)cv).byteValue());
        }
        if (cv instanceof Short) {
            return new Short(-((Short)cv).shortValue());
        }
        if (cv instanceof Integer) {
            return new Integer(-((Integer)cv).intValue());
        }
        if (cv instanceof Long) {
            return new Long(-((Long)cv).longValue());
        }
        if (cv instanceof Float) {
            return new Float(-((Float)cv).floatValue());
        }
        if (cv instanceof Double) {
            return new Double(-((Double)cv).doubleValue());
        }
        return NOT_CONSTANT;
    }

    private Object getNegatedConstantValue2(Java.UnaryOperation uo) throws CompileException {
        return uo.operator.equals("+") ? this.getNegatedConstantValue(uo.operand) : (uo.operator.equals("-") ? this.getConstantValue(uo.operand) : NOT_CONSTANT);
    }

    private Object getNegatedConstantValue2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.getNegatedConstantValue(pe.value);
    }

    private Object getNegatedConstantValue2(Java.IntegerLiteral il) throws CompileException {
        String v2;
        String v = il.value;
        if ("2147483648".equals(v) || "020000000000".equals(v)) {
            return new Integer(Integer.MIN_VALUE);
        }
        char lastChar = v.charAt(v.length() - 1);
        if ((lastChar == 'l' || lastChar == 'L') && ("9223372036854775808".equals(v2 = v.substring(0, v.length() - 1)) || "01000000000000000000000".equals(v2))) {
            return new Long(Long.MIN_VALUE);
        }
        return this.getNegatedConstantValue2((Java.Rvalue)il);
    }

    private boolean generatesCode(Java.BlockStatement bs) throws CompileException {
        final boolean[] res = new boolean[1];
        Visitor.BlockStatementVisitor bsv = new Visitor.BlockStatementVisitor(){

            @Override
            public void visitInitializer(Java.Initializer i) {
                try {
                    res[0] = UnitCompiler.this.generatesCode2(i);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldDeclaration(Java.FieldDeclaration fd) {
                try {
                    res[0] = UnitCompiler.this.generatesCode2(fd);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLabeledStatement(Java.LabeledStatement ls) {
                res[0] = UnitCompiler.this.generatesCode2(ls);
            }

            @Override
            public void visitBlock(Java.Block b) {
                try {
                    res[0] = UnitCompiler.this.generatesCode2(b);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitExpressionStatement(Java.ExpressionStatement es) {
                res[0] = UnitCompiler.this.generatesCode2(es);
            }

            @Override
            public void visitIfStatement(Java.IfStatement is) {
                res[0] = UnitCompiler.this.generatesCode2(is);
            }

            @Override
            public void visitForStatement(Java.ForStatement fs) {
                res[0] = UnitCompiler.this.generatesCode2(fs);
            }

            @Override
            public void visitForEachStatement(Java.ForEachStatement fes) {
                res[0] = UnitCompiler.this.generatesCode2(fes);
            }

            @Override
            public void visitWhileStatement(Java.WhileStatement ws) {
                res[0] = UnitCompiler.this.generatesCode2(ws);
            }

            @Override
            public void visitTryStatement(Java.TryStatement ts) {
                res[0] = UnitCompiler.this.generatesCode2(ts);
            }

            @Override
            public void visitSwitchStatement(Java.SwitchStatement ss) {
                res[0] = UnitCompiler.this.generatesCode2(ss);
            }

            @Override
            public void visitSynchronizedStatement(Java.SynchronizedStatement ss) {
                res[0] = UnitCompiler.this.generatesCode2(ss);
            }

            @Override
            public void visitDoStatement(Java.DoStatement ds) {
                res[0] = UnitCompiler.this.generatesCode2(ds);
            }

            @Override
            public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                res[0] = UnitCompiler.this.generatesCode2(lvds);
            }

            @Override
            public void visitReturnStatement(Java.ReturnStatement rs) {
                res[0] = UnitCompiler.this.generatesCode2(rs);
            }

            @Override
            public void visitThrowStatement(Java.ThrowStatement ts) {
                res[0] = UnitCompiler.this.generatesCode2(ts);
            }

            @Override
            public void visitBreakStatement(Java.BreakStatement bs) {
                res[0] = UnitCompiler.this.generatesCode2(bs);
            }

            @Override
            public void visitContinueStatement(Java.ContinueStatement cs) {
                res[0] = UnitCompiler.this.generatesCode2(cs);
            }

            @Override
            public void visitAssertStatement(Java.AssertStatement as) {
                res[0] = UnitCompiler.this.generatesCode2(as);
            }

            @Override
            public void visitEmptyStatement(Java.EmptyStatement es) {
                res[0] = UnitCompiler.this.generatesCode2(es);
            }

            @Override
            public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) {
                res[0] = UnitCompiler.this.generatesCode2(lcds);
            }

            @Override
            public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) {
                res[0] = UnitCompiler.this.generatesCode2(aci);
            }

            @Override
            public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) {
                res[0] = UnitCompiler.this.generatesCode2(sci);
            }
        };
        try {
            bs.accept(bsv);
            return res[0];
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
    }

    private boolean generatesCode2(Java.BlockStatement bs) {
        return true;
    }

    private boolean generatesCode2(Java.AssertStatement as) {
        return true;
    }

    private boolean generatesCode2(Java.EmptyStatement es) {
        return false;
    }

    private boolean generatesCode2(Java.LocalClassDeclarationStatement lcds) {
        return false;
    }

    private boolean generatesCode2(Java.Initializer i) throws CompileException {
        return this.generatesCode(i.block);
    }

    private boolean generatesCode2(List<Java.BlockStatement> l) throws CompileException {
        for (Java.BlockStatement bs : l) {
            if (!this.generatesCode(bs)) continue;
            return true;
        }
        return false;
    }

    private boolean generatesCode2(Java.Block b) throws CompileException {
        return this.generatesCode2(b.statements);
    }

    private boolean generatesCode2(Java.FieldDeclaration fd) throws CompileException {
        for (Java.VariableDeclarator vd : fd.variableDeclarators) {
            if (this.getNonConstantFinalInitializer(fd, vd) == null) continue;
            return true;
        }
        return false;
    }

    private void leave(Java.BlockStatement bs, final IClass optionalStackValueType) {
        Visitor.BlockStatementVisitor bsv = new Visitor.BlockStatementVisitor(){

            @Override
            public void visitInitializer(Java.Initializer i) {
                UnitCompiler.this.leave2(i, optionalStackValueType);
            }

            @Override
            public void visitFieldDeclaration(Java.FieldDeclaration fd) {
                UnitCompiler.this.leave2(fd, optionalStackValueType);
            }

            @Override
            public void visitLabeledStatement(Java.LabeledStatement ls) {
                UnitCompiler.this.leave2(ls, optionalStackValueType);
            }

            @Override
            public void visitBlock(Java.Block b) {
                UnitCompiler.this.leave2(b, optionalStackValueType);
            }

            @Override
            public void visitExpressionStatement(Java.ExpressionStatement es) {
                UnitCompiler.this.leave2(es, optionalStackValueType);
            }

            @Override
            public void visitIfStatement(Java.IfStatement is) {
                UnitCompiler.this.leave2(is, optionalStackValueType);
            }

            @Override
            public void visitForStatement(Java.ForStatement fs) {
                UnitCompiler.this.leave2(fs, optionalStackValueType);
            }

            @Override
            public void visitForEachStatement(Java.ForEachStatement fes) {
                UnitCompiler.this.leave2(fes, optionalStackValueType);
            }

            @Override
            public void visitWhileStatement(Java.WhileStatement ws) {
                UnitCompiler.this.leave2(ws, optionalStackValueType);
            }

            @Override
            public void visitTryStatement(Java.TryStatement ts) {
                UnitCompiler.this.leave2(ts, optionalStackValueType);
            }

            @Override
            public void visitSwitchStatement(Java.SwitchStatement ss) {
                UnitCompiler.this.leave2(ss, optionalStackValueType);
            }

            @Override
            public void visitSynchronizedStatement(Java.SynchronizedStatement ss) {
                UnitCompiler.this.leave2(ss, optionalStackValueType);
            }

            @Override
            public void visitDoStatement(Java.DoStatement ds) {
                UnitCompiler.this.leave2(ds, optionalStackValueType);
            }

            @Override
            public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                UnitCompiler.this.leave2(lvds, optionalStackValueType);
            }

            @Override
            public void visitReturnStatement(Java.ReturnStatement rs) {
                UnitCompiler.this.leave2(rs, optionalStackValueType);
            }

            @Override
            public void visitThrowStatement(Java.ThrowStatement ts) {
                UnitCompiler.this.leave2(ts, optionalStackValueType);
            }

            @Override
            public void visitBreakStatement(Java.BreakStatement bs) {
                UnitCompiler.this.leave2(bs, optionalStackValueType);
            }

            @Override
            public void visitContinueStatement(Java.ContinueStatement cs) {
                UnitCompiler.this.leave2(cs, optionalStackValueType);
            }

            @Override
            public void visitAssertStatement(Java.AssertStatement as) {
                UnitCompiler.this.leave2(as, optionalStackValueType);
            }

            @Override
            public void visitEmptyStatement(Java.EmptyStatement es) {
                UnitCompiler.this.leave2(es, optionalStackValueType);
            }

            @Override
            public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) {
                UnitCompiler.this.leave2(lcds, optionalStackValueType);
            }

            @Override
            public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) {
                UnitCompiler.this.leave2(aci, optionalStackValueType);
            }

            @Override
            public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) {
                UnitCompiler.this.leave2(sci, optionalStackValueType);
            }
        };
        bs.accept(bsv);
    }

    private void leave2(Java.BlockStatement bs, IClass optionalStackValueType) {
    }

    private void leave2(Java.SynchronizedStatement ss, IClass optionalStackValueType) {
        this.load(ss, this.iClassLoader.TYPE_java_lang_Object, ss.monitorLvIndex);
        this.writeOpcode(ss, -61);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leave2(Java.TryStatement ts, IClass optionalStackValueType) {
        if (ts.finallyOffset != null) {
            this.codeContext.saveLocalVariables();
            try {
                short sv = 0;
                if (optionalStackValueType != null) {
                    sv = this.codeContext.allocateLocalVariable(Descriptor.size(optionalStackValueType.getDescriptor()));
                    this.store(ts, optionalStackValueType, sv);
                }
                this.writeBranch(ts, -88, ts.finallyOffset);
                if (optionalStackValueType != null) {
                    this.load(ts, optionalStackValueType, sv);
                }
            }
            finally {
                this.codeContext.restoreLocalVariables();
            }
        }
    }

    private void compileSet(Java.Lvalue lv) throws CompileException {
        Visitor.LvalueVisitor lvv = new Visitor.LvalueVisitor(){

            @Override
            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    UnitCompiler.this.compileSet2(an);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    UnitCompiler.this.compileSet2(aae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    UnitCompiler.this.compileSet2(fa);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    UnitCompiler.this.compileSet2(fae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    UnitCompiler.this.compileSet2(scfae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                UnitCompiler.this.compileSet2(lva);
            }

            @Override
            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    UnitCompiler.this.compileSet2(pe);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }
        };
        try {
            lv.accept(lvv);
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
    }

    private void compileSet2(Java.AmbiguousName an) throws CompileException {
        this.compileSet(this.toLvalueOrCompileException(this.reclassify(an)));
    }

    private void compileSet2(Java.LocalVariableAccess lva) {
        this.store(lva, lva.localVariable);
    }

    private void compileSet2(Java.FieldAccess fa) throws CompileException {
        this.checkAccessible(fa.field, fa.getEnclosingBlockStatement());
        this.putfield(fa, fa.field);
    }

    private void compileSet2(Java.ArrayAccessExpression aae) throws CompileException {
        this.writeOpcode(aae, 79 + UnitCompiler.ilfdabcs(this.getType(aae)));
    }

    private void compileSet2(Java.FieldAccessExpression fae) throws CompileException {
        this.determineValue(fae);
        this.compileSet(this.toLvalueOrCompileException(fae.value));
    }

    private void compileSet2(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        this.determineValue(scfae);
        this.compileSet(this.toLvalueOrCompileException(scfae.value));
    }

    private void compileSet2(Java.ParenthesizedExpression pe) throws CompileException {
        this.compileSet(this.toLvalueOrCompileException(pe.value));
    }

    private IClass getType(Java.Atom a) throws CompileException {
        final IClass[] res = new IClass[1];
        Visitor.AtomVisitor av = new Visitor.AtomVisitor(){

            @Override
            public void visitPackage(Java.Package p) {
                try {
                    res[0] = UnitCompiler.this.getType2(p);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitArrayType(Java.ArrayType at) {
                try {
                    res[0] = UnitCompiler.this.getType2(at);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBasicType(Java.BasicType bt) {
                res[0] = UnitCompiler.this.getType2(bt);
            }

            @Override
            public void visitReferenceType(Java.ReferenceType rt) {
                try {
                    res[0] = UnitCompiler.this.getType2(rt);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitRvalueMemberType(Java.RvalueMemberType rmt) {
                try {
                    res[0] = UnitCompiler.this.getType2(rmt);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSimpleType(Java.SimpleType st) {
                res[0] = UnitCompiler.this.getType2(st);
            }

            @Override
            public void visitArrayLength(Java.ArrayLength al) {
                res[0] = UnitCompiler.this.getType2(al);
            }

            @Override
            public void visitAssignment(Java.Assignment a) {
                try {
                    res[0] = UnitCompiler.this.getType2(a);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitUnaryOperation(Java.UnaryOperation uo) {
                try {
                    res[0] = UnitCompiler.this.getType2(uo);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitBinaryOperation(Java.BinaryOperation bo) {
                try {
                    res[0] = UnitCompiler.this.getType2(bo);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCast(Java.Cast c) {
                try {
                    res[0] = UnitCompiler.this.getType2(c);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitClassLiteral(Java.ClassLiteral cl) {
                res[0] = UnitCompiler.this.getType2(cl);
            }

            @Override
            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                try {
                    res[0] = UnitCompiler.this.getType2(ce);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitCrement(Java.Crement c) {
                try {
                    res[0] = UnitCompiler.this.getType2(c);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitInstanceof(Java.Instanceof io) {
                res[0] = UnitCompiler.this.getType2(io);
            }

            @Override
            public void visitMethodInvocation(Java.MethodInvocation mi) {
                try {
                    res[0] = UnitCompiler.this.getType2(mi);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                try {
                    res[0] = UnitCompiler.this.getType2(smi);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitIntegerLiteral(Java.IntegerLiteral il) {
                res[0] = UnitCompiler.this.getType2(il);
            }

            @Override
            public void visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) {
                res[0] = UnitCompiler.this.getType2(fpl);
            }

            @Override
            public void visitBooleanLiteral(Java.BooleanLiteral bl) {
                res[0] = UnitCompiler.this.getType2(bl);
            }

            @Override
            public void visitCharacterLiteral(Java.CharacterLiteral cl) {
                res[0] = UnitCompiler.this.getType2(cl);
            }

            @Override
            public void visitStringLiteral(Java.StringLiteral sl) {
                res[0] = UnitCompiler.this.getType2(sl);
            }

            @Override
            public void visitNullLiteral(Java.NullLiteral nl) {
                res[0] = UnitCompiler.this.getType2(nl);
            }

            @Override
            public void visitSimpleConstant(Java.SimpleConstant sl) {
                res[0] = UnitCompiler.this.getType2(sl);
            }

            @Override
            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                res[0] = UnitCompiler.this.getType2(naci);
            }

            @Override
            public void visitNewArray(Java.NewArray na) {
                try {
                    res[0] = UnitCompiler.this.getType2(na);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                try {
                    res[0] = UnitCompiler.this.getType2(nia);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitNewClassInstance(Java.NewClassInstance nci) {
                try {
                    res[0] = UnitCompiler.this.getType2(nci);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitParameterAccess(Java.ParameterAccess pa) {
                try {
                    res[0] = UnitCompiler.this.getType2(pa);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                try {
                    res[0] = UnitCompiler.this.getType2(qtr);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitThisReference(Java.ThisReference tr) {
                try {
                    res[0] = UnitCompiler.this.getType2(tr);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    res[0] = UnitCompiler.this.getType2(an);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                try {
                    res[0] = UnitCompiler.this.getType2(aae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccess(Java.FieldAccess fa) {
                try {
                    res[0] = UnitCompiler.this.getType2(fa);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                try {
                    res[0] = UnitCompiler.this.getType2(fae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                try {
                    res[0] = UnitCompiler.this.getType2(scfae);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                res[0] = UnitCompiler.this.getType2(lva);
            }

            @Override
            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                try {
                    res[0] = UnitCompiler.this.getType2(pe);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }
        };
        try {
            a.accept(av);
            return res[0] != null ? res[0] : this.iClassLoader.TYPE_java_lang_Object;
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
    }

    private IClass getType2(Java.SimpleType st) {
        return st.iClass;
    }

    private IClass getType2(Java.BasicType bt) {
        switch (bt.index) {
            case 0: {
                return IClass.VOID;
            }
            case 1: {
                return IClass.BYTE;
            }
            case 2: {
                return IClass.SHORT;
            }
            case 3: {
                return IClass.CHAR;
            }
            case 4: {
                return IClass.INT;
            }
            case 5: {
                return IClass.LONG;
            }
            case 6: {
                return IClass.FLOAT;
            }
            case 7: {
                return IClass.DOUBLE;
            }
            case 8: {
                return IClass.BOOLEAN;
            }
        }
        throw new JaninoRuntimeException("Invalid index " + bt.index);
    }

    private IClass getType2(Java.ReferenceType rt) throws CompileException {
        Java.BlockStatement scopeBlockStatement = null;
        Java.TypeDeclaration scopeTypeDeclaration = null;
        Java.Scope s2 = rt.getEnclosingScope();
        while (true) {
            if (s2 instanceof Java.BlockStatement && scopeBlockStatement == null) {
                scopeBlockStatement = (Java.BlockStatement)s2;
            }
            if (s2 instanceof Java.TypeDeclaration && scopeTypeDeclaration == null) {
                scopeTypeDeclaration = (Java.TypeDeclaration)s2;
            }
            if (s2 instanceof Java.CompilationUnit) break;
            s2 = s2.getEnclosingScope();
        }
        Java.CompilationUnit scopeCompilationUnit = (Java.CompilationUnit)s2;
        if (rt.identifiers.length == 1) {
            IClass importedClass;
            Java.LocalClassDeclaration lcd;
            Java.TypeParameter[] optionalTypeParameters;
            String simpleTypeName = rt.identifiers[0];
            if (scopeTypeDeclaration instanceof Java.NamedTypeDeclaration && (optionalTypeParameters = ((Java.NamedTypeDeclaration)scopeTypeDeclaration).getOptionalTypeParameters()) != null) {
                for (Java.TypeParameter tp : optionalTypeParameters) {
                    IClass[] boundTypes;
                    if (!tp.name.equals(simpleTypeName)) continue;
                    if (tp.optionalBound == null) {
                        boundTypes = new IClass[]{this.iClassLoader.TYPE_java_lang_Object};
                    } else {
                        boundTypes = new IClass[tp.optionalBound.length];
                        for (int i = 0; i < boundTypes.length; ++i) {
                            boundTypes[i] = this.getType(tp.optionalBound[i]);
                        }
                    }
                    return boundTypes[0];
                }
            }
            if ((lcd = UnitCompiler.findLocalClassDeclaration(rt.getEnclosingScope(), simpleTypeName)) != null) {
                return this.resolve(lcd);
            }
            if (scopeTypeDeclaration != null) {
                Java.Scope s3 = scopeTypeDeclaration;
                while (!(s3 instanceof Java.CompilationUnit)) {
                    IClass mt;
                    if (s3 instanceof Java.TypeDeclaration && (mt = this.findMemberType(this.resolve((Java.AbstractTypeDeclaration)s3), simpleTypeName, rt.getLocation())) != null) {
                        return mt;
                    }
                    s3 = s3.getEnclosingScope();
                }
            }
            if ((importedClass = this.importSingleType(simpleTypeName, rt.getLocation())) != null) {
                return importedClass;
            }
            Java.PackageMemberTypeDeclaration pmtd = scopeCompilationUnit.getPackageMemberTypeDeclaration(simpleTypeName);
            if (pmtd != null) {
                return this.resolve(pmtd);
            }
            String pkg = scopeCompilationUnit.optionalPackageDeclaration == null ? null : scopeCompilationUnit.optionalPackageDeclaration.packageName;
            String className = pkg == null ? simpleTypeName : pkg + "." + simpleTypeName;
            IClass result2 = this.findTypeByName(rt.getLocation(), className);
            if (result2 != null) {
                return result2;
            }
            importedClass = this.importTypeOnDemand(simpleTypeName, rt.getLocation());
            if (importedClass != null) {
                return importedClass;
            }
            List<Object> l = this.singleStaticImports.get(simpleTypeName);
            if (l != null) {
                IClass importedMemberType = null;
                for (Object o : l) {
                    IClass mt;
                    if (!(o instanceof IClass) || !this.isAccessible(mt = (IClass)o, (Java.Scope)scopeBlockStatement)) continue;
                    if (importedMemberType != null && importedMemberType != mt) {
                        this.compileError("Ambiguous static imports: \"" + importedMemberType.toString() + "\" vs. \"" + mt.toString() + "\"");
                    }
                    importedMemberType = mt;
                }
                if (importedMemberType != null) {
                    return importedMemberType;
                }
            }
            IClass importedMemberType = null;
            for (IClass ic : this.staticImportsOnDemand) {
                IClass[] memberTypes2;
                for (IClass mt : memberTypes2 = ic.getDeclaredIClasses()) {
                    if (!this.isAccessible(mt, (Java.Scope)scopeBlockStatement) || !mt.getDescriptor().endsWith('$' + simpleTypeName + ';')) continue;
                    if (importedMemberType != null) {
                        this.compileError("Ambiguous static imports: \"" + importedMemberType.toString() + "\" vs. \"" + mt.toString() + "\"");
                    }
                    importedMemberType = mt;
                }
            }
            if (importedMemberType != null) {
                return importedMemberType;
            }
            this.compileError("Cannot determine simple type name \"" + simpleTypeName + "\"", rt.getLocation());
            return this.iClassLoader.TYPE_java_lang_Object;
        }
        Java.Atom q = this.reclassifyName(rt.getLocation(), rt.getEnclosingScope(), rt.identifiers, rt.identifiers.length - 1);
        if (q instanceof Java.Package) {
            String className = Java.join(rt.identifiers, ".");
            IClass result3 = this.findTypeByName(rt.getLocation(), className);
            if (result3 != null) {
                return result3;
            }
            this.compileError("Class \"" + className + "\" not found", rt.getLocation());
            return this.iClassLoader.TYPE_java_lang_Object;
        }
        String memberTypeName = rt.identifiers[rt.identifiers.length - 1];
        IClass[] types2 = this.getType(this.toTypeOrCompileException(q)).findMemberType(memberTypeName);
        if (types2.length == 1) {
            return types2[0];
        }
        if (types2.length == 0) {
            this.compileError("\"" + q + "\" declares no member type \"" + memberTypeName + "\"", rt.getLocation());
        } else {
            this.compileError("\"" + q + "\" and its supertypes declare more than one member type \"" + memberTypeName + "\"", rt.getLocation());
        }
        return this.iClassLoader.TYPE_java_lang_Object;
    }

    private IClass getType2(Java.RvalueMemberType rvmt) throws CompileException {
        IClass rvt = this.getType(rvmt.rvalue);
        IClass memberType = this.findMemberType(rvt, rvmt.identifier, rvmt.getLocation());
        if (memberType == null) {
            this.compileError("\"" + rvt + "\" has no member type \"" + rvmt.identifier + "\"", rvmt.getLocation());
        }
        return memberType;
    }

    private IClass getType2(Java.ArrayType at) throws CompileException {
        return this.getType(at.componentType).getArrayIClass(this.iClassLoader.TYPE_java_lang_Object);
    }

    private IClass getType2(Java.AmbiguousName an) throws CompileException {
        return this.getType(this.reclassify(an));
    }

    private IClass getType2(Java.Package p) throws CompileException {
        this.compileError("Unknown variable or type \"" + p.name + "\"", p.getLocation());
        return this.iClassLoader.TYPE_java_lang_Object;
    }

    private IClass getType2(Java.LocalVariableAccess lva) {
        return lva.localVariable.type;
    }

    private IClass getType2(Java.FieldAccess fa) throws CompileException {
        return fa.field.getType();
    }

    private IClass getType2(Java.ArrayLength al) {
        return IClass.INT;
    }

    private IClass getType2(Java.ThisReference tr) throws CompileException {
        return this.getIClass(tr);
    }

    private IClass getType2(Java.QualifiedThisReference qtr) throws CompileException {
        return this.getTargetIClass(qtr);
    }

    private IClass getType2(Java.ClassLiteral cl) {
        return this.iClassLoader.TYPE_java_lang_Class;
    }

    private IClass getType2(Java.Assignment a) throws CompileException {
        return this.getType(a.lhs);
    }

    private IClass getType2(Java.ConditionalExpression ce) throws CompileException {
        IClass rhsType;
        IClass mhsType = this.getType(ce.mhs);
        if (mhsType == (rhsType = this.getType(ce.rhs))) {
            return mhsType;
        }
        if (mhsType.isPrimitiveNumeric() && rhsType.isPrimitiveNumeric()) {
            return this.binaryNumericPromotionType(ce, mhsType, rhsType);
        }
        if (this.getConstantValue(ce.mhs) == null && !rhsType.isPrimitive()) {
            return rhsType;
        }
        if (!mhsType.isPrimitive() && this.getConstantValue(ce.rhs) == null) {
            return mhsType;
        }
        if (!mhsType.isPrimitive() && !rhsType.isPrimitive()) {
            if (mhsType.isAssignableFrom(rhsType)) {
                return mhsType;
            }
            if (rhsType.isAssignableFrom(mhsType)) {
                return rhsType;
            }
            this.compileError("Reference types \"" + mhsType + "\" and \"" + rhsType + "\" don't match", ce.getLocation());
            return this.iClassLoader.TYPE_java_lang_Object;
        }
        this.compileError("Incompatible expression types \"" + mhsType + "\" and \"" + rhsType + "\"", ce.getLocation());
        return this.iClassLoader.TYPE_java_lang_Object;
    }

    private IClass getType2(Java.Crement c) throws CompileException {
        return this.getType(c.operand);
    }

    private IClass getType2(Java.ArrayAccessExpression aae) throws CompileException {
        return this.getType(aae.lhs).getComponentType();
    }

    private IClass getType2(Java.FieldAccessExpression fae) throws CompileException {
        this.determineValue(fae);
        return this.getType(fae.value);
    }

    private IClass getType2(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        this.determineValue(scfae);
        return this.getType(scfae.value);
    }

    private IClass getType2(Java.UnaryOperation uo) throws CompileException {
        if (uo.operator == "!") {
            return IClass.BOOLEAN;
        }
        if (uo.operator == "+" || uo.operator == "-" || uo.operator == "~") {
            return this.unaryNumericPromotionType(uo, this.getUnboxedType(this.getType(uo.operand)));
        }
        this.compileError("Unexpected operator \"" + uo.operator + "\"", uo.getLocation());
        return IClass.BOOLEAN;
    }

    private IClass getType2(Java.Instanceof io) {
        return IClass.BOOLEAN;
    }

    private IClass getType2(Java.BinaryOperation bo) throws CompileException {
        if (bo.op == "||" || bo.op == "&&" || bo.op == "==" || bo.op == "!=" || bo.op == "<" || bo.op == ">" || bo.op == "<=" || bo.op == ">=") {
            return IClass.BOOLEAN;
        }
        if (bo.op == "|" || bo.op == "^" || bo.op == "&") {
            IClass lhsType = this.getType(bo.lhs);
            return lhsType == IClass.BOOLEAN || lhsType == this.iClassLoader.TYPE_java_lang_Boolean ? IClass.BOOLEAN : this.binaryNumericPromotionType(bo, lhsType, this.getType(bo.rhs));
        }
        if (bo.op == "*" || bo.op == "/" || bo.op == "%" || bo.op == "+" || bo.op == "-") {
            IClassLoader icl = this.iClassLoader;
            Iterator<Java.Rvalue> ops2 = bo.unrollLeftAssociation();
            IClass lhsType = this.getUnboxedType(this.getType(ops2.next()));
            if (bo.op == "+" && lhsType == icl.TYPE_java_lang_String) {
                return icl.TYPE_java_lang_String;
            }
            do {
                IClass rhsType = this.getUnboxedType(this.getType(ops2.next()));
                if (bo.op == "+" && rhsType == icl.TYPE_java_lang_String) {
                    return icl.TYPE_java_lang_String;
                }
                lhsType = this.binaryNumericPromotionType(bo, lhsType, rhsType);
            } while (ops2.hasNext());
            return lhsType;
        }
        if (bo.op == "<<" || bo.op == ">>" || bo.op == ">>>") {
            IClass lhsType = this.getType(bo.lhs);
            return this.unaryNumericPromotionType(bo, lhsType);
        }
        this.compileError("Unexpected operator \"" + bo.op + "\"", bo.getLocation());
        return this.iClassLoader.TYPE_java_lang_Object;
    }

    private IClass getUnboxedType(IClass type) {
        IClass c = this.isUnboxingConvertible(type);
        return c != null ? c : type;
    }

    private IClass getType2(Java.Cast c) throws CompileException {
        return this.getType(c.targetType);
    }

    private IClass getType2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.getType(pe.value);
    }

    private IClass getType2(Java.MethodInvocation mi) throws CompileException {
        if (mi.iMethod == null) {
            mi.iMethod = this.findIMethod(mi);
        }
        return mi.iMethod.getReturnType();
    }

    private IClass getType2(Java.SuperclassMethodInvocation scmi) throws CompileException {
        return this.findIMethod(scmi).getReturnType();
    }

    private IClass getType2(Java.NewClassInstance nci) throws CompileException {
        if (nci.iClass == null) {
            nci.iClass = this.getType(nci.type);
        }
        return nci.iClass;
    }

    private IClass getType2(Java.NewAnonymousClassInstance naci) {
        return this.resolve(naci.anonymousClassDeclaration);
    }

    private IClass getType2(Java.ParameterAccess pa) throws CompileException {
        return this.getLocalVariable((Java.FunctionDeclarator.FormalParameter)pa.formalParameter).type;
    }

    private IClass getType2(Java.NewArray na) throws CompileException {
        IClass res = this.getType(na.type);
        return res.getArrayIClass(na.dimExprs.length + na.dims, this.iClassLoader.TYPE_java_lang_Object);
    }

    private IClass getType2(Java.NewInitializedArray nia) throws CompileException {
        return nia.arrayType == null ? nia.arrayIClass : this.getType(nia.arrayType);
    }

    private IClass getType2(Java.IntegerLiteral il) {
        String v = il.value;
        char lastChar = v.charAt(v.length() - 1);
        return lastChar == 'l' || lastChar == 'L' ? IClass.LONG : IClass.INT;
    }

    private IClass getType2(Java.FloatingPointLiteral fpl) {
        String v = fpl.value;
        char lastChar = v.charAt(v.length() - 1);
        return lastChar == 'f' || lastChar == 'F' ? IClass.FLOAT : IClass.DOUBLE;
    }

    private IClass getType2(Java.BooleanLiteral bl) {
        return IClass.BOOLEAN;
    }

    private IClass getType2(Java.CharacterLiteral cl) {
        return IClass.CHAR;
    }

    private IClass getType2(Java.StringLiteral sl) {
        return this.iClassLoader.TYPE_java_lang_String;
    }

    private IClass getType2(Java.NullLiteral nl) {
        return IClass.VOID;
    }

    private IClass getType2(Java.SimpleConstant sl) {
        Object v = sl.value;
        if (v instanceof Byte) {
            return IClass.BYTE;
        }
        if (v instanceof Short) {
            return IClass.SHORT;
        }
        if (v instanceof Integer) {
            return IClass.INT;
        }
        if (v instanceof Long) {
            return IClass.LONG;
        }
        if (v instanceof Float) {
            return IClass.FLOAT;
        }
        if (v instanceof Double) {
            return IClass.DOUBLE;
        }
        if (v instanceof Boolean) {
            return IClass.BOOLEAN;
        }
        if (v instanceof Character) {
            return IClass.CHAR;
        }
        if (v instanceof String) {
            return this.iClassLoader.TYPE_java_lang_String;
        }
        if (v == null) {
            return IClass.VOID;
        }
        throw new JaninoRuntimeException("Invalid SimpleLiteral value type '" + v.getClass() + "'");
    }

    private boolean isType(Java.Atom a) throws CompileException {
        final boolean[] res = new boolean[1];
        Visitor.AtomVisitor av = new Visitor.AtomVisitor(){

            @Override
            public void visitPackage(Java.Package p) {
                res[0] = UnitCompiler.this.isType2(p);
            }

            @Override
            public void visitArrayType(Java.ArrayType at) {
                res[0] = UnitCompiler.this.isType2(at);
            }

            @Override
            public void visitBasicType(Java.BasicType bt) {
                res[0] = UnitCompiler.this.isType2(bt);
            }

            @Override
            public void visitReferenceType(Java.ReferenceType rt) {
                res[0] = UnitCompiler.this.isType2(rt);
            }

            @Override
            public void visitRvalueMemberType(Java.RvalueMemberType rmt) {
                res[0] = UnitCompiler.this.isType2(rmt);
            }

            @Override
            public void visitSimpleType(Java.SimpleType st) {
                res[0] = UnitCompiler.this.isType2(st);
            }

            @Override
            public void visitArrayLength(Java.ArrayLength al) {
                res[0] = UnitCompiler.this.isType2(al);
            }

            @Override
            public void visitAssignment(Java.Assignment a) {
                res[0] = UnitCompiler.this.isType2(a);
            }

            @Override
            public void visitUnaryOperation(Java.UnaryOperation uo) {
                res[0] = UnitCompiler.this.isType2(uo);
            }

            @Override
            public void visitBinaryOperation(Java.BinaryOperation bo) {
                res[0] = UnitCompiler.this.isType2(bo);
            }

            @Override
            public void visitCast(Java.Cast c) {
                res[0] = UnitCompiler.this.isType2(c);
            }

            @Override
            public void visitClassLiteral(Java.ClassLiteral cl) {
                res[0] = UnitCompiler.this.isType2(cl);
            }

            @Override
            public void visitConditionalExpression(Java.ConditionalExpression ce) {
                res[0] = UnitCompiler.this.isType2(ce);
            }

            @Override
            public void visitCrement(Java.Crement c) {
                res[0] = UnitCompiler.this.isType2(c);
            }

            @Override
            public void visitInstanceof(Java.Instanceof io) {
                res[0] = UnitCompiler.this.isType2(io);
            }

            @Override
            public void visitMethodInvocation(Java.MethodInvocation mi) {
                res[0] = UnitCompiler.this.isType2(mi);
            }

            @Override
            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                res[0] = UnitCompiler.this.isType2(smi);
            }

            @Override
            public void visitIntegerLiteral(Java.IntegerLiteral il) {
                res[0] = UnitCompiler.this.isType2(il);
            }

            @Override
            public void visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) {
                res[0] = UnitCompiler.this.isType2(fpl);
            }

            @Override
            public void visitBooleanLiteral(Java.BooleanLiteral bl) {
                res[0] = UnitCompiler.this.isType2(bl);
            }

            @Override
            public void visitCharacterLiteral(Java.CharacterLiteral cl) {
                res[0] = UnitCompiler.this.isType2(cl);
            }

            @Override
            public void visitStringLiteral(Java.StringLiteral sl) {
                res[0] = UnitCompiler.this.isType2(sl);
            }

            @Override
            public void visitNullLiteral(Java.NullLiteral nl) {
                res[0] = UnitCompiler.this.isType2(nl);
            }

            @Override
            public void visitSimpleConstant(Java.SimpleConstant sl) {
                res[0] = UnitCompiler.this.isType2(sl);
            }

            @Override
            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                res[0] = UnitCompiler.this.isType2(naci);
            }

            @Override
            public void visitNewArray(Java.NewArray na) {
                res[0] = UnitCompiler.this.isType2(na);
            }

            @Override
            public void visitNewInitializedArray(Java.NewInitializedArray nia) {
                res[0] = UnitCompiler.this.isType2(nia);
            }

            @Override
            public void visitNewClassInstance(Java.NewClassInstance nci) {
                res[0] = UnitCompiler.this.isType2(nci);
            }

            @Override
            public void visitParameterAccess(Java.ParameterAccess pa) {
                res[0] = UnitCompiler.this.isType2(pa);
            }

            @Override
            public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                res[0] = UnitCompiler.this.isType2(qtr);
            }

            @Override
            public void visitThisReference(Java.ThisReference tr) {
                res[0] = UnitCompiler.this.isType2(tr);
            }

            @Override
            public void visitAmbiguousName(Java.AmbiguousName an) {
                try {
                    res[0] = UnitCompiler.this.isType2(an);
                }
                catch (CompileException e) {
                    throw new UncheckedCompileException(e);
                }
            }

            @Override
            public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                res[0] = UnitCompiler.this.isType2(aae);
            }

            @Override
            public void visitFieldAccess(Java.FieldAccess fa) {
                res[0] = UnitCompiler.this.isType2(fa);
            }

            @Override
            public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                res[0] = UnitCompiler.this.isType2(fae);
            }

            @Override
            public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                res[0] = UnitCompiler.this.isType2(scfae);
            }

            @Override
            public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                res[0] = UnitCompiler.this.isType2(lva);
            }

            @Override
            public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                res[0] = UnitCompiler.this.isType2(pe);
            }
        };
        try {
            a.accept(av);
            return res[0];
        }
        catch (UncheckedCompileException uce) {
            throw uce.compileException;
        }
    }

    private boolean isType2(Java.Atom a) {
        return a instanceof Java.Type;
    }

    private boolean isType2(Java.AmbiguousName an) throws CompileException {
        return this.isType(this.reclassify(an));
    }

    private boolean isAccessible(IClass.IMember member, Java.Scope contextScope) throws CompileException {
        IClass declaringIClass = member.getDeclaringIClass();
        boolean acc = this.isAccessible(declaringIClass, contextScope);
        acc = acc && this.isAccessible(declaringIClass, member.getAccess(), contextScope);
        return acc;
    }

    private void checkAccessible(IClass.IMember member, Java.BlockStatement contextBlockStatement) throws CompileException {
        IClass declaringIClass = member.getDeclaringIClass();
        this.checkAccessible(declaringIClass, contextBlockStatement);
        this.checkAccessible(declaringIClass, member.getAccess(), contextBlockStatement);
    }

    private boolean isAccessible(IClass iClassDeclaringMember, Access memberAccess, Java.Scope contextScope) throws CompileException {
        return null == this.internalCheckAccessible(iClassDeclaringMember, memberAccess, contextScope);
    }

    private void checkAccessible(IClass iClassDeclaringMember, Access memberAccess, Java.BlockStatement contextBlockStatement) throws CompileException {
        String message = this.internalCheckAccessible(iClassDeclaringMember, memberAccess, contextBlockStatement);
        if (message != null) {
            this.compileError(message, contextBlockStatement.getLocation());
        }
    }

    private String internalCheckAccessible(IClass iClassDeclaringMember, Access memberAccess, Java.Scope contextScope) throws CompileException {
        if (memberAccess == Access.PUBLIC) {
            return null;
        }
        Java.Scope s2 = contextScope;
        while (true) {
            if (s2 instanceof Java.TypeDeclaration) break;
            s2 = s2.getEnclosingScope();
        }
        IClass iClassDeclaringContextBlockStatement = this.resolve((Java.TypeDeclaration)s2);
        if (iClassDeclaringContextBlockStatement == iClassDeclaringMember) {
            return null;
        }
        IClass topLevelIClassEnclosingMember = iClassDeclaringMember;
        for (IClass c = iClassDeclaringMember.getDeclaringIClass(); c != null; c = c.getDeclaringIClass()) {
            topLevelIClassEnclosingMember = c;
        }
        IClass topLevelIClassEnclosingContextBlockStatement = iClassDeclaringContextBlockStatement;
        for (IClass c = iClassDeclaringContextBlockStatement.getDeclaringIClass(); c != null; c = c.getDeclaringIClass()) {
            topLevelIClassEnclosingContextBlockStatement = c;
        }
        if (topLevelIClassEnclosingMember == topLevelIClassEnclosingContextBlockStatement) {
            return null;
        }
        if (memberAccess == Access.PRIVATE) {
            return "Private member cannot be accessed from type \"" + iClassDeclaringContextBlockStatement + "\".";
        }
        if (Descriptor.areInSamePackage(iClassDeclaringMember.getDescriptor(), iClassDeclaringContextBlockStatement.getDescriptor())) {
            return null;
        }
        if (memberAccess == Access.DEFAULT) {
            return "Member with \"" + memberAccess + "\" access cannot be accessed from type \"" + iClassDeclaringContextBlockStatement + "\".";
        }
        IClass parentClass = iClassDeclaringContextBlockStatement;
        do {
            if (!iClassDeclaringMember.isAssignableFrom(parentClass)) continue;
            return null;
        } while ((parentClass = parentClass.getOuterIClass()) != null);
        return "Protected member cannot be accessed from type \"" + iClassDeclaringContextBlockStatement + "\", which is neither declared in the same package as nor is a subclass of \"" + iClassDeclaringMember + "\".";
    }

    private boolean isAccessible(IClass type, Java.Scope contextScope) throws CompileException {
        return null == this.internalCheckAccessible(type, contextScope);
    }

    private void checkAccessible(IClass type, Java.BlockStatement contextBlockStatement) throws CompileException {
        String message = this.internalCheckAccessible(type, contextBlockStatement);
        if (message != null) {
            this.compileError(message, contextBlockStatement.getLocation());
        }
    }

    private String internalCheckAccessible(IClass type, Java.Scope contextScope) throws CompileException {
        IClass iClassDeclaringType = type.getDeclaringIClass();
        if (iClassDeclaringType == null) {
            if (type.getAccess() == Access.PUBLIC) {
                return null;
            }
            if (type.getAccess() == Access.DEFAULT) {
                Java.Scope s2 = contextScope;
                while (true) {
                    if (s2 instanceof Java.TypeDeclaration) break;
                    s2 = s2.getEnclosingScope();
                }
                IClass iClassDeclaringContextBlockStatement = this.resolve((Java.TypeDeclaration)s2);
                String packageDeclaringType = Descriptor.getPackageName(type.getDescriptor());
                String contextPackage = Descriptor.getPackageName(iClassDeclaringContextBlockStatement.getDescriptor());
                if (packageDeclaringType == null ? contextPackage != null : !packageDeclaringType.equals(contextPackage)) {
                    return "\"" + type + "\" is inaccessible from this package";
                }
                return null;
            }
            throw new JaninoRuntimeException("\"" + type + "\" has unexpected access \"" + type.getAccess() + "\"");
        }
        return this.internalCheckAccessible(iClassDeclaringType, type.getAccess(), contextScope);
    }

    private Java.Type toTypeOrCompileException(Java.Atom a) throws CompileException {
        Java.Type result2 = a.toType();
        if (result2 == null) {
            this.compileError("Expression \"" + a.toString() + "\" is not a type", a.getLocation());
            return new Java.SimpleType(a.getLocation(), this.iClassLoader.TYPE_java_lang_Object);
        }
        return result2;
    }

    private Java.Rvalue toRvalueOrCompileException(Java.Atom a) throws CompileException {
        Java.Rvalue result2 = a.toRvalue();
        if (result2 == null) {
            this.compileError("Expression \"" + a.toString() + "\" is not an rvalue", a.getLocation());
            return new Java.StringLiteral(a.getLocation(), "\"X\"");
        }
        return result2;
    }

    private Java.Lvalue toLvalueOrCompileException(final Java.Atom a) throws CompileException {
        Java.Lvalue result2 = a.toLvalue();
        if (result2 == null) {
            this.compileError("Expression \"" + a.toString() + "\" is not an lvalue", a.getLocation());
            return new Java.Lvalue(a.getLocation()){

                @Override
                public String toString() {
                    return a.toString();
                }

                @Override
                public void accept(Visitor.AtomVisitor visitor) {
                }

                @Override
                public void accept(Visitor.RvalueVisitor visitor) {
                }

                @Override
                public void accept(Visitor.LvalueVisitor visitor) {
                }

                @Override
                public void accept(Visitor.ElementValueVisitor visitor) {
                }
            };
        }
        return result2;
    }

    void assignSyntheticParametersToSyntheticFields(Java.ConstructorDeclarator cd) throws CompileException {
        for (IClass.IField sf : cd.getDeclaringClass().syntheticFields.values()) {
            Java.LocalVariable syntheticParameter = cd.syntheticParameters.get(sf.getName());
            if (syntheticParameter == null) {
                throw new JaninoRuntimeException("SNO: Synthetic parameter for synthetic field \"" + sf.getName() + "\" not found");
            }
            Java.ExpressionStatement es = new Java.ExpressionStatement(new Java.Assignment(cd.getLocation(), new Java.FieldAccess(cd.getLocation(), new Java.ThisReference(cd.getLocation()), sf), "=", new Java.LocalVariableAccess(cd.getLocation(), syntheticParameter)));
            es.setEnclosingScope(cd);
            this.compile(es);
        }
    }

    void initializeInstanceVariablesAndInvokeInstanceInitializers(Java.ConstructorDeclarator cd) throws CompileException {
        List<Java.BlockStatement> vdai = cd.getDeclaringClass().variableDeclaratorsAndInitializers;
        for (int i = 0; i < vdai.size(); ++i) {
            Java.BlockStatement bs = vdai.get(i);
            if (((Java.TypeBodyDeclaration)((Object)bs)).isStatic() || this.compile(bs)) continue;
            this.compileError("Instance variable declarator or instance initializer does not complete normally", bs.getLocation());
        }
    }

    private void leaveStatements(Java.Scope from2, Java.Scope to2, IClass optionalStackValueType) {
        for (Java.Scope s2 = from2; s2 != to2; s2 = s2.getEnclosingScope()) {
            if (!(s2 instanceof Java.BlockStatement)) continue;
            this.leave((Java.BlockStatement)s2, optionalStackValueType);
        }
    }

    private IClass compileArithmeticBinaryOperation(Java.Locatable locatable, IClass lhsType, String operator, Java.Rvalue rhs) throws CompileException {
        return this.compileArithmeticOperation(locatable, lhsType, Arrays.asList(rhs).iterator(), operator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClass compileArithmeticOperation(Java.Locatable locatable, IClass type, Iterator<Java.Rvalue> operands, String operator) throws CompileException {
        if (operator == "|" || operator == "^" || operator == "&") {
            int iopcode = operator == "&" ? 126 : (operator == "|" ? -128 : (operator == "^" ? -126 : Integer.MAX_VALUE));
            do {
                Java.Rvalue operand = operands.next();
                if (type == null) {
                    type = this.compileGetValue(operand);
                    continue;
                }
                CodeContext.Inserter convertLhsInserter = this.codeContext.newInserter();
                IClass rhsType = this.compileGetValue(operand);
                if (type.isPrimitiveNumeric() && rhsType.isPrimitiveNumeric()) {
                    IClass promotedType = this.binaryNumericPromotion(locatable, type, convertLhsInserter, rhsType);
                    if (promotedType == IClass.INT) {
                        this.writeOpcode(locatable, iopcode);
                    } else if (promotedType == IClass.LONG) {
                        this.writeOpcode(locatable, iopcode + 1);
                    } else {
                        this.compileError("Operator \"" + operator + "\" not defined on types \"" + type + "\" and \"" + rhsType + "\"", locatable.getLocation());
                    }
                    type = promotedType;
                    continue;
                }
                if (!(type != IClass.BOOLEAN && this.getUnboxedType(type) != IClass.BOOLEAN || rhsType != IClass.BOOLEAN && this.getUnboxedType(rhsType) != IClass.BOOLEAN)) {
                    IClassLoader icl = this.iClassLoader;
                    if (type == icl.TYPE_java_lang_Boolean) {
                        this.codeContext.pushInserter(convertLhsInserter);
                        try {
                            this.unboxingConversion(locatable, icl.TYPE_java_lang_Boolean, IClass.BOOLEAN);
                        }
                        finally {
                            this.codeContext.popInserter();
                        }
                    }
                    if (rhsType == icl.TYPE_java_lang_Boolean) {
                        this.unboxingConversion(locatable, icl.TYPE_java_lang_Boolean, IClass.BOOLEAN);
                    }
                    this.writeOpcode(locatable, iopcode);
                    type = IClass.BOOLEAN;
                    continue;
                }
                this.compileError("Operator \"" + operator + "\" not defined on types \"" + type + "\" and \"" + rhsType + "\"", locatable.getLocation());
                type = IClass.INT;
            } while (operands.hasNext());
            return type;
        }
        if (operator == "*" || operator == "/" || operator == "%" || operator == "+" || operator == "-") {
            int iopcode = operator == "*" ? 104 : (operator == "/" ? 108 : (operator == "%" ? 112 : (operator == "+" ? 96 : (operator == "-" ? 100 : Integer.MAX_VALUE))));
            do {
                int opcode;
                IClass rhsType;
                Java.Rvalue operand = operands.next();
                IClass operandType = this.getType(operand);
                IClassLoader icl = this.iClassLoader;
                if (operator == "+" && (type == icl.TYPE_java_lang_String || operandType == icl.TYPE_java_lang_String)) {
                    return this.compileStringConcatenation(locatable, type, operand, operands);
                }
                if (type == null) {
                    type = this.compileGetValue(operand);
                    continue;
                }
                CodeContext.Inserter convertLhsInserter = this.codeContext.newInserter();
                if ((type = this.binaryNumericPromotion(locatable, type, convertLhsInserter, rhsType = this.compileGetValue(operand))) == IClass.INT) {
                    opcode = iopcode;
                } else if (type == IClass.LONG) {
                    opcode = iopcode + 1;
                } else if (type == IClass.FLOAT) {
                    opcode = iopcode + 2;
                } else if (type == IClass.DOUBLE) {
                    opcode = iopcode + 3;
                } else {
                    this.compileError("Unexpected promoted type \"" + type + "\"", locatable.getLocation());
                    opcode = iopcode;
                }
                this.writeOpcode(locatable, opcode);
            } while (operands.hasNext());
            return type;
        }
        if (operator == "<<" || operator == ">>" || operator == ">>>") {
            int iopcode = operator == "<<" ? 120 : (operator == ">>" ? 122 : (operator == ">>>" ? 124 : Integer.MAX_VALUE));
            do {
                IClass promotedRhsType;
                IClass promotedLhsType;
                Java.Rvalue operand = operands.next();
                if (type == null) {
                    type = this.compileGetValue(operand);
                    continue;
                }
                CodeContext.Inserter convertLhsInserter = this.codeContext.newInserter();
                IClass rhsType = this.compileGetValue(operand);
                this.codeContext.pushInserter(convertLhsInserter);
                try {
                    promotedLhsType = this.unaryNumericPromotion(locatable, type);
                }
                finally {
                    this.codeContext.popInserter();
                }
                if (promotedLhsType != IClass.INT && promotedLhsType != IClass.LONG) {
                    this.compileError("Shift operation not allowed on operand type \"" + type + "\"", locatable.getLocation());
                }
                if ((promotedRhsType = this.unaryNumericPromotion(locatable, rhsType)) != IClass.INT && promotedRhsType != IClass.LONG) {
                    this.compileError("Shift distance of type \"" + rhsType + "\" is not allowed", locatable.getLocation());
                }
                if (promotedRhsType == IClass.LONG) {
                    this.writeOpcode(locatable, -120);
                }
                this.writeOpcode(locatable, promotedLhsType == IClass.LONG ? iopcode + 1 : iopcode);
                type = promotedLhsType;
            } while (operands.hasNext());
            return type;
        }
        throw new JaninoRuntimeException("Unexpected operator \"" + operator + "\"");
    }

    private IClass compileStringConcatenation(final Java.Locatable locatable, IClass type, Java.Rvalue operand, Iterator<Java.Rvalue> operands) throws CompileException {
        boolean operandOnStack;
        if (type != null) {
            this.stringConversion(locatable, type);
            operandOnStack = true;
        } else {
            operandOnStack = false;
        }
        ArrayList<Compilable> tmp = new ArrayList<Compilable>();
        do {
            String[] ss;
            Object cv;
            if ((cv = this.getConstantValue(operand)) == NOT_CONSTANT) {
                final Java.Rvalue finalOperand = operand;
                tmp.add(new Compilable(){

                    @Override
                    public void compile() throws CompileException {
                        UnitCompiler.this.stringConversion(locatable, UnitCompiler.this.compileGetValue(finalOperand));
                    }
                });
                operand = operands.hasNext() ? operands.next() : null;
                continue;
            }
            if (operands.hasNext()) {
                operand = operands.next();
                Object cv2 = this.getConstantValue(operand);
                if (cv2 != NOT_CONSTANT) {
                    StringBuilder sb = new StringBuilder(cv.toString()).append(cv2);
                    while (true) {
                        if (!operands.hasNext()) {
                            operand = null;
                            break;
                        }
                        operand = operands.next();
                        Object cv3 = this.getConstantValue(operand);
                        if (cv3 == NOT_CONSTANT) break;
                        sb.append(cv3);
                    }
                    cv = sb.toString();
                }
            } else {
                operand = null;
            }
            for (final String s2 : ss = UnitCompiler.makeUtf8Able(cv.toString())) {
                tmp.add(new Compilable(){

                    @Override
                    public void compile() throws CompileException {
                        UnitCompiler.this.pushConstant(locatable, s2);
                    }
                });
            }
        } while (operand != null);
        if (tmp.size() <= (operandOnStack ? 2 : 3)) {
            for (Compilable c : tmp) {
                c.compile();
                if (operandOnStack) {
                    this.invoke(locatable, this.iClassLoader.METH_java_lang_String__concat__java_lang_String);
                    continue;
                }
                operandOnStack = true;
            }
            return this.iClassLoader.TYPE_java_lang_String;
        }
        Iterator it = tmp.iterator();
        if (operandOnStack) {
            this.writeOpcode(locatable, -69);
            this.writeConstantClassInfo("Ljava/lang/StringBuilder;");
            this.writeOpcode(locatable, 90);
            this.writeOpcode(locatable, 95);
        } else {
            this.writeOpcode(locatable, -69);
            this.writeConstantClassInfo("Ljava/lang/StringBuilder;");
            this.writeOpcode(locatable, 89);
            ((Compilable)it.next()).compile();
        }
        this.invoke(locatable, this.iClassLoader.CTOR_java_lang_StringBuilder__java_lang_String);
        while (it.hasNext()) {
            ((Compilable)it.next()).compile();
            this.invoke(locatable, this.iClassLoader.METH_java_lang_StringBuilder__append__java_lang_String);
        }
        this.invoke(locatable, this.iClassLoader.METH_java_lang_StringBuilder__toString);
        return this.iClassLoader.TYPE_java_lang_String;
    }

    private void stringConversion(Java.Locatable locatable, IClass sourceType) throws CompileException {
        this.invoke(locatable, sourceType == IClass.BYTE ? this.iClassLoader.METH_java_lang_String__valueOf__int : (sourceType == IClass.SHORT ? this.iClassLoader.METH_java_lang_String__valueOf__int : (sourceType == IClass.INT ? this.iClassLoader.METH_java_lang_String__valueOf__int : (sourceType == IClass.LONG ? this.iClassLoader.METH_java_lang_String__valueOf__long : (sourceType == IClass.FLOAT ? this.iClassLoader.METH_java_lang_String__valueOf__float : (sourceType == IClass.DOUBLE ? this.iClassLoader.METH_java_lang_String__valueOf__double : (sourceType == IClass.CHAR ? this.iClassLoader.METH_java_lang_String__valueOf__char : (sourceType == IClass.BOOLEAN ? this.iClassLoader.METH_java_lang_String__valueOf__boolean : this.iClassLoader.METH_java_lang_String__valueOf__java_lang_Object))))))));
    }

    private void invokeConstructor(Java.Locatable locatable, Java.Scope scope, Java.Rvalue optionalEnclosingInstance, IClass targetClass, Java.Rvalue[] arguments) throws CompileException {
        IClass eiic;
        IClass outerIClass;
        IClass[] thrownExceptions;
        IClass.IInvocable[] iConstructors = targetClass.getDeclaredIConstructors();
        if (iConstructors.length == 0) {
            throw new JaninoRuntimeException("SNO: Target class \"" + targetClass.getDescriptor() + "\" has no constructors");
        }
        IClass.IConstructor iConstructor = (IClass.IConstructor)this.findMostSpecificIInvocable(locatable, iConstructors, arguments, scope);
        for (IClass te : thrownExceptions = iConstructor.getThrownExceptions()) {
            this.checkThrownException(locatable, te, scope);
        }
        if (optionalEnclosingInstance != null && (outerIClass = targetClass.getOuterIClass()) != null && !outerIClass.isAssignableFrom(eiic = this.compileGetValue(optionalEnclosingInstance))) {
            this.compileError("Type of enclosing instance (\"" + eiic + "\") is not assignable to \"" + outerIClass + "\"", locatable.getLocation());
        }
        IClass.IField[] syntheticFields = targetClass.getSyntheticIFields();
        Java.Scope s2 = scope;
        while (!(s2 instanceof Java.TypeBodyDeclaration)) {
            s2 = s2.getEnclosingScope();
        }
        Java.TypeBodyDeclaration scopeTbd = (Java.TypeBodyDeclaration)s2;
        Java.TypeDeclaration scopeTypeDeclaration = scopeTbd.getDeclaringType();
        if (!(scopeTypeDeclaration instanceof Java.ClassDeclaration)) {
            if (syntheticFields.length > 0) {
                throw new JaninoRuntimeException("SNO: Target class has synthetic fields");
            }
            return;
        }
        Java.ClassDeclaration scopeClassDeclaration = (Java.ClassDeclaration)scopeTypeDeclaration;
        for (IClass.IField sf : syntheticFields) {
            Java.LocalVariable lv;
            block22: {
                if (!sf.getName().startsWith("val$")) continue;
                IClass.IField eisf = (IClass.IField)scopeClassDeclaration.syntheticFields.get(sf.getName());
                if (eisf != null) {
                    if (scopeTbd instanceof Java.MethodDeclarator) {
                        this.load(locatable, this.resolve(scopeClassDeclaration), 0);
                        this.getfield(locatable, eisf);
                        continue;
                    }
                    if (scopeTbd instanceof Java.ConstructorDeclarator) {
                        Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)scopeTbd;
                        Java.LocalVariable syntheticParameter = constructorDeclarator.syntheticParameters.get(sf.getName());
                        if (syntheticParameter == null) {
                            this.compileError("Compiler limitation: Constructor cannot access local variable \"" + sf.getName().substring(4) + "\" declared in an enclosing block because none of the methods accesses it. " + "As a workaround, declare a dummy method that accesses the local variable.", locatable.getLocation());
                            this.writeOpcode(locatable, 1);
                            continue;
                        }
                        this.load(locatable, syntheticParameter);
                        continue;
                    }
                    if (scopeTbd instanceof Java.FieldDeclaration) {
                        this.compileError("Compiler limitation: Field initializers cannot access local variable \"" + sf.getName().substring(4) + "\" declared in an enclosing block because none of the methods accesses it. " + "As a workaround, declare a dummy method that accesses the local variable.", locatable.getLocation());
                        this.writeOpcode(scopeTbd, 1);
                        continue;
                    }
                    throw new AssertionError(scopeTbd);
                }
                String localVariableName = sf.getName().substring(4);
                Java.Scope s3 = scope;
                while (s3 instanceof Java.BlockStatement) {
                    block26: {
                        List<Java.BlockStatement> statements;
                        Java.BlockStatement bs;
                        block24: {
                            Java.Scope es;
                            block25: {
                                block23: {
                                    bs = (Java.BlockStatement)s3;
                                    es = bs.getEnclosingScope();
                                    if (!(es instanceof Java.Block)) break block23;
                                    statements = ((Java.Block)es).statements;
                                    break block24;
                                }
                                if (!(es instanceof Java.FunctionDeclarator)) break block25;
                                statements = ((Java.FunctionDeclarator)es).optionalStatements;
                                break block24;
                            }
                            if (!(es instanceof Java.ForEachStatement)) break block26;
                            Java.FunctionDeclarator.FormalParameter fp = ((Java.ForEachStatement)es).currentElement;
                            if (fp.name.equals(localVariableName)) {
                                lv = this.getLocalVariable(fp);
                                break block22;
                            }
                            break block26;
                        }
                        for (Java.BlockStatement bs2 : statements) {
                            if (bs2 == bs) break;
                            if (!(bs2 instanceof Java.LocalVariableDeclarationStatement)) continue;
                            Java.LocalVariableDeclarationStatement lvds = (Java.LocalVariableDeclarationStatement)bs2;
                            for (Java.VariableDeclarator vd : lvds.variableDeclarators) {
                                if (!vd.name.equals(localVariableName)) continue;
                                lv = this.getLocalVariable(lvds, vd);
                                break block22;
                            }
                        }
                    }
                    s3 = s3.getEnclosingScope();
                }
                while (!(s3 instanceof Java.FunctionDeclarator)) {
                    s3 = s3.getEnclosingScope();
                }
                Java.FunctionDeclarator fd = (Java.FunctionDeclarator)s3;
                for (Java.FunctionDeclarator.FormalParameter fp : fd.formalParameters.parameters) {
                    if (!fp.name.equals(localVariableName)) continue;
                    lv = this.getLocalVariable(fp);
                    break block22;
                }
                throw new JaninoRuntimeException("SNO: Synthetic field \"" + sf.getName() + "\" neither maps a synthetic field of an enclosing instance nor a local variable");
            }
            this.load(locatable, lv);
        }
        Java.Rvalue[] adjustedArgs = null;
        IClass[] parameterTypes = iConstructor.getParameterTypes();
        int actualSize = arguments.length;
        if (iConstructor.isVarargs() && iConstructor.argsNeedAdjust()) {
            adjustedArgs = new Java.Rvalue[parameterTypes.length];
            Java.ArrayInitializerOrRvalue[] lastArgs = new Java.Rvalue[actualSize - parameterTypes.length + 1];
            int i = 0;
            int j = parameterTypes.length - 1;
            while (i < lastArgs.length) {
                lastArgs[i] = arguments[j];
                ++i;
                ++j;
            }
            for (i = parameterTypes.length - 2; i >= 0; --i) {
                adjustedArgs[i] = arguments[i];
            }
            Location loc = (lastArgs.length == 0 ? locatable : lastArgs[lastArgs.length - 1]).getLocation();
            adjustedArgs[adjustedArgs.length - 1] = new Java.NewInitializedArray(loc, parameterTypes[parameterTypes.length - 1], new Java.ArrayInitializer(loc, lastArgs));
            arguments = adjustedArgs;
        }
        for (int i = 0; i < arguments.length; ++i) {
            this.assignmentConversion(locatable, this.compileGetValue(arguments[i]), parameterTypes[i], this.getConstantValue(arguments[i]));
        }
        this.invoke(locatable, iConstructor);
    }

    private IClass.IField[] getIFields(final Java.FieldDeclaration fieldDeclaration) {
        IClass.IField[] res = new IClass.IField[fieldDeclaration.variableDeclarators.length];
        for (int i = 0; i < res.length; ++i) {
            final Java.VariableDeclarator variableDeclarator = fieldDeclaration.variableDeclarators[i];
            IClass iClass = this.resolve(fieldDeclaration.getDeclaringType());
            iClass.getClass();
            res[i] = new IClass.IField(iClass){

                @Override
                public Access getAccess() {
                    switch (fieldDeclaration.modifiers.flags & 7) {
                        case 2: {
                            return Access.PRIVATE;
                        }
                        case 4: {
                            return Access.PROTECTED;
                        }
                        case 0: {
                            return Access.DEFAULT;
                        }
                        case 1: {
                            return Access.PUBLIC;
                        }
                    }
                    throw new JaninoRuntimeException("Invalid access");
                }

                @Override
                public Java.Annotation[] getAnnotations() {
                    return fieldDeclaration.modifiers.annotations;
                }

                @Override
                public boolean isStatic() {
                    return Mod.isStatic(fieldDeclaration.modifiers.flags);
                }

                @Override
                public IClass getType() throws CompileException {
                    return UnitCompiler.this.getType(fieldDeclaration.type).getArrayIClass(variableDeclarator.brackets, ((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Object);
                }

                @Override
                public String getName() {
                    return variableDeclarator.name;
                }

                @Override
                public Object getConstantValue() throws CompileException {
                    Object constantInitializerValue;
                    if (Mod.isFinal(fieldDeclaration.modifiers.flags) && variableDeclarator.optionalInitializer instanceof Java.Rvalue && (constantInitializerValue = UnitCompiler.this.getConstantValue((Java.Rvalue)variableDeclarator.optionalInitializer)) != NOT_CONSTANT) {
                        return UnitCompiler.this.assignmentConversion(variableDeclarator.optionalInitializer, constantInitializerValue, this.getType());
                    }
                    return NOT_CONSTANT;
                }
            };
        }
        return res;
    }

    Java.ArrayInitializerOrRvalue getNonConstantFinalInitializer(Java.FieldDeclaration fd, Java.VariableDeclarator vd) throws CompileException {
        if (vd.optionalInitializer == null) {
            return null;
        }
        if (Mod.isStatic(fd.modifiers.flags) && Mod.isFinal(fd.modifiers.flags) && vd.optionalInitializer instanceof Java.Rvalue && this.getConstantValue((Java.Rvalue)vd.optionalInitializer) != NOT_CONSTANT) {
            return null;
        }
        return vd.optionalInitializer;
    }

    private Java.Atom reclassify(Java.AmbiguousName an) throws CompileException {
        if (an.reclassified == null) {
            an.reclassified = this.reclassifyName(an.getLocation(), an.getEnclosingBlockStatement(), an.identifiers, an.n);
        }
        return an.reclassified;
    }

    private Java.Atom reclassifyName(Location location, Java.Scope scope, final String[] identifiers, int n) throws CompileException {
        IClass[] classes2;
        if (n == 1) {
            return this.reclassifyName(location, scope, identifiers[0]);
        }
        Java.Atom lhs = this.reclassifyName(location, scope, identifiers, n - 1);
        String rhs = identifiers[n - 1];
        if (lhs instanceof Java.Package) {
            String className = ((Java.Package)lhs).name + '.' + rhs;
            IClass result2 = this.findTypeByName(location, className);
            if (result2 != null) {
                return new Java.SimpleType(location, result2);
            }
            return new Java.Package(location, className);
        }
        if ("length".equals(rhs) && this.getType(lhs).isArray()) {
            Java.ArrayLength al = new Java.ArrayLength(location, this.toRvalueOrCompileException(lhs));
            if (!(scope instanceof Java.BlockStatement)) {
                this.compileError("\".length\" only allowed in expression context");
                return al;
            }
            al.setEnclosingBlockStatement((Java.BlockStatement)scope);
            return al;
        }
        IClass lhsType = this.getType(lhs);
        IClass.IField field2 = this.findIField(lhsType, rhs, location);
        if (field2 != null) {
            Java.FieldAccess fa = new Java.FieldAccess(location, lhs, field2);
            fa.setEnclosingBlockStatement((Java.BlockStatement)scope);
            return fa;
        }
        for (IClass memberType : classes2 = lhsType.getDeclaredIClasses()) {
            String name2 = Descriptor.toClassName(memberType.getDescriptor());
            if (!(name2 = name2.substring(name2.lastIndexOf(36) + 1)).equals(rhs)) continue;
            return new Java.SimpleType(location, memberType);
        }
        this.compileError("\"" + rhs + "\" is neither a method, a field, nor a member class of \"" + lhsType + "\"", location);
        return new Java.Atom(location){

            @Override
            public String toString() {
                return Java.join(identifiers, ".");
            }

            @Override
            public final void accept(Visitor.AtomVisitor visitor) {
            }
        };
    }

    private IClass findTypeByName(Location location, String className) throws CompileException {
        IClass res = this.findClass(className);
        if (res != null) {
            return res;
        }
        try {
            return this.iClassLoader.loadIClass(Descriptor.fromClassName(className));
        }
        catch (ClassNotFoundException ex) {
            if (ex.getException() instanceof CompileException) {
                throw (CompileException)ex.getException();
            }
            throw new CompileException(className, location, ex);
        }
    }

    private Java.Atom reclassifyName(Location location, Java.Scope scope, String identifier2) throws CompileException {
        IClass memberType;
        IClass.IField f2;
        Java.LocalVariable lv;
        Java.BlockStatement scopeBlockStatement = null;
        Java.TypeBodyDeclaration scopeTbd = null;
        Java.AbstractTypeDeclaration scopeTypeDeclaration = null;
        Java.Scope s2 = scope;
        if (s2 instanceof Java.BlockStatement) {
            scopeBlockStatement = (Java.BlockStatement)s2;
        }
        while ((s2 instanceof Java.BlockStatement || s2 instanceof Java.CatchClause) && !(s2 instanceof Java.TypeBodyDeclaration)) {
            s2 = s2.getEnclosingScope();
        }
        if (s2 instanceof Java.TypeBodyDeclaration) {
            scopeTbd = (Java.TypeBodyDeclaration)s2;
            s2 = s2.getEnclosingScope();
        }
        if (s2 instanceof Java.TypeDeclaration) {
            scopeTypeDeclaration = (Java.AbstractTypeDeclaration)s2;
            s2 = s2.getEnclosingScope();
        }
        while (!(s2 instanceof Java.CompilationUnit)) {
            s2 = s2.getEnclosingScope();
        }
        Java.CompilationUnit scopeCompilationUnit = (Java.CompilationUnit)s2;
        s2 = scope;
        if (s2 instanceof Java.BlockStatement) {
            Java.BlockStatement bs = (Java.BlockStatement)s2;
            lv = bs.findLocalVariable(identifier2);
            if (lv != null) {
                Java.LocalVariableAccess lva = new Java.LocalVariableAccess(location, lv);
                lva.setEnclosingBlockStatement(bs);
                return lva;
            }
            s2 = s2.getEnclosingScope();
        }
        while (s2 instanceof Java.BlockStatement || s2 instanceof Java.CatchClause) {
            s2 = s2.getEnclosingScope();
        }
        if (s2 instanceof Java.FunctionDeclarator) {
            s2 = s2.getEnclosingScope();
        }
        if (s2 instanceof Java.InnerClassDeclaration) {
            Java.InnerClassDeclaration icd = (Java.InnerClassDeclaration)s2;
            if ((s2 = s2.getEnclosingScope()) instanceof Java.AnonymousClassDeclaration) {
                s2 = s2.getEnclosingScope();
            } else if (s2 instanceof Java.FieldDeclaration) {
                s2 = s2.getEnclosingScope().getEnclosingScope();
            }
            while (s2 instanceof Java.BlockStatement) {
                lv = ((Java.BlockStatement)s2).findLocalVariable(identifier2);
                if (lv != null) {
                    if (!lv.finaL) {
                        this.compileError("Cannot access non-final local variable \"" + identifier2 + "\" from inner class");
                    }
                    IClass lvType = lv.type;
                    SimpleIField iField = new SimpleIField(this.resolve(icd), "val$" + identifier2, lvType);
                    icd.defineSyntheticField(iField);
                    Java.FieldAccess fa = new Java.FieldAccess(location, new Java.QualifiedThisReference(location, new Java.SimpleType(location, this.resolve(icd))), iField);
                    fa.setEnclosingBlockStatement((Java.BlockStatement)scope);
                    return fa;
                }
                s2 = s2.getEnclosingScope();
                while (s2 instanceof Java.BlockStatement) {
                    s2 = s2.getEnclosingScope();
                }
                if (!(s2 instanceof Java.FunctionDeclarator) || !((s2 = s2.getEnclosingScope()) instanceof Java.InnerClassDeclaration)) break;
                icd = (Java.InnerClassDeclaration)s2;
                s2 = s2.getEnclosingScope();
            }
        }
        Java.BlockStatement enclosingBlockStatement = null;
        Java.Scope s3 = scope;
        while (!(s3 instanceof Java.CompilationUnit)) {
            Java.AbstractTypeDeclaration enclosingTypeDecl;
            IClass etd;
            if (s3 instanceof Java.BlockStatement && enclosingBlockStatement == null) {
                enclosingBlockStatement = (Java.BlockStatement)s3;
            }
            if (s3 instanceof Java.TypeDeclaration && (f2 = this.findIField(etd = this.resolve(enclosingTypeDecl = (Java.AbstractTypeDeclaration)s3), identifier2, location)) != null) {
                if (f2.isStatic()) {
                    this.warning("IASF", "Implicit access to static field \"" + identifier2 + "\" of declaring class (better write \"" + f2.getDeclaringIClass() + '.' + f2.getName() + "\")", location);
                } else if (f2.getDeclaringIClass() == etd) {
                    this.warning("IANSF", "Implicit access to non-static field \"" + identifier2 + "\" of declaring class (better write \"this." + f2.getName() + "\")", location);
                } else {
                    this.warning("IANSFEI", "Implicit access to non-static field \"" + identifier2 + "\" of enclosing instance (better write \"" + f2.getDeclaringIClass() + ".this." + f2.getName() + "\")", location);
                }
                Java.SimpleType ct = new Java.SimpleType(scopeTypeDeclaration.getLocation(), etd);
                Java.Atom lhs = scopeTbd.isStatic() ? ct : (f2.isStatic() ? ct : new Java.QualifiedThisReference(location, ct));
                Java.FieldAccess res = new Java.FieldAccess(location, lhs, f2);
                res.setEnclosingBlockStatement(enclosingBlockStatement);
                return res;
            }
            s3 = s3.getEnclosingScope();
        }
        List<Object> l = this.singleStaticImports.get(identifier2);
        if (l != null) {
            for (Object o : l) {
                if (!(o instanceof IClass.IField)) continue;
                Java.FieldAccess fieldAccess = new Java.FieldAccess(location, new Java.SimpleType(location, ((IClass.IField)o).getDeclaringIClass()), (IClass.IField)o);
                fieldAccess.setEnclosingBlockStatement(enclosingBlockStatement);
                return fieldAccess;
            }
        }
        IClass.IField importedField = null;
        for (IClass iClass : this.staticImportsOnDemand) {
            f2 = iClass.getDeclaredIField(identifier2);
            if (f2 == null || !this.isAccessible(f2, (Java.Scope)enclosingBlockStatement)) continue;
            if (importedField != null) {
                this.compileError("Ambiguous static field import: \"" + importedField.toString() + "\" vs. \"" + f2.toString() + "\"");
            }
            importedField = f2;
        }
        if (importedField != null) {
            if (!importedField.isStatic()) {
                this.compileError("Cannot static-import non-static field");
            }
            Java.FieldAccess fieldAccess = new Java.FieldAccess(location, new Java.SimpleType(location, importedField.getDeclaringIClass()), importedField);
            fieldAccess.setEnclosingBlockStatement(enclosingBlockStatement);
            return fieldAccess;
        }
        if ("java".equals(identifier2)) {
            return new Java.Package(location, identifier2);
        }
        Java.LocalClassDeclaration lcd = UnitCompiler.findLocalClassDeclaration(scope, identifier2);
        if (lcd != null) {
            return new Java.SimpleType(location, this.resolve(lcd));
        }
        if (scopeTypeDeclaration != null && (memberType = this.findMemberType(this.resolve(scopeTypeDeclaration), identifier2, location)) != null) {
            return new Java.SimpleType(location, memberType);
        }
        IClass iClass = this.importSingleType(identifier2, location);
        if (iClass != null) {
            return new Java.SimpleType(location, iClass);
        }
        Java.PackageMemberTypeDeclaration pmtd = scopeCompilationUnit.getPackageMemberTypeDeclaration(identifier2);
        if (pmtd != null) {
            return new Java.SimpleType(location, this.resolve(pmtd));
        }
        String className = scopeCompilationUnit.optionalPackageDeclaration == null ? identifier2 : scopeCompilationUnit.optionalPackageDeclaration.packageName + '.' + identifier2;
        IClass result2 = this.findTypeByName(location, className);
        if (result2 != null) {
            return new Java.SimpleType(location, result2);
        }
        IClass importedClass = this.importTypeOnDemand(identifier2, location);
        if (importedClass != null) {
            return new Java.SimpleType(location, importedClass);
        }
        l = this.singleStaticImports.get(identifier2);
        if (l != null) {
            for (Object o : l) {
                if (!(o instanceof IClass)) continue;
                return new Java.SimpleType(null, (IClass)o);
            }
        }
        IClass importedType = null;
        for (IClass ic : this.staticImportsOnDemand) {
            IClass[] memberTypes2;
            for (IClass memberType2 : memberTypes2 = ic.getDeclaredIClasses()) {
                if (!this.isAccessible(memberType2, (Java.Scope)scopeBlockStatement) || !memberType2.getDescriptor().endsWith('$' + identifier2 + ';')) continue;
                if (importedType != null) {
                    this.compileError("Ambiguous static type import: \"" + importedType.toString() + "\" vs. \"" + memberType2.toString() + "\"");
                }
                importedType = memberType2;
            }
        }
        if (importedType != null) {
            return new Java.SimpleType(null, importedType);
        }
        return new Java.Package(location, identifier2);
    }

    private void determineValue(Java.FieldAccessExpression fae) throws CompileException {
        if (fae.value != null) {
            return;
        }
        IClass lhsType = this.getType(fae.lhs);
        if (fae.fieldName.equals("length") && lhsType.isArray()) {
            fae.value = new Java.ArrayLength(fae.getLocation(), this.toRvalueOrCompileException(fae.lhs));
        } else {
            IClass.IField iField = this.findIField(lhsType, fae.fieldName, fae.getLocation());
            if (iField == null) {
                this.compileError("\"" + this.getType(fae.lhs).toString() + "\" has no field \"" + fae.fieldName + "\"", fae.getLocation());
                fae.value = new Java.Rvalue(fae.getLocation()){

                    @Override
                    public String toString() {
                        return "???";
                    }

                    @Override
                    public void accept(Visitor.AtomVisitor visitor) {
                    }

                    @Override
                    public void accept(Visitor.RvalueVisitor visitor) {
                    }

                    @Override
                    public void accept(Visitor.ElementValueVisitor visitor) {
                    }
                };
                return;
            }
            fae.value = new Java.FieldAccess(fae.getLocation(), fae.lhs, iField);
        }
        fae.value.setEnclosingBlockStatement(fae.getEnclosingBlockStatement());
    }

    private void determineValue(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        if (scfae.value != null) {
            return;
        }
        Java.ThisReference tr = new Java.ThisReference(scfae.getLocation());
        tr.setEnclosingBlockStatement(scfae.getEnclosingBlockStatement());
        IClass type = scfae.optionalQualification != null ? this.getType(scfae.optionalQualification) : this.getType(tr);
        Java.Cast lhs = new Java.Cast(scfae.getLocation(), new Java.SimpleType(scfae.getLocation(), type.getSuperclass()), tr);
        IClass.IField iField = this.findIField(this.getType(lhs), scfae.fieldName, scfae.getLocation());
        if (iField == null) {
            this.compileError("Class has no field \"" + scfae.fieldName + "\"", scfae.getLocation());
            scfae.value = new Java.Rvalue(scfae.getLocation()){

                @Override
                public String toString() {
                    return "???";
                }

                @Override
                public void accept(Visitor.AtomVisitor visitor) {
                }

                @Override
                public void accept(Visitor.RvalueVisitor visitor) {
                }

                @Override
                public void accept(Visitor.ElementValueVisitor visitor) {
                }
            };
            return;
        }
        scfae.value = new Java.FieldAccess(scfae.getLocation(), lhs, iField);
        scfae.value.setEnclosingBlockStatement(scfae.getEnclosingBlockStatement());
    }

    public IClass.IMethod findIMethod(Java.MethodInvocation mi) throws CompileException {
        IClass.IMethod iMethod;
        block11: {
            block14: {
                List<Object> l;
                block13: {
                    block12: {
                        if (mi.optionalTarget != null) break block12;
                        Java.Scope s2 = mi.getEnclosingBlockStatement();
                        while (!(s2 instanceof Java.CompilationUnit)) {
                            Java.TypeDeclaration td;
                            if (!(s2 instanceof Java.TypeDeclaration) || (iMethod = this.findIMethod(this.resolve(td = (Java.TypeDeclaration)s2), mi)) == null) {
                                s2 = s2.getEnclosingScope();
                                continue;
                            }
                            break block11;
                        }
                        break block13;
                    }
                    iMethod = this.findIMethod(this.getType(mi.optionalTarget), mi);
                    if (iMethod != null) break block11;
                }
                if ((l = this.singleStaticImports.get(mi.methodName)) == null) break block14;
                iMethod = null;
                for (Object o : l) {
                    IClass declaringIClass;
                    IClass.IMethod im;
                    if (!(o instanceof IClass.IMethod) || (im = this.findIMethod(declaringIClass = ((IClass.IMethod)o).getDeclaringIClass(), mi)) == null) continue;
                    if (iMethod != null && iMethod != im) {
                        this.compileError("Ambiguous static method import: \"" + iMethod.toString() + "\" vs. \"" + im.toString() + "\"");
                    }
                    iMethod = im;
                }
                if (iMethod != null) break block11;
            }
            iMethod = null;
            for (IClass iClass : this.staticImportsOnDemand) {
                IClass.IMethod im = this.findIMethod(iClass, mi);
                if (im == null) continue;
                if (iMethod != null) {
                    this.compileError("Ambiguous static method import: \"" + iMethod.toString() + "\" vs. \"" + im.toString() + "\"");
                }
                iMethod = im;
            }
            if (iMethod == null) {
                this.compileError("A method named \"" + mi.methodName + "\" is not declared in any enclosing class nor any supertype, nor through a static import", mi.getLocation());
                return this.fakeIMethod(this.iClassLoader.TYPE_java_lang_Object, mi.methodName, mi.arguments);
            }
        }
        this.checkThrownExceptions(mi, iMethod);
        return iMethod;
    }

    private IClass.IMethod findIMethod(IClass targetType, Java.Invocation invocation) throws CompileException {
        ArrayList<IClass.IMethod> ms = new ArrayList<IClass.IMethod>();
        this.getIMethods(targetType, invocation.methodName, ms);
        if (targetType.isInterface()) {
            IClass.IMethod[] oms;
            for (IClass.IMethod om : oms = this.iClassLoader.TYPE_java_lang_Object.getDeclaredIMethods(invocation.methodName)) {
                if (om.isStatic() || om.getAccess() != Access.PUBLIC) continue;
                ms.add(om);
            }
        }
        if (ms.size() == 0) {
            return null;
        }
        return (IClass.IMethod)this.findMostSpecificIInvocable(invocation, ms.toArray(new IClass.IMethod[ms.size()]), invocation.arguments, invocation.getEnclosingBlockStatement());
    }

    private IClass.IMethod fakeIMethod(IClass targetType, final String name2, Java.Rvalue[] arguments) throws CompileException {
        final IClass[] pts = new IClass[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            pts[i] = this.getType(arguments[i]);
        }
        IClass iClass = targetType;
        iClass.getClass();
        return new IClass.IMethod(iClass){

            @Override
            public String getName() {
                return name2;
            }

            @Override
            public IClass getReturnType() {
                return IClass.INT;
            }

            @Override
            public boolean isStatic() {
                return false;
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public boolean isVarargs() {
                return false;
            }

            @Override
            public IClass[] getParameterTypes2() {
                return pts;
            }

            @Override
            public IClass[] getThrownExceptions2() {
                return new IClass[0];
            }

            @Override
            public Access getAccess() {
                return Access.PUBLIC;
            }

            @Override
            public Java.Annotation[] getAnnotations() {
                return new Java.Annotation[0];
            }
        };
    }

    public void getIMethods(IClass type, String methodName, List<IClass.IMethod> v) throws CompileException {
        IClass[] interfaces2;
        IClass.IMethod[] ims;
        for (IClass.IMethod im : ims = type.getDeclaredIMethods(methodName)) {
            v.add(im);
        }
        IClass superclass = type.getSuperclass();
        if (superclass != null) {
            this.getIMethods(superclass, methodName, v);
        }
        for (IClass interfacE : interfaces2 = type.getInterfaces()) {
            this.getIMethods(interfacE, methodName, v);
        }
    }

    public IClass.IMethod findIMethod(Java.SuperclassMethodInvocation superclassMethodInvocation) throws CompileException {
        Java.Scope s2 = superclassMethodInvocation.getEnclosingBlockStatement();
        while (true) {
            if (s2 instanceof Java.FunctionDeclarator) {
                Java.FunctionDeclarator fd = (Java.FunctionDeclarator)s2;
                if (Mod.isStatic(fd.modifiers.flags)) {
                    this.compileError("Superclass method cannot be invoked in static context", superclassMethodInvocation.getLocation());
                }
            }
            if (s2 instanceof Java.ClassDeclaration) break;
            s2 = s2.getEnclosingScope();
        }
        Java.ClassDeclaration declaringClass = (Java.ClassDeclaration)s2;
        IClass superclass = this.resolve(declaringClass).getSuperclass();
        IClass.IMethod iMethod = this.findIMethod(superclass, superclassMethodInvocation);
        if (iMethod == null) {
            this.compileError("Class \"" + superclass + "\" has no method named \"" + superclassMethodInvocation.methodName + "\"", superclassMethodInvocation.getLocation());
            return this.fakeIMethod(superclass, superclassMethodInvocation.methodName, superclassMethodInvocation.arguments);
        }
        this.checkThrownExceptions(superclassMethodInvocation, iMethod);
        return iMethod;
    }

    private IClass.IInvocable findMostSpecificIInvocable(Java.Locatable locatable, IClass.IInvocable[] iInvocables, Java.Rvalue[] arguments, Java.Scope contextScope) throws CompileException {
        int i;
        final IClass[] argumentTypes = new IClass[arguments.length];
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            argumentTypes[i2] = this.getType(arguments[i2]);
        }
        IClass.IInvocable ii = this.findMostSpecificIInvocable(locatable, iInvocables, argumentTypes, false, contextScope);
        if (ii != null) {
            return ii;
        }
        ii = this.findMostSpecificIInvocable(locatable, iInvocables, argumentTypes, true, contextScope);
        if (ii != null) {
            return ii;
        }
        StringBuilder sb = new StringBuilder("No applicable constructor/method found for ");
        if (argumentTypes.length == 0) {
            sb.append("zero actual parameters");
        } else {
            sb.append("actual parameters \"").append(argumentTypes[0]);
            for (i = 1; i < argumentTypes.length; ++i) {
                sb.append(", ").append(argumentTypes[i]);
            }
            sb.append("\"");
        }
        sb.append("; candidates are: ").append('\"' + iInvocables[0].toString() + '\"');
        for (i = 1; i < iInvocables.length; ++i) {
            sb.append(", ").append('\"' + iInvocables[i].toString() + '\"');
        }
        this.compileError(sb.toString(), locatable.getLocation());
        if (iInvocables[0] instanceof IClass.IConstructor) {
            IClass iClass = iInvocables[0].getDeclaringIClass();
            iClass.getClass();
            return new IClass.IConstructor(iClass){

                @Override
                public boolean isVarargs() {
                    return false;
                }

                @Override
                public IClass[] getParameterTypes2() {
                    return argumentTypes;
                }

                @Override
                public Access getAccess() {
                    return Access.PUBLIC;
                }

                @Override
                public IClass[] getThrownExceptions2() {
                    return new IClass[0];
                }

                @Override
                public Java.Annotation[] getAnnotations() {
                    return new Java.Annotation[0];
                }
            };
        }
        if (iInvocables[0] instanceof IClass.IMethod) {
            final String methodName = ((IClass.IMethod)iInvocables[0]).getName();
            IClass iClass = iInvocables[0].getDeclaringIClass();
            iClass.getClass();
            return new IClass.IMethod(iClass){

                @Override
                public boolean isStatic() {
                    return true;
                }

                @Override
                public boolean isAbstract() {
                    return false;
                }

                @Override
                public IClass getReturnType() {
                    return IClass.INT;
                }

                @Override
                public String getName() {
                    return methodName;
                }

                @Override
                public Access getAccess() {
                    return Access.PUBLIC;
                }

                @Override
                public boolean isVarargs() {
                    return false;
                }

                @Override
                public IClass[] getParameterTypes2() {
                    return argumentTypes;
                }

                @Override
                public IClass[] getThrownExceptions2() {
                    return new IClass[0];
                }

                @Override
                public Java.Annotation[] getAnnotations() {
                    return new Java.Annotation[0];
                }
            };
        }
        return iInvocables[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IClass.IInvocable findMostSpecificIInvocable(Java.Locatable locatable, IClass.IInvocable[] iInvocables, IClass[] argumentTypes, boolean boxingPermitted, Java.Scope contextScope) throws CompileException {
        int i;
        ArrayList<IClass.IInvocable> maximallySpecificIInvocables;
        block40: {
            ArrayList<IClass.IInvocable> applicableIInvocables = new ArrayList<IClass.IInvocable>();
            ArrayList<IClass.IInvocable> varargApplicables = new ArrayList<IClass.IInvocable>();
            block0: for (IClass.IInvocable ii : iInvocables) {
                boolean isVarargs;
                int nUncheckedArg;
                int formalParamCount;
                IClass[] parameterTypes;
                boolean argsNeedAdjust;
                block39: {
                    argsNeedAdjust = false;
                    if (!this.isAccessible(ii, contextScope)) continue;
                    parameterTypes = ii.getParameterTypes();
                    formalParamCount = parameterTypes.length;
                    nUncheckedArg = argumentTypes.length;
                    isVarargs = ii.isVarargs();
                    if (isVarargs) {
                        IClass lastParamType = parameterTypes[--formalParamCount].getComponentType();
                        int lastActualArg = nUncheckedArg - 1;
                        if (formalParamCount == lastActualArg && argumentTypes[lastActualArg].isArray() && this.isMethodInvocationConvertible(argumentTypes[lastActualArg].getComponentType(), lastParamType, boxingPermitted)) {
                            --nUncheckedArg;
                        } else {
                            for (int idx = lastActualArg; idx >= formalParamCount; --idx) {
                                if (!this.isMethodInvocationConvertible(argumentTypes[idx], lastParamType, boxingPermitted)) {
                                    ++formalParamCount;
                                    break block39;
                                }
                                --nUncheckedArg;
                            }
                            argsNeedAdjust = true;
                        }
                    }
                }
                if (formalParamCount != nUncheckedArg) continue;
                for (int j = 0; j < nUncheckedArg; ++j) {
                    if (!this.isMethodInvocationConvertible(argumentTypes[j], parameterTypes[j], boxingPermitted)) continue block0;
                }
                if (isVarargs) {
                    ii.setArgsNeedAdjust(argsNeedAdjust);
                    varargApplicables.add(ii);
                    continue;
                }
                applicableIInvocables.add(ii);
            }
            if (applicableIInvocables.size() == 1) {
                return (IClass.IInvocable)applicableIInvocables.get(0);
            }
            if (applicableIInvocables.size() == 0 && !varargApplicables.isEmpty() && (applicableIInvocables = varargApplicables).size() == 1) {
                return (IClass.IInvocable)applicableIInvocables.get(0);
            }
            if (applicableIInvocables.size() == 0) {
                return null;
            }
            maximallySpecificIInvocables = new ArrayList<IClass.IInvocable>();
            for (IClass.IInvocable applicableIInvocable : applicableIInvocables) {
                int moreSpecific = 0;
                int lessSpecific = 0;
                for (IClass.IInvocable mostSpecificIInvocable : maximallySpecificIInvocables) {
                    if (applicableIInvocable.isMoreSpecificThan(mostSpecificIInvocable)) {
                        ++moreSpecific;
                        continue;
                    }
                    if (!applicableIInvocable.isLessSpecificThan(mostSpecificIInvocable)) continue;
                    ++lessSpecific;
                }
                if (moreSpecific == maximallySpecificIInvocables.size()) {
                    maximallySpecificIInvocables.clear();
                    maximallySpecificIInvocables.add(applicableIInvocable);
                    continue;
                }
                if (lessSpecific >= maximallySpecificIInvocables.size()) continue;
                maximallySpecificIInvocables.add(applicableIInvocable);
            }
            if (maximallySpecificIInvocables.size() == 1) {
                return (IClass.IInvocable)maximallySpecificIInvocables.get(0);
            }
            if (maximallySpecificIInvocables.size() > 1 && iInvocables[0] instanceof IClass.IMethod) {
                int i2;
                IClass.IMethod theNonAbstractMethod = null;
                Iterator it = maximallySpecificIInvocables.iterator();
                IClass.IMethod m = (IClass.IMethod)it.next();
                IClass[] parameterTypesOfFirstMethod = m.getParameterTypes();
                block5: while (true) {
                    if (!m.isAbstract()) {
                        if (theNonAbstractMethod == null) {
                            theNonAbstractMethod = m;
                        } else {
                            IClass theNonAbstractMethodDeclaringIClass;
                            IClass declaringIClass = m.getDeclaringIClass();
                            if (declaringIClass == (theNonAbstractMethodDeclaringIClass = theNonAbstractMethod.getDeclaringIClass())) {
                                if (m.getReturnType() == theNonAbstractMethod.getReturnType()) {
                                    throw new JaninoRuntimeException("Two non-abstract methods '" + m + "' have the same parameter types, " + "declaring type and return type");
                                }
                                if (!m.getReturnType().isAssignableFrom(theNonAbstractMethod.getReturnType())) {
                                    if (!theNonAbstractMethod.getReturnType().isAssignableFrom(m.getReturnType())) throw new JaninoRuntimeException("Incompatible return types");
                                    theNonAbstractMethod = m;
                                }
                            } else if (!declaringIClass.isAssignableFrom(theNonAbstractMethodDeclaringIClass)) {
                                if (!theNonAbstractMethodDeclaringIClass.isAssignableFrom(declaringIClass)) throw new JaninoRuntimeException("SNO: Types declaring '" + theNonAbstractMethod + "' are not assignable");
                                theNonAbstractMethod = m;
                            }
                        }
                    }
                    if (!it.hasNext()) break;
                    m = (IClass.IMethod)it.next();
                    IClass[] pts = m.getParameterTypes();
                    int i3 = 0;
                    while (true) {
                        if (i3 >= pts.length) continue block5;
                        if (pts[i3] == parameterTypesOfFirstMethod[i3]) {
                            ++i3;
                            continue;
                        }
                        break block40;
                        break;
                    }
                    break;
                }
                if (theNonAbstractMethod != null) {
                    return theNonAbstractMethod;
                }
                HashSet<IClass> s2 = new HashSet<IClass>();
                IClass[][] tes = new IClass[maximallySpecificIInvocables.size()][];
                Iterator it2 = maximallySpecificIInvocables.iterator();
                for (i2 = 0; i2 < tes.length; ++i2) {
                    tes[i2] = ((IClass.IMethod)it2.next()).getThrownExceptions();
                }
                for (i2 = 0; i2 < tes.length; ++i2) {
                    block9: for (IClass te1 : tes[i2]) {
                        block10: for (int k = 0; k < tes.length; ++k) {
                            if (k == i2) continue;
                            for (IClass te2 : tes[k]) {
                                if (te2.isAssignableFrom(te1)) continue block10;
                            }
                            continue block9;
                        }
                        s2.add(te1);
                    }
                }
                final IClass.IMethod im = (IClass.IMethod)maximallySpecificIInvocables.get(0);
                final IClass[] tes2 = s2.toArray(new IClass[s2.size()]);
                IClass iClass = im.getDeclaringIClass();
                iClass.getClass();
                return new IClass.IMethod(iClass){

                    @Override
                    public String getName() {
                        return im.getName();
                    }

                    @Override
                    public IClass getReturnType() throws CompileException {
                        return im.getReturnType();
                    }

                    @Override
                    public boolean isAbstract() {
                        return im.isAbstract();
                    }

                    @Override
                    public boolean isStatic() {
                        return im.isStatic();
                    }

                    @Override
                    public Access getAccess() {
                        return im.getAccess();
                    }

                    @Override
                    public boolean isVarargs() {
                        return im.isVarargs();
                    }

                    @Override
                    public IClass[] getParameterTypes2() throws CompileException {
                        return im.getParameterTypes();
                    }

                    @Override
                    public IClass[] getThrownExceptions2() {
                        return tes2;
                    }

                    @Override
                    public Java.Annotation[] getAnnotations() {
                        return im.getAnnotations();
                    }
                };
            }
        }
        if (!boxingPermitted) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Invocation of constructor/method with argument type(s) \"");
        for (i = 0; i < argumentTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(Descriptor.toString(argumentTypes[i].getDescriptor()));
        }
        sb.append("\" is ambiguous: ");
        for (i = 0; i < maximallySpecificIInvocables.size(); ++i) {
            if (i > 0) {
                sb.append(" vs. ");
            }
            sb.append("\"" + maximallySpecificIInvocables.get(i) + "\"");
        }
        this.compileError(sb.toString(), locatable.getLocation());
        return iInvocables[0];
    }

    private boolean isMethodInvocationConvertible(IClass sourceType, IClass targetType, boolean boxingPermitted) throws CompileException {
        IClass unboxedType;
        IClass boxedType;
        if (sourceType == targetType) {
            return true;
        }
        if (this.isWideningPrimitiveConvertible(sourceType, targetType)) {
            return true;
        }
        if (this.isWideningReferenceConvertible(sourceType, targetType)) {
            return true;
        }
        if (boxingPermitted && (boxedType = this.isBoxingConvertible(sourceType)) != null) {
            return this.isIdentityConvertible(boxedType, targetType) || this.isWideningReferenceConvertible(boxedType, targetType);
        }
        if (boxingPermitted && (unboxedType = this.isUnboxingConvertible(sourceType)) != null) {
            return this.isIdentityConvertible(unboxedType, targetType) || this.isWideningPrimitiveConvertible(unboxedType, targetType);
        }
        return false;
    }

    private void checkThrownExceptions(Java.Invocation in, IClass.IMethod iMethod) throws CompileException {
        IClass[] thrownExceptions;
        for (IClass thrownException : thrownExceptions = iMethod.getThrownExceptions()) {
            this.checkThrownException(in, thrownException, in.getEnclosingBlockStatement());
        }
    }

    private void checkThrownException(Java.Locatable locatable, IClass type, Java.Scope scope) throws CompileException {
        if (!this.iClassLoader.TYPE_java_lang_Throwable.isAssignableFrom(type)) {
            this.compileError("Thrown object of type \"" + type + "\" is not assignable to \"Throwable\"", locatable.getLocation());
        }
        if (this.iClassLoader.TYPE_java_lang_RuntimeException.isAssignableFrom(type) || this.iClassLoader.TYPE_java_lang_Error.isAssignableFrom(type)) {
            return;
        }
        while (true) {
            if (scope instanceof Java.TryStatement) {
                Java.TryStatement ts = (Java.TryStatement)scope;
                block1: for (int i = 0; i < ts.catchClauses.size(); ++i) {
                    Java.CatchClause cc = ts.catchClauses.get(i);
                    IClass caughtType = this.getType(cc.caughtException.type);
                    if (caughtType.isAssignableFrom(type)) {
                        cc.reachable = true;
                        return;
                    }
                    if (!type.isAssignableFrom(caughtType)) continue;
                    for (int j = 0; j < i; ++j) {
                        if (this.getType(ts.catchClauses.get((int)j).caughtException.type).isAssignableFrom(caughtType)) continue block1;
                    }
                    cc.reachable = true;
                }
            } else {
                if (scope instanceof Java.FunctionDeclarator) {
                    Java.FunctionDeclarator fd = (Java.FunctionDeclarator)scope;
                    for (Java.Type thrownException : fd.thrownExceptions) {
                        if (!this.getType(thrownException).isAssignableFrom(type)) continue;
                        return;
                    }
                    break;
                }
                if (scope instanceof Java.TypeBodyDeclaration) break;
            }
            scope = scope.getEnclosingScope();
        }
        this.compileError("Thrown exception of type \"" + type + "\" is neither caught by a \"try...catch\" block " + "nor declared in the \"throws\" clause of the declaring function", locatable.getLocation());
    }

    private IClass getTargetIClass(Java.QualifiedThisReference qtr) throws CompileException {
        if (qtr.targetIClass == null) {
            qtr.targetIClass = this.getType(qtr.qualification);
        }
        return qtr.targetIClass;
    }

    Java.LocalVariable isIntLv(Java.Crement c) throws CompileException {
        if (!(c.operand instanceof Java.AmbiguousName)) {
            return null;
        }
        Java.AmbiguousName an = (Java.AmbiguousName)c.operand;
        Java.Atom rec = this.reclassify(an);
        if (!(rec instanceof Java.LocalVariableAccess)) {
            return null;
        }
        Java.LocalVariableAccess lva = (Java.LocalVariableAccess)rec;
        Java.LocalVariable lv = lva.localVariable;
        if (lv.finaL) {
            this.compileError("Must not increment or decrement \"final\" local variable", lva.getLocation());
        }
        if (lv.type == IClass.BYTE || lv.type == IClass.SHORT || lv.type == IClass.INT || lv.type == IClass.CHAR) {
            return lv;
        }
        return null;
    }

    private IClass resolve(final Java.TypeDeclaration td) {
        final Java.AbstractTypeDeclaration atd = (Java.AbstractTypeDeclaration)td;
        if (atd.resolvedType == null) {
            atd.resolvedType = new IClass(){
                private IClass[] declaredClasses;

                @Override
                protected IClass.IMethod[] getDeclaredIMethods2() {
                    IClass.IMethod[] res = new IClass.IMethod[atd.getMethodDeclarations().size()];
                    int i = 0;
                    for (Java.MethodDeclarator md : atd.getMethodDeclarations()) {
                        res[i++] = UnitCompiler.this.toIMethod(md);
                    }
                    return res;
                }

                @Override
                protected IClass[] getDeclaredIClasses2() {
                    if (this.declaredClasses == null) {
                        Collection<Java.MemberTypeDeclaration> mtds = td.getMemberTypeDeclarations();
                        IClass[] mts = new IClass[mtds.size()];
                        int i = 0;
                        for (Java.MemberTypeDeclaration mtd : mtds) {
                            mts[i++] = UnitCompiler.this.resolve(mtd);
                        }
                        this.declaredClasses = mts;
                    }
                    return this.declaredClasses;
                }

                @Override
                protected IClass getDeclaringIClass2() {
                    Java.Scope s2 = atd;
                    while (!(s2 instanceof Java.TypeBodyDeclaration)) {
                        if (s2 instanceof Java.CompilationUnit) {
                            return null;
                        }
                        s2 = s2.getEnclosingScope();
                    }
                    return UnitCompiler.this.resolve((Java.AbstractTypeDeclaration)s2.getEnclosingScope());
                }

                @Override
                protected IClass getOuterIClass2() {
                    Java.AbstractTypeDeclaration oc = (Java.AbstractTypeDeclaration)UnitCompiler.getOuterClass(atd);
                    if (oc == null) {
                        return null;
                    }
                    return UnitCompiler.this.resolve(oc);
                }

                @Override
                protected final String getDescriptor2() {
                    return Descriptor.fromClassName(atd.getClassName());
                }

                @Override
                public boolean isArray() {
                    return false;
                }

                @Override
                protected IClass getComponentType2() {
                    throw new JaninoRuntimeException("SNO: Non-array type has no component type");
                }

                @Override
                public boolean isPrimitive() {
                    return false;
                }

                @Override
                public boolean isPrimitiveNumeric() {
                    return false;
                }

                @Override
                protected IClass.IConstructor[] getDeclaredIConstructors2() {
                    if (atd instanceof Java.ClassDeclaration) {
                        Java.ConstructorDeclarator[] cs = ((Java.ClassDeclaration)atd).getConstructors();
                        IClass.IConstructor[] res = new IClass.IConstructor[cs.length];
                        for (int i = 0; i < cs.length; ++i) {
                            res[i] = UnitCompiler.this.toIConstructor(cs[i]);
                        }
                        return res;
                    }
                    return new IClass.IConstructor[0];
                }

                @Override
                protected IClass.IField[] getDeclaredIFields2() {
                    if (atd instanceof Java.ClassDeclaration) {
                        Java.ClassDeclaration cd = (Java.ClassDeclaration)atd;
                        ArrayList<IClass.IField> l = new ArrayList<IClass.IField>();
                        for (Java.BlockStatement vdoi : cd.variableDeclaratorsAndInitializers) {
                            IClass.IField[] flds;
                            if (!(vdoi instanceof Java.FieldDeclaration)) continue;
                            Java.FieldDeclaration fd = (Java.FieldDeclaration)vdoi;
                            for (IClass.IField fld : flds = UnitCompiler.this.getIFields(fd)) {
                                l.add(fld);
                            }
                        }
                        return l.toArray(new IClass.IField[l.size()]);
                    }
                    if (atd instanceof Java.InterfaceDeclaration) {
                        Java.InterfaceDeclaration id = (Java.InterfaceDeclaration)atd;
                        ArrayList<IClass.IField> l = new ArrayList<IClass.IField>();
                        for (Java.FieldDeclaration bs : id.constantDeclarations) {
                            IClass.IField[] flds;
                            if (!(bs instanceof Java.FieldDeclaration)) continue;
                            Java.FieldDeclaration fd = bs;
                            for (IClass.IField fld : flds = UnitCompiler.this.getIFields(fd)) {
                                l.add(fld);
                            }
                        }
                        return l.toArray(new IClass.IField[l.size()]);
                    }
                    throw new JaninoRuntimeException("SNO: AbstractTypeDeclaration is neither ClassDeclaration nor InterfaceDeclaration");
                }

                @Override
                public IClass.IField[] getSyntheticIFields() {
                    if (atd instanceof Java.ClassDeclaration) {
                        Collection<IClass.IField> c = ((Java.ClassDeclaration)atd).syntheticFields.values();
                        return c.toArray(new IClass.IField[c.size()]);
                    }
                    return new IClass.IField[0];
                }

                @Override
                protected IClass getSuperclass2() throws CompileException {
                    if (atd instanceof Java.AnonymousClassDeclaration) {
                        IClass bt = UnitCompiler.this.getType(((Java.AnonymousClassDeclaration)atd).baseType);
                        return bt.isInterface() ? ((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Object : bt;
                    }
                    if (atd instanceof Java.NamedClassDeclaration) {
                        Java.NamedClassDeclaration ncd = (Java.NamedClassDeclaration)atd;
                        if (ncd.optionalExtendedType == null) {
                            return ((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Object;
                        }
                        IClass superclass = UnitCompiler.this.getType(ncd.optionalExtendedType);
                        if (superclass.isInterface()) {
                            UnitCompiler.this.compileError("\"" + superclass.toString() + "\" is an interface; classes can only extend a class", td.getLocation());
                        }
                        return superclass;
                    }
                    return null;
                }

                @Override
                public Access getAccess() {
                    return UnitCompiler.modifiers2Access(atd.getModifierFlags());
                }

                @Override
                public boolean isFinal() {
                    return Mod.isFinal(atd.getModifierFlags());
                }

                @Override
                protected IClass[] getInterfaces2() throws CompileException {
                    if (atd instanceof Java.AnonymousClassDeclaration) {
                        IClass[] iClassArray;
                        IClass bt = UnitCompiler.this.getType(((Java.AnonymousClassDeclaration)atd).baseType);
                        if (bt.isInterface()) {
                            IClass[] iClassArray2 = new IClass[1];
                            iClassArray = iClassArray2;
                            iClassArray2[0] = bt;
                        } else {
                            iClassArray = new IClass[]{};
                        }
                        return iClassArray;
                    }
                    if (atd instanceof Java.NamedClassDeclaration) {
                        Java.NamedClassDeclaration ncd = (Java.NamedClassDeclaration)atd;
                        IClass[] res = new IClass[ncd.implementedTypes.length];
                        for (int i = 0; i < res.length; ++i) {
                            res[i] = UnitCompiler.this.getType(ncd.implementedTypes[i]);
                            if (res[i].isInterface()) continue;
                            UnitCompiler.this.compileError("\"" + res[i].toString() + "\" is not an interface; classes can only implement interfaces", td.getLocation());
                        }
                        return res;
                    }
                    if (atd instanceof Java.InterfaceDeclaration) {
                        Java.InterfaceDeclaration id = (Java.InterfaceDeclaration)atd;
                        IClass[] res = new IClass[id.extendedTypes.length];
                        for (int i = 0; i < res.length; ++i) {
                            res[i] = UnitCompiler.this.getType(id.extendedTypes[i]);
                            if (res[i].isInterface()) continue;
                            UnitCompiler.this.compileError("\"" + res[i].toString() + "\" is not an interface; interfaces can only extend interfaces", td.getLocation());
                        }
                        return res;
                    }
                    throw new JaninoRuntimeException("SNO: AbstractTypeDeclaration is neither ClassDeclaration nor InterfaceDeclaration");
                }

                @Override
                public boolean isAbstract() {
                    return atd instanceof Java.InterfaceDeclaration || Mod.isAbstract(atd.getModifierFlags());
                }

                @Override
                public boolean isInterface() {
                    return atd instanceof Java.InterfaceDeclaration;
                }
            };
        }
        return atd.resolvedType;
    }

    private void referenceThis(Java.Locatable locatable, Java.ClassDeclaration declaringClass, Java.TypeBodyDeclaration declaringTypeBodyDeclaration, IClass targetIClass) throws CompileException {
        int i;
        int j;
        List<Java.TypeDeclaration> path;
        block8: {
            path = UnitCompiler.getOuterClasses(declaringClass);
            if (declaringTypeBodyDeclaration.isStatic()) {
                this.compileError("No current instance available in static context", locatable.getLocation());
            }
            for (j = 0; j < path.size(); ++j) {
                if (!targetIClass.isAssignableFrom(this.resolve(path.get(j)))) {
                    continue;
                }
                break block8;
            }
            this.compileError("\"" + declaringClass + "\" is not enclosed by \"" + targetIClass + "\"", locatable.getLocation());
        }
        if (declaringTypeBodyDeclaration instanceof Java.ConstructorDeclarator) {
            if (j == 0) {
                this.writeOpcode(locatable, 42);
                return;
            }
            Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)declaringTypeBodyDeclaration;
            String spn = "this$" + (path.size() - 2);
            Java.LocalVariable syntheticParameter = constructorDeclarator.syntheticParameters.get(spn);
            if (syntheticParameter == null) {
                throw new JaninoRuntimeException("SNO: Synthetic parameter \"" + spn + "\" not found");
            }
            this.load(locatable, syntheticParameter);
            i = 1;
        } else {
            this.writeOpcode(locatable, 42);
            i = 0;
        }
        while (i < j) {
            Java.InnerClassDeclaration inner3 = (Java.InnerClassDeclaration)path.get(i);
            Java.TypeDeclaration outer3 = path.get(i + 1);
            SimpleIField sf = new SimpleIField(this.resolve(inner3), "this$" + (path.size() - i - 2), this.resolve(outer3));
            inner3.defineSyntheticField(sf);
            this.getfield(locatable, sf);
            ++i;
        }
    }

    private static List<Java.TypeDeclaration> getOuterClasses(Java.TypeDeclaration inner3) {
        ArrayList<Java.TypeDeclaration> path = new ArrayList<Java.TypeDeclaration>();
        Java.TypeDeclaration ic = inner3;
        while (ic != null) {
            path.add(ic);
            ic = UnitCompiler.getOuterClass(ic);
        }
        return path;
    }

    static Java.TypeDeclaration getOuterClass(Java.TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof Java.PackageMemberClassDeclaration) {
            return null;
        }
        if (typeDeclaration instanceof Java.LocalClassDeclaration) {
            Java.Scope s2 = typeDeclaration.getEnclosingScope();
            while (!(s2 instanceof Java.FunctionDeclarator)) {
                s2 = s2.getEnclosingScope();
            }
            if (s2 instanceof Java.MethodDeclarator && Mod.isStatic(((Java.FunctionDeclarator)s2).modifiers.flags)) {
                return null;
            }
            while (!(s2 instanceof Java.TypeDeclaration)) {
                s2 = s2.getEnclosingScope();
            }
            Java.TypeDeclaration immediatelyEnclosingTypeDeclaration = (Java.TypeDeclaration)s2;
            return immediatelyEnclosingTypeDeclaration instanceof Java.ClassDeclaration ? immediatelyEnclosingTypeDeclaration : null;
        }
        if (typeDeclaration instanceof Java.MemberClassDeclaration && Mod.isStatic(((Java.MemberClassDeclaration)typeDeclaration).getModifierFlags())) {
            return null;
        }
        Java.Scope s3 = typeDeclaration;
        while (!(s3 instanceof Java.TypeBodyDeclaration)) {
            if (s3 instanceof Java.ConstructorInvocation) {
                return null;
            }
            if (s3 instanceof Java.CompilationUnit) {
                return null;
            }
            s3 = s3.getEnclosingScope();
        }
        if (((Java.TypeBodyDeclaration)s3).isStatic()) {
            return null;
        }
        return (Java.AbstractTypeDeclaration)s3.getEnclosingScope();
    }

    private IClass getIClass(Java.ThisReference tr) throws CompileException {
        if (tr.iClass == null) {
            Java.Scope s2 = tr.getEnclosingBlockStatement();
            while (s2 instanceof Java.Statement || s2 instanceof Java.CatchClause) {
                s2 = s2.getEnclosingScope();
            }
            if (s2 instanceof Java.FunctionDeclarator) {
                Java.FunctionDeclarator function = (Java.FunctionDeclarator)s2;
                if (Mod.isStatic(function.modifiers.flags)) {
                    this.compileError("No current instance available in static method", tr.getLocation());
                }
            }
            while (!(s2 instanceof Java.TypeDeclaration)) {
                s2 = s2.getEnclosingScope();
            }
            if (!(s2 instanceof Java.ClassDeclaration)) {
                this.compileError("Only methods of classes can have a current instance", tr.getLocation());
            }
            tr.iClass = this.resolve((Java.ClassDeclaration)s2);
        }
        return tr.iClass;
    }

    private IClass getReturnType(Java.FunctionDeclarator fd) throws CompileException {
        if (fd.returnType == null) {
            fd.returnType = this.getType(fd.type);
        }
        return fd.returnType;
    }

    IClass.IConstructor toIConstructor(final Java.ConstructorDeclarator constructorDeclarator) {
        if (constructorDeclarator.iConstructor != null) {
            return constructorDeclarator.iConstructor;
        }
        IClass iClass = this.resolve(constructorDeclarator.getDeclaringType());
        iClass.getClass();
        constructorDeclarator.iConstructor = new IClass.IConstructor(iClass){

            @Override
            public Access getAccess() {
                switch (constructorDeclarator.modifiers.flags & 7) {
                    case 2: {
                        return Access.PRIVATE;
                    }
                    case 4: {
                        return Access.PROTECTED;
                    }
                    case 0: {
                        return Access.DEFAULT;
                    }
                    case 1: {
                        return Access.PUBLIC;
                    }
                }
                throw new JaninoRuntimeException("Invalid access");
            }

            @Override
            public Java.Annotation[] getAnnotations() {
                return constructorDeclarator.modifiers.annotations;
            }

            @Override
            public String getDescriptor2() throws CompileException {
                if (!(constructorDeclarator.getDeclaringClass() instanceof Java.InnerClassDeclaration)) {
                    return super.getDescriptor2();
                }
                ArrayList<String> parameterFds = new ArrayList<String>();
                IClass outerClass = UnitCompiler.this.resolve(constructorDeclarator.getDeclaringClass()).getOuterIClass();
                if (outerClass != null) {
                    parameterFds.add(outerClass.getDescriptor());
                }
                for (IClass.IField sf : constructorDeclarator.getDeclaringClass().syntheticFields.values()) {
                    if (!sf.getName().startsWith("val$")) continue;
                    parameterFds.add(sf.getType().getDescriptor());
                }
                Java.FunctionDeclarator.FormalParameter[] parameters = constructorDeclarator.formalParameters.parameters;
                for (int i = 0; i < parameters.length; ++i) {
                    IClass parameterType = UnitCompiler.this.getType(parameters[i].type);
                    if (i == parameters.length - 1 && constructorDeclarator.formalParameters.variableArity) {
                        parameterType = parameterType.getArrayIClass(((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Object);
                    }
                    parameterFds.add(parameterType.getDescriptor());
                }
                return new MethodDescriptor(parameterFds.toArray(new String[parameterFds.size()]), "V").toString();
            }

            @Override
            public boolean isVarargs() {
                return Mod.isVarargs(constructorDeclarator.modifiers.flags);
            }

            @Override
            public IClass[] getParameterTypes2() throws CompileException {
                Java.FunctionDeclarator.FormalParameter[] parameters = constructorDeclarator.formalParameters.parameters;
                IClass[] res = new IClass[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    IClass parameterType = UnitCompiler.this.getType(parameters[i].type);
                    if (i == parameters.length - 1 && constructorDeclarator.formalParameters.variableArity) {
                        parameterType = parameterType.getArrayIClass(((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Object);
                    }
                    res[i] = parameterType;
                }
                return res;
            }

            @Override
            public IClass[] getThrownExceptions2() throws CompileException {
                IClass[] res = new IClass[constructorDeclarator.thrownExceptions.length];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = UnitCompiler.this.getType(constructorDeclarator.thrownExceptions[i]);
                }
                return res;
            }

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder().append(constructorDeclarator.getDeclaringType().getClassName()).append('(');
                Java.FunctionDeclarator.FormalParameter[] parameters = constructorDeclarator.formalParameters.parameters;
                for (int i = 0; i < parameters.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(parameters[i].toString(i == parameters.length - 1 && constructorDeclarator.formalParameters.variableArity));
                }
                return sb.append(')').toString();
            }
        };
        return constructorDeclarator.iConstructor;
    }

    public IClass.IMethod toIMethod(final Java.MethodDeclarator methodDeclarator) {
        if (methodDeclarator.iMethod != null) {
            return methodDeclarator.iMethod;
        }
        IClass iClass = this.resolve(methodDeclarator.getDeclaringType());
        iClass.getClass();
        methodDeclarator.iMethod = new IClass.IMethod(iClass){

            @Override
            public Access getAccess() {
                switch (methodDeclarator.modifiers.flags & 7) {
                    case 2: {
                        return Access.PRIVATE;
                    }
                    case 4: {
                        return Access.PROTECTED;
                    }
                    case 0: {
                        return Access.DEFAULT;
                    }
                    case 1: {
                        return Access.PUBLIC;
                    }
                }
                throw new JaninoRuntimeException("Invalid access");
            }

            @Override
            public Java.Annotation[] getAnnotations() {
                return methodDeclarator.modifiers.annotations;
            }

            @Override
            public boolean isVarargs() {
                return Mod.isVarargs(methodDeclarator.modifiers.flags);
            }

            @Override
            public IClass[] getParameterTypes2() throws CompileException {
                Java.FunctionDeclarator.FormalParameter[] parameters = methodDeclarator.formalParameters.parameters;
                IClass[] res = new IClass[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    IClass parameterType = UnitCompiler.this.getType(parameters[i].type);
                    if (i == parameters.length - 1 && methodDeclarator.formalParameters.variableArity) {
                        parameterType = parameterType.getArrayIClass(((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Object);
                    }
                    res[i] = parameterType;
                }
                return res;
            }

            @Override
            public IClass[] getThrownExceptions2() throws CompileException {
                IClass[] res = new IClass[methodDeclarator.thrownExceptions.length];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = UnitCompiler.this.getType(methodDeclarator.thrownExceptions[i]);
                }
                return res;
            }

            @Override
            public boolean isStatic() {
                return Mod.isStatic(methodDeclarator.modifiers.flags);
            }

            @Override
            public boolean isAbstract() {
                return methodDeclarator.getDeclaringType() instanceof Java.InterfaceDeclaration || Mod.isAbstract(methodDeclarator.modifiers.flags);
            }

            @Override
            public IClass getReturnType() throws CompileException {
                return UnitCompiler.this.getReturnType(methodDeclarator);
            }

            @Override
            public String getName() {
                return methodDeclarator.name;
            }
        };
        return methodDeclarator.iMethod;
    }

    private IClass.IInvocable toIInvocable(final Java.FunctionDeclarator fd) {
        final IClass.IInvocable[] result2 = new IClass.IInvocable[1];
        fd.accept(new Visitor.FunctionDeclaratorVisitor(){

            @Override
            public void visitMethodDeclarator(Java.MethodDeclarator md) {
                result2[0] = UnitCompiler.this.toIMethod((Java.MethodDeclarator)fd);
            }

            @Override
            public void visitConstructorDeclarator(Java.ConstructorDeclarator cd) {
                result2[0] = UnitCompiler.this.toIConstructor((Java.ConstructorDeclarator)fd);
            }
        });
        return result2[0];
    }

    private IClass importSingleType(String simpleTypeName, Location location) throws CompileException {
        Object[] ss = this.getSingleTypeImport(simpleTypeName, location);
        if (ss == null) {
            return null;
        }
        IClass iClass = this.findTypeByFullyQualifiedName(location, (String[])ss);
        if (iClass == null) {
            this.compileError("Imported class \"" + Java.join(ss, ".") + "\" could not be loaded", location);
            return this.iClassLoader.TYPE_java_lang_Object;
        }
        return iClass;
    }

    public String[] getSingleTypeImport(String name2, Location location) throws CompileException {
        if (this.singleTypeImports == null) {
            final ArrayList stids = new ArrayList();
            for (Java.CompilationUnit.ImportDeclaration id : this.compilationUnit.importDeclarations) {
                id.accept(new Visitor.ImportVisitor(){

                    @Override
                    public void visitSingleTypeImportDeclaration(Java.CompilationUnit.SingleTypeImportDeclaration stid) {
                        stids.add(stid);
                    }

                    @Override
                    public void visitTypeImportOnDemandDeclaration(Java.CompilationUnit.TypeImportOnDemandDeclaration tiodd) {
                    }

                    @Override
                    public void visitSingleStaticImportDeclaration(Java.CompilationUnit.SingleStaticImportDeclaration ssid) {
                    }

                    @Override
                    public void visitStaticImportOnDemandDeclaration(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) {
                    }
                });
            }
            this.singleTypeImports = new HashMap<String, String[]>();
            for (Java.CompilationUnit.SingleTypeImportDeclaration stid : stids) {
                Object[] ids = stid.identifiers;
                String simpleName = UnitCompiler.last((String[])ids);
                Object[] prev = this.singleTypeImports.put(simpleName, (String[])ids);
                if (prev != null && !Arrays.equals(prev, ids)) {
                    this.compileError("Class \"" + simpleName + "\" was previously imported as " + "\"" + Java.join(prev, ".") + "\", now as \"" + Java.join(ids, ".") + "\"", stid.getLocation());
                }
                if (this.findTypeByFullyQualifiedName(location, (String[])ids) != null) continue;
                this.compileError("A class '" + Java.join(ids, ".") + "' could not be found", stid.getLocation());
            }
        }
        return this.singleTypeImports.get(name2);
    }

    public IClass importTypeOnDemand(String simpleTypeName, Location location) throws CompileException {
        IClass importedClass = this.onDemandImportableTypes.get(simpleTypeName);
        if (importedClass != null) {
            return importedClass;
        }
        if (this.typeImportsOnDemand == null) {
            this.typeImportsOnDemand = new ArrayList<String[]>();
            this.typeImportsOnDemand.add(new String[]{"java", "lang"});
            for (Java.CompilationUnit.ImportDeclaration id : this.compilationUnit.importDeclarations) {
                id.accept(new Visitor.ImportVisitor(){

                    @Override
                    public void visitSingleTypeImportDeclaration(Java.CompilationUnit.SingleTypeImportDeclaration stid) {
                    }

                    @Override
                    public void visitTypeImportOnDemandDeclaration(Java.CompilationUnit.TypeImportOnDemandDeclaration tiodd) {
                        UnitCompiler.this.typeImportsOnDemand.add(tiodd.identifiers);
                    }

                    @Override
                    public void visitSingleStaticImportDeclaration(Java.CompilationUnit.SingleStaticImportDeclaration ssid) {
                    }

                    @Override
                    public void visitStaticImportOnDemandDeclaration(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) {
                    }
                });
            }
        }
        importedClass = null;
        for (String[] packageComponents : this.typeImportsOnDemand) {
            String[] typeComponents = UnitCompiler.concat(packageComponents, simpleTypeName);
            IClass iClass = this.findTypeByFullyQualifiedName(location, typeComponents);
            if (iClass == null) continue;
            if (importedClass != null && importedClass != iClass) {
                this.compileError("Ambiguous class name: \"" + importedClass + "\" vs. \"" + iClass + "\"", location);
            }
            importedClass = iClass;
        }
        if (importedClass == null) {
            return null;
        }
        this.onDemandImportableTypes.put(simpleTypeName, importedClass);
        return importedClass;
    }

    private void declareClassDollarMethod(Java.ClassLiteral cl) {
        IClass noClassDefFoundErrorIClass;
        IClass classNotFoundExceptionIClass;
        Location loc = cl.getLocation();
        Java.Scope s2 = cl.getEnclosingBlockStatement();
        while (true) {
            if (s2 instanceof Java.AbstractTypeDeclaration) break;
            s2 = s2.getEnclosingScope();
        }
        Java.AbstractTypeDeclaration declaringType = (Java.AbstractTypeDeclaration)s2;
        Java.MethodInvocation mi = new Java.MethodInvocation(loc, new Java.SimpleType(loc, this.iClassLoader.TYPE_java_lang_Class), "forName", new Java.Rvalue[]{new Java.AmbiguousName(loc, new String[]{"className"})});
        try {
            classNotFoundExceptionIClass = this.iClassLoader.loadIClass("Ljava/lang/ClassNotFoundException;");
        }
        catch (ClassNotFoundException ex) {
            throw new JaninoRuntimeException("Loading class \"ClassNotFoundException\": " + ex.getMessage(), ex);
        }
        if (classNotFoundExceptionIClass == null) {
            throw new JaninoRuntimeException("SNO: Cannot load \"ClassNotFoundException\"");
        }
        try {
            noClassDefFoundErrorIClass = this.iClassLoader.loadIClass("Ljava/lang/NoClassDefFoundError;");
        }
        catch (ClassNotFoundException ex) {
            throw new JaninoRuntimeException("Loading class \"NoClassDefFoundError\": " + ex.getMessage(), ex);
        }
        if (noClassDefFoundErrorIClass == null) {
            throw new JaninoRuntimeException("SNO: Cannot load \"NoClassFoundError\"");
        }
        Java.Block b = new Java.Block(loc);
        b.addStatement(new Java.ThrowStatement(loc, new Java.NewClassInstance(loc, (Java.Rvalue)null, new Java.SimpleType(loc, noClassDefFoundErrorIClass), new Java.Rvalue[]{new Java.MethodInvocation(loc, new Java.AmbiguousName(loc, new String[]{"ex"}), "getMessage", new Java.Rvalue[0])})));
        ArrayList<Java.CatchClause> l = new ArrayList<Java.CatchClause>();
        l.add(new Java.CatchClause(loc, new Java.FunctionDeclarator.FormalParameter(loc, true, new Java.SimpleType(loc, classNotFoundExceptionIClass), "ex"), b));
        Java.TryStatement ts = new Java.TryStatement(loc, new Java.ReturnStatement(loc, mi), l, null);
        ArrayList<Java.TryStatement> statements = new ArrayList<Java.TryStatement>();
        statements.add(ts);
        Java.FunctionDeclarator.FormalParameter parameter = new Java.FunctionDeclarator.FormalParameter(loc, false, new Java.SimpleType(loc, this.iClassLoader.TYPE_java_lang_String), "className");
        Java.MethodDeclarator cdmd = new Java.MethodDeclarator(loc, null, new Java.Modifiers(8), new Java.SimpleType(loc, this.iClassLoader.TYPE_java_lang_Class), "class$", new Java.FunctionDeclarator.FormalParameters(loc, new Java.FunctionDeclarator.FormalParameter[]{parameter}, false), new Java.Type[0], statements);
        declaringType.addDeclaredMethod(cdmd);
        declaringType.invalidateMethodCaches();
    }

    private IClass pushConstant(Java.Locatable locatable, Object value2) throws CompileException {
        block27: {
            int iv;
            block24: {
                block26: {
                    block25: {
                        block23: {
                            if (!(value2 instanceof Character)) break block23;
                            iv = ((Character)value2).charValue();
                            break block24;
                        }
                        if (!(value2 instanceof Byte)) break block25;
                        iv = ((Byte)value2).intValue();
                        break block24;
                    }
                    if (!(value2 instanceof Short)) break block26;
                    iv = ((Short)value2).intValue();
                    break block24;
                }
                if (!(value2 instanceof Integer)) break block27;
                iv = (Integer)value2;
            }
            if (iv >= -1 && iv <= 5) {
                this.writeOpcode(locatable, 3 + iv);
            } else if (iv >= -128 && iv <= 127) {
                this.writeOpcode(locatable, 16);
                this.writeByte((byte)iv);
            } else {
                this.writeLdc(locatable, this.addConstantIntegerInfo(iv));
            }
            return IClass.INT;
        }
        if (value2 instanceof Long) {
            long lv = (Long)value2;
            if (lv == 0L) {
                this.writeOpcode(locatable, 9);
            } else if (lv == 1L) {
                this.writeOpcode(locatable, 10);
            } else {
                this.writeOpcode(locatable, 20);
                this.writeConstantLongInfo(lv);
            }
            return IClass.LONG;
        }
        if (value2 instanceof Float) {
            float fv = ((Float)value2).floatValue();
            if (Float.floatToIntBits(fv) == Float.floatToIntBits(0.0f) || fv == 1.0f || fv == 2.0f) {
                this.writeOpcode(locatable, 11 + (int)fv);
            } else {
                this.writeLdc(locatable, this.addConstantFloatInfo(fv));
            }
            return IClass.FLOAT;
        }
        if (value2 instanceof Double) {
            double dv = (Double)value2;
            if (Double.doubleToLongBits(dv) == Double.doubleToLongBits(0.0) || dv == 1.0) {
                this.writeOpcode(locatable, 14 + (int)dv);
            } else {
                this.writeOpcode(locatable, 20);
                this.writeConstantDoubleInfo(dv);
            }
            return IClass.DOUBLE;
        }
        if (value2 instanceof String) {
            String s2 = (String)value2;
            String[] ss = UnitCompiler.makeUtf8Able(s2);
            this.writeLdc(locatable, this.addConstantStringInfo(ss[0]));
            for (int i = 1; i < ss.length; ++i) {
                this.writeLdc(locatable, this.addConstantStringInfo(ss[i]));
                this.invoke(locatable, this.iClassLoader.METH_java_lang_String__concat__java_lang_String);
            }
            return this.iClassLoader.TYPE_java_lang_String;
        }
        if (Boolean.TRUE.equals(value2)) {
            this.writeOpcode(locatable, 4);
            return IClass.BOOLEAN;
        }
        if (Boolean.FALSE.equals(value2)) {
            this.writeOpcode(locatable, 3);
            return IClass.BOOLEAN;
        }
        if (value2 == null) {
            this.writeOpcode(locatable, 1);
            return IClass.VOID;
        }
        throw new JaninoRuntimeException("Unknown literal '" + value2 + "'");
    }

    private static int hex2Int(Java.Locatable locatable, String value2) throws CompileException {
        int result2 = 0;
        for (int i = 0; i < value2.length(); ++i) {
            if ((result2 & 0xF0000000) != 0) {
                throw UnitCompiler.compileException(locatable, "Value of hexadecimal integer literal \"" + value2 + "\" is out of range");
            }
            result2 = (result2 << 4) + Character.digit(value2.charAt(i), 16);
        }
        return result2;
    }

    private static int oct2Int(Java.Locatable locatable, String value2) throws CompileException {
        int result2 = 0;
        for (int i = 0; i < value2.length(); ++i) {
            if ((result2 & 0xE0000000) != 0) {
                throw UnitCompiler.compileException(locatable, "Value of octal integer literal '" + value2 + "' is out of range");
            }
            result2 = (result2 << 3) + Character.digit(value2.charAt(i), 8);
        }
        return result2;
    }

    private static long hex2Long(Java.Locatable locatable, String value2) throws CompileException {
        long result2 = 0L;
        for (int i = 0; i < value2.length(); ++i) {
            if ((result2 & 0xF000000000000000L) != 0L) {
                throw UnitCompiler.compileException(locatable, "Value of hexadecimal long literal \"" + value2 + "\" is out of range");
            }
            result2 = (result2 << 4) + (long)Character.digit(value2.charAt(i), 16);
        }
        return result2;
    }

    private static long oct2Long(Java.Locatable locatable, String value2) throws CompileException {
        long result2 = 0L;
        for (int i = 0; i < value2.length(); ++i) {
            if ((result2 & 0xE000000000000000L) != 0L) {
                throw UnitCompiler.compileException(locatable, "Value of octal long literal '" + value2 + "' is out of range");
            }
            result2 = (result2 << 3) + (long)Character.digit(value2.charAt(i), 8);
        }
        return result2;
    }

    private static String[] makeUtf8Able(String s2) {
        if (s2.length() < 21845) {
            return new String[]{s2};
        }
        int sLength = s2.length();
        int utfLength = 0;
        int from2 = 0;
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (true) {
            char c;
            if (i == sLength) {
                l.add(s2.substring(from2));
                break;
            }
            if (utfLength >= 65532) {
                l.add(s2.substring(from2, i));
                if (i + 21845 > sLength) {
                    l.add(s2.substring(i));
                    break;
                }
                from2 = i;
                utfLength = 0;
            }
            utfLength = (c = s2.charAt(i)) >= '\u0001' && c <= '\u007f' ? ++utfLength : (c > '\u07ff' ? (utfLength += 3) : (utfLength += 2));
            ++i;
        }
        return l.toArray(new String[l.size()]);
    }

    private void writeLdc(Java.Locatable locatable, short index2) {
        if (0 <= index2 && index2 <= 255) {
            this.writeOpcode(locatable, 18);
            this.writeByte((byte)index2);
        } else {
            this.writeOpcode(locatable, 19);
            this.writeShort(index2);
        }
    }

    private void assignmentConversion(Java.Locatable locatable, IClass sourceType, IClass targetType, Object optionalConstantValue) throws CompileException {
        if (!this.tryAssignmentConversion(locatable, sourceType, targetType, optionalConstantValue)) {
            this.compileError("Assignment conversion not possible from type \"" + sourceType + "\" to type \"" + targetType + "\"", locatable.getLocation());
        }
    }

    private boolean tryAssignmentConversion(Java.Locatable locatable, IClass sourceType, IClass targetType, Object optionalConstantValue) throws CompileException {
        IClass unboxedType;
        if (this.tryIdentityConversion(sourceType, targetType)) {
            return true;
        }
        if (this.tryWideningPrimitiveConversion(locatable, sourceType, targetType)) {
            return true;
        }
        if (this.isWideningReferenceConvertible(sourceType, targetType)) {
            return true;
        }
        IClass boxedType = this.isBoxingConvertible(sourceType);
        if (boxedType != null) {
            if (this.tryIdentityConversion(boxedType, targetType)) {
                this.boxingConversion(locatable, sourceType, boxedType);
                return true;
            }
            if (this.isWideningReferenceConvertible(boxedType, targetType)) {
                this.boxingConversion(locatable, sourceType, boxedType);
                return true;
            }
        }
        if ((unboxedType = this.isUnboxingConvertible(sourceType)) != null) {
            if (this.tryIdentityConversion(unboxedType, targetType)) {
                this.unboxingConversion(locatable, sourceType, unboxedType);
                return true;
            }
            if (this.isWideningPrimitiveConvertible(unboxedType, targetType)) {
                this.unboxingConversion(locatable, sourceType, unboxedType);
                this.tryWideningPrimitiveConversion(locatable, unboxedType, targetType);
                return true;
            }
        }
        return optionalConstantValue != NOT_CONSTANT && this.tryConstantAssignmentConversion(locatable, optionalConstantValue, targetType);
    }

    private Object assignmentConversion(Java.Locatable locatable, Object value2, IClass targetType) throws CompileException {
        if (targetType == IClass.BOOLEAN) {
            if (value2 instanceof Boolean) {
                return value2;
            }
        } else if (targetType == this.iClassLoader.TYPE_java_lang_String) {
            if (value2 instanceof String) {
                return value2;
            }
        } else if (targetType == IClass.BYTE) {
            char x;
            if (value2 instanceof Byte) {
                return value2;
            }
            if (value2 instanceof Short || value2 instanceof Integer) {
                int x2 = ((Number)value2).intValue();
                if (x2 >= -128 && x2 <= 127) {
                    return new Byte((byte)x2);
                }
            } else if (value2 instanceof Character && (x = ((Character)value2).charValue()) >= '\uffffff80' && x <= '\u007f') {
                return new Byte((byte)x);
            }
        } else if (targetType == IClass.SHORT) {
            int x;
            if (value2 instanceof Byte) {
                return new Short(((Number)value2).shortValue());
            }
            if (value2 instanceof Short) {
                return value2;
            }
            if (value2 instanceof Character) {
                char x3 = ((Character)value2).charValue();
                if (x3 >= Short.MIN_VALUE && x3 <= Short.MAX_VALUE) {
                    return new Short((short)x3);
                }
            } else if (value2 instanceof Integer && (x = ((Integer)value2).intValue()) >= Short.MIN_VALUE && x <= Short.MAX_VALUE) {
                return new Short((short)x);
            }
        } else if (targetType == IClass.CHAR) {
            int x;
            if (value2 instanceof Short) {
                return value2;
            }
            if ((value2 instanceof Byte || value2 instanceof Short || value2 instanceof Integer) && (x = ((Number)value2).intValue()) >= 0 && x <= 65535) {
                return new Character((char)x);
            }
        } else if (targetType == IClass.INT) {
            if (value2 instanceof Integer) {
                return value2;
            }
            if (value2 instanceof Byte || value2 instanceof Short) {
                return new Integer(((Number)value2).intValue());
            }
            if (value2 instanceof Character) {
                return new Integer(((Character)value2).charValue());
            }
        } else if (targetType == IClass.LONG) {
            if (value2 instanceof Long) {
                return value2;
            }
            if (value2 instanceof Byte || value2 instanceof Short || value2 instanceof Integer) {
                return new Long(((Number)value2).longValue());
            }
            if (value2 instanceof Character) {
                return new Long(((Character)value2).charValue());
            }
        } else if (targetType == IClass.FLOAT) {
            if (value2 instanceof Float) {
                return value2;
            }
            if (value2 instanceof Byte || value2 instanceof Short || value2 instanceof Integer || value2 instanceof Long) {
                return new Float(((Number)value2).floatValue());
            }
            if (value2 instanceof Character) {
                return new Float(((Character)value2).charValue());
            }
        } else if (targetType == IClass.DOUBLE) {
            if (value2 instanceof Double) {
                return value2;
            }
            if (value2 instanceof Byte || value2 instanceof Short || value2 instanceof Integer || value2 instanceof Long || value2 instanceof Float) {
                return new Double(((Number)value2).doubleValue());
            }
            if (value2 instanceof Character) {
                return new Double(((Character)value2).charValue());
            }
        } else if (value2 == null && !targetType.isPrimitive()) {
            return null;
        }
        if (value2 == null) {
            this.compileError("Cannot convert 'null' to type '" + targetType.toString() + "'", locatable.getLocation());
        } else {
            this.compileError("Cannot convert constant of type '" + value2.getClass().getName() + "' to type '" + targetType.toString() + "'", locatable.getLocation());
        }
        return value2;
    }

    private IClass unaryNumericPromotion(Java.Locatable locatable, IClass type) throws CompileException {
        type = this.convertToPrimitiveNumericType(locatable, type);
        IClass promotedType = this.unaryNumericPromotionType(locatable, type);
        this.numericPromotion(locatable, type, promotedType);
        return promotedType;
    }

    private void reverseUnaryNumericPromotion(Java.Locatable locatable, IClass sourceType, IClass targetType) throws CompileException {
        IClass pt;
        IClass unboxedType = this.isUnboxingConvertible(targetType);
        IClass iClass = pt = unboxedType != null ? unboxedType : targetType;
        if (!this.tryIdentityConversion(sourceType, pt) && !this.tryNarrowingPrimitiveConversion(locatable, sourceType, pt)) {
            throw new JaninoRuntimeException("SNO: reverse unary numeric promotion failed");
        }
        if (unboxedType != null) {
            this.boxingConversion(locatable, unboxedType, targetType);
        }
    }

    private IClass convertToPrimitiveNumericType(Java.Locatable locatable, IClass type) throws CompileException {
        if (type.isPrimitiveNumeric()) {
            return type;
        }
        IClass unboxedType = this.isUnboxingConvertible(type);
        if (unboxedType != null) {
            this.unboxingConversion(locatable, type, unboxedType);
            return unboxedType;
        }
        this.compileError("Object of type \"" + type.toString() + "\" cannot be converted to a numeric type", locatable.getLocation());
        return type;
    }

    private void numericPromotion(Java.Locatable locatable, IClass sourceType, IClass targetType) {
        if (!this.tryIdentityConversion(sourceType, targetType) && !this.tryWideningPrimitiveConversion(locatable, sourceType, targetType)) {
            throw new JaninoRuntimeException("SNO: Conversion failed");
        }
    }

    private IClass unaryNumericPromotionType(Java.Locatable locatable, IClass type) throws CompileException {
        if (!type.isPrimitiveNumeric()) {
            this.compileError("Unary numeric promotion not possible on non-numeric-primitive type \"" + type + "\"", locatable.getLocation());
        }
        return type == IClass.DOUBLE ? IClass.DOUBLE : (type == IClass.FLOAT ? IClass.FLOAT : (type == IClass.LONG ? IClass.LONG : IClass.INT));
    }

    private IClass binaryNumericPromotion(Java.Locatable locatable, IClass type1, CodeContext.Inserter convertInserter1, IClass type2) throws CompileException {
        return this.binaryNumericPromotion(locatable, type1, convertInserter1, type2, this.codeContext.currentInserter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClass binaryNumericPromotion(Java.Locatable locatable, IClass type1, CodeContext.Inserter convertInserter1, IClass type2, CodeContext.Inserter convertInserter2) throws CompileException {
        IClass c1 = this.isUnboxingConvertible(type1);
        IClass c2 = this.isUnboxingConvertible(type2);
        IClass promotedType = this.binaryNumericPromotionType(locatable, c1 != null ? c1 : type1, c2 != null ? c2 : type2);
        if (convertInserter1 != null) {
            this.codeContext.pushInserter(convertInserter1);
            try {
                this.numericPromotion(locatable, this.convertToPrimitiveNumericType(locatable, type1), promotedType);
            }
            finally {
                this.codeContext.popInserter();
            }
        }
        if (convertInserter2 != null) {
            this.codeContext.pushInserter(convertInserter2);
            try {
                this.numericPromotion(locatable, this.convertToPrimitiveNumericType(locatable, type2), promotedType);
            }
            finally {
                this.codeContext.popInserter();
            }
        }
        return promotedType;
    }

    private IClass binaryNumericPromotionType(Java.Locatable locatable, IClass type1, IClass type2) throws CompileException {
        if (!type1.isPrimitiveNumeric() || !type2.isPrimitiveNumeric()) {
            this.compileError("Binary numeric promotion not possible on types \"" + type1 + "\" and \"" + type2 + "\"", locatable.getLocation());
        }
        return type1 == IClass.DOUBLE || type2 == IClass.DOUBLE ? IClass.DOUBLE : (type1 == IClass.FLOAT || type2 == IClass.FLOAT ? IClass.FLOAT : (type1 == IClass.LONG || type2 == IClass.LONG ? IClass.LONG : IClass.INT));
    }

    private boolean isIdentityConvertible(IClass sourceType, IClass targetType) {
        return sourceType == targetType;
    }

    private boolean tryIdentityConversion(IClass sourceType, IClass targetType) {
        return sourceType == targetType;
    }

    private boolean isWideningPrimitiveConvertible(IClass sourceType, IClass targetType) {
        return PRIMITIVE_WIDENING_CONVERSIONS.get(sourceType.getDescriptor() + targetType.getDescriptor()) != null;
    }

    private boolean tryWideningPrimitiveConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) {
        byte[] opcodes2 = PRIMITIVE_WIDENING_CONVERSIONS.get(sourceType.getDescriptor() + targetType.getDescriptor());
        if (opcodes2 != null) {
            this.writeOpcodes(locatable, opcodes2);
            return true;
        }
        return false;
    }

    private static void fillConversionMap(Object[] array2, Map<String, byte[]> map2) {
        byte[] opcodes2 = null;
        for (Object o : array2) {
            if (o instanceof byte[]) {
                opcodes2 = (byte[])o;
                continue;
            }
            map2.put((String)o, opcodes2);
        }
    }

    private boolean isWideningReferenceConvertible(IClass sourceType, IClass targetType) throws CompileException {
        if (targetType.isPrimitive() || sourceType == targetType) {
            return false;
        }
        return targetType.isAssignableFrom(sourceType);
    }

    private boolean tryWideningReferenceConversion(IClass sourceType, IClass targetType) throws CompileException {
        if (targetType.isPrimitive() || sourceType == targetType) {
            return false;
        }
        return targetType.isAssignableFrom(sourceType);
    }

    private boolean isNarrowingPrimitiveConvertible(IClass sourceType, IClass targetType) {
        return PRIMITIVE_NARROWING_CONVERSIONS.containsKey(sourceType.getDescriptor() + targetType.getDescriptor());
    }

    private boolean tryNarrowingPrimitiveConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) {
        byte[] opcodes2 = PRIMITIVE_NARROWING_CONVERSIONS.get(sourceType.getDescriptor() + targetType.getDescriptor());
        if (opcodes2 != null) {
            this.writeOpcodes(locatable, opcodes2);
            return true;
        }
        return false;
    }

    private boolean tryConstantAssignmentConversion(Java.Locatable locatable, Object constantValue, IClass targetType) throws CompileException {
        int cv;
        if (constantValue instanceof Byte) {
            cv = ((Byte)constantValue).byteValue();
        } else if (constantValue instanceof Short) {
            cv = ((Short)constantValue).shortValue();
        } else if (constantValue instanceof Integer) {
            cv = (Integer)constantValue;
        } else if (constantValue instanceof Character) {
            cv = ((Character)constantValue).charValue();
        } else {
            return false;
        }
        if (targetType == IClass.BYTE) {
            return cv >= -128 && cv <= 127;
        }
        if (targetType == IClass.SHORT) {
            return cv >= Short.MIN_VALUE && cv <= Short.MAX_VALUE;
        }
        if (targetType == IClass.CHAR) {
            return cv >= 0 && cv <= 65535;
        }
        IClassLoader icl = this.iClassLoader;
        if (targetType == icl.TYPE_java_lang_Byte && cv >= -128 && cv <= 127) {
            this.boxingConversion(locatable, IClass.BYTE, targetType);
            return true;
        }
        if (targetType == icl.TYPE_java_lang_Short && cv >= Short.MIN_VALUE && cv <= Short.MAX_VALUE) {
            this.boxingConversion(locatable, IClass.SHORT, targetType);
            return true;
        }
        if (targetType == icl.TYPE_java_lang_Character && cv >= 0 && cv <= 65535) {
            this.boxingConversion(locatable, IClass.CHAR, targetType);
            return true;
        }
        return false;
    }

    private boolean isNarrowingReferenceConvertible(IClass sourceType, IClass targetType) throws CompileException {
        IClass tt;
        IClass st;
        if (sourceType.isPrimitive()) {
            return false;
        }
        if (sourceType == targetType) {
            return false;
        }
        if (sourceType.isAssignableFrom(targetType)) {
            return true;
        }
        if (targetType.isInterface() && !sourceType.isFinal() && !targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (sourceType == this.iClassLoader.TYPE_java_lang_Object && targetType.isArray()) {
            return true;
        }
        if (sourceType == this.iClassLoader.TYPE_java_lang_Object && targetType.isInterface()) {
            return true;
        }
        if (sourceType.isInterface() && !targetType.isFinal()) {
            return true;
        }
        if (sourceType.isInterface() && targetType.isFinal() && sourceType.isAssignableFrom(targetType)) {
            return true;
        }
        if (sourceType.isInterface() && targetType.isInterface() && !targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        return sourceType.isArray() && targetType.isArray() && (this.isNarrowingPrimitiveConvertible(st = sourceType.getComponentType(), tt = targetType.getComponentType()) || this.isNarrowingReferenceConvertible(st, tt));
    }

    private boolean tryNarrowingReferenceConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) throws CompileException {
        if (!this.isNarrowingReferenceConvertible(sourceType, targetType)) {
            return false;
        }
        this.writeOpcode(locatable, -64);
        this.writeConstantClassInfo(targetType.getDescriptor());
        return true;
    }

    private boolean isCastReferenceConvertible(IClass sourceType, IClass targetType) throws CompileException {
        return this.isIdentityConvertible(sourceType, targetType) || this.isWideningReferenceConvertible(sourceType, targetType) || this.isNarrowingReferenceConvertible(sourceType, targetType);
    }

    private IClass isBoxingConvertible(IClass sourceType) {
        IClassLoader icl = this.iClassLoader;
        if (sourceType == IClass.BOOLEAN) {
            return icl.TYPE_java_lang_Boolean;
        }
        if (sourceType == IClass.BYTE) {
            return icl.TYPE_java_lang_Byte;
        }
        if (sourceType == IClass.CHAR) {
            return icl.TYPE_java_lang_Character;
        }
        if (sourceType == IClass.SHORT) {
            return icl.TYPE_java_lang_Short;
        }
        if (sourceType == IClass.INT) {
            return icl.TYPE_java_lang_Integer;
        }
        if (sourceType == IClass.LONG) {
            return icl.TYPE_java_lang_Long;
        }
        if (sourceType == IClass.FLOAT) {
            return icl.TYPE_java_lang_Float;
        }
        if (sourceType == IClass.DOUBLE) {
            return icl.TYPE_java_lang_Double;
        }
        return null;
    }

    private boolean tryBoxingConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) throws CompileException {
        if (this.isBoxingConvertible(sourceType) == targetType) {
            this.boxingConversion(locatable, sourceType, targetType);
            return true;
        }
        return false;
    }

    private void boxingConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) throws CompileException {
        if (targetType.hasIMethod("valueOf", new IClass[]{sourceType})) {
            this.writeOpcode(locatable, -72);
            this.writeConstantMethodrefInfo(targetType.getDescriptor(), "valueOf", '(' + sourceType.getDescriptor() + ')' + targetType.getDescriptor());
            return;
        }
        this.writeOpcode(locatable, -69);
        this.writeConstantClassInfo(targetType.getDescriptor());
        if (Descriptor.hasSize2(sourceType.getDescriptor())) {
            this.writeOpcode(locatable, 91);
            this.writeOpcode(locatable, 91);
            this.writeOpcode(locatable, 87);
        } else {
            this.writeOpcode(locatable, 90);
            this.writeOpcode(locatable, 95);
        }
        this.writeOpcode(locatable, -73);
        this.writeConstantMethodrefInfo(targetType.getDescriptor(), "<init>", '(' + sourceType.getDescriptor() + ')' + "V");
    }

    private IClass isUnboxingConvertible(IClass sourceType) {
        IClassLoader icl = this.iClassLoader;
        if (sourceType == icl.TYPE_java_lang_Boolean) {
            return IClass.BOOLEAN;
        }
        if (sourceType == icl.TYPE_java_lang_Byte) {
            return IClass.BYTE;
        }
        if (sourceType == icl.TYPE_java_lang_Character) {
            return IClass.CHAR;
        }
        if (sourceType == icl.TYPE_java_lang_Short) {
            return IClass.SHORT;
        }
        if (sourceType == icl.TYPE_java_lang_Integer) {
            return IClass.INT;
        }
        if (sourceType == icl.TYPE_java_lang_Long) {
            return IClass.LONG;
        }
        if (sourceType == icl.TYPE_java_lang_Float) {
            return IClass.FLOAT;
        }
        if (sourceType == icl.TYPE_java_lang_Double) {
            return IClass.DOUBLE;
        }
        return null;
    }

    private boolean tryUnboxingConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) {
        if (this.isUnboxingConvertible(sourceType) == targetType) {
            this.unboxingConversion(locatable, sourceType, targetType);
            return true;
        }
        return false;
    }

    private void unboxingConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) {
        this.writeOpcode(locatable, -74);
        this.writeConstantMethodrefInfo(sourceType.getDescriptor(), targetType.toString() + "Value", "()" + targetType.getDescriptor());
    }

    private IClass findTypeByFullyQualifiedName(Location location, String[] identifiers) throws CompileException {
        String className = Java.join(identifiers, ".");
        while (true) {
            IClass iClass;
            if ((iClass = this.findTypeByName(location, className)) != null) {
                return iClass;
            }
            int idx = className.lastIndexOf(46);
            if (idx == -1) break;
            className = className.substring(0, idx) + '$' + className.substring(idx + 1);
        }
        return null;
    }

    private IClass load(Java.Locatable locatable, Java.LocalVariable localVariable) {
        this.load(locatable, localVariable.type, localVariable.getSlotIndex());
        return localVariable.type;
    }

    private void load(Java.Locatable locatable, IClass type, int index2) {
        if (index2 <= 3) {
            this.writeOpcode(locatable, 26 + 4 * UnitCompiler.ilfda(type) + index2);
        } else if (index2 <= 255) {
            this.writeOpcode(locatable, 21 + UnitCompiler.ilfda(type));
            this.writeByte(index2);
        } else {
            this.writeOpcode(locatable, -60);
            this.writeOpcode(locatable, 21 + UnitCompiler.ilfda(type));
            this.writeShort(index2);
        }
    }

    private void store(Java.Locatable locatable, Java.LocalVariable localVariable) {
        this.store(locatable, localVariable.type, localVariable.getSlotIndex());
    }

    private void store(Java.Locatable locatable, IClass lvType, short lvIndex) {
        if (lvIndex <= 3) {
            this.writeOpcode(locatable, 59 + 4 * UnitCompiler.ilfda(lvType) + lvIndex);
        } else if (lvIndex <= 255) {
            this.writeOpcode(locatable, 54 + UnitCompiler.ilfda(lvType));
            this.writeByte(lvIndex);
        } else {
            this.writeOpcode(locatable, -60);
            this.writeOpcode(locatable, 54 + UnitCompiler.ilfda(lvType));
            this.writeShort(lvIndex);
        }
    }

    private void getfield(Java.Locatable locatable, IClass.IField iField) throws CompileException {
        this.writeOpcode(locatable, iField.isStatic() ? -78 : -76);
        this.writeConstantFieldrefInfo(iField.getDeclaringIClass().getDescriptor(), iField.getName(), iField.getDescriptor());
    }

    private void putfield(Java.Locatable locatable, IClass.IField iField) throws CompileException {
        this.writeOpcode(locatable, iField.isStatic() ? -77 : -75);
        this.writeConstantFieldrefInfo(iField.getDeclaringIClass().getDescriptor(), iField.getName(), iField.getDescriptor());
    }

    private void dup(Java.Locatable locatable, int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.writeOpcode(locatable, 89);
                break;
            }
            case 2: {
                this.writeOpcode(locatable, 92);
                break;
            }
            default: {
                throw new JaninoRuntimeException("dup(" + n + ")");
            }
        }
    }

    private void dupx(Java.Locatable locatable, IClass type, int x) {
        if (x < 0 || x > 2) {
            throw new JaninoRuntimeException("SNO: x has value " + x);
        }
        int dup = 89 + x;
        int dup2 = 92 + x;
        this.writeOpcode(locatable, type == IClass.LONG || type == IClass.DOUBLE ? dup2 : dup);
    }

    private void pop(Java.Locatable locatable, IClass type) {
        if (type == IClass.VOID) {
            return;
        }
        this.writeOpcode(locatable, type == IClass.LONG || type == IClass.DOUBLE ? 88 : 87);
    }

    private static int ilfd(IClass t) {
        if (t == IClass.BYTE || t == IClass.CHAR || t == IClass.INT || t == IClass.SHORT || t == IClass.BOOLEAN) {
            return 0;
        }
        if (t == IClass.LONG) {
            return 1;
        }
        if (t == IClass.FLOAT) {
            return 2;
        }
        if (t == IClass.DOUBLE) {
            return 3;
        }
        throw new JaninoRuntimeException("Unexpected type \"" + t + "\"");
    }

    private static int ilfd(IClass t, int opcodeInt, int opcodeLong, int opcodeFloat, int opcodeDouble) {
        if (t == IClass.BYTE || t == IClass.CHAR || t == IClass.INT || t == IClass.SHORT || t == IClass.BOOLEAN) {
            return opcodeInt;
        }
        if (t == IClass.LONG) {
            return opcodeLong;
        }
        if (t == IClass.FLOAT) {
            return opcodeFloat;
        }
        if (t == IClass.DOUBLE) {
            return opcodeDouble;
        }
        throw new JaninoRuntimeException("Unexpected type \"" + t + "\"");
    }

    private static int ilfda(IClass t) {
        return !t.isPrimitive() ? 4 : UnitCompiler.ilfd(t);
    }

    private static int ilfdabcs(IClass t) {
        if (t == IClass.INT) {
            return 0;
        }
        if (t == IClass.LONG) {
            return 1;
        }
        if (t == IClass.FLOAT) {
            return 2;
        }
        if (t == IClass.DOUBLE) {
            return 3;
        }
        if (!t.isPrimitive()) {
            return 4;
        }
        if (t == IClass.BOOLEAN) {
            return 5;
        }
        if (t == IClass.BYTE) {
            return 5;
        }
        if (t == IClass.CHAR) {
            return 6;
        }
        if (t == IClass.SHORT) {
            return 7;
        }
        throw new JaninoRuntimeException("Unexpected type \"" + t + "\"");
    }

    private void invoke(Java.Locatable locatable, IClass.IMethod iMethod) throws CompileException {
        if (iMethod.getDeclaringIClass().isInterface()) {
            this.writeOpcode(locatable, -71);
            this.writeConstantInterfaceMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName(), iMethod.getDescriptor());
            int count2 = 1;
            for (IClass pt : iMethod.getParameterTypes()) {
                count2 += Descriptor.size(pt.getDescriptor());
            }
            this.writeByte(count2);
            this.writeByte(0);
        } else {
            this.writeOpcode(locatable, iMethod.isStatic() ? -72 : -74);
            this.writeConstantMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName(), iMethod.getDescriptor());
        }
    }

    private void invoke(Java.Locatable locatable, IClass.IConstructor iConstructor) throws CompileException {
        this.writeOpcode(locatable, -73);
        this.writeConstantMethodrefInfo(iConstructor.getDeclaringIClass().getDescriptor(), "<init>", iConstructor.getDescriptor());
    }

    private IClass.IField findIField(IClass iClass, String name2, Location location) throws CompileException {
        IClass[] ifs;
        IClass.IField f2 = iClass.getDeclaredIField(name2);
        if (f2 != null) {
            return f2;
        }
        IClass superclass = iClass.getSuperclass();
        if (superclass != null) {
            f2 = this.findIField(superclass, name2, location);
        }
        for (IClass iF : ifs = iClass.getInterfaces()) {
            IClass.IField f22 = this.findIField(iF, name2, location);
            if (f22 == null) continue;
            if (f2 != null) {
                throw new CompileException("Access to field \"" + name2 + "\" is ambiguous - both \"" + f2.getDeclaringIClass() + "\" and \"" + f22.getDeclaringIClass() + "\" declare it", location);
            }
            f2 = f22;
        }
        return f2;
    }

    private IClass findMemberType(IClass iClass, String name2, Location location) throws CompileException {
        IClass[] types2 = iClass.findMemberType(name2);
        if (types2.length == 0) {
            return null;
        }
        if (types2.length == 1) {
            return types2[0];
        }
        StringBuilder sb = new StringBuilder("Type \"").append(name2).append("\" is ambiguous: ").append(types2[0]);
        for (int i = 1; i < types2.length; ++i) {
            sb.append(" vs. ").append(types2[i].toString());
        }
        this.compileError(sb.toString(), location);
        return types2[0];
    }

    public IClass findClass(String className) {
        StringTokenizer st;
        Java.NamedTypeDeclaration td;
        String packageName;
        String string2 = packageName = this.compilationUnit.optionalPackageDeclaration == null ? null : this.compilationUnit.optionalPackageDeclaration.packageName;
        if (packageName != null) {
            if (!className.startsWith(packageName + '.')) {
                return null;
            }
            className = className.substring(packageName.length() + 1);
        }
        if ((td = this.compilationUnit.getPackageMemberTypeDeclaration((st = new StringTokenizer(className, "$")).nextToken())) == null) {
            return null;
        }
        while (st.hasMoreTokens()) {
            if ((td = td.getMemberTypeDeclaration(st.nextToken())) != null) continue;
            return null;
        }
        return this.resolve(td);
    }

    private void compileError(String message) throws CompileException {
        this.compileError(message, null);
    }

    private void compileError(String message, Location optionalLocation) throws CompileException {
        ++this.compileErrorCount;
        if (this.optionalCompileErrorHandler == null) {
            throw new CompileException(message, optionalLocation);
        }
        this.optionalCompileErrorHandler.handleError(message, optionalLocation);
    }

    private void warning(String handle, String message, Location optionalLocation) throws CompileException {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(handle, message, optionalLocation);
        }
    }

    public void setCompileErrorHandler(ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    public void setWarningHandler(WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    private CodeContext getCodeContext() {
        CodeContext res = this.codeContext;
        if (res == null) {
            throw new JaninoRuntimeException("S.N.O.: Null CodeContext");
        }
        return res;
    }

    private CodeContext replaceCodeContext(CodeContext newCodeContext) {
        CodeContext oldCodeContext = this.codeContext;
        this.codeContext = newCodeContext;
        return oldCodeContext;
    }

    private CodeContext createDummyCodeContext() {
        return new CodeContext(this.getCodeContext().getClassFile());
    }

    private void writeByte(int v) {
        if (v > 255) {
            throw new JaninoRuntimeException("Byte value out of legal range");
        }
        this.codeContext.write((short)-1, (byte)v);
    }

    private void writeShort(int v) {
        if (v > 65535) {
            throw new JaninoRuntimeException("Short value out of legal range");
        }
        this.codeContext.write((short)-1, (byte)(v >> 8), (byte)v);
    }

    private void writeInt(int v) {
        this.codeContext.write((short)-1, (byte)(v >> 24), (byte)(v >> 16), (byte)(v >> 8), (byte)v);
    }

    private void writeOpcode(Java.Locatable locatable, int opcode) {
        this.codeContext.write(locatable.getLocation().getLineNumber(), (byte)opcode);
    }

    private void writeOpcodes(Java.Locatable locatable, byte[] opcodes2) {
        this.codeContext.write(locatable.getLocation().getLineNumber(), opcodes2);
    }

    private void writeBranch(Java.Locatable locatable, int opcode, CodeContext.Offset dst) {
        this.codeContext.writeBranch(locatable.getLocation().getLineNumber(), opcode, dst);
    }

    private void writeOffset(CodeContext.Offset src, CodeContext.Offset dst) {
        this.codeContext.writeOffset((short)-1, src, dst);
    }

    private void writeConstantClassInfo(String descriptor) {
        CodeContext ca = this.codeContext;
        ca.writeShort((short)-1, ca.getClassFile().addConstantClassInfo(descriptor));
    }

    private void writeConstantFieldrefInfo(String classFd, String fieldName, String fieldFd) {
        CodeContext ca = this.codeContext;
        ca.writeShort((short)-1, ca.getClassFile().addConstantFieldrefInfo(classFd, fieldName, fieldFd));
    }

    private void writeConstantMethodrefInfo(String classFd, String methodName, String methodMd) {
        CodeContext ca = this.codeContext;
        ca.writeShort((short)-1, ca.getClassFile().addConstantMethodrefInfo(classFd, methodName, methodMd));
    }

    private void writeConstantInterfaceMethodrefInfo(String classFd, String methodName, String methodMd) {
        CodeContext ca = this.codeContext;
        ca.writeShort((short)-1, ca.getClassFile().addConstantInterfaceMethodrefInfo(classFd, methodName, methodMd));
    }

    private short addConstantStringInfo(String value2) {
        return this.codeContext.getClassFile().addConstantStringInfo(value2);
    }

    private short addConstantIntegerInfo(int value2) {
        return this.codeContext.getClassFile().addConstantIntegerInfo(value2);
    }

    private short addConstantFloatInfo(float value2) {
        return this.codeContext.getClassFile().addConstantFloatInfo(value2);
    }

    private void writeConstantLongInfo(long value2) {
        CodeContext ca = this.codeContext;
        ca.writeShort((short)-1, ca.getClassFile().addConstantLongInfo(value2));
    }

    private void writeConstantDoubleInfo(double value2) {
        CodeContext ca = this.codeContext;
        ca.writeShort((short)-1, ca.getClassFile().addConstantDoubleInfo(value2));
    }

    private CodeContext.Offset getWhereToBreak(Java.BreakableStatement bs) {
        if (bs.whereToBreak == null) {
            bs.whereToBreak = this.codeContext.new CodeContext.Offset();
        }
        return bs.whereToBreak;
    }

    private Java.TypeBodyDeclaration getDeclaringTypeBodyDeclaration(Java.QualifiedThisReference qtr) throws CompileException {
        if (qtr.declaringTypeBodyDeclaration == null) {
            Java.Scope s2 = qtr.getEnclosingBlockStatement();
            while (!(s2 instanceof Java.TypeBodyDeclaration)) {
                s2 = s2.getEnclosingScope();
            }
            qtr.declaringTypeBodyDeclaration = (Java.TypeBodyDeclaration)s2;
            if (qtr.declaringTypeBodyDeclaration.isStatic()) {
                this.compileError("No current instance available in static method", qtr.getLocation());
            }
            qtr.declaringClass = (Java.ClassDeclaration)qtr.declaringTypeBodyDeclaration.getDeclaringType();
        }
        return qtr.declaringTypeBodyDeclaration;
    }

    private Java.ClassDeclaration getDeclaringClass(Java.QualifiedThisReference qtr) throws CompileException {
        if (qtr.declaringClass == null) {
            this.getDeclaringTypeBodyDeclaration(qtr);
        }
        return qtr.declaringClass;
    }

    private void referenceThis(Java.Locatable locatable) {
        this.writeOpcode(locatable, 42);
    }

    private IClass newArray(Java.Locatable locatable, int dimExprCount, int dims, IClass componentType) {
        if (dimExprCount == 1 && dims == 0 && componentType.isPrimitive()) {
            this.writeOpcode(locatable, -68);
            this.writeByte(componentType == IClass.BOOLEAN ? 4 : (componentType == IClass.CHAR ? 5 : (componentType == IClass.FLOAT ? 6 : (componentType == IClass.DOUBLE ? 7 : (componentType == IClass.BYTE ? 8 : (componentType == IClass.SHORT ? 9 : (componentType == IClass.INT ? 10 : (componentType == IClass.LONG ? 11 : -1))))))));
            return componentType.getArrayIClass(this.iClassLoader.TYPE_java_lang_Object);
        }
        if (dimExprCount == 1) {
            IClass at = componentType.getArrayIClass(dims, this.iClassLoader.TYPE_java_lang_Object);
            this.writeOpcode(locatable, -67);
            this.writeConstantClassInfo(at.getDescriptor());
            return at.getArrayIClass(this.iClassLoader.TYPE_java_lang_Object);
        }
        IClass at = componentType.getArrayIClass(dimExprCount + dims, this.iClassLoader.TYPE_java_lang_Object);
        this.writeOpcode(locatable, -59);
        this.writeConstantClassInfo(at.getDescriptor());
        this.writeByte(dimExprCount);
        return at;
    }

    private static Access modifiers2Access(short modifiers) {
        return Mod.isPublicAccess(modifiers) ? Access.PUBLIC : (Mod.isProtectedAccess(modifiers) ? Access.PROTECTED : (Mod.isPrivateAccess(modifiers) ? Access.PRIVATE : Access.DEFAULT));
    }

    private static String last(String[] sa) {
        if (sa.length == 0) {
            throw new IllegalArgumentException("SNO: Empty string array");
        }
        return sa[sa.length - 1];
    }

    private static String[] allButLast(String[] sa) {
        if (sa.length == 0) {
            throw new IllegalArgumentException("SNO: Empty string array");
        }
        String[] tmp = new String[sa.length - 1];
        System.arraycopy(sa, 0, tmp, 0, tmp.length);
        return tmp;
    }

    private static String[] concat(String[] sa, String s2) {
        String[] tmp = new String[sa.length + 1];
        System.arraycopy(sa, 0, tmp, 0, sa.length);
        tmp[sa.length] = s2;
        return tmp;
    }

    private static CompileException compileException(Java.Locatable locatable, String message) {
        return new CompileException(message, locatable.getLocation());
    }

    private static String unescape(String s2) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s2.length()) {
            int secondDigit;
            int idx;
            char c;
            if ((c = s2.charAt(i++)) != '\\') {
                sb.append(c);
                continue;
            }
            if ((idx = "btnfr\"'\\".indexOf(c = s2.charAt(i++))) != -1) {
                sb.append("\b\t\n\f\r\"'\\".charAt(idx));
                continue;
            }
            int x = Character.digit(c, 8);
            if (x == -1) {
                throw new JaninoRuntimeException("Invalid escape sequence '\\" + c + "'");
            }
            if (i < s2.length() && (secondDigit = Character.digit(c = s2.charAt(i), 8)) != -1) {
                int thirdDigit;
                x = 8 * x + secondDigit;
                if (++i < s2.length() && x <= 31 && (thirdDigit = Character.digit(c, 8)) != -1) {
                    x = 8 * x + thirdDigit;
                    ++i;
                }
            }
            sb.append((char)x);
        }
        return sb.toString();
    }

    static {
        UnitCompiler.fillConversionMap(new Object[]{new byte[0], "BS", "BI", "SI", "CI", new byte[]{-123}, "BJ", "SJ", "CJ", "IJ", new byte[]{-122}, "BF", "SF", "CF", "IF", new byte[]{-119}, "JF", new byte[]{-121}, "BD", "SD", "CD", "ID", new byte[]{-118}, "JD", new byte[]{-115}, "FD"}, PRIMITIVE_WIDENING_CONVERSIONS);
        PRIMITIVE_NARROWING_CONVERSIONS = new HashMap<String, byte[]>();
        UnitCompiler.fillConversionMap(new Object[]{new byte[0], "BC", "SC", "CS", new byte[]{-111}, "SB", "CB", "IB", new byte[]{-109}, "IS", "IC", new byte[]{-120, -111}, "JB", new byte[]{-120, -109}, "JS", "JC", new byte[]{-120}, "JI", new byte[]{-117, -111}, "FB", new byte[]{-117, -109}, "FS", "FC", new byte[]{-117}, "FI", new byte[]{-116}, "FJ", new byte[]{-114, -111}, "DB", new byte[]{-114, -109}, "DS", "DC", new byte[]{-114}, "DI", new byte[]{-113}, "DJ", new byte[]{-112}, "DF"}, PRIMITIVE_NARROWING_CONVERSIONS);
    }

    public static class SimpleIField
    extends IClass.IField {
        private final String name;
        private final IClass type;

        public SimpleIField(IClass declaringIClass, String name2, IClass type) {
            this.name = name2;
            this.type = type;
        }

        @Override
        public Object getConstantValue() {
            return NOT_CONSTANT;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IClass getType() {
            return this.type;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Access getAccess() {
            return Access.DEFAULT;
        }

        @Override
        public Java.Annotation[] getAnnotations() {
            return new Java.Annotation[0];
        }
    }

    static interface Compilable {
        public void compile() throws CompileException;
    }
}

