/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Cookable;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.ISimpleCompiler;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.janino.ByteArrayClassLoader;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.ReflectionIClass;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.util.ClassFile;

public class SimpleCompiler
extends Cookable
implements ISimpleCompiler {
    private static final boolean DEBUG = false;
    private ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
    private ClassLoaderIClassLoader classLoaderIClassLoader;
    private ClassLoader result;
    private ErrorHandler optionalCompileErrorHandler;
    private WarningHandler optionalWarningHandler;
    private boolean debugSource;
    private boolean debugLines = this.debugSource = Boolean.getBoolean("org.codehaus.janino.source_debugging.enable");
    private boolean debugVars = this.debugSource;

    public static void main(String[] args2) throws Exception {
        if (args2.length >= 1 && "-help".equals(args2[0])) {
            System.out.println("Usage:");
            System.out.println("    org.codehaus.janino.SimpleCompiler <source-file> <class-name> { <argument> }");
            System.out.println("Reads a compilation unit from the given <source-file> and invokes method");
            System.out.println("\"public static void main(String[])\" of class <class-name>, passing the");
            System.out.println("given <argument>s.");
            System.exit(1);
        }
        if (args2.length < 2) {
            System.err.println("Source file and/or class name missing; try \"-help\".");
            System.exit(1);
        }
        String sourceFileName = args2[0];
        String className = args2[1];
        String[] arguments = new String[args2.length - 2];
        System.arraycopy(args2, 2, arguments, 0, arguments.length);
        ClassLoader cl = new SimpleCompiler(sourceFileName, new FileInputStream(sourceFileName)).getClassLoader();
        Class<?> c = cl.loadClass(className);
        Method m = c.getMethod("main", String[].class);
        m.invoke(null, new Object[]{arguments});
    }

    public SimpleCompiler(String optionalFileName, Reader in) throws IOException, CompileException {
        this.cook(optionalFileName, in);
    }

    public SimpleCompiler(String optionalFileName, InputStream is) throws IOException, CompileException {
        this.cook(optionalFileName, is);
    }

    public SimpleCompiler(String fileName) throws IOException, CompileException {
        this.cookFile(fileName);
    }

    public SimpleCompiler(Scanner scanner, ClassLoader optionalParentClassLoader) throws IOException, CompileException {
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public SimpleCompiler() {
    }

    @Override
    public void setParentClassLoader(ClassLoader optionalParentClassLoader) {
        this.assertNotCooked();
        this.parentClassLoader = optionalParentClassLoader != null ? optionalParentClassLoader : Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void setDebuggingInformation(boolean debugSource, boolean debugLines, boolean debugVars) {
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
    }

    @Override
    public final void cook(String optionalFileName, Reader r) throws CompileException, IOException {
        this.cook(new Scanner(optionalFileName, r));
    }

    public void cook(Scanner scanner) throws CompileException, IOException {
        this.compileToClassLoader(new Parser(scanner).parseCompilationUnit());
    }

    public void cook(Java.CompilationUnit compilationUnit2) throws CompileException {
        this.compileToClassLoader(compilationUnit2);
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.getClass() != SimpleCompiler.class) {
            throw new IllegalStateException("Must not be called on derived instances");
        }
        if (this.result == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        return this.result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimpleCompiler)) {
            return false;
        }
        SimpleCompiler that = (SimpleCompiler)o;
        if (this.getClass() != that.getClass()) {
            return false;
        }
        if (this.result == null || that.result == null) {
            throw new IllegalStateException("Equality can only be checked after cooking");
        }
        return this.result.equals(that.result);
    }

    public int hashCode() {
        return this.parentClassLoader.hashCode();
    }

    @Override
    public void setCompileErrorHandler(ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    @Override
    public void setWarningHandler(WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    protected Java.Type classToType(final Location location, final Class clazz2) {
        if (clazz2 == null) {
            return null;
        }
        return new Java.Type(location){
            private Java.SimpleType delegate;

            @Override
            public String toString() {
                return this.getDelegate().toString();
            }

            @Override
            public void accept(Visitor.AtomVisitor visitor) {
                this.getDelegate().accept((Visitor.TypeVisitor)visitor);
            }

            @Override
            public void accept(Visitor.TypeVisitor visitor) {
                this.getDelegate().accept(visitor);
            }

            private Java.Type getDelegate() {
                if (this.delegate == null) {
                    IClass iClass;
                    try {
                        iClass = SimpleCompiler.this.classLoaderIClassLoader.loadIClass(Descriptor.fromClassName(clazz2.getName()));
                    }
                    catch (ClassNotFoundException ex) {
                        throw new JaninoRuntimeException("Loading IClass \"" + clazz2.getName() + "\": " + ex);
                    }
                    if (iClass == null) {
                        throw new JaninoRuntimeException("Cannot load class '" + clazz2.getName() + "' through the parent loader");
                    }
                    if (!clazz2.isPrimitive() && ((ReflectionIClass)iClass).getClazz() != clazz2) {
                        throw new JaninoRuntimeException("Class '" + clazz2.getName() + "' was loaded through a different loader");
                    }
                    this.delegate = new Java.SimpleType(location, iClass);
                }
                return this.delegate;
            }
        };
    }

    protected Java.Type[] classesToTypes(Location location, Class[] classes2) {
        Java.Type[] types2 = new Java.Type[classes2.length];
        for (int i = 0; i < classes2.length; ++i) {
            types2[i] = this.classToType(location, classes2[i]);
        }
        return types2;
    }

    protected final ClassLoader compileToClassLoader(Java.CompilationUnit compilationUnit2) throws CompileException {
        this.classLoaderIClassLoader = new ClassLoaderIClassLoader(this.parentClassLoader);
        UnitCompiler unitCompiler = new UnitCompiler(compilationUnit2, this.classLoaderIClassLoader);
        unitCompiler.setCompileErrorHandler(this.optionalCompileErrorHandler);
        unitCompiler.setWarningHandler(this.optionalWarningHandler);
        ClassFile[] classFiles = unitCompiler.compileUnit(this.debugSource, this.debugLines, this.debugVars);
        final HashMap<String, byte[]> classes2 = new HashMap<String, byte[]>();
        for (ClassFile cf : classFiles) {
            byte[] contents = cf.toByteArray();
            classes2.put(cf.getThisClassName(), contents);
        }
        this.result = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ByteArrayClassLoader(classes2, SimpleCompiler.this.parentClassLoader);
            }
        });
        return this.result;
    }

    protected void assertNotCooked() {
        if (this.classLoaderIClassLoader != null) {
            throw new IllegalStateException("Already cooked");
        }
    }
}

