/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.codehaus.commons.compiler.AbstractJavaSourceClassLoader;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.JavaSourceIClassLoader;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.resource.DirectoryResourceFinder;
import org.codehaus.janino.util.resource.PathResourceFinder;
import org.codehaus.janino.util.resource.ResourceFinder;

public class JavaSourceClassLoader
extends AbstractJavaSourceClassLoader {
    private final Map<String, byte[]> precompiledClasses = new HashMap<String, byte[]>();
    private final JavaSourceIClassLoader iClassLoader;
    private boolean debugSource;
    private boolean debugLines = this.debugSource = Boolean.getBoolean("org.codehaus.janino.source_debugging.enable");
    private boolean debugVars = this.debugSource;

    public JavaSourceClassLoader() {
        this(ClassLoader.getSystemClassLoader());
    }

    public JavaSourceClassLoader(ClassLoader parentClassLoader) {
        this(parentClassLoader, (File[])null, null);
    }

    public JavaSourceClassLoader(ClassLoader parentClassLoader, File[] optionalSourcePath, String optionalCharacterEncoding) {
        this(parentClassLoader, optionalSourcePath == null ? new DirectoryResourceFinder(new File(".")) : new PathResourceFinder(optionalSourcePath), optionalCharacterEncoding);
    }

    public JavaSourceClassLoader(ClassLoader parentClassLoader, ResourceFinder sourceFinder, String optionalCharacterEncoding) {
        this(parentClassLoader, new JavaSourceIClassLoader(sourceFinder, optionalCharacterEncoding, new ClassLoaderIClassLoader(parentClassLoader)));
    }

    public JavaSourceClassLoader(ClassLoader parentClassLoader, JavaSourceIClassLoader iClassLoader) {
        super(parentClassLoader);
        this.iClassLoader = iClassLoader;
    }

    @Override
    public void setSourcePath(File[] sourcePath) {
        this.iClassLoader.setSourceFinder(new PathResourceFinder(sourcePath));
    }

    @Override
    public void setSourceFileCharacterEncoding(String optionalCharacterEncoding) {
        this.iClassLoader.setCharacterEncoding(optionalCharacterEncoding);
    }

    @Override
    public void setDebuggingInfo(boolean debugSource, boolean debugLines, boolean debugVars) {
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
    }

    public void setCompileErrorHandler(ErrorHandler optionalCompileErrorHandler) {
        this.iClassLoader.setCompileErrorHandler(optionalCompileErrorHandler);
    }

    public void setWarningHandler(WarningHandler optionalWarningHandler) {
        this.iClassLoader.setWarningHandler(optionalWarningHandler);
    }

    protected Class findClass(String name2) throws ClassNotFoundException {
        byte[] bytecode = this.precompiledClasses.remove(name2);
        if (bytecode == null) {
            Map<String, byte[]> bytecodes = this.generateBytecodes(name2);
            if (bytecodes == null) {
                throw new ClassNotFoundException(name2);
            }
            this.precompiledClasses.putAll(bytecodes);
            bytecode = this.precompiledClasses.remove(name2);
            if (bytecode == null) {
                throw new JaninoRuntimeException("SNO: Scanning, parsing and compiling class \"" + name2 + "\" did not create a class file!?");
            }
        }
        return this.defineBytecode(name2, bytecode);
    }

    protected Map<String, byte[]> generateBytecodes(String name2) throws ClassNotFoundException {
        if (this.iClassLoader.loadIClass(Descriptor.fromClassName(name2)) == null) {
            return null;
        }
        HashMap<String, byte[]> bytecodes = new HashMap<String, byte[]>();
        HashSet<UnitCompiler> compiledUnitCompilers = new HashSet<UnitCompiler>();
        block2: while (true) {
            for (UnitCompiler uc : this.iClassLoader.getUnitCompilers()) {
                ClassFile[] cfs;
                if (compiledUnitCompilers.contains(uc)) continue;
                try {
                    cfs = uc.compileUnit(this.debugSource, this.debugLines, this.debugVars);
                }
                catch (CompileException ex) {
                    throw new ClassNotFoundException(ex.getMessage(), ex);
                }
                for (ClassFile cf : cfs) {
                    bytecodes.put(cf.getThisClassName(), cf.toByteArray());
                }
                compiledUnitCompilers.add(uc);
                continue block2;
            }
            break;
        }
        return bytecodes;
    }

    private Class defineBytecode(String className, byte[] ba) {
        return this.defineClass(className, ba, 0, ba.length, this.optionalProtectionDomainFactory == null ? null : this.optionalProtectionDomainFactory.getProtectionDomain(ClassFile.getSourceResourceName(className)));
    }
}

