/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.sym;

import java.util.Arrays;
import org.codehaus.jackson.util.InternCache;

public final class CharsToNameCanonicalizer {
    protected static final int DEFAULT_TABLE_SIZE = 64;
    protected static final int MAX_TABLE_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final CharsToNameCanonicalizer sBootstrapSymbolTable = new CharsToNameCanonicalizer();
    protected CharsToNameCanonicalizer _parent;
    protected final boolean _intern;
    protected final boolean _canonicalize;
    protected String[] _symbols;
    protected Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected boolean _dirty;

    public static CharsToNameCanonicalizer createRoot() {
        return sBootstrapSymbolTable.makeOrphan();
    }

    private CharsToNameCanonicalizer() {
        this._canonicalize = true;
        this._intern = true;
        this._dirty = true;
        this.initTables(64);
    }

    private void initTables(int initialSize) {
        this._symbols = new String[initialSize];
        this._buckets = new Bucket[initialSize >> 1];
        this._indexMask = initialSize - 1;
        this._size = 0;
        this._sizeThreshold = initialSize - (initialSize >> 2);
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer parent, boolean canonicalize, boolean intern, String[] symbols2, Bucket[] buckets2, int size2) {
        this._parent = parent;
        this._canonicalize = canonicalize;
        this._intern = intern;
        this._symbols = symbols2;
        this._buckets = buckets2;
        this._size = size2;
        int arrayLen = symbols2.length;
        this._sizeThreshold = arrayLen - (arrayLen >> 2);
        this._indexMask = arrayLen - 1;
        this._dirty = false;
    }

    public synchronized CharsToNameCanonicalizer makeChild(boolean canonicalize, boolean intern) {
        return new CharsToNameCanonicalizer(this, canonicalize, intern, this._symbols, this._buckets, this._size);
    }

    private CharsToNameCanonicalizer makeOrphan() {
        return new CharsToNameCanonicalizer(null, true, true, this._symbols, this._buckets, this._size);
    }

    private synchronized void mergeChild(CharsToNameCanonicalizer child) {
        if (child.size() > 12000) {
            this.initTables(64);
        } else {
            if (child.size() <= this.size()) {
                return;
            }
            this._symbols = child._symbols;
            this._buckets = child._buckets;
            this._size = child._size;
            this._sizeThreshold = child._sizeThreshold;
            this._indexMask = child._indexMask;
        }
        this._dirty = false;
    }

    public void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null) {
            this._parent.mergeChild(this);
            this._dirty = false;
        }
    }

    public int size() {
        return this._size;
    }

    public boolean maybeDirty() {
        return this._dirty;
    }

    public String findSymbol(char[] buffer2, int start, int len, int hash2) {
        if (len < 1) {
            return "";
        }
        if (!this._canonicalize) {
            return new String(buffer2, start, len);
        }
        String sym = this._symbols[hash2 &= this._indexMask];
        if (sym != null) {
            Bucket b;
            if (sym.length() == len) {
                int i = 0;
                while (sym.charAt(i) == buffer2[start + i] && ++i < len) {
                }
                if (i == len) {
                    return sym;
                }
            }
            if ((b = this._buckets[hash2 >> 1]) != null && (sym = b.find(buffer2, start, len)) != null) {
                return sym;
            }
        }
        if (!this._dirty) {
            this.copyArrays();
            this._dirty = true;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            hash2 = CharsToNameCanonicalizer.calcHash(buffer2, start, len) & this._indexMask;
        }
        ++this._size;
        String newSymbol = new String(buffer2, start, len);
        if (this._intern) {
            newSymbol = InternCache.instance.intern(newSymbol);
        }
        if (this._symbols[hash2] == null) {
            this._symbols[hash2] = newSymbol;
        } else {
            int bix = hash2 >> 1;
            this._buckets[bix] = new Bucket(newSymbol, this._buckets[bix]);
        }
        return newSymbol;
    }

    public static int calcHash(char[] buffer2, int start, int len) {
        int hash2 = buffer2[0];
        for (int i = 1; i < len; ++i) {
            hash2 = hash2 * 31 + buffer2[i];
        }
        return hash2;
    }

    public static int calcHash(String key) {
        int hash2 = key.charAt(0);
        int len = key.length();
        for (int i = 1; i < len; ++i) {
            hash2 = hash2 * 31 + key.charAt(i);
        }
        return hash2;
    }

    private void copyArrays() {
        String[] oldSyms = this._symbols;
        int size2 = oldSyms.length;
        this._symbols = new String[size2];
        System.arraycopy(oldSyms, 0, this._symbols, 0, size2);
        Bucket[] oldBuckets = this._buckets;
        size2 = oldBuckets.length;
        this._buckets = new Bucket[size2];
        System.arraycopy(oldBuckets, 0, this._buckets, 0, size2);
    }

    private void rehash() {
        int i;
        int size2 = this._symbols.length;
        int newSize = size2 + size2;
        if (newSize > 65536) {
            this._size = 0;
            Arrays.fill(this._symbols, null);
            Arrays.fill(this._buckets, null);
            this._dirty = true;
            return;
        }
        String[] oldSyms = this._symbols;
        Bucket[] oldBuckets = this._buckets;
        this._symbols = new String[newSize];
        this._buckets = new Bucket[newSize >> 1];
        this._indexMask = newSize - 1;
        this._sizeThreshold += this._sizeThreshold;
        int count2 = 0;
        for (i = 0; i < size2; ++i) {
            String symbol = oldSyms[i];
            if (symbol == null) continue;
            ++count2;
            int index2 = CharsToNameCanonicalizer.calcHash(symbol) & this._indexMask;
            if (this._symbols[index2] == null) {
                this._symbols[index2] = symbol;
                continue;
            }
            int bix = index2 >> 1;
            this._buckets[bix] = new Bucket(symbol, this._buckets[bix]);
        }
        size2 >>= 1;
        for (i = 0; i < size2; ++i) {
            for (Bucket b = oldBuckets[i]; b != null; b = b.getNext()) {
                ++count2;
                String symbol = b.getSymbol();
                int index3 = CharsToNameCanonicalizer.calcHash(symbol) & this._indexMask;
                if (this._symbols[index3] == null) {
                    this._symbols[index3] = symbol;
                    continue;
                }
                int bix = index3 >> 1;
                this._buckets[bix] = new Bucket(symbol, this._buckets[bix]);
            }
        }
        if (count2 != this._size) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this._size + " entries; now have " + count2 + ".");
        }
    }

    static final class Bucket {
        private final String _symbol;
        private final Bucket mNext;

        public Bucket(String symbol, Bucket next2) {
            this._symbol = symbol;
            this.mNext = next2;
        }

        public String getSymbol() {
            return this._symbol;
        }

        public Bucket getNext() {
            return this.mNext;
        }

        public String find(char[] buf, int start, int len) {
            String sym = this._symbol;
            Bucket b = this.mNext;
            while (true) {
                if (sym.length() == len) {
                    int i = 0;
                    while (sym.charAt(i) == buf[start + i] && ++i < len) {
                    }
                    if (i == len) {
                        return sym;
                    }
                }
                if (b == null) break;
                sym = b.getSymbol();
                b = b.getNext();
            }
            return null;
        }
    }
}

