/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.Serializers;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.codehaus.jackson.map.ser.AnyGetterWriter;
import org.codehaus.jackson.map.ser.BasicSerializerFactory;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.BeanSerializerBuilder;
import org.codehaus.jackson.map.ser.BeanSerializerModifier;
import org.codehaus.jackson.map.ser.FilteredBeanPropertyWriter;
import org.codehaus.jackson.map.ser.MapSerializer;
import org.codehaus.jackson.map.ser.PropertyBuilder;
import org.codehaus.jackson.map.type.TypeBindings;
import org.codehaus.jackson.map.util.ArrayBuilders;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializerFactory
extends BasicSerializerFactory {
    public static final BeanSerializerFactory instance = new BeanSerializerFactory(null);
    protected final SerializerFactory.Config _factoryConfig;

    @Deprecated
    protected BeanSerializerFactory() {
        this(null);
    }

    protected BeanSerializerFactory(SerializerFactory.Config config2) {
        if (config2 == null) {
            config2 = new ConfigImpl();
        }
        this._factoryConfig = config2;
    }

    @Override
    public SerializerFactory.Config getConfig() {
        return this._factoryConfig;
    }

    @Override
    public SerializerFactory withConfig(SerializerFactory.Config config2) {
        if (this._factoryConfig == config2) {
            return this;
        }
        if (this.getClass() != BeanSerializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanSerializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalSerializers': can not instantiate subtype with " + "additional serializer definitions");
        }
        return new BeanSerializerFactory(config2);
    }

    @Override
    protected Iterable<Serializers> customSerializers() {
        return this._factoryConfig.serializers();
    }

    @Override
    public JsonSerializer<Object> createSerializer(SerializationConfig config2, JavaType origType, BeanProperty property) throws JsonMappingException {
        boolean staticTyping;
        BasicBeanDescription beanDesc = (BasicBeanDescription)config2.introspect(origType);
        JsonSerializer<Object> ser = this.findSerializerFromAnnotation(config2, beanDesc.getClassInfo(), property);
        if (ser != null) {
            return ser;
        }
        JavaType type = this.modifyTypeByAnnotation(config2, beanDesc.getClassInfo(), origType);
        boolean bl = staticTyping = type != origType;
        if (origType.isContainerType()) {
            return this.buildContainerSerializer(config2, type, beanDesc, property, staticTyping);
        }
        for (Serializers serializers : this._factoryConfig.serializers()) {
            ser = serializers.findSerializer(config2, type, beanDesc, property);
            if (ser == null) continue;
            return ser;
        }
        ser = this.findSerializerByLookup(type, config2, beanDesc, property, staticTyping);
        if (ser != null) {
            return ser;
        }
        ser = this.findSerializerByPrimaryType(type, config2, beanDesc, property, staticTyping);
        if (ser != null) {
            return ser;
        }
        ser = this.findBeanSerializer(config2, type, beanDesc, property);
        if (ser == null) {
            ser = super.findSerializerByAddonType(config2, type, beanDesc, property, staticTyping);
        }
        return ser;
    }

    @Override
    public JsonSerializer<Object> createKeySerializer(SerializationConfig config2, JavaType type, BeanProperty property) {
        Serializers serializers;
        if (!this._factoryConfig.hasKeySerializers()) {
            return null;
        }
        BasicBeanDescription beanDesc = (BasicBeanDescription)config2.introspectClassAnnotations(type.getRawClass());
        JsonSerializer<?> ser = null;
        Iterator<Serializers> i$ = this._factoryConfig.keySerializers().iterator();
        while (i$.hasNext() && (ser = (serializers = i$.next()).findSerializer(config2, type, beanDesc, property)) == null) {
        }
        return ser;
    }

    public JsonSerializer<Object> findBeanSerializer(SerializationConfig config2, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        if (!this.isPotentialBeanType(type.getRawClass())) {
            return null;
        }
        JsonSerializer<Object> serializer = this.constructBeanSerializer(config2, beanDesc, property);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                serializer = mod.modifySerializer(config2, beanDesc, serializer);
            }
        }
        return serializer;
    }

    public TypeSerializer findPropertyTypeSerializer(JavaType baseType, SerializationConfig config2, AnnotatedMember accessor, BeanProperty property) throws JsonMappingException {
        AnnotationIntrospector ai = config2.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyTypeResolver(config2, accessor, baseType);
        if (b == null) {
            return this.createTypeSerializer(config2, baseType, property);
        }
        Collection<NamedType> subtypes = config2.getSubtypeResolver().collectAndResolveSubtypes(accessor, config2, ai);
        return b.buildTypeSerializer(config2, baseType, subtypes, property);
    }

    public TypeSerializer findPropertyContentTypeSerializer(JavaType containerType, SerializationConfig config2, AnnotatedMember accessor, BeanProperty property) throws JsonMappingException {
        JavaType contentType = containerType.getContentType();
        AnnotationIntrospector ai = config2.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyContentTypeResolver(config2, accessor, containerType);
        if (b == null) {
            return this.createTypeSerializer(config2, contentType, property);
        }
        Collection<NamedType> subtypes = config2.getSubtypeResolver().collectAndResolveSubtypes(accessor, config2, ai);
        return b.buildTypeSerializer(config2, contentType, subtypes, property);
    }

    protected JsonSerializer<Object> constructBeanSerializer(SerializationConfig config2, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        if (beanDesc.getBeanClass() == Object.class) {
            throw new IllegalArgumentException("Can not create bean serializer for Object.class");
        }
        BeanSerializerBuilder builder = this.constructBeanSerializerBuilder(beanDesc);
        List<BeanPropertyWriter> props = this.findBeanProperties(config2, beanDesc);
        if (this._factoryConfig.hasSerializerModifiers()) {
            if (props == null) {
                props = new ArrayList<BeanPropertyWriter>();
            }
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                props = mod.changeProperties(config2, beanDesc, props);
            }
        }
        AnnotatedMethod anyGetter = beanDesc.findAnyGetter();
        if (props == null || props.size() == 0) {
            if (anyGetter == null) {
                if (beanDesc.hasKnownClassAnnotations()) {
                    return builder.createDummy();
                }
                return null;
            }
            props = Collections.emptyList();
        } else {
            props = this.filterBeanProperties(config2, beanDesc, props);
            props = this.sortBeanProperties(config2, beanDesc, props);
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                props = mod.orderProperties(config2, beanDesc, props);
            }
        }
        builder.setProperties(props);
        builder.setFilterId(this.findFilterId(config2, beanDesc));
        if (anyGetter != null) {
            if (config2.isEnabled(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                anyGetter.fixAccess();
            }
            JavaType type = anyGetter.getType(beanDesc.bindingsForBeanType());
            boolean staticTyping = config2.isEnabled(SerializationConfig.Feature.USE_STATIC_TYPING);
            JavaType valueType = type.getContentType();
            TypeSerializer typeSer = this.createTypeSerializer(config2, valueType, property);
            MapSerializer mapSer = MapSerializer.construct(null, type, staticTyping, typeSer, property, null, null);
            builder.setAnyGetter(new AnyGetterWriter(anyGetter, mapSer));
        }
        this.processViews(config2, builder);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                builder = mod.updateBuilder(config2, beanDesc, builder);
            }
        }
        return builder.build();
    }

    protected BeanPropertyWriter constructFilteredBeanWriter(BeanPropertyWriter writer, Class<?>[] inViews) {
        return FilteredBeanPropertyWriter.constructViewBased(writer, inViews);
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig config2, BasicBeanDescription beanDesc) {
        return new PropertyBuilder(config2, beanDesc);
    }

    protected BeanSerializerBuilder constructBeanSerializerBuilder(BasicBeanDescription beanDesc) {
        return new BeanSerializerBuilder(beanDesc);
    }

    protected Object findFilterId(SerializationConfig config2, BasicBeanDescription beanDesc) {
        return config2.getAnnotationIntrospector().findFilterId(beanDesc.getClassInfo());
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        return ClassUtil.canBeABeanType(type) == null && !ClassUtil.isProxyType(type);
    }

    protected List<BeanPropertyWriter> findBeanProperties(SerializationConfig config2, BasicBeanDescription beanDesc) throws JsonMappingException {
        AnnotationIntrospector.ReferenceProperty prop;
        VisibilityChecker<?> vchecker = config2.getDefaultVisibilityChecker();
        if (!config2.isEnabled(SerializationConfig.Feature.AUTO_DETECT_GETTERS)) {
            vchecker = vchecker.withGetterVisibility(JsonAutoDetect.Visibility.NONE);
        }
        if (!config2.isEnabled(SerializationConfig.Feature.AUTO_DETECT_IS_GETTERS)) {
            vchecker = vchecker.withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
        }
        if (!config2.isEnabled(SerializationConfig.Feature.AUTO_DETECT_FIELDS)) {
            vchecker = vchecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE);
        }
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        vchecker = intr.findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        LinkedHashMap<String, AnnotatedMethod> methodsByProp = beanDesc.findGetters(vchecker, null);
        LinkedHashMap<String, AnnotatedField> fieldsByProp = beanDesc.findSerializableFields(vchecker, methodsByProp.keySet());
        this.removeIgnorableTypes(config2, beanDesc, methodsByProp);
        this.removeIgnorableTypes(config2, beanDesc, fieldsByProp);
        if (methodsByProp.isEmpty() && fieldsByProp.isEmpty()) {
            return null;
        }
        boolean staticTyping = this.usesStaticTyping(config2, beanDesc, null, null);
        PropertyBuilder pb = this.constructPropertyBuilder(config2, beanDesc);
        ArrayList<BeanPropertyWriter> props = new ArrayList<BeanPropertyWriter>(methodsByProp.size());
        TypeBindings typeBind = beanDesc.bindingsForBeanType();
        for (Map.Entry<String, AnnotatedField> entry2 : fieldsByProp.entrySet()) {
            prop = intr.findReferenceType(entry2.getValue());
            if (prop != null && prop.isBackReference()) continue;
            props.add(this._constructWriter(config2, typeBind, pb, staticTyping, entry2.getKey(), entry2.getValue()));
        }
        for (Map.Entry<String, AnnotatedMember> entry3 : methodsByProp.entrySet()) {
            prop = intr.findReferenceType(entry3.getValue());
            if (prop != null && prop.isBackReference()) continue;
            props.add(this._constructWriter(config2, typeBind, pb, staticTyping, entry3.getKey(), entry3.getValue()));
        }
        return props;
    }

    protected List<BeanPropertyWriter> filterBeanProperties(SerializationConfig config2, BasicBeanDescription beanDesc, List<BeanPropertyWriter> props) {
        AnnotatedClass ac;
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        String[] ignored = intr.findPropertiesToIgnore(ac = beanDesc.getClassInfo());
        if (ignored != null && ignored.length > 0) {
            HashSet<String> ignoredSet = ArrayBuilders.arrayToSet(ignored);
            Iterator<BeanPropertyWriter> it = props.iterator();
            while (it.hasNext()) {
                if (!ignoredSet.contains(it.next().getName())) continue;
                it.remove();
            }
        }
        return props;
    }

    protected List<BeanPropertyWriter> sortBeanProperties(SerializationConfig config2, BasicBeanDescription beanDesc, List<BeanPropertyWriter> props) {
        List<String> creatorProps = beanDesc.findCreatorPropertyNames();
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        AnnotatedClass ac = beanDesc.getClassInfo();
        String[] propOrder = intr.findSerializationPropertyOrder(ac);
        Boolean alpha = intr.findSerializationSortAlphabetically(ac);
        boolean sort2 = alpha == null ? config2.isEnabled(SerializationConfig.Feature.SORT_PROPERTIES_ALPHABETICALLY) : alpha.booleanValue();
        if (sort2 || !creatorProps.isEmpty() || propOrder != null) {
            props = this._sortBeanProperties(props, creatorProps, propOrder, sort2);
        }
        return props;
    }

    protected void processViews(SerializationConfig config2, BeanSerializerBuilder builder) {
        List<BeanPropertyWriter> props = builder.getProperties();
        boolean includeByDefault = config2.isEnabled(SerializationConfig.Feature.DEFAULT_VIEW_INCLUSION);
        int propCount = props.size();
        int viewsFound = 0;
        BeanPropertyWriter[] filtered2 = new BeanPropertyWriter[propCount];
        for (int i = 0; i < propCount; ++i) {
            BeanPropertyWriter bpw = props.get(i);
            Class<?>[] views = bpw.getViews();
            if (views == null) {
                if (!includeByDefault) continue;
                filtered2[i] = bpw;
                continue;
            }
            ++viewsFound;
            filtered2[i] = this.constructFilteredBeanWriter(bpw, views);
        }
        if (includeByDefault && viewsFound == 0) {
            return;
        }
        builder.setFilteredProperties(filtered2);
    }

    protected <T extends AnnotatedMember> void removeIgnorableTypes(SerializationConfig config2, BasicBeanDescription beanDesc, Map<String, T> props) {
        if (props.isEmpty()) {
            return;
        }
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        Iterator<Map.Entry<String, T>> it = props.entrySet().iterator();
        HashMap ignores = new HashMap();
        while (it.hasNext()) {
            Map.Entry<String, T> entry2 = it.next();
            Class<?> type = ((AnnotatedMember)entry2.getValue()).getRawType();
            Boolean result2 = (Boolean)ignores.get(type);
            if (result2 == null) {
                BasicBeanDescription desc = (BasicBeanDescription)config2.introspectClassAnnotations(type);
                AnnotatedClass ac = desc.getClassInfo();
                result2 = intr.isIgnorableType(ac);
                if (result2 == null) {
                    result2 = Boolean.FALSE;
                }
                ignores.put(type, result2);
            }
            if (!result2.booleanValue()) continue;
            it.remove();
        }
    }

    protected BeanPropertyWriter _constructWriter(SerializationConfig config2, TypeBindings typeContext, PropertyBuilder pb, boolean staticTyping, String name2, AnnotatedMember accessor) throws JsonMappingException {
        if (config2.isEnabled(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            accessor.fixAccess();
        }
        JavaType type = accessor.getType(typeContext);
        BeanProperty.Std property = new BeanProperty.Std(name2, type, pb.getClassAnnotations(), accessor);
        JsonSerializer<Object> annotatedSerializer = this.findSerializerFromAnnotation(config2, accessor, property);
        TypeSerializer contentTypeSer = null;
        if (ClassUtil.isCollectionMapOrArray(type.getRawClass())) {
            contentTypeSer = this.findPropertyContentTypeSerializer(type, config2, accessor, property);
        }
        TypeSerializer typeSer = this.findPropertyTypeSerializer(type, config2, accessor, property);
        BeanPropertyWriter pbw = pb.buildWriter(name2, type, annotatedSerializer, typeSer, contentTypeSer, accessor, staticTyping);
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        pbw.setViews(intr.findSerializationViews(accessor));
        return pbw;
    }

    protected List<BeanPropertyWriter> _sortBeanProperties(List<BeanPropertyWriter> props, List<String> creatorProps, String[] propertyOrder, boolean sort2) {
        int size2 = props.size();
        AbstractMap all = sort2 ? new TreeMap() : new LinkedHashMap(size2 * 2);
        for (BeanPropertyWriter w : props) {
            all.put(w.getName(), w);
        }
        LinkedHashMap<String, BeanPropertyWriter> ordered = new LinkedHashMap<String, BeanPropertyWriter>(size2 * 2);
        if (propertyOrder != null) {
            for (String name2 : propertyOrder) {
                BeanPropertyWriter w = (BeanPropertyWriter)all.get(name2);
                if (w == null) continue;
                ordered.put(name2, w);
            }
        }
        for (String name3 : creatorProps) {
            BeanPropertyWriter w = (BeanPropertyWriter)all.get(name3);
            if (w == null) continue;
            ordered.put(name3, w);
        }
        ordered.putAll(all);
        return new ArrayList<BeanPropertyWriter>(ordered.values());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigImpl
    extends SerializerFactory.Config {
        protected static final Serializers[] NO_SERIALIZERS = new Serializers[0];
        protected static final BeanSerializerModifier[] NO_MODIFIERS = new BeanSerializerModifier[0];
        protected final Serializers[] _additionalSerializers;
        protected final Serializers[] _additionalKeySerializers;
        protected final BeanSerializerModifier[] _modifiers;

        public ConfigImpl() {
            this(null, null, null);
        }

        protected ConfigImpl(Serializers[] allAdditionalSerializers, Serializers[] allAdditionalKeySerializers, BeanSerializerModifier[] modifiers) {
            this._additionalSerializers = allAdditionalSerializers == null ? NO_SERIALIZERS : allAdditionalSerializers;
            this._additionalKeySerializers = allAdditionalKeySerializers == null ? NO_SERIALIZERS : allAdditionalKeySerializers;
            this._modifiers = modifiers == null ? NO_MODIFIERS : modifiers;
        }

        @Override
        public SerializerFactory.Config withAdditionalSerializers(Serializers additional) {
            if (additional == null) {
                throw new IllegalArgumentException("Can not pass null Serializers");
            }
            Serializers[] all = ArrayBuilders.insertInListNoDup(this._additionalSerializers, additional);
            return new ConfigImpl(all, this._additionalKeySerializers, this._modifiers);
        }

        @Override
        public SerializerFactory.Config withAdditionalKeySerializers(Serializers additional) {
            if (additional == null) {
                throw new IllegalArgumentException("Can not pass null Serializers");
            }
            Serializers[] all = ArrayBuilders.insertInListNoDup(this._additionalKeySerializers, additional);
            return new ConfigImpl(this._additionalSerializers, all, this._modifiers);
        }

        @Override
        public SerializerFactory.Config withSerializerModifier(BeanSerializerModifier modifier) {
            if (modifier == null) {
                throw new IllegalArgumentException("Can not pass null modifier");
            }
            BeanSerializerModifier[] modifiers = ArrayBuilders.insertInListNoDup(this._modifiers, modifier);
            return new ConfigImpl(this._additionalSerializers, this._additionalKeySerializers, modifiers);
        }

        @Override
        public boolean hasSerializers() {
            return this._additionalSerializers.length > 0;
        }

        @Override
        public boolean hasKeySerializers() {
            return this._additionalKeySerializers.length > 0;
        }

        @Override
        public boolean hasSerializerModifiers() {
            return this._modifiers.length > 0;
        }

        @Override
        public Iterable<Serializers> serializers() {
            return ArrayBuilders.arrayAsIterable(this._additionalSerializers);
        }

        @Override
        public Iterable<Serializers> keySerializers() {
            return ArrayBuilders.arrayAsIterable(this._additionalKeySerializers);
        }

        @Override
        public Iterable<BeanSerializerModifier> serializerModifiers() {
            return ArrayBuilders.arrayAsIterable(this._modifiers);
        }
    }
}

