/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ResolvableSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.annotate.JacksonStdImpl;
import org.codehaus.jackson.map.ser.ContainerSerializerBase;
import org.codehaus.jackson.map.ser.SerializerBase;
import org.codehaus.jackson.node.ObjectNode;

public final class ArraySerializers {
    private ArraySerializers() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static final class DoubleArraySerializer
    extends AsArraySerializer<double[]> {
        public DoubleArraySerializer() {
            super(double[].class, null, null);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public void serializeContents(double[] value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            int len = value2.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value2[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("number"));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static final class FloatArraySerializer
    extends AsArraySerializer<float[]> {
        public FloatArraySerializer() {
            this((TypeSerializer)null);
        }

        public FloatArraySerializer(TypeSerializer vts) {
            super(float[].class, vts, null);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new FloatArraySerializer(vts);
        }

        @Override
        public void serializeContents(float[] value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            int len = value2.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value2[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("number"));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static final class LongArraySerializer
    extends AsArraySerializer<long[]> {
        public LongArraySerializer() {
            this((TypeSerializer)null);
        }

        public LongArraySerializer(TypeSerializer vts) {
            super(long[].class, vts, null);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new LongArraySerializer(vts);
        }

        @Override
        public void serializeContents(long[] value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            int len = value2.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value2[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("number", true));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static final class IntArraySerializer
    extends AsArraySerializer<int[]> {
        public IntArraySerializer() {
            super(int[].class, null, null);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public void serializeContents(int[] value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            int len = value2.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value2[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("integer"));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static final class CharArraySerializer
    extends SerializerBase<char[]> {
        public CharArraySerializer() {
            super(char[].class);
        }

        @Override
        public void serialize(char[] value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (provider.isEnabled(SerializationConfig.Feature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                jgen.writeStartArray();
                this._writeArrayContents(jgen, value2);
                jgen.writeEndArray();
            } else {
                jgen.writeString(value2, 0, value2.length);
            }
        }

        @Override
        public void serializeWithType(char[] value2, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
            if (provider.isEnabled(SerializationConfig.Feature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                typeSer.writeTypePrefixForArray(value2, jgen);
                this._writeArrayContents(jgen, value2);
                typeSer.writeTypeSuffixForArray(value2, jgen);
            } else {
                typeSer.writeTypePrefixForScalar(value2, jgen);
                jgen.writeString(value2, 0, value2.length);
                typeSer.writeTypeSuffixForScalar(value2, jgen);
            }
        }

        private final void _writeArrayContents(JsonGenerator jgen, char[] value2) throws IOException, JsonGenerationException {
            int len = value2.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeString(value2, i, 1);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            ObjectNode itemSchema = this.createSchemaNode("string");
            itemSchema.put("type", "string");
            o.put("items", itemSchema);
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static final class ShortArraySerializer
    extends AsArraySerializer<short[]> {
        public ShortArraySerializer() {
            this((TypeSerializer)null);
        }

        public ShortArraySerializer(TypeSerializer vts) {
            super(short[].class, vts, null);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return new ShortArraySerializer(vts);
        }

        @Override
        public void serializeContents(short[] value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            int len = value2.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeNumber(value2[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("integer"));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static final class ByteArraySerializer
    extends SerializerBase<byte[]> {
        public ByteArraySerializer() {
            super(byte[].class);
        }

        @Override
        public void serialize(byte[] value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeBinary(value2);
        }

        @Override
        public void serializeWithType(byte[] value2, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
            typeSer.writeTypePrefixForScalar(value2, jgen);
            jgen.writeBinary(value2);
            typeSer.writeTypeSuffixForScalar(value2, jgen);
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            ObjectNode itemSchema = this.createSchemaNode("string");
            o.put("items", itemSchema);
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static final class BooleanArraySerializer
    extends AsArraySerializer<boolean[]> {
        public BooleanArraySerializer() {
            super(boolean[].class, null, null);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public void serializeContents(boolean[] value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            int len = value2.length;
            for (int i = 0; i < len; ++i) {
                jgen.writeBoolean(value2[i]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("boolean"));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static final class StringArraySerializer
    extends AsArraySerializer<String[]>
    implements ResolvableSerializer {
        protected JsonSerializer<Object> _elementSerializer;

        public StringArraySerializer(BeanProperty prop) {
            super(String[].class, null, prop);
        }

        @Override
        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return this;
        }

        @Override
        public void serializeContents(String[] value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            int len = value2.length;
            if (len == 0) {
                return;
            }
            if (this._elementSerializer != null) {
                this.serializeContentsSlow(value2, jgen, provider, this._elementSerializer);
                return;
            }
            for (int i = 0; i < len; ++i) {
                String str = value2[i];
                if (str == null) {
                    jgen.writeNull();
                    continue;
                }
                jgen.writeString(value2[i]);
            }
        }

        private void serializeContentsSlow(String[] value2, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
            int len = value2.length;
            for (int i = 0; i < len; ++i) {
                String str = value2[i];
                if (str == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                ser.serialize(value2[i], jgen, provider);
            }
        }

        @Override
        public void resolve(SerializerProvider provider) throws JsonMappingException {
            JsonSerializer<Object> ser = provider.findValueSerializer(String.class, this._property);
            if (ser != null && ser.getClass().getAnnotation(JacksonStdImpl.class) == null) {
                this._elementSerializer = ser;
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.put("items", this.createSchemaNode("string"));
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AsArraySerializer<T>
    extends ContainerSerializerBase<T> {
        protected final TypeSerializer _valueTypeSerializer;
        protected final BeanProperty _property;

        protected AsArraySerializer(Class<T> cls, TypeSerializer vts, BeanProperty property) {
            super(cls);
            this._valueTypeSerializer = vts;
            this._property = property;
        }

        @Override
        public final void serialize(T value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartArray();
            this.serializeContents(value2, jgen, provider);
            jgen.writeEndArray();
        }

        @Override
        public final void serializeWithType(T value2, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
            typeSer.writeTypePrefixForArray(value2, jgen);
            this.serializeContents(value2, jgen, provider);
            typeSer.writeTypeSuffixForArray(value2, jgen);
        }

        protected abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;
    }
}

