/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.jsontype.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.jsontype.SubtypeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdSubtypeResolver
extends SubtypeResolver {
    protected LinkedHashSet<NamedType> _registeredSubtypes;

    @Override
    public void registerSubtypes(NamedType ... types2) {
        if (this._registeredSubtypes == null) {
            this._registeredSubtypes = new LinkedHashSet();
        }
        for (NamedType type : types2) {
            this._registeredSubtypes.add(type);
        }
    }

    @Override
    public void registerSubtypes(Class<?> ... classes2) {
        NamedType[] types2 = new NamedType[classes2.length];
        int len = classes2.length;
        for (int i = 0; i < len; ++i) {
            types2[i] = new NamedType(classes2[i]);
        }
        this.registerSubtypes(types2);
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypes(AnnotatedMember property, MapperConfig<?> config2, AnnotationIntrospector ai) {
        List<NamedType> st;
        HashMap<NamedType, NamedType> collected = new HashMap<NamedType, NamedType>();
        if (this._registeredSubtypes != null) {
            Class<?> rawBase = property.getRawType();
            for (NamedType subtype : this._registeredSubtypes) {
                if (!rawBase.isAssignableFrom(subtype.getType())) continue;
                AnnotatedClass curr = AnnotatedClass.constructWithoutSuperTypes(subtype.getType(), ai, config2);
                this._collectAndResolve(curr, subtype, config2, ai, collected);
            }
        }
        if ((st = ai.findSubtypes(property)) != null) {
            for (NamedType nt : st) {
                AnnotatedClass ac = AnnotatedClass.constructWithoutSuperTypes(nt.getType(), ai, config2);
                this._collectAndResolve(ac, nt, config2, ai, collected);
            }
        }
        NamedType rootType = new NamedType(property.getRawType(), null);
        AnnotatedClass ac = AnnotatedClass.constructWithoutSuperTypes(property.getRawType(), ai, config2);
        this._collectAndResolve(ac, rootType, config2, ai, collected);
        return new ArrayList<NamedType>(collected.values());
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypes(AnnotatedClass type, MapperConfig<?> config2, AnnotationIntrospector ai) {
        HashMap<NamedType, NamedType> subtypes = new HashMap<NamedType, NamedType>();
        if (this._registeredSubtypes != null) {
            Class<?> rawBase = type.getRawType();
            for (NamedType subtype : this._registeredSubtypes) {
                if (!rawBase.isAssignableFrom(subtype.getType())) continue;
                AnnotatedClass curr = AnnotatedClass.constructWithoutSuperTypes(subtype.getType(), ai, config2);
                this._collectAndResolve(curr, subtype, config2, ai, subtypes);
            }
        }
        NamedType rootType = new NamedType(type.getRawType(), null);
        this._collectAndResolve(type, rootType, config2, ai, subtypes);
        return new ArrayList<NamedType>(subtypes.values());
    }

    protected void _collectAndResolve(AnnotatedClass annotatedType, NamedType namedType, MapperConfig<?> config2, AnnotationIntrospector ai, HashMap<NamedType, NamedType> collectedSubtypes) {
        String name2;
        if (!namedType.hasName() && (name2 = ai.findTypeName(annotatedType)) != null) {
            namedType = new NamedType(namedType.getType(), name2);
        }
        if (collectedSubtypes.containsKey(namedType)) {
            NamedType prev;
            if (namedType.hasName() && !(prev = collectedSubtypes.get(namedType)).hasName()) {
                collectedSubtypes.put(namedType, namedType);
            }
            return;
        }
        collectedSubtypes.put(namedType, namedType);
        List<NamedType> st = ai.findSubtypes(annotatedType);
        if (st != null && !st.isEmpty()) {
            for (NamedType subtype : st) {
                AnnotatedClass subtypeClass = AnnotatedClass.constructWithoutSuperTypes(subtype.getType(), ai, config2);
                if (!subtype.hasName()) {
                    subtype = new NamedType(subtype.getType(), ai.findTypeName(subtypeClass));
                }
                this._collectAndResolve(subtypeClass, subtype, config2, ai, collectedSubtypes);
            }
        }
    }
}

