/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ClassIntrospector;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedMethodMap;
import org.codehaus.jackson.map.introspect.AnnotationMap;
import org.codehaus.jackson.map.introspect.MemberKey;
import org.codehaus.jackson.map.introspect.MethodFilter;
import org.codehaus.jackson.map.util.Annotations;
import org.codehaus.jackson.map.util.ArrayBuilders;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedClass
extends Annotated {
    private static final AnnotationMap[] NO_ANNOTATION_MAPS = new AnnotationMap[0];
    protected final Class<?> _class;
    protected final Collection<Class<?>> _superTypes;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final ClassIntrospector.MixInResolver _mixInResolver;
    protected final Class<?> _primaryMixIn;
    protected AnnotationMap _classAnnotations;
    protected AnnotatedConstructor _defaultConstructor;
    protected List<AnnotatedConstructor> _constructors;
    protected List<AnnotatedMethod> _creatorMethods;
    protected AnnotatedMethodMap _memberMethods;
    protected List<AnnotatedField> _fields;
    protected List<AnnotatedMethod> _ignoredMethods;
    protected List<AnnotatedField> _ignoredFields;

    private AnnotatedClass(Class<?> cls, List<Class<?>> superTypes, AnnotationIntrospector aintr, ClassIntrospector.MixInResolver mir) {
        this._class = cls;
        this._superTypes = superTypes;
        this._annotationIntrospector = aintr;
        this._mixInResolver = mir;
        this._primaryMixIn = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(this._class);
    }

    public static AnnotatedClass construct(Class<?> cls, AnnotationIntrospector aintr, ClassIntrospector.MixInResolver mir) {
        List<Class<?>> st = ClassUtil.findSuperTypes(cls, null);
        AnnotatedClass ac = new AnnotatedClass(cls, st, aintr, mir);
        ac.resolveClassAnnotations();
        return ac;
    }

    public static AnnotatedClass constructWithoutSuperTypes(Class<?> cls, AnnotationIntrospector aintr, ClassIntrospector.MixInResolver mir) {
        List<Class<?>> empty = Collections.emptyList();
        AnnotatedClass ac = new AnnotatedClass(cls, empty, aintr, mir);
        ac.resolveClassAnnotations();
        return ac;
    }

    @Override
    public Class<?> getAnnotated() {
        return this._class;
    }

    @Override
    public int getModifiers() {
        return this._class.getModifiers();
    }

    @Override
    public String getName() {
        return this._class.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        if (this._classAnnotations == null) {
            return null;
        }
        return this._classAnnotations.get(acls);
    }

    @Override
    public Type getGenericType() {
        return this._class;
    }

    @Override
    public Class<?> getRawType() {
        return this._class;
    }

    public Annotations getAnnotations() {
        return this._classAnnotations;
    }

    public boolean hasAnnotations() {
        return this._classAnnotations.size() > 0;
    }

    public AnnotatedConstructor getDefaultConstructor() {
        return this._defaultConstructor;
    }

    public List<AnnotatedConstructor> getConstructors() {
        if (this._constructors == null) {
            return Collections.emptyList();
        }
        return this._constructors;
    }

    public List<AnnotatedMethod> getStaticMethods() {
        if (this._creatorMethods == null) {
            return Collections.emptyList();
        }
        return this._creatorMethods;
    }

    public Iterable<AnnotatedMethod> memberMethods() {
        return this._memberMethods;
    }

    public Iterable<AnnotatedMethod> ignoredMemberMethods() {
        if (this._ignoredMethods == null) {
            List<AnnotatedMethod> l = Collections.emptyList();
            return l;
        }
        return this._ignoredMethods;
    }

    public int getMemberMethodCount() {
        return this._memberMethods.size();
    }

    public AnnotatedMethod findMethod(String name2, Class<?>[] paramTypes2) {
        return this._memberMethods.find(name2, paramTypes2);
    }

    public int getFieldCount() {
        return this._fields == null ? 0 : this._fields.size();
    }

    public Iterable<AnnotatedField> fields() {
        if (this._fields == null) {
            List<AnnotatedField> l = Collections.emptyList();
            return l;
        }
        return this._fields;
    }

    public Iterable<AnnotatedField> ignoredFields() {
        if (this._ignoredFields == null) {
            List<AnnotatedField> l = Collections.emptyList();
            return l;
        }
        return this._ignoredFields;
    }

    protected void resolveClassAnnotations() {
        this._classAnnotations = new AnnotationMap();
        if (this._annotationIntrospector == null) {
            return;
        }
        if (this._primaryMixIn != null) {
            this._addClassMixIns(this._classAnnotations, this._class, this._primaryMixIn);
        }
        for (Annotation a : this._class.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a)) continue;
            this._classAnnotations.addIfNotPresent(a);
        }
        for (Class<?> cls : this._superTypes) {
            this._addClassMixIns(this._classAnnotations, cls);
            for (Annotation a : cls.getDeclaredAnnotations()) {
                if (!this._annotationIntrospector.isHandled(a)) continue;
                this._classAnnotations.addIfNotPresent(a);
            }
        }
        this._addClassMixIns(this._classAnnotations, Object.class);
    }

    protected void _addClassMixIns(AnnotationMap annotations2, Class<?> toMask) {
        if (this._mixInResolver != null) {
            this._addClassMixIns(annotations2, toMask, this._mixInResolver.findMixInClassFor(toMask));
        }
    }

    protected void _addClassMixIns(AnnotationMap annotations2, Class<?> toMask, Class<?> mixin) {
        if (mixin == null) {
            return;
        }
        for (Annotation a : mixin.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a)) continue;
            annotations2.addIfNotPresent(a);
        }
        for (Class<?> parent : ClassUtil.findSuperTypes(mixin, toMask)) {
            for (Annotation a : parent.getDeclaredAnnotations()) {
                if (!this._annotationIntrospector.isHandled(a)) continue;
                annotations2.addIfNotPresent(a);
            }
        }
    }

    public void resolveCreators(boolean includeAll) {
        this._constructors = null;
        block3: for (Constructor<?> constructor : this._class.getDeclaredConstructors()) {
            switch (constructor.getParameterTypes().length) {
                case 0: {
                    this._defaultConstructor = this._constructConstructor(constructor, true);
                    continue block3;
                }
                default: {
                    if (!includeAll) continue block3;
                    if (this._constructors == null) {
                        this._constructors = new ArrayList<AnnotatedConstructor>();
                    }
                    this._constructors.add(this._constructConstructor(constructor, false));
                }
            }
        }
        if (this._primaryMixIn != null && (this._defaultConstructor != null || this._constructors != null)) {
            this._addConstructorMixIns(this._primaryMixIn);
        }
        if (this._annotationIntrospector != null) {
            if (this._defaultConstructor != null && this._annotationIntrospector.isIgnorableConstructor(this._defaultConstructor)) {
                this._defaultConstructor = null;
            }
            if (this._constructors != null) {
                int i = this._constructors.size();
                while (--i >= 0) {
                    if (!this._annotationIntrospector.isIgnorableConstructor(this._constructors.get(i))) continue;
                    this._constructors.remove(i);
                }
            }
        }
        this._creatorMethods = null;
        if (includeAll) {
            for (Executable executable : this._class.getDeclaredMethods()) {
                int argCount;
                if (!Modifier.isStatic(((Method)executable).getModifiers()) || (argCount = ((Method)executable).getParameterTypes().length) < 1) continue;
                if (this._creatorMethods == null) {
                    this._creatorMethods = new ArrayList<AnnotatedMethod>();
                }
                this._creatorMethods.add(this._constructCreatorMethod((Method)executable));
            }
            if (this._primaryMixIn != null && this._creatorMethods != null) {
                this._addFactoryMixIns(this._primaryMixIn);
            }
            if (this._annotationIntrospector != null && this._creatorMethods != null) {
                int i = this._creatorMethods.size();
                while (--i >= 0) {
                    if (!this._annotationIntrospector.isIgnorableMethod(this._creatorMethods.get(i))) continue;
                    this._creatorMethods.remove(i);
                }
            }
        }
    }

    protected void _addConstructorMixIns(Class<?> mixin) {
        MemberKey[] ctorKeys = null;
        int ctorCount = this._constructors == null ? 0 : this._constructors.size();
        block3: for (Constructor<?> ctor : mixin.getDeclaredConstructors()) {
            switch (ctor.getParameterTypes().length) {
                case 0: {
                    if (this._defaultConstructor == null) continue block3;
                    this._addMixOvers(ctor, this._defaultConstructor, false);
                    continue block3;
                }
                default: {
                    if (ctorKeys == null) {
                        ctorKeys = new MemberKey[ctorCount];
                        for (int i = 0; i < ctorCount; ++i) {
                            ctorKeys[i] = new MemberKey((Constructor<?>)this._constructors.get(i).getAnnotated());
                        }
                    }
                    MemberKey key = new MemberKey(ctor);
                    for (int i = 0; i < ctorCount; ++i) {
                        if (!key.equals(ctorKeys[i])) continue;
                        this._addMixOvers(ctor, this._constructors.get(i), true);
                        continue block3;
                    }
                }
            }
        }
    }

    protected void _addFactoryMixIns(Class<?> mixin) {
        MemberKey[] methodKeys = null;
        int methodCount = this._creatorMethods.size();
        block0: for (Method m : mixin.getDeclaredMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length == 0) continue;
            if (methodKeys == null) {
                methodKeys = new MemberKey[methodCount];
                for (int i = 0; i < methodCount; ++i) {
                    methodKeys[i] = new MemberKey(this._creatorMethods.get(i).getAnnotated());
                }
            }
            MemberKey key = new MemberKey(m);
            for (int i = 0; i < methodCount; ++i) {
                if (!key.equals(methodKeys[i])) continue;
                this._addMixOvers(m, this._creatorMethods.get(i), true);
                continue block0;
            }
        }
    }

    public void resolveMemberMethods(MethodFilter methodFilter, boolean collectIgnored) {
        Class<?> mixin;
        this._memberMethods = new AnnotatedMethodMap();
        AnnotatedMethodMap mixins = new AnnotatedMethodMap();
        this._addMemberMethods(this._class, methodFilter, this._memberMethods, this._primaryMixIn, mixins);
        for (Class<?> cls : this._superTypes) {
            Class<?> mixin2 = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(cls);
            this._addMemberMethods(cls, methodFilter, this._memberMethods, mixin2, mixins);
        }
        if (this._mixInResolver != null && (mixin = this._mixInResolver.findMixInClassFor(Object.class)) != null) {
            this._addMethodMixIns(methodFilter, this._memberMethods, mixin, mixins);
        }
        if (this._annotationIntrospector != null) {
            if (!mixins.isEmpty()) {
                for (AnnotatedMethod mixIn : mixins) {
                    try {
                        Method m = Object.class.getDeclaredMethod(mixIn.getName(), mixIn.getParameterClasses());
                        if (m == null) continue;
                        AnnotatedMethod am = this._constructMethod(m);
                        this._addMixOvers(mixIn.getAnnotated(), am, false);
                        this._memberMethods.add(am);
                    }
                    catch (Exception e) {}
                }
            }
            Iterator<AnnotatedMethod> it = this._memberMethods.iterator();
            while (it.hasNext()) {
                AnnotatedMethod am = it.next();
                if (!this._annotationIntrospector.isIgnorableMethod(am)) continue;
                it.remove();
                if (!collectIgnored) continue;
                this._ignoredMethods = ArrayBuilders.addToList(this._ignoredMethods, am);
            }
        }
    }

    protected void _addMemberMethods(Class<?> cls, MethodFilter methodFilter, AnnotatedMethodMap methods2, Class<?> mixInCls, AnnotatedMethodMap mixIns) {
        if (mixInCls != null) {
            this._addMethodMixIns(methodFilter, methods2, mixInCls, mixIns);
        }
        if (cls == null) {
            return;
        }
        for (Method m : cls.getDeclaredMethods()) {
            if (!this._isIncludableMethod(m, methodFilter)) continue;
            AnnotatedMethod old = methods2.find(m);
            if (old == null) {
                AnnotatedMethod newM = this._constructMethod(m);
                methods2.add(newM);
                old = mixIns.remove(m);
                if (old == null) continue;
                this._addMixOvers(old.getAnnotated(), newM, false);
                continue;
            }
            this._addMixUnders(m, old);
            if (!old.getDeclaringClass().isInterface() || m.getDeclaringClass().isInterface()) continue;
            methods2.add(old.withMethod(m));
        }
    }

    protected void _addMethodMixIns(MethodFilter methodFilter, AnnotatedMethodMap methods2, Class<?> mixInCls, AnnotatedMethodMap mixIns) {
        for (Method m : mixInCls.getDeclaredMethods()) {
            if (!this._isIncludableMethod(m, methodFilter)) continue;
            AnnotatedMethod am = methods2.find(m);
            if (am != null) {
                this._addMixUnders(m, am);
                continue;
            }
            mixIns.add(this._constructMethod(m));
        }
    }

    public void resolveFields(boolean collectIgnored) {
        LinkedHashMap<String, AnnotatedField> foundFields = new LinkedHashMap<String, AnnotatedField>();
        this._addFields(foundFields, this._class);
        if (this._annotationIntrospector != null) {
            Iterator<Map.Entry<String, AnnotatedField>> it = foundFields.entrySet().iterator();
            while (it.hasNext()) {
                AnnotatedField f2 = it.next().getValue();
                if (!this._annotationIntrospector.isIgnorableField(f2)) continue;
                it.remove();
                if (!collectIgnored) continue;
                this._ignoredFields = ArrayBuilders.addToList(this._ignoredFields, f2);
            }
        }
        if (foundFields.isEmpty()) {
            this._fields = Collections.emptyList();
        } else {
            this._fields = new ArrayList<AnnotatedField>(foundFields.size());
            this._fields.addAll(foundFields.values());
        }
    }

    protected void _addFields(Map<String, AnnotatedField> fields2, Class<?> c) {
        Class<?> parent = c.getSuperclass();
        if (parent != null) {
            Class<?> mixin;
            this._addFields(fields2, parent);
            for (Field f2 : c.getDeclaredFields()) {
                if (!this._isIncludableField(f2)) continue;
                fields2.put(f2.getName(), this._constructField(f2));
            }
            if (this._mixInResolver != null && (mixin = this._mixInResolver.findMixInClassFor(c)) != null) {
                this._addFieldMixIns(mixin, fields2);
            }
        }
    }

    protected void _addFieldMixIns(Class<?> mixin, Map<String, AnnotatedField> fields2) {
        for (Field mixinField : mixin.getDeclaredFields()) {
            String name2;
            AnnotatedField maskedField;
            if (!this._isIncludableField(mixinField) || (maskedField = fields2.get(name2 = mixinField.getName())) == null) continue;
            for (Annotation a : mixinField.getDeclaredAnnotations()) {
                if (!this._annotationIntrospector.isHandled(a)) continue;
                maskedField.addOrOverride(a);
            }
        }
    }

    protected AnnotatedMethod _constructMethod(Method m) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedMethod(m, this._emptyAnnotationMap(), null);
        }
        return new AnnotatedMethod(m, this._collectRelevantAnnotations(m.getDeclaredAnnotations()), null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AnnotatedConstructor _constructConstructor(Constructor<?> ctor, boolean defaultCtor) {
        AnnotationMap[] resolvedAnnotations;
        if (this._annotationIntrospector == null) {
            return new AnnotatedConstructor(ctor, this._emptyAnnotationMap(), this._emptyAnnotationMaps(ctor.getParameterTypes().length));
        }
        if (defaultCtor) {
            return new AnnotatedConstructor(ctor, this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), null);
        }
        Annotation[][] paramAnns = ctor.getParameterAnnotations();
        int paramCount = ctor.getParameterTypes().length;
        if (paramCount != paramAnns.length) {
            if (!ctor.getDeclaringClass().isMemberClass() || paramCount != paramAnns.length + 1) throw new IllegalStateException("Internal error: constructor for " + ctor.getDeclaringClass().getName() + " has mismatch: " + paramCount + " parameters; " + paramAnns.length + " sets of annotations");
            Annotation[][] old = paramAnns;
            paramAnns = new Annotation[old.length + 1][];
            System.arraycopy(old, 0, paramAnns, 1, old.length);
            resolvedAnnotations = this._collectRelevantAnnotations(paramAnns);
            return new AnnotatedConstructor(ctor, this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), resolvedAnnotations);
        } else {
            resolvedAnnotations = this._collectRelevantAnnotations(paramAnns);
        }
        return new AnnotatedConstructor(ctor, this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), resolvedAnnotations);
    }

    protected AnnotatedMethod _constructCreatorMethod(Method m) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedMethod(m, this._emptyAnnotationMap(), this._emptyAnnotationMaps(m.getParameterTypes().length));
        }
        return new AnnotatedMethod(m, this._collectRelevantAnnotations(m.getDeclaredAnnotations()), this._collectRelevantAnnotations(m.getParameterAnnotations()));
    }

    protected AnnotatedField _constructField(Field f2) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedField(f2, this._emptyAnnotationMap());
        }
        return new AnnotatedField(f2, this._collectRelevantAnnotations(f2.getDeclaredAnnotations()));
    }

    protected AnnotationMap[] _collectRelevantAnnotations(Annotation[][] anns) {
        int len = anns.length;
        AnnotationMap[] result2 = new AnnotationMap[len];
        for (int i = 0; i < len; ++i) {
            result2[i] = this._collectRelevantAnnotations(anns[i]);
        }
        return result2;
    }

    protected AnnotationMap _collectRelevantAnnotations(Annotation[] anns) {
        AnnotationMap annMap = new AnnotationMap();
        if (anns != null) {
            for (Annotation a : anns) {
                if (!this._annotationIntrospector.isHandled(a)) continue;
                annMap.add(a);
            }
        }
        return annMap;
    }

    private AnnotationMap _emptyAnnotationMap() {
        return new AnnotationMap();
    }

    private AnnotationMap[] _emptyAnnotationMaps(int count2) {
        if (count2 == 0) {
            return NO_ANNOTATION_MAPS;
        }
        AnnotationMap[] maps = new AnnotationMap[count2];
        for (int i = 0; i < count2; ++i) {
            maps[i] = this._emptyAnnotationMap();
        }
        return maps;
    }

    protected boolean _isIncludableMethod(Method m, MethodFilter filter2) {
        if (filter2 != null && !filter2.includeMethod(m)) {
            return false;
        }
        return !m.isSynthetic() && !m.isBridge();
    }

    private boolean _isIncludableField(Field f2) {
        if (f2.isSynthetic()) {
            return false;
        }
        int mods = f2.getModifiers();
        return !Modifier.isStatic(mods) && !Modifier.isTransient(mods);
    }

    protected void _addMixOvers(Constructor<?> mixin, AnnotatedConstructor target, boolean addParamAnnotations2) {
        for (Annotation a : mixin.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a)) continue;
            target.addOrOverride(a);
        }
        if (addParamAnnotations2) {
            Annotation[][] pa = mixin.getParameterAnnotations();
            int len = pa.length;
            for (int i = 0; i < len; ++i) {
                for (Annotation a : pa[i]) {
                    target.addOrOverrideParam(i, a);
                }
            }
        }
    }

    protected void _addMixOvers(Method mixin, AnnotatedMethod target, boolean addParamAnnotations2) {
        for (Annotation a : mixin.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a)) continue;
            target.addOrOverride(a);
        }
        if (addParamAnnotations2) {
            Annotation[][] pa = mixin.getParameterAnnotations();
            int len = pa.length;
            for (int i = 0; i < len; ++i) {
                for (Annotation a : pa[i]) {
                    target.addOrOverrideParam(i, a);
                }
            }
        }
    }

    protected void _addMixUnders(Method src, AnnotatedMethod target) {
        for (Annotation a : src.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a)) continue;
            target.addIfNotPresent(a);
        }
    }

    public String toString() {
        return "[AnnotedClass " + this._class.getName() + "]";
    }
}

