/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.AbstractTypeResolver;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.ContextualDeserializer;
import org.codehaus.jackson.map.ContextualKeyDeserializer;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.Deserializers;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.KeyDeserializers;
import org.codehaus.jackson.map.ResolvableDeserializer;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.BeanDeserializerFactory;
import org.codehaus.jackson.map.deser.BeanDeserializerModifier;
import org.codehaus.jackson.map.deser.StdKeyDeserializers;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionLikeType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapLikeType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdDeserializerProvider
extends DeserializerProvider {
    static final HashMap<JavaType, KeyDeserializer> _keyDeserializers = StdKeyDeserializers.constructAll();
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers = new ConcurrentHashMap(64, 0.75f, 2);
    protected final HashMap<JavaType, JsonDeserializer<Object>> _incompleteDeserializers = new HashMap(8);
    protected DeserializerFactory _factory;

    public StdDeserializerProvider() {
        this(BeanDeserializerFactory.instance);
    }

    public StdDeserializerProvider(DeserializerFactory f2) {
        this._factory = f2;
    }

    @Override
    public DeserializerProvider withAdditionalDeserializers(Deserializers d) {
        this._factory = this._factory.withAdditionalDeserializers(d);
        return this;
    }

    @Override
    public DeserializerProvider withAdditionalKeyDeserializers(KeyDeserializers d) {
        this._factory = this._factory.withAdditionalKeyDeserializers(d);
        return this;
    }

    @Override
    public DeserializerProvider withDeserializerModifier(BeanDeserializerModifier modifier) {
        this._factory = this._factory.withDeserializerModifier(modifier);
        return this;
    }

    @Override
    public DeserializerProvider withAbstractTypeResolver(AbstractTypeResolver resolver) {
        this._factory = this._factory.withAbstractTypeResolver(resolver);
        return this;
    }

    @Override
    public JsonDeserializer<Object> findValueDeserializer(DeserializationConfig config2, JavaType propertyType, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._findCachedDeserializer(propertyType);
        if (deser != null) {
            if (deser instanceof ContextualDeserializer) {
                JsonDeserializer d = ((ContextualDeserializer)((Object)deser)).createContextual(config2, property);
                deser = d;
            }
            return deser;
        }
        deser = this._createAndCacheValueDeserializer(config2, propertyType, property);
        if (deser == null) {
            deser = this._handleUnknownValueDeserializer(propertyType);
        }
        if (deser instanceof ContextualDeserializer) {
            JsonDeserializer d = ((ContextualDeserializer)((Object)deser)).createContextual(config2, property);
            deser = d;
        }
        return deser;
    }

    @Override
    public JsonDeserializer<Object> findTypedValueDeserializer(DeserializationConfig config2, JavaType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this.findValueDeserializer(config2, type, property);
        TypeDeserializer typeDeser = this._factory.findTypeDeserializer(config2, type, property);
        if (typeDeser != null) {
            return new WrappedDeserializer(typeDeser, deser);
        }
        return deser;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(DeserializationConfig config2, JavaType type, BeanProperty property) throws JsonMappingException {
        KeyDeserializer kd = this._factory.createKeyDeserializer(config2, type, property);
        if (kd == null) {
            Class<?> raw2 = type.getRawClass();
            if (raw2 == String.class || raw2 == Object.class) {
                return null;
            }
            KeyDeserializer kdes = _keyDeserializers.get(type);
            if (kdes != null) {
                return kdes;
            }
            if (type.isEnumType()) {
                return StdKeyDeserializers.constructEnumKeyDeserializer(config2, type);
            }
            kdes = StdKeyDeserializers.findStringBasedKeyDeserializer(config2, type);
            if (kdes != null) {
                return kdes;
            }
            if (kd == null) {
                return this._handleUnknownKeyDeserializer(type);
            }
        }
        if (kd instanceof ContextualKeyDeserializer) {
            kd = ((ContextualKeyDeserializer)((Object)kd)).createContextual(config2, property);
        }
        return kd;
    }

    @Override
    public boolean hasValueDeserializerFor(DeserializationConfig config2, JavaType type) {
        JsonDeserializer<Object> deser = this._findCachedDeserializer(type);
        if (deser == null) {
            try {
                deser = this._createAndCacheValueDeserializer(config2, type, null);
            }
            catch (Exception e) {
                return false;
            }
        }
        return deser != null;
    }

    @Override
    public int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    @Override
    public void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    protected JsonDeserializer<Object> _findCachedDeserializer(JavaType type) {
        return this._cachedDeserializers.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationConfig config2, JavaType type, BeanProperty property) throws JsonMappingException {
        HashMap<JavaType, JsonDeserializer<Object>> hashMap = this._incompleteDeserializers;
        synchronized (hashMap) {
            JsonDeserializer<Object> jsonDeserializer;
            block9: {
                JsonDeserializer<Object> deser = this._findCachedDeserializer(type);
                if (deser != null) {
                    return deser;
                }
                int count2 = this._incompleteDeserializers.size();
                if (count2 > 0 && (deser = this._incompleteDeserializers.get(type)) != null) {
                    return deser;
                }
                try {
                    jsonDeserializer = this._createAndCache2(config2, type, property);
                    if (count2 != 0 || this._incompleteDeserializers.size() <= 0) break block9;
                    this._incompleteDeserializers.clear();
                }
                catch (Throwable throwable2) {
                    if (count2 == 0 && this._incompleteDeserializers.size() > 0) {
                        this._incompleteDeserializers.clear();
                    }
                    throw throwable2;
                }
            }
            return jsonDeserializer;
        }
    }

    protected JsonDeserializer<Object> _createAndCache2(DeserializationConfig config2, JavaType type, BeanProperty property) throws JsonMappingException {
        AnnotatedClass ac;
        AnnotationIntrospector aintr;
        Boolean cacheAnn;
        boolean addToCache;
        JsonDeserializer<Object> deser;
        try {
            deser = this._createDeserializer(config2, type, property);
        }
        catch (IllegalArgumentException iae) {
            throw new JsonMappingException(iae.getMessage(), null, iae);
        }
        if (deser == null) {
            return null;
        }
        boolean isResolvable = deser instanceof ResolvableDeserializer;
        boolean bl = addToCache = deser.getClass() == BeanDeserializer.class;
        if (!addToCache && config2.isEnabled(DeserializationConfig.Feature.USE_ANNOTATIONS) && (cacheAnn = (aintr = config2.getAnnotationIntrospector()).findCachability(ac = AnnotatedClass.construct(deser.getClass(), aintr, null))) != null) {
            addToCache = cacheAnn;
        }
        if (isResolvable) {
            this._incompleteDeserializers.put(type, deser);
            this._resolveDeserializer(config2, (ResolvableDeserializer)((Object)deser));
            this._incompleteDeserializers.remove(type);
        }
        if (addToCache) {
            this._cachedDeserializers.put(type, deser);
        }
        return deser;
    }

    protected JsonDeserializer<Object> _createDeserializer(DeserializationConfig config2, JavaType type, BeanProperty property) throws JsonMappingException {
        if (type.isEnumType()) {
            return this._factory.createEnumDeserializer(config2, this, type, property);
        }
        if (type.isContainerType()) {
            if (type.isArrayType()) {
                return this._factory.createArrayDeserializer(config2, this, (ArrayType)type, property);
            }
            if (type.isMapLikeType()) {
                MapLikeType mlt = (MapLikeType)type;
                if (mlt.isTrueMapType()) {
                    return this._factory.createMapDeserializer(config2, this, (MapType)mlt, property);
                }
                return this._factory.createMapLikeDeserializer(config2, this, mlt, property);
            }
            if (type.isCollectionLikeType()) {
                CollectionLikeType clt = (CollectionLikeType)type;
                if (clt.isTrueCollectionType()) {
                    return this._factory.createCollectionDeserializer(config2, this, (CollectionType)clt, property);
                }
                return this._factory.createCollectionLikeDeserializer(config2, this, clt, property);
            }
        }
        if (JsonNode.class.isAssignableFrom(type.getRawClass())) {
            return this._factory.createTreeDeserializer(config2, this, type, property);
        }
        return this._factory.createBeanDeserializer(config2, this, type, property);
    }

    protected void _resolveDeserializer(DeserializationConfig config2, ResolvableDeserializer ser) throws JsonMappingException {
        ser.resolve(config2, this);
    }

    protected JsonDeserializer<Object> _handleUnknownValueDeserializer(JavaType type) throws JsonMappingException {
        Class<?> rawClass = type.getRawClass();
        if (!ClassUtil.isConcrete(rawClass)) {
            throw new JsonMappingException("Can not find a Value deserializer for abstract type " + type);
        }
        throw new JsonMappingException("Can not find a Value deserializer for type " + type);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(JavaType type) throws JsonMappingException {
        throw new JsonMappingException("Can not find a (Map) Key deserializer for type " + type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class WrappedDeserializer
    extends JsonDeserializer<Object> {
        final TypeDeserializer _typeDeserializer;
        final JsonDeserializer<Object> _deserializer;

        public WrappedDeserializer(TypeDeserializer typeDeser, JsonDeserializer<Object> deser) {
            this._typeDeserializer = typeDeser;
            this._deserializer = deser;
        }

        @Override
        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return this._deserializer.deserializeWithType(jp, ctxt, this._typeDeserializer);
        }

        @Override
        public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
            throw new IllegalStateException("Type-wrapped deserializer's deserializeWithType should never get called");
        }
    }
}

