/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.AbstractTypeResolver;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.Deserializers;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.KeyDeserializers;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.AbstractDeserializer;
import org.codehaus.jackson.map.deser.BasicDeserializerFactory;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.BeanDeserializerBuilder;
import org.codehaus.jackson.map.deser.BeanDeserializerModifier;
import org.codehaus.jackson.map.deser.CreatorContainer;
import org.codehaus.jackson.map.deser.SettableAnyProperty;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.deser.ThrowableDeserializer;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionLikeType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapLikeType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.util.ArrayBuilders;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeserializerFactory
extends BasicDeserializerFactory {
    private static final Class<?>[] INIT_CAUSE_PARAMS = new Class[]{Throwable.class};
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory(null);
    protected final DeserializerFactory.Config _factoryConfig;

    @Deprecated
    public BeanDeserializerFactory() {
        this(null);
    }

    public BeanDeserializerFactory(DeserializerFactory.Config config2) {
        if (config2 == null) {
            config2 = new ConfigImpl();
        }
        this._factoryConfig = config2;
    }

    @Override
    public final DeserializerFactory.Config getConfig() {
        return this._factoryConfig;
    }

    @Override
    public DeserializerFactory withConfig(DeserializerFactory.Config config2) {
        if (this._factoryConfig == config2) {
            return this;
        }
        if (this.getClass() != BeanDeserializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanDeserializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalDeserializers': can not instantiate subtype with " + "additional deserializer definitions");
        }
        return new BeanDeserializerFactory(config2);
    }

    @Override
    public KeyDeserializer createKeyDeserializer(DeserializationConfig config2, JavaType type, BeanProperty property) throws JsonMappingException {
        if (this._factoryConfig.hasKeyDeserializers()) {
            BasicBeanDescription beanDesc = (BasicBeanDescription)config2.introspectClassAnnotations(type.getRawClass());
            for (KeyDeserializers d : this._factoryConfig.keyDeserializers()) {
                KeyDeserializer deser = d.findKeyDeserializer(type, config2, beanDesc, property);
                if (deser == null) continue;
                return deser;
            }
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType type, DeserializationConfig config2, DeserializerProvider provider, BeanProperty property, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findArrayDeserializer(type, config2, provider, property, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType type, DeserializationConfig config2, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findCollectionDeserializer(type, config2, provider, beanDesc, property, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType type, DeserializationConfig config2, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findCollectionLikeDeserializer(type, config2, provider, beanDesc, property, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> type, DeserializationConfig config2, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findEnumDeserializer(type, config2, beanDesc, property);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomMapDeserializer(MapType type, DeserializationConfig config2, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findMapDeserializer(type, config2, provider, beanDesc, property, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType type, DeserializationConfig config2, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findMapLikeDeserializer(type, config2, provider, beanDesc, property, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    protected JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> type, DeserializationConfig config2, BeanProperty property) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findTreeNodeDeserializer(type, config2, property);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected JsonDeserializer<Object> _findCustomBeanDeserializer(JavaType type, DeserializationConfig config2, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<Object> deser = d.findBeanDeserializer(type, config2, provider, beanDesc, property);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationConfig config2, DeserializerProvider p, JavaType type, BeanProperty property) throws JsonMappingException {
        JavaType concreteType;
        JsonDeserializer<Object> custom;
        BasicBeanDescription beanDesc;
        JsonDeserializer<Object> ad;
        if (type.isAbstract()) {
            type = this.mapAbstractType(config2, type);
        }
        if ((ad = this.findDeserializerFromAnnotation(config2, (beanDesc = (BasicBeanDescription)config2.introspect(type)).getClassInfo(), property)) != null) {
            return ad;
        }
        JavaType newType = this.modifyTypeByAnnotation(config2, beanDesc.getClassInfo(), type, null);
        if (newType.getRawClass() != type.getRawClass()) {
            type = newType;
            beanDesc = (BasicBeanDescription)config2.introspect(type);
        }
        if ((custom = this._findCustomBeanDeserializer(type, config2, p, beanDesc, property)) != null) {
            return custom;
        }
        if (type.isThrowable()) {
            return this.buildThrowableDeserializer(config2, type, beanDesc, property);
        }
        if (type.isAbstract() && (concreteType = this.materializeAbstractType(config2, beanDesc)) != null) {
            beanDesc = (BasicBeanDescription)config2.introspect(concreteType);
            return this.buildBeanDeserializer(config2, concreteType, beanDesc, property);
        }
        JsonDeserializer<Object> deser = this.findStdBeanDeserializer(config2, p, type, property);
        if (deser != null) {
            return deser;
        }
        if (!this.isPotentialBeanType(type.getRawClass())) {
            return null;
        }
        return this.buildBeanDeserializer(config2, type, beanDesc, property);
    }

    @Override
    protected JavaType mapAbstractType(DeserializationConfig config2, JavaType type) throws JsonMappingException {
        JavaType next2;
        while ((next2 = this._mapAbstractType2(config2, type)) != null) {
            Class<?> nextCls;
            Class<?> prevCls = type.getRawClass();
            if (prevCls == (nextCls = next2.getRawClass()) || !prevCls.isAssignableFrom(nextCls)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + type + " to " + next2 + ": latter is not a subtype of former");
            }
            type = next2;
        }
        return type;
    }

    protected JavaType _mapAbstractType2(DeserializationConfig config2, JavaType type) throws JsonMappingException {
        JavaType concrete;
        AbstractTypeResolver resolver;
        Class<?> currClass = type.getRawClass();
        if (this._factoryConfig.hasAbstractTypeResolvers()) {
            for (AbstractTypeResolver resolver2 : this._factoryConfig.abstractTypeResolvers()) {
                JavaType concrete2 = resolver2.findTypeMapping(config2, type);
                if (concrete2 == null || concrete2.getRawClass() == currClass) continue;
                return concrete2;
            }
        }
        if ((resolver = config2.getAbstractTypeResolver()) != null && (concrete = resolver.findTypeMapping(config2, type)) != null && concrete.getRawClass() != currClass) {
            return concrete;
        }
        return null;
    }

    protected JavaType materializeAbstractType(DeserializationConfig config2, BasicBeanDescription beanDesc) throws JsonMappingException {
        JavaType concrete;
        AbstractTypeResolver resolver = config2.getAbstractTypeResolver();
        if (resolver == null && !this._factoryConfig.hasAbstractTypeResolvers()) {
            return null;
        }
        JavaType abstractType = beanDesc.getType();
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        if (intr.findTypeResolver(config2, beanDesc.getClassInfo(), abstractType) != null) {
            return null;
        }
        if (resolver != null && (concrete = resolver.resolveAbstractType(config2, abstractType)) != null) {
            return concrete;
        }
        for (AbstractTypeResolver r : this._factoryConfig.abstractTypeResolvers()) {
            JavaType concrete2 = r.resolveAbstractType(config2, abstractType);
            if (concrete2 == null) continue;
            return concrete2;
        }
        return null;
    }

    public JsonDeserializer<Object> buildBeanDeserializer(DeserializationConfig config2, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        if (type.isAbstract()) {
            return new AbstractDeserializer(type);
        }
        BeanDeserializerBuilder builder = this.constructBeanDeserializerBuilder(beanDesc);
        builder.setCreators(this.findDeserializerCreators(config2, beanDesc));
        this.addBeanProps(config2, beanDesc, builder);
        this.addReferenceProperties(config2, beanDesc, builder);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder = mod.updateBuilder(config2, beanDesc, builder);
            }
        }
        JsonDeserializer<Object> deserializer = builder.build(property);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config2, beanDesc, deserializer);
            }
        }
        return deserializer;
    }

    public JsonDeserializer<Object> buildThrowableDeserializer(DeserializationConfig config2, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deserializer;
        SettableBeanProperty prop;
        BeanDeserializerBuilder builder = this.constructBeanDeserializerBuilder(beanDesc);
        builder.setCreators(this.findDeserializerCreators(config2, beanDesc));
        this.addBeanProps(config2, beanDesc, builder);
        AnnotatedMethod am = beanDesc.findMethod("initCause", INIT_CAUSE_PARAMS);
        if (am != null && (prop = this.constructSettableProperty(config2, beanDesc, "cause", am)) != null) {
            builder.addProperty(prop);
        }
        builder.addIgnorable("localizedMessage");
        builder.addIgnorable("message");
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder = mod.updateBuilder(config2, beanDesc, builder);
            }
        }
        if ((deserializer = builder.build(property)) instanceof BeanDeserializer) {
            deserializer = new ThrowableDeserializer((BeanDeserializer)deserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config2, beanDesc, deserializer);
            }
        }
        return deserializer;
    }

    protected BeanDeserializerBuilder constructBeanDeserializerBuilder(BasicBeanDescription beanDesc) {
        return new BeanDeserializerBuilder(beanDesc);
    }

    protected CreatorContainer findDeserializerCreators(DeserializationConfig config2, BasicBeanDescription beanDesc) throws JsonMappingException {
        Constructor<?> defaultCtor;
        boolean fixAccess = config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        CreatorContainer creators = new CreatorContainer(beanDesc, fixAccess);
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        if (beanDesc.getType().isConcrete() && (defaultCtor = beanDesc.findDefaultConstructor()) != null) {
            if (fixAccess) {
                ClassUtil.checkAndFixAccess(defaultCtor);
            }
            creators.setDefaultConstructor(defaultCtor);
        }
        VisibilityChecker<?> vchecker = config2.getDefaultVisibilityChecker();
        if (!config2.isEnabled(DeserializationConfig.Feature.AUTO_DETECT_CREATORS)) {
            vchecker = vchecker.withCreatorVisibility(JsonAutoDetect.Visibility.NONE);
        }
        vchecker = config2.getAnnotationIntrospector().findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        this._addDeserializerConstructors(config2, beanDesc, vchecker, intr, creators);
        this._addDeserializerFactoryMethods(config2, beanDesc, vchecker, intr, creators);
        return creators;
    }

    protected void _addDeserializerConstructors(DeserializationConfig config2, BasicBeanDescription beanDesc, VisibilityChecker<?> vchecker, AnnotationIntrospector intr, CreatorContainer creators) throws JsonMappingException {
        for (AnnotatedConstructor ctor : beanDesc.getConstructors()) {
            SettableBeanProperty[] properties;
            int argCount = ctor.getParameterCount();
            if (argCount < 1) continue;
            boolean isCreator = intr.hasCreatorAnnotation(ctor);
            boolean isVisible = vchecker.isCreatorVisible(ctor);
            if (argCount == 1) {
                AnnotatedParameter param2 = ctor.getParameter(0);
                String name2 = intr.findPropertyNameForParam(param2);
                if (name2 == null || name2.length() == 0) {
                    Class<?> type = ctor.getParameterClass(0);
                    if (type == String.class) {
                        if (!isCreator && !isVisible) continue;
                        creators.addStringConstructor(ctor);
                        continue;
                    }
                    if (type == Integer.TYPE || type == Integer.class) {
                        if (!isCreator && !isVisible) continue;
                        creators.addIntConstructor(ctor);
                        continue;
                    }
                    if (type == Long.TYPE || type == Long.class) {
                        if (!isCreator && !isVisible) continue;
                        creators.addLongConstructor(ctor);
                        continue;
                    }
                    if (!isCreator) continue;
                    creators.addDelegatingConstructor(ctor);
                    continue;
                }
                properties = new SettableBeanProperty[]{this.constructCreatorProperty(config2, beanDesc, name2, 0, param2)};
                creators.addPropertyConstructor(ctor, properties);
                continue;
            }
            if (!isCreator && !isVisible) continue;
            boolean annotationFound = false;
            boolean notAnnotatedParamFound = false;
            properties = new SettableBeanProperty[argCount];
            for (int i = 0; i < argCount; ++i) {
                AnnotatedParameter param3 = ctor.getParameter(i);
                String name3 = param3 == null ? null : intr.findPropertyNameForParam(param3);
                if (notAnnotatedParamFound && ((annotationFound |= !(notAnnotatedParamFound |= name3 == null || name3.length() == 0)) || isCreator)) {
                    throw new IllegalArgumentException("Argument #" + i + " of constructor " + ctor + " has no property name annotation; must have name when multiple-paramater constructor annotated as Creator");
                }
                properties[i] = this.constructCreatorProperty(config2, beanDesc, name3, i, param3);
            }
            if (!annotationFound) continue;
            creators.addPropertyConstructor(ctor, properties);
        }
    }

    protected void _addDeserializerFactoryMethods(DeserializationConfig config2, BasicBeanDescription beanDesc, VisibilityChecker<?> vchecker, AnnotationIntrospector intr, CreatorContainer creators) throws JsonMappingException {
        for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
            int argCount = factory.getParameterCount();
            if (argCount < 1) continue;
            boolean isCreator = intr.hasCreatorAnnotation(factory);
            if (argCount == 1) {
                String name2 = intr.findPropertyNameForParam(factory.getParameter(0));
                if (name2 == null || name2.length() == 0) {
                    Class<?> type = factory.getParameterClass(0);
                    if (type == String.class) {
                        if (!isCreator && !vchecker.isCreatorVisible(factory)) continue;
                        creators.addStringFactory(factory);
                        continue;
                    }
                    if (type == Integer.TYPE || type == Integer.class) {
                        if (!isCreator && !vchecker.isCreatorVisible(factory)) continue;
                        creators.addIntFactory(factory);
                        continue;
                    }
                    if (type == Long.TYPE || type == Long.class) {
                        if (!isCreator && !vchecker.isCreatorVisible(factory)) continue;
                        creators.addLongFactory(factory);
                        continue;
                    }
                    if (!intr.hasCreatorAnnotation(factory)) continue;
                    creators.addDelegatingFactory(factory);
                    continue;
                }
            } else if (!intr.hasCreatorAnnotation(factory)) continue;
            SettableBeanProperty[] properties = new SettableBeanProperty[argCount];
            for (int i = 0; i < argCount; ++i) {
                AnnotatedParameter param2 = factory.getParameter(i);
                String name3 = intr.findPropertyNameForParam(param2);
                if (name3 == null || name3.length() == 0) {
                    throw new IllegalArgumentException("Argument #" + i + " of factory method " + factory + " has no property name annotation; must have when multiple-paramater static method annotated as Creator");
                }
                properties[i] = this.constructCreatorProperty(config2, beanDesc, name3, i, param2);
            }
            creators.addPropertyFactory(factory, properties);
        }
    }

    protected void addBeanProps(DeserializationConfig config2, BasicBeanDescription beanDesc, BeanDeserializerBuilder builder) throws JsonMappingException {
        VisibilityChecker<?> vchecker = config2.getDefaultVisibilityChecker();
        if (!config2.isEnabled(DeserializationConfig.Feature.AUTO_DETECT_SETTERS)) {
            vchecker = vchecker.withSetterVisibility(JsonAutoDetect.Visibility.NONE);
        }
        if (!config2.isEnabled(DeserializationConfig.Feature.AUTO_DETECT_FIELDS)) {
            vchecker = vchecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE);
        }
        vchecker = config2.getAnnotationIntrospector().findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        LinkedHashMap<String, AnnotatedMethod> setters = beanDesc.findSetters(vchecker);
        AnnotatedMethod anySetter = beanDesc.findAnySetter();
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        boolean ignoreAny = false;
        Boolean B = intr.findIgnoreUnknownProperties(beanDesc.getClassInfo());
        if (B != null) {
            ignoreAny = B;
            builder.setIgnoreUnknownProperties(ignoreAny);
        }
        HashSet<String> ignored = ArrayBuilders.arrayToSet(intr.findPropertiesToIgnore(beanDesc.getClassInfo()));
        for (String propName : ignored) {
            builder.addIgnorable(propName);
        }
        AnnotatedClass ac = beanDesc.getClassInfo();
        for (AnnotatedMethod annotatedMethod : ac.ignoredMemberMethods()) {
            String name2 = beanDesc.okNameForSetter(annotatedMethod);
            if (name2 == null) continue;
            builder.addIgnorable(name2);
        }
        for (AnnotatedField annotatedField : ac.ignoredFields()) {
            builder.addIgnorable(annotatedField.getName());
        }
        HashMap ignoredTypes = new HashMap();
        for (Map.Entry entry2 : setters.entrySet()) {
            String name2 = (String)entry2.getKey();
            if (ignored.contains(name2)) continue;
            AnnotatedMethod setter2 = (AnnotatedMethod)entry2.getValue();
            Class<?> type = setter2.getParameterClass(0);
            if (this.isIgnorableType(config2, beanDesc, type, ignoredTypes)) {
                builder.addIgnorable(name2);
                continue;
            }
            SettableBeanProperty prop = this.constructSettableProperty(config2, beanDesc, name2, setter2);
            if (prop == null) continue;
            builder.addProperty(prop);
        }
        if (anySetter != null) {
            builder.setAnySetter(this.constructAnySetter(config2, beanDesc, anySetter));
        }
        HashSet<String> addedProps = new HashSet<String>(setters.keySet());
        LinkedHashMap<String, AnnotatedField> linkedHashMap = beanDesc.findDeserializableFields(vchecker, addedProps);
        for (Map.Entry<String, AnnotatedField> en : linkedHashMap.entrySet()) {
            String name3 = en.getKey();
            if (ignored.contains(name3) || builder.hasProperty(name3)) continue;
            AnnotatedField field2 = en.getValue();
            Class<?> type = field2.getRawType();
            if (this.isIgnorableType(config2, beanDesc, type, ignoredTypes)) {
                builder.addIgnorable(name3);
                continue;
            }
            SettableBeanProperty prop = this.constructSettableProperty(config2, beanDesc, name3, field2);
            if (prop == null) continue;
            builder.addProperty(prop);
            addedProps.add(name3);
        }
        if (config2.isEnabled(DeserializationConfig.Feature.USE_GETTERS_AS_SETTERS)) {
            LinkedHashMap<String, AnnotatedMethod> getters = beanDesc.findGetters(vchecker, addedProps);
            for (Map.Entry en : getters.entrySet()) {
                String name4;
                AnnotatedMethod getter2 = (AnnotatedMethod)en.getValue();
                Class<?> rt = getter2.getRawType();
                if (!Collection.class.isAssignableFrom(rt) && !Map.class.isAssignableFrom(rt) || ignored.contains(name4 = (String)en.getKey()) || builder.hasProperty(name4)) continue;
                builder.addProperty(this.constructSetterlessProperty(config2, beanDesc, name4, getter2));
                addedProps.add(name4);
            }
        }
    }

    protected void addReferenceProperties(DeserializationConfig config2, BasicBeanDescription beanDesc, BeanDeserializerBuilder builder) throws JsonMappingException {
        Map<String, AnnotatedMember> refs = beanDesc.findBackReferenceProperties();
        if (refs != null) {
            for (Map.Entry<String, AnnotatedMember> en : refs.entrySet()) {
                String name2 = en.getKey();
                AnnotatedMember m = en.getValue();
                if (m instanceof AnnotatedMethod) {
                    builder.addBackReferenceProperty(name2, this.constructSettableProperty(config2, beanDesc, m.getName(), (AnnotatedMethod)m));
                    continue;
                }
                builder.addBackReferenceProperty(name2, this.constructSettableProperty(config2, beanDesc, m.getName(), (AnnotatedField)m));
            }
        }
    }

    protected SettableAnyProperty constructAnySetter(DeserializationConfig config2, BasicBeanDescription beanDesc, AnnotatedMethod setter2) throws JsonMappingException {
        if (config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            setter2.fixAccess();
        }
        JavaType type = beanDesc.bindingsForBeanType().resolveType(setter2.getParameterType(1));
        BeanProperty.Std property = new BeanProperty.Std(setter2.getName(), type, beanDesc.getClassAnnotations(), setter2);
        type = this.resolveType(config2, beanDesc, type, setter2, property);
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config2, setter2, property);
        if (deser != null) {
            SettableAnyProperty prop = new SettableAnyProperty(property, setter2, type);
            prop.setValueDeserializer(deser);
            return prop;
        }
        type = this.modifyTypeByAnnotation(config2, setter2, type, property.getName());
        return new SettableAnyProperty(property, setter2, type);
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationConfig config2, BasicBeanDescription beanDesc, String name2, AnnotatedMethod setter2) throws JsonMappingException {
        AnnotationIntrospector.ReferenceProperty ref;
        BeanProperty.Std property;
        JavaType t0;
        JavaType type;
        if (config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            setter2.fixAccess();
        }
        if ((type = this.resolveType(config2, beanDesc, t0 = beanDesc.bindingsForBeanType().resolveType(setter2.getParameterType(0)), setter2, property = new BeanProperty.Std(name2, t0, beanDesc.getClassAnnotations(), setter2))) != t0) {
            property = property.withType(type);
        }
        JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(config2, setter2, property);
        type = this.modifyTypeByAnnotation(config2, setter2, type, name2);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty.MethodProperty prop = new SettableBeanProperty.MethodProperty(name2, type, typeDeser, beanDesc.getClassAnnotations(), setter2);
        if (propDeser != null) {
            prop.setValueDeserializer(propDeser);
        }
        if ((ref = config2.getAnnotationIntrospector().findReferenceType(setter2)) != null && ref.isManagedReference()) {
            prop.setManagedReferenceName(ref.getName());
        }
        return prop;
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationConfig config2, BasicBeanDescription beanDesc, String name2, AnnotatedField field2) throws JsonMappingException {
        AnnotationIntrospector.ReferenceProperty ref;
        BeanProperty.Std property;
        JavaType t0;
        JavaType type;
        if (config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            field2.fixAccess();
        }
        if ((type = this.resolveType(config2, beanDesc, t0 = beanDesc.bindingsForBeanType().resolveType(field2.getGenericType()), field2, property = new BeanProperty.Std(name2, t0, beanDesc.getClassAnnotations(), field2))) != t0) {
            property = property.withType(type);
        }
        JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(config2, field2, property);
        type = this.modifyTypeByAnnotation(config2, field2, type, name2);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty.FieldProperty prop = new SettableBeanProperty.FieldProperty(name2, type, typeDeser, beanDesc.getClassAnnotations(), field2);
        if (propDeser != null) {
            prop.setValueDeserializer(propDeser);
        }
        if ((ref = config2.getAnnotationIntrospector().findReferenceType(field2)) != null && ref.isManagedReference()) {
            prop.setManagedReferenceName(ref.getName());
        }
        return prop;
    }

    protected SettableBeanProperty constructSetterlessProperty(DeserializationConfig config2, BasicBeanDescription beanDesc, String name2, AnnotatedMethod getter2) throws JsonMappingException {
        if (config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            getter2.fixAccess();
        }
        JavaType type = getter2.getType(beanDesc.bindingsForBeanType());
        BeanProperty.Std property = new BeanProperty.Std(name2, type, beanDesc.getClassAnnotations(), getter2);
        JsonDeserializer<Object> propDeser = this.findDeserializerFromAnnotation(config2, getter2, property);
        type = this.modifyTypeByAnnotation(config2, getter2, type, name2);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty.SetterlessProperty prop = new SettableBeanProperty.SetterlessProperty(name2, type, typeDeser, beanDesc.getClassAnnotations(), getter2);
        if (propDeser != null) {
            prop.setValueDeserializer(propDeser);
        }
        return prop;
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        String typeStr = ClassUtil.canBeABeanType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        if (ClassUtil.isProxyType(type)) {
            throw new IllegalArgumentException("Can not deserialize Proxy class " + type.getName() + " as a Bean");
        }
        typeStr = ClassUtil.isLocalType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        return true;
    }

    protected boolean isIgnorableType(DeserializationConfig config2, BasicBeanDescription beanDesc, Class<?> type, Map<Class<?>, Boolean> ignoredTypes) {
        Boolean status = ignoredTypes.get(type);
        if (status == null) {
            BasicBeanDescription desc = (BasicBeanDescription)config2.introspectClassAnnotations(type);
            status = config2.getAnnotationIntrospector().isIgnorableType(desc.getClassInfo());
            if (status == null) {
                status = Boolean.FALSE;
            }
        }
        return status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigImpl
    extends DeserializerFactory.Config {
        protected static final KeyDeserializers[] NO_KEY_DESERIALIZERS = new KeyDeserializers[0];
        protected static final BeanDeserializerModifier[] NO_MODIFIERS = new BeanDeserializerModifier[0];
        protected static final AbstractTypeResolver[] NO_ABSTRACT_TYPE_RESOLVERS = new AbstractTypeResolver[0];
        protected final Deserializers[] _additionalDeserializers;
        protected final KeyDeserializers[] _additionalKeyDeserializers;
        protected final BeanDeserializerModifier[] _modifiers;
        protected final AbstractTypeResolver[] _abstractTypeResolvers;

        public ConfigImpl() {
            this(null, null, null, null);
        }

        protected ConfigImpl(Deserializers[] allAdditionalDeserializers, KeyDeserializers[] allAdditionalKeyDeserializers, BeanDeserializerModifier[] modifiers, AbstractTypeResolver[] atr) {
            this._additionalDeserializers = allAdditionalDeserializers == null ? NO_DESERIALIZERS : allAdditionalDeserializers;
            this._additionalKeyDeserializers = allAdditionalKeyDeserializers == null ? NO_KEY_DESERIALIZERS : allAdditionalKeyDeserializers;
            this._modifiers = modifiers == null ? NO_MODIFIERS : modifiers;
            this._abstractTypeResolvers = atr == null ? NO_ABSTRACT_TYPE_RESOLVERS : atr;
        }

        @Override
        public DeserializerFactory.Config withAdditionalDeserializers(Deserializers additional) {
            if (additional == null) {
                throw new IllegalArgumentException("Can not pass null Deserializers");
            }
            Deserializers[] all = ArrayBuilders.insertInListNoDup(this._additionalDeserializers, additional);
            return new ConfigImpl(all, this._additionalKeyDeserializers, this._modifiers, this._abstractTypeResolvers);
        }

        @Override
        public DeserializerFactory.Config withAdditionalKeyDeserializers(KeyDeserializers additional) {
            if (additional == null) {
                throw new IllegalArgumentException("Can not pass null KeyDeserializers");
            }
            KeyDeserializers[] all = ArrayBuilders.insertInListNoDup(this._additionalKeyDeserializers, additional);
            return new ConfigImpl(this._additionalDeserializers, all, this._modifiers, this._abstractTypeResolvers);
        }

        @Override
        public DeserializerFactory.Config withDeserializerModifier(BeanDeserializerModifier modifier) {
            if (modifier == null) {
                throw new IllegalArgumentException("Can not pass null modifier");
            }
            BeanDeserializerModifier[] all = ArrayBuilders.insertInListNoDup(this._modifiers, modifier);
            return new ConfigImpl(this._additionalDeserializers, this._additionalKeyDeserializers, all, this._abstractTypeResolvers);
        }

        @Override
        public DeserializerFactory.Config withAbstractTypeResolver(AbstractTypeResolver resolver) {
            if (resolver == null) {
                throw new IllegalArgumentException("Can not pass null resolver");
            }
            AbstractTypeResolver[] all = ArrayBuilders.insertInListNoDup(this._abstractTypeResolvers, resolver);
            return new ConfigImpl(this._additionalDeserializers, this._additionalKeyDeserializers, this._modifiers, all);
        }

        @Override
        public boolean hasDeserializers() {
            return this._additionalDeserializers.length > 0;
        }

        @Override
        public boolean hasKeyDeserializers() {
            return this._additionalKeyDeserializers.length > 0;
        }

        @Override
        public boolean hasDeserializerModifiers() {
            return this._modifiers.length > 0;
        }

        @Override
        public boolean hasAbstractTypeResolvers() {
            return this._abstractTypeResolvers.length > 0;
        }

        @Override
        public Iterable<Deserializers> deserializers() {
            return ArrayBuilders.arrayAsIterable(this._additionalDeserializers);
        }

        @Override
        public Iterable<KeyDeserializers> keyDeserializers() {
            return ArrayBuilders.arrayAsIterable(this._additionalKeyDeserializers);
        }

        @Override
        public Iterable<BeanDeserializerModifier> deserializerModifiers() {
            return ArrayBuilders.arrayAsIterable(this._modifiers);
        }

        @Override
        public Iterable<AbstractTypeResolver> abstractTypeResolvers() {
            return ArrayBuilders.arrayAsIterable(this._abstractTypeResolvers);
        }
    }
}

