/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.ContextualDeserializer;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.ArrayDeserializer;
import org.codehaus.jackson.map.deser.ArrayDeserializers;
import org.codehaus.jackson.map.deser.CollectionDeserializer;
import org.codehaus.jackson.map.deser.CreatorContainer;
import org.codehaus.jackson.map.deser.EnumDeserializer;
import org.codehaus.jackson.map.deser.EnumMapDeserializer;
import org.codehaus.jackson.map.deser.EnumResolver;
import org.codehaus.jackson.map.deser.EnumSetDeserializer;
import org.codehaus.jackson.map.deser.JsonNodeDeserializer;
import org.codehaus.jackson.map.deser.MapDeserializer;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.codehaus.jackson.map.deser.StdDeserializers;
import org.codehaus.jackson.map.deser.impl.StringCollectionDeserializer;
import org.codehaus.jackson.map.ext.OptionalHandlerFactory;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionLikeType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapLikeType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicDeserializerFactory
extends DeserializerFactory {
    static final HashMap<JavaType, JsonDeserializer<Object>> _simpleDeserializers = StdDeserializers.constructAll();
    static final HashMap<String, Class<? extends Map>> _mapFallbacks = new HashMap();
    static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
    protected static final HashMap<JavaType, JsonDeserializer<Object>> _arrayDeserializers;
    protected OptionalHandlerFactory optionalHandlers = OptionalHandlerFactory.instance;

    protected BasicDeserializerFactory() {
    }

    @Override
    public abstract DeserializerFactory withConfig(DeserializerFactory.Config var1);

    protected abstract JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType var1, DeserializationConfig var2, DeserializerProvider var3, BeanProperty var4, TypeDeserializer var5, JsonDeserializer<?> var6) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType var1, DeserializationConfig var2, DeserializerProvider var3, BasicBeanDescription var4, BeanProperty var5, TypeDeserializer var6, JsonDeserializer<?> var7) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType var1, DeserializationConfig var2, DeserializerProvider var3, BasicBeanDescription var4, BeanProperty var5, TypeDeserializer var6, JsonDeserializer<?> var7) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> var1, DeserializationConfig var2, BasicBeanDescription var3, BeanProperty var4) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomMapDeserializer(MapType var1, DeserializationConfig var2, DeserializerProvider var3, BasicBeanDescription var4, BeanProperty var5, KeyDeserializer var6, TypeDeserializer var7, JsonDeserializer<?> var8) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType var1, DeserializationConfig var2, DeserializerProvider var3, BasicBeanDescription var4, BeanProperty var5, KeyDeserializer var6, TypeDeserializer var7, JsonDeserializer<?> var8) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> var1, DeserializationConfig var2, BeanProperty var3) throws JsonMappingException;

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationConfig config2, DeserializerProvider p, ArrayType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<?> custom;
        TypeDeserializer elemTypeDeser;
        JavaType elemType = type.getContentType();
        JsonDeserializer<Object> contentDeser = (JsonDeserializer<Object>)elemType.getValueHandler();
        if (contentDeser == null) {
            JsonDeserializer<Object> deser = _arrayDeserializers.get(elemType);
            if (deser != null) {
                JsonDeserializer<?> custom2 = this._findCustomArrayDeserializer(type, config2, p, property, null, null);
                if (custom2 != null) {
                    return custom2;
                }
                return deser;
            }
            if (elemType.isPrimitive()) {
                throw new IllegalArgumentException("Internal error: primitive type (" + type + ") passed, no array deserializer found");
            }
        }
        if ((elemTypeDeser = (TypeDeserializer)elemType.getTypeHandler()) == null) {
            elemTypeDeser = this.findTypeDeserializer(config2, elemType, property);
        }
        if ((custom = this._findCustomArrayDeserializer(type, config2, p, property, elemTypeDeser, contentDeser)) != null) {
            return custom;
        }
        if (contentDeser == null) {
            contentDeser = p.findValueDeserializer(config2, elemType, property);
        }
        return new ArrayDeserializer(type, contentDeser, elemTypeDeser);
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationConfig config2, DeserializerProvider p, CollectionType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<?> custom;
        Class<Object> collectionClass = (type = (CollectionType)this.mapAbstractType(config2, type)).getRawClass();
        BasicBeanDescription beanDesc = (BasicBeanDescription)config2.introspectClassAnnotations(collectionClass);
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config2, beanDesc.getClassInfo(), property);
        if (deser != null) {
            return deser;
        }
        type = this.modifyTypeByAnnotation(config2, beanDesc.getClassInfo(), type, null);
        JavaType contentType = type.getContentType();
        JsonDeserializer<Object> contentDeser = (JsonDeserializer<Object>)contentType.getValueHandler();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = this.findTypeDeserializer(config2, contentType, property);
        }
        if ((custom = this._findCustomCollectionDeserializer(type, config2, p, beanDesc, property, contentTypeDeser, contentDeser)) != null) {
            return custom;
        }
        if (contentDeser == null) {
            if (EnumSet.class.isAssignableFrom(collectionClass)) {
                return new EnumSetDeserializer(contentType.getRawClass(), this.createEnumDeserializer(config2, p, contentType, property));
            }
            contentDeser = p.findValueDeserializer(config2, contentType, property);
        }
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Collection> fallback = _collectionFallbacks.get(collectionClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + type);
            }
            collectionClass = fallback;
        }
        boolean fixAccess = config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        Constructor<Collection<Object>> ctor = ClassUtil.findConstructor(collectionClass, fixAccess);
        if (contentType.getRawClass() == String.class) {
            return new StringCollectionDeserializer(type, contentDeser, ctor);
        }
        return new CollectionDeserializer(type, contentDeser, contentTypeDeser, ctor);
    }

    @Override
    public JsonDeserializer<?> createCollectionLikeDeserializer(DeserializationConfig config2, DeserializerProvider p, CollectionLikeType type, BeanProperty property) throws JsonMappingException {
        Class<?> collectionClass = (type = (CollectionLikeType)this.mapAbstractType(config2, type)).getRawClass();
        BasicBeanDescription beanDesc = (BasicBeanDescription)config2.introspectClassAnnotations(collectionClass);
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config2, beanDesc.getClassInfo(), property);
        if (deser != null) {
            return deser;
        }
        type = this.modifyTypeByAnnotation(config2, beanDesc.getClassInfo(), type, null);
        JavaType contentType = type.getContentType();
        JsonDeserializer contentDeser = (JsonDeserializer)contentType.getValueHandler();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = this.findTypeDeserializer(config2, contentType, property);
        }
        return this._findCustomCollectionLikeDeserializer(type, config2, p, beanDesc, property, contentTypeDeser, contentDeser);
    }

    @Override
    public JsonDeserializer<?> createMapDeserializer(DeserializationConfig config2, DeserializerProvider p, MapType type, BeanProperty property) throws JsonMappingException {
        Class<Object> mapClass;
        JsonDeserializer<?> custom;
        TypeDeserializer contentTypeDeser;
        BasicBeanDescription beanDesc = (BasicBeanDescription)config2.introspectForCreation(type = (MapType)this.mapAbstractType(config2, type));
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config2, beanDesc.getClassInfo(), property);
        if (deser != null) {
            return deser;
        }
        type = this.modifyTypeByAnnotation(config2, beanDesc.getClassInfo(), type, null);
        JavaType keyType = type.getKeyType();
        JavaType contentType = type.getContentType();
        JsonDeserializer<Object> contentDeser = (JsonDeserializer<Object>)contentType.getValueHandler();
        KeyDeserializer keyDes = (KeyDeserializer)keyType.getValueHandler();
        if (keyDes == null) {
            keyDes = p.findKeyDeserializer(config2, keyType, property);
        }
        if ((contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler()) == null) {
            contentTypeDeser = this.findTypeDeserializer(config2, contentType, property);
        }
        if ((custom = this._findCustomMapDeserializer(type, config2, p, beanDesc, property, keyDes, contentTypeDeser, contentDeser)) != null) {
            return custom;
        }
        if (contentDeser == null) {
            contentDeser = p.findValueDeserializer(config2, contentType, property);
        }
        if (EnumMap.class.isAssignableFrom(mapClass = type.getRawClass())) {
            Class<?> kt = keyType.getRawClass();
            if (kt == null || !kt.isEnum()) {
                throw new IllegalArgumentException("Can not construct EnumMap; generic (key) type not available");
            }
            return new EnumMapDeserializer(keyType.getRawClass(), this.createEnumDeserializer(config2, p, keyType, property), contentDeser);
        }
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Map> fallback = _mapFallbacks.get(mapClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Map type " + type);
            }
            mapClass = fallback;
            type = (MapType)type.forcedNarrowBy(mapClass);
            beanDesc = (BasicBeanDescription)config2.introspectForCreation(type);
        }
        boolean fixAccess = config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        Constructor<Map<Object, Object>> defaultCtor = beanDesc.findDefaultConstructor();
        if (defaultCtor != null && fixAccess) {
            ClassUtil.checkAndFixAccess(defaultCtor);
        }
        MapDeserializer md = new MapDeserializer(type, defaultCtor, keyDes, contentDeser, contentTypeDeser);
        md.setIgnorableProperties(config2.getAnnotationIntrospector().findPropertiesToIgnore(beanDesc.getClassInfo()));
        md.setCreators(this.findMapCreators(config2, beanDesc));
        return md;
    }

    @Override
    public JsonDeserializer<?> createMapLikeDeserializer(DeserializationConfig config2, DeserializerProvider p, MapLikeType type, BeanProperty property) throws JsonMappingException {
        TypeDeserializer contentTypeDeser;
        BasicBeanDescription beanDesc = (BasicBeanDescription)config2.introspectForCreation(type = (MapLikeType)this.mapAbstractType(config2, type));
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config2, beanDesc.getClassInfo(), property);
        if (deser != null) {
            return deser;
        }
        type = this.modifyTypeByAnnotation(config2, beanDesc.getClassInfo(), type, null);
        JavaType keyType = type.getKeyType();
        JavaType contentType = type.getContentType();
        JsonDeserializer contentDeser = (JsonDeserializer)contentType.getValueHandler();
        KeyDeserializer keyDes = (KeyDeserializer)keyType.getValueHandler();
        if (keyDes == null) {
            keyDes = p.findKeyDeserializer(config2, keyType, property);
        }
        if ((contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler()) == null) {
            contentTypeDeser = this.findTypeDeserializer(config2, contentType, property);
        }
        return this._findCustomMapLikeDeserializer(type, config2, p, beanDesc, property, keyDes, contentTypeDeser, contentDeser);
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationConfig config2, DeserializerProvider p, JavaType type, BeanProperty property) throws JsonMappingException {
        BasicBeanDescription beanDesc = (BasicBeanDescription)config2.introspectForCreation(type);
        JsonDeserializer<Object> des = this.findDeserializerFromAnnotation(config2, beanDesc.getClassInfo(), property);
        if (des != null) {
            return des;
        }
        Class<?> enumClass = type.getRawClass();
        JsonDeserializer<?> custom = this._findCustomEnumDeserializer(enumClass, config2, beanDesc, property);
        if (custom != null) {
            return custom;
        }
        for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
            Class<?> returnType;
            if (!config2.getAnnotationIntrospector().hasCreatorAnnotation(factory)) continue;
            int argCount = factory.getParameterCount();
            if (argCount == 1 && (returnType = factory.getRawType()).isAssignableFrom(enumClass)) {
                return EnumDeserializer.deserializerForCreator(config2, enumClass, factory);
            }
            throw new IllegalArgumentException("Unsuitable method (" + factory + ") decorated with @JsonCreator (for Enum type " + enumClass.getName() + ")");
        }
        return new EnumDeserializer(this.constructEnumResolver(enumClass, config2));
    }

    @Override
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig config2, DeserializerProvider p, JavaType nodeType, BeanProperty property) throws JsonMappingException {
        Class<?> nodeClass = nodeType.getRawClass();
        JsonDeserializer<?> custom = this._findCustomTreeNodeDeserializer(nodeClass, config2, property);
        if (custom != null) {
            return custom;
        }
        return JsonNodeDeserializer.getDeserializer(nodeClass);
    }

    protected JsonDeserializer<Object> findStdBeanDeserializer(DeserializationConfig config2, DeserializerProvider p, JavaType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = _simpleDeserializers.get(type);
        if (deser != null) {
            return deser;
        }
        Class<?> cls = type.getRawClass();
        if (cls == Class.class) {
            return new StdDeserializer.ClassDeserializer();
        }
        if (AtomicReference.class.isAssignableFrom(cls)) {
            TypeFactory tf = config2.getTypeFactory();
            JavaType[] params2 = tf.findTypeParameters(type, AtomicReference.class);
            JavaType referencedType = params2 == null || params2.length < 1 ? TypeFactory.unknownType() : params2[0];
            StdDeserializer.AtomicReferenceDeserializer d2 = new StdDeserializer.AtomicReferenceDeserializer(referencedType, property);
            return d2;
        }
        JsonDeserializer<Object> d = this.optionalHandlers.findDeserializer(type, config2, p);
        if (d != null) {
            return d;
        }
        return null;
    }

    @Override
    public TypeDeserializer findTypeDeserializer(DeserializationConfig config2, JavaType baseType, BeanProperty property) {
        Class<?> cls = baseType.getRawClass();
        BasicBeanDescription bean = (BasicBeanDescription)config2.introspectClassAnnotations(cls);
        AnnotatedClass ac = bean.getClassInfo();
        AnnotationIntrospector ai = config2.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findTypeResolver(config2, ac, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config2.getDefaultTyper(baseType);
            if (b == null) {
                return null;
            }
        } else {
            subtypes = config2.getSubtypeResolver().collectAndResolveSubtypes(ac, config2, ai);
        }
        return b.buildTypeDeserializer(config2, baseType, subtypes, property);
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig config2, JavaType baseType, AnnotatedMember annotated, BeanProperty property) {
        AnnotationIntrospector ai = config2.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyTypeResolver(config2, annotated, baseType);
        if (b == null) {
            return this.findTypeDeserializer(config2, baseType, property);
        }
        Collection<NamedType> subtypes = config2.getSubtypeResolver().collectAndResolveSubtypes(annotated, config2, ai);
        return b.buildTypeDeserializer(config2, baseType, subtypes, property);
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig config2, JavaType containerType, AnnotatedMember propertyEntity, BeanProperty property) {
        AnnotationIntrospector ai = config2.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyContentTypeResolver(config2, propertyEntity, containerType);
        JavaType contentType = containerType.getContentType();
        if (b == null) {
            return this.findTypeDeserializer(config2, contentType, property);
        }
        Collection<NamedType> subtypes = config2.getSubtypeResolver().collectAndResolveSubtypes(propertyEntity, config2, ai);
        return b.buildTypeDeserializer(config2, contentType, subtypes, property);
    }

    protected abstract JavaType mapAbstractType(DeserializationConfig var1, JavaType var2) throws JsonMappingException;

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationConfig config2, Annotated ann, BeanProperty property) throws JsonMappingException {
        Object deserDef = config2.getAnnotationIntrospector().findDeserializer(ann);
        if (deserDef != null) {
            return this._constructDeserializer(config2, ann, property, deserDef);
        }
        return null;
    }

    JsonDeserializer<Object> _constructDeserializer(DeserializationConfig config2, Annotated ann, BeanProperty property, Object deserDef) throws JsonMappingException {
        if (deserDef instanceof JsonDeserializer) {
            JsonDeserializer deser = (JsonDeserializer)deserDef;
            if (deser instanceof ContextualDeserializer) {
                deser = ((ContextualDeserializer)((Object)deser)).createContextual(config2, property);
            }
            return deser;
        }
        if (!(deserDef instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + deserDef.getClass().getName() + "; expected type JsonDeserializer or Class<JsonDeserializer> instead");
        }
        Class deserClass = (Class)deserDef;
        if (!JsonDeserializer.class.isAssignableFrom(deserClass)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + deserClass.getName() + "; expected Class<JsonDeserializer>");
        }
        JsonDeserializer<Object> deser = config2.deserializerInstance(ann, deserClass);
        if (deser instanceof ContextualDeserializer) {
            deser = ((ContextualDeserializer)((Object)deser)).createContextual(config2, property);
        }
        return deser;
    }

    protected <T extends JavaType> T modifyTypeByAnnotation(DeserializationConfig config2, Annotated a, T type, String propName) throws JsonMappingException {
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        Class<?> subclass = intr.findDeserializationType(a, (JavaType)type, propName);
        if (subclass != null) {
            try {
                type = ((JavaType)type).narrowBy(subclass);
            }
            catch (IllegalArgumentException iae) {
                throw new JsonMappingException("Failed to narrow type " + type + " with concrete-type annotation (value " + subclass.getName() + "), method '" + a.getName() + "': " + iae.getMessage(), null, iae);
            }
        }
        if (((JavaType)type).isContainerType()) {
            Class<? extends JsonDeserializer<?>> cdClass;
            JavaType contentType;
            Class<?> cc;
            Class<? extends KeyDeserializer> kdClass;
            JavaType keyType;
            Class<?> keyClass = intr.findDeserializationKeyType(a, ((JavaType)type).getKeyType(), propName);
            if (keyClass != null) {
                if (!(type instanceof MapType)) {
                    throw new JsonMappingException("Illegal key-type annotation: type " + type + " is not a Map type");
                }
                try {
                    type = ((MapType)type).narrowKey(keyClass);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException("Failed to narrow key type " + type + " with key-type annotation (" + keyClass.getName() + "): " + iae.getMessage(), null, iae);
                }
            }
            if ((keyType = ((JavaType)type).getKeyType()) != null && keyType.getValueHandler() == null && (kdClass = intr.findKeyDeserializer(a)) != null && kdClass != KeyDeserializer.None.class) {
                KeyDeserializer kd = config2.keyDeserializerInstance(a, kdClass);
                keyType.setValueHandler(kd);
            }
            if ((cc = intr.findDeserializationContentType(a, ((JavaType)type).getContentType(), propName)) != null) {
                try {
                    type = ((JavaType)type).narrowContentsBy(cc);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException("Failed to narrow content type " + type + " with content-type annotation (" + cc.getName() + "): " + iae.getMessage(), null, iae);
                }
            }
            if ((contentType = ((JavaType)type).getContentType()).getValueHandler() == null && (cdClass = intr.findContentDeserializer(a)) != null && cdClass != JsonDeserializer.None.class) {
                JsonDeserializer<Object> cd = config2.deserializerInstance(a, cdClass);
                ((JavaType)type).getContentType().setValueHandler(cd);
            }
        }
        return (T)type;
    }

    protected JavaType resolveType(DeserializationConfig config2, BasicBeanDescription beanDesc, JavaType type, AnnotatedMember member, BeanProperty property) {
        TypeDeserializer valueTypeDeser;
        if (type.isContainerType()) {
            TypeDeserializer contentTypeDeser;
            Class<? extends JsonDeserializer<?>> cdClass;
            Class<? extends KeyDeserializer> kdClass;
            AnnotationIntrospector intr = config2.getAnnotationIntrospector();
            JavaType keyType = type.getKeyType();
            if (keyType != null && (kdClass = intr.findKeyDeserializer(member)) != null && kdClass != KeyDeserializer.None.class) {
                KeyDeserializer kd = config2.keyDeserializerInstance(member, kdClass);
                keyType.setValueHandler(kd);
            }
            if ((cdClass = intr.findContentDeserializer(member)) != null && cdClass != JsonDeserializer.None.class) {
                JsonDeserializer<Object> cd = config2.deserializerInstance(member, cdClass);
                type.getContentType().setValueHandler(cd);
            }
            if (member instanceof AnnotatedMember && (contentTypeDeser = this.findPropertyContentTypeDeserializer(config2, type, member, property)) != null) {
                type = type.withContentTypeHandler(contentTypeDeser);
            }
        }
        if ((valueTypeDeser = member instanceof AnnotatedMember ? this.findPropertyTypeDeserializer(config2, type, member, property) : this.findTypeDeserializer(config2, type, null)) != null) {
            type = type.withTypeHandler(valueTypeDeser);
        }
        return type;
    }

    protected EnumResolver<?> constructEnumResolver(Class<?> enumClass, DeserializationConfig config2) {
        if (config2.isEnabled(DeserializationConfig.Feature.READ_ENUMS_USING_TO_STRING)) {
            return EnumResolver.constructUnsafeUsingToString(enumClass);
        }
        return EnumResolver.constructUnsafe(enumClass, config2.getAnnotationIntrospector());
    }

    protected CreatorContainer findMapCreators(DeserializationConfig config2, BasicBeanDescription beanDesc) throws JsonMappingException {
        String name2;
        AnnotatedParameter param2;
        int i;
        int nameCount;
        SettableBeanProperty[] properties;
        int argCount;
        AnnotationIntrospector intr = config2.getAnnotationIntrospector();
        boolean fixAccess = config2.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        CreatorContainer creators = new CreatorContainer(beanDesc, fixAccess);
        for (AnnotatedConstructor ctor : beanDesc.getConstructors()) {
            argCount = ctor.getParameterCount();
            if (argCount < 1 || !intr.hasCreatorAnnotation(ctor)) continue;
            properties = new SettableBeanProperty[argCount];
            nameCount = 0;
            for (i = 0; i < argCount; ++i) {
                param2 = ctor.getParameter(i);
                String string2 = name2 = param2 == null ? null : intr.findPropertyNameForParam(param2);
                if (name2 == null || name2.length() == 0) {
                    throw new IllegalArgumentException("Parameter #" + i + " of constructor " + ctor + " has no property name annotation: must have for @JsonCreator for a Map type");
                }
                ++nameCount;
                properties[i] = this.constructCreatorProperty(config2, beanDesc, name2, i, param2);
            }
            creators.addPropertyConstructor(ctor, properties);
        }
        for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
            argCount = factory.getParameterCount();
            if (argCount < 1 || !intr.hasCreatorAnnotation(factory)) continue;
            properties = new SettableBeanProperty[argCount];
            nameCount = 0;
            for (i = 0; i < argCount; ++i) {
                param2 = factory.getParameter(i);
                String string3 = name2 = param2 == null ? null : intr.findPropertyNameForParam(param2);
                if (name2 == null || name2.length() == 0) {
                    throw new IllegalArgumentException("Parameter #" + i + " of factory method " + factory + " has no property name annotation: must have for @JsonCreator for a Map type");
                }
                ++nameCount;
                properties[i] = this.constructCreatorProperty(config2, beanDesc, name2, i, param2);
            }
            creators.addPropertyFactory(factory, properties);
        }
        return creators;
    }

    protected SettableBeanProperty constructCreatorProperty(DeserializationConfig config2, BasicBeanDescription beanDesc, String name2, int index2, AnnotatedParameter param2) throws JsonMappingException {
        BeanProperty.Std property;
        JavaType t0 = config2.getTypeFactory().constructType(param2.getParameterType(), beanDesc.bindingsForBeanType());
        JavaType type = this.resolveType(config2, beanDesc, t0, param2, property = new BeanProperty.Std(name2, t0, beanDesc.getClassAnnotations(), param2));
        if (type != t0) {
            property = property.withType(type);
        }
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config2, param2, property);
        type = this.modifyTypeByAnnotation(config2, param2, type, name2);
        TypeDeserializer typeDeser = this.findTypeDeserializer(config2, type, property);
        SettableBeanProperty.CreatorProperty prop = new SettableBeanProperty.CreatorProperty(name2, type, typeDeser, beanDesc.getClassAnnotations(), param2, index2);
        if (deser != null) {
            prop.setValueDeserializer(deser);
        }
        return prop;
    }

    static {
        _mapFallbacks.put(Map.class.getName(), LinkedHashMap.class);
        _mapFallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        _mapFallbacks.put(SortedMap.class.getName(), TreeMap.class);
        _mapFallbacks.put("java.util.NavigableMap", TreeMap.class);
        try {
            Class<?> value2;
            Class<?> key = Class.forName("java.util.ConcurrentNavigableMap");
            Class<?> mapValue = value2 = Class.forName("java.util.ConcurrentSkipListMap");
            _mapFallbacks.put(key.getName(), mapValue);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        _collectionFallbacks = new HashMap();
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), HashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
        _arrayDeserializers = ArrayDeserializers.getAll();
    }
}

