/*
 * Decompiled with CFR 0.152.
 */
package org.ccil.cowan.tagsoup;

import org.ccil.cowan.tagsoup.AttributesImpl;
import org.ccil.cowan.tagsoup.Schema;

public class ElementType {
    private String theName;
    private String theNamespace;
    private String theLocalName;
    private int theModel;
    private int theMemberOf;
    private int theFlags;
    private AttributesImpl theAtts;
    private ElementType theParent;
    private Schema theSchema;

    public ElementType(String name2, int model, int memberOf, int flags2, Schema schema) {
        this.theName = name2;
        this.theModel = model;
        this.theMemberOf = memberOf;
        this.theFlags = flags2;
        this.theAtts = new AttributesImpl();
        this.theSchema = schema;
        this.theNamespace = this.namespace(name2, false);
        this.theLocalName = this.localName(name2);
    }

    public String namespace(String name2, boolean attribute) {
        int colon2 = name2.indexOf(58);
        if (colon2 == -1) {
            return attribute ? "" : this.theSchema.getURI();
        }
        String prefix = name2.substring(0, colon2);
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return ("urn:x-prefix:" + prefix).intern();
    }

    public String localName(String name2) {
        int colon2 = name2.indexOf(58);
        if (colon2 == -1) {
            return name2;
        }
        return name2.substring(colon2 + 1).intern();
    }

    public String name() {
        return this.theName;
    }

    public String namespace() {
        return this.theNamespace;
    }

    public String localName() {
        return this.theLocalName;
    }

    public int model() {
        return this.theModel;
    }

    public int memberOf() {
        return this.theMemberOf;
    }

    public int flags() {
        return this.theFlags;
    }

    public AttributesImpl atts() {
        return this.theAtts;
    }

    public ElementType parent() {
        return this.theParent;
    }

    public Schema schema() {
        return this.theSchema;
    }

    public boolean canContain(ElementType other) {
        return (this.theModel & other.theMemberOf) != 0;
    }

    public void setAttribute(AttributesImpl atts, String name2, String type, String value2) {
        if (name2.equals("xmlns") || name2.startsWith("xmlns:")) {
            return;
        }
        String namespace = this.namespace(name2, true);
        String localName = this.localName(name2);
        int i = atts.getIndex(name2);
        if (i == -1) {
            name2 = name2.intern();
            if (type == null) {
                type = "CDATA";
            }
            if (!type.equals("CDATA")) {
                value2 = ElementType.normalize(value2);
            }
            atts.addAttribute(namespace, localName, name2, type, value2);
        } else {
            if (type == null) {
                type = atts.getType(i);
            }
            if (!type.equals("CDATA")) {
                value2 = ElementType.normalize(value2);
            }
            atts.setAttribute(i, namespace, localName, name2, type, value2);
        }
    }

    public static String normalize(String value2) {
        if (value2 == null) {
            return value2;
        }
        if ((value2 = value2.trim()).indexOf("  ") == -1) {
            return value2;
        }
        boolean space = false;
        int len = value2.length();
        StringBuffer b = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char v = value2.charAt(i);
            if (v == ' ') {
                if (!space) {
                    b.append(v);
                }
                space = true;
                continue;
            }
            b.append(v);
            space = false;
        }
        return b.toString();
    }

    public void setAttribute(String name2, String type, String value2) {
        this.setAttribute(this.theAtts, name2, type, value2);
    }

    public void setModel(int model) {
        this.theModel = model;
    }

    public void setMemberOf(int memberOf) {
        this.theMemberOf = memberOf;
    }

    public void setFlags(int flags2) {
        this.theFlags = flags2;
    }

    public void setParent(ElementType parent) {
        this.theParent = parent;
    }
}

