/*
 * Decompiled with CFR 0.152.
 */
package org.ccil.cowan.tagsoup;

import org.xml.sax.Attributes;

public class AttributesImpl
implements Attributes {
    int length;
    String[] data;

    public AttributesImpl() {
        this.length = 0;
        this.data = null;
    }

    public AttributesImpl(Attributes atts) {
        this.setAttributes(atts);
    }

    public int getLength() {
        return this.length;
    }

    public String getURI(int index2) {
        if (index2 >= 0 && index2 < this.length) {
            return this.data[index2 * 5];
        }
        return null;
    }

    public String getLocalName(int index2) {
        if (index2 >= 0 && index2 < this.length) {
            return this.data[index2 * 5 + 1];
        }
        return null;
    }

    public String getQName(int index2) {
        if (index2 >= 0 && index2 < this.length) {
            return this.data[index2 * 5 + 2];
        }
        return null;
    }

    public String getType(int index2) {
        if (index2 >= 0 && index2 < this.length) {
            return this.data[index2 * 5 + 3];
        }
        return null;
    }

    public String getValue(int index2) {
        if (index2 >= 0 && index2 < this.length) {
            return this.data[index2 * 5 + 4];
        }
        return null;
    }

    public int getIndex(String uri, String localName) {
        int max2 = this.length * 5;
        for (int i = 0; i < max2; i += 5) {
            if (!this.data[i].equals(uri) || !this.data[i + 1].equals(localName)) continue;
            return i / 5;
        }
        return -1;
    }

    public int getIndex(String qName) {
        int max2 = this.length * 5;
        for (int i = 0; i < max2; i += 5) {
            if (!this.data[i + 2].equals(qName)) continue;
            return i / 5;
        }
        return -1;
    }

    public String getType(String uri, String localName) {
        int max2 = this.length * 5;
        for (int i = 0; i < max2; i += 5) {
            if (!this.data[i].equals(uri) || !this.data[i + 1].equals(localName)) continue;
            return this.data[i + 3];
        }
        return null;
    }

    public String getType(String qName) {
        int max2 = this.length * 5;
        for (int i = 0; i < max2; i += 5) {
            if (!this.data[i + 2].equals(qName)) continue;
            return this.data[i + 3];
        }
        return null;
    }

    public String getValue(String uri, String localName) {
        int max2 = this.length * 5;
        for (int i = 0; i < max2; i += 5) {
            if (!this.data[i].equals(uri) || !this.data[i + 1].equals(localName)) continue;
            return this.data[i + 4];
        }
        return null;
    }

    public String getValue(String qName) {
        int max2 = this.length * 5;
        for (int i = 0; i < max2; i += 5) {
            if (!this.data[i + 2].equals(qName)) continue;
            return this.data[i + 4];
        }
        return null;
    }

    public void clear() {
        if (this.data != null) {
            for (int i = 0; i < this.length * 5; ++i) {
                this.data[i] = null;
            }
        }
        this.length = 0;
    }

    public void setAttributes(Attributes atts) {
        this.clear();
        this.length = atts.getLength();
        if (this.length > 0) {
            this.data = new String[this.length * 5];
            for (int i = 0; i < this.length; ++i) {
                this.data[i * 5] = atts.getURI(i);
                this.data[i * 5 + 1] = atts.getLocalName(i);
                this.data[i * 5 + 2] = atts.getQName(i);
                this.data[i * 5 + 3] = atts.getType(i);
                this.data[i * 5 + 4] = atts.getValue(i);
            }
        }
    }

    public void addAttribute(String uri, String localName, String qName, String type, String value2) {
        this.ensureCapacity(this.length + 1);
        this.data[this.length * 5] = uri;
        this.data[this.length * 5 + 1] = localName;
        this.data[this.length * 5 + 2] = qName;
        this.data[this.length * 5 + 3] = type;
        this.data[this.length * 5 + 4] = value2;
        ++this.length;
    }

    public void setAttribute(int index2, String uri, String localName, String qName, String type, String value2) {
        if (index2 >= 0 && index2 < this.length) {
            this.data[index2 * 5] = uri;
            this.data[index2 * 5 + 1] = localName;
            this.data[index2 * 5 + 2] = qName;
            this.data[index2 * 5 + 3] = type;
            this.data[index2 * 5 + 4] = value2;
        } else {
            this.badIndex(index2);
        }
    }

    public void removeAttribute(int index2) {
        if (index2 >= 0 && index2 < this.length) {
            if (index2 < this.length - 1) {
                System.arraycopy(this.data, (index2 + 1) * 5, this.data, index2 * 5, (this.length - index2 - 1) * 5);
            }
            index2 = (this.length - 1) * 5;
            this.data[index2++] = null;
            this.data[index2++] = null;
            this.data[index2++] = null;
            this.data[index2++] = null;
            this.data[index2] = null;
            --this.length;
        } else {
            this.badIndex(index2);
        }
    }

    public void setURI(int index2, String uri) {
        if (index2 >= 0 && index2 < this.length) {
            this.data[index2 * 5] = uri;
        } else {
            this.badIndex(index2);
        }
    }

    public void setLocalName(int index2, String localName) {
        if (index2 >= 0 && index2 < this.length) {
            this.data[index2 * 5 + 1] = localName;
        } else {
            this.badIndex(index2);
        }
    }

    public void setQName(int index2, String qName) {
        if (index2 >= 0 && index2 < this.length) {
            this.data[index2 * 5 + 2] = qName;
        } else {
            this.badIndex(index2);
        }
    }

    public void setType(int index2, String type) {
        if (index2 >= 0 && index2 < this.length) {
            this.data[index2 * 5 + 3] = type;
        } else {
            this.badIndex(index2);
        }
    }

    public void setValue(int index2, String value2) {
        if (index2 >= 0 && index2 < this.length) {
            this.data[index2 * 5 + 4] = value2;
        } else {
            this.badIndex(index2);
        }
    }

    private void ensureCapacity(int n) {
        int max2;
        if (n <= 0) {
            return;
        }
        if (this.data == null || this.data.length == 0) {
            max2 = 25;
        } else {
            if (this.data.length >= n * 5) {
                return;
            }
            max2 = this.data.length;
        }
        while (max2 < n * 5) {
            max2 *= 2;
        }
        String[] newData = new String[max2];
        if (this.length > 0) {
            System.arraycopy(this.data, 0, newData, 0, this.length * 5);
        }
        this.data = newData;
    }

    private void badIndex(int index2) throws ArrayIndexOutOfBoundsException {
        String msg = "Attempt to modify attribute at illegal index: " + index2;
        throw new ArrayIndexOutOfBoundsException(msg);
    }
}

