/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scalding;

import com.twitter.scalding.ScaldingILoop;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scalding.ZeppelinScaldingShell;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Console;
import scala.tools.nsc.interpreter.Results;
import scala.tools.nsc.interpreter.Results$Incomplete$;
import scala.tools.nsc.interpreter.Results$Success$;

public class ScaldingInterpreter
extends Interpreter {
    public static final Logger LOGGER = LoggerFactory.getLogger(ScaldingInterpreter.class);
    static final String ARGS_STRING = "args.string";
    static final String ARGS_STRING_DEFAULT = "--local --repl";
    static final String MAX_OPEN_INSTANCES = "max.open.instances";
    static final String MAX_OPEN_INSTANCES_DEFAULT = "50";
    public static final List NO_COMPLETION = Collections.unmodifiableList(new ArrayList());
    static int numOpenInstances = 0;
    private ScaldingILoop interpreter;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();

    public ScaldingInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        ++numOpenInstances;
        String maxOpenInstancesStr = this.getProperty(MAX_OPEN_INSTANCES, MAX_OPEN_INSTANCES_DEFAULT);
        int maxOpenInstances = 50;
        try {
            maxOpenInstances = Integer.valueOf(maxOpenInstancesStr);
        }
        catch (Exception e) {
            LOGGER.error("Error reading max.open.instances", e);
        }
        LOGGER.info("max.open.instances = {}", (Object)maxOpenInstances);
        if (numOpenInstances > maxOpenInstances) {
            LOGGER.error("Reached maximum number of open instances");
            return;
        }
        LOGGER.info("Opening instance {}", (Object)numOpenInstances);
        LOGGER.info("property: {}", (Object)this.getProperties());
        String argsString = this.getProperty(ARGS_STRING, ARGS_STRING_DEFAULT);
        Object[] args2 = argsString == null ? new String[]{} : argsString.split(" ");
        LOGGER.info("{}", (Object)Arrays.toString(args2));
        PrintWriter printWriter = new PrintWriter(this.out, true);
        this.interpreter = ZeppelinScaldingShell.getRepl((String[])args2, printWriter);
        this.interpreter.createInterpreter();
    }

    public void close() {
        this.interpreter.intp().close();
    }

    public InterpreterResult interpret(String cmd, InterpreterContext contextInterpreter) {
        String user = contextInterpreter.getAuthenticationInfo().getUser();
        LOGGER.info("Running Scalding command: user: {} cmd: '{}'", (Object)user, (Object)cmd);
        if (this.interpreter == null) {
            LOGGER.error("interpreter == null, open may not have been called because max.open.instances reached");
            return new InterpreterResult(InterpreterResult.Code.ERROR, "interpreter == null\nopen may not have been called because max.open.instances reached");
        }
        if (cmd == null || cmd.trim().length() == 0) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR);
        if (this.getProperty(ARGS_STRING).contains("hdfs")) {
            UserGroupInformation ugi = null;
            try {
                ugi = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
            }
            catch (IOException e) {
                LOGGER.error("Error creating UserGroupInformation", e);
                return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
            }
            try {
                final String cmd1 = cmd;
                final InterpreterContext contextInterpreter1 = contextInterpreter;
                PrivilegedExceptionAction<InterpreterResult> action2 = new PrivilegedExceptionAction<InterpreterResult>(){

                    @Override
                    public InterpreterResult run() throws Exception {
                        return ScaldingInterpreter.this.interpret(cmd1.split("\n"), contextInterpreter1);
                    }
                };
                interpreterResult = (InterpreterResult)ugi.doAs((PrivilegedExceptionAction)action2);
            }
            catch (Exception e) {
                LOGGER.error("Error running command with ugi.doAs", e);
                return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
            }
        }
        interpreterResult = this.interpret(cmd.split("\n"), contextInterpreter);
        return interpreterResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult interpret(String[] lines2, InterpreterContext context) {
        ScaldingInterpreter scaldingInterpreter = this;
        synchronized (scaldingInterpreter) {
            InterpreterResult r = this.interpretInput(lines2);
            return r;
        }
    }

    public InterpreterResult interpretInput(String[] lines2) {
        String[] linesToRun = new String[lines2.length + 1];
        for (int i = 0; i < lines2.length; ++i) {
            linesToRun[i] = lines2[i];
        }
        linesToRun[lines2.length] = "print(\"\")";
        this.out.reset();
        PrintStream printStream = new PrintStream(this.out, true);
        Console.setOut(printStream);
        InterpreterResult.Code r = null;
        String incomplete = "";
        boolean inComment = false;
        for (int l = 0; l < linesToRun.length; ++l) {
            String s2 = linesToRun[l];
            if (l + 1 < linesToRun.length) {
                String nextLine = linesToRun[l + 1].trim();
                boolean continuation = false;
                if (nextLine.isEmpty() || nextLine.startsWith("//") || nextLine.startsWith("}") || nextLine.startsWith("object")) {
                    continuation = true;
                } else if (!inComment && nextLine.startsWith("/*")) {
                    inComment = true;
                    continuation = true;
                } else if (inComment && nextLine.lastIndexOf("*/") >= 0) {
                    inComment = false;
                    continuation = true;
                } else if (nextLine.length() > 1 && nextLine.charAt(0) == '.' && nextLine.charAt(1) != '.' && nextLine.charAt(1) != '/') {
                    continuation = true;
                } else if (inComment) {
                    continuation = true;
                }
                if (continuation) {
                    incomplete = incomplete + s2 + "\n";
                    continue;
                }
            }
            Results.Result res = null;
            try {
                res = this.interpreter.intp().interpret(incomplete + s2);
            }
            catch (Exception e) {
                LOGGER.error("Interpreter exception: ", e);
                return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
            }
            r = this.getResultCode(res);
            if (r == InterpreterResult.Code.ERROR) {
                Console.flush();
                return new InterpreterResult(r, this.out.toString());
            }
            incomplete = r == InterpreterResult.Code.INCOMPLETE ? incomplete + s2 + "\n" : "";
        }
        if (r == InterpreterResult.Code.INCOMPLETE) {
            return new InterpreterResult(r, "Incomplete expression");
        }
        Console.flush();
        return new InterpreterResult(r, this.out.toString());
    }

    private InterpreterResult.Code getResultCode(Results.Result r) {
        if (r instanceof Results$Success$) {
            return InterpreterResult.Code.SUCCESS;
        }
        if (r instanceof Results$Incomplete$) {
            return InterpreterResult.Code.INCOMPLETE;
        }
        return InterpreterResult.Code.ERROR;
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(ScaldingInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return NO_COMPLETION;
    }
}

