/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.util.introspection.Introspector;
import org.apache.velocity.util.introspection.SecureIntrospectorControl;

public class SecureIntrospectorImpl
extends Introspector
implements SecureIntrospectorControl {
    private String[] badClasses;
    private String[] badPackages;

    public SecureIntrospectorImpl(String[] badClasses, String[] badPackages, Log log2) {
        super(log2);
        this.badClasses = badClasses;
        this.badPackages = badPackages;
    }

    public Method getMethod(Class clazz2, String methodName, Object[] params2) throws IllegalArgumentException {
        if (!this.checkObjectExecutePermission(clazz2, methodName)) {
            this.log.warn("Cannot retrieve method " + methodName + " from object of class " + clazz2.getName() + " due to security restrictions.");
            return null;
        }
        return super.getMethod(clazz2, methodName, params2);
    }

    public boolean checkObjectExecutePermission(Class clazz2, String methodName) {
        int i;
        int dotPos;
        if (methodName != null && (methodName.equals("wait") || methodName.equals("notify"))) {
            return false;
        }
        if (Number.class.isAssignableFrom(clazz2)) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(clazz2)) {
            return true;
        }
        if (String.class.isAssignableFrom(clazz2)) {
            return true;
        }
        if (Class.class.isAssignableFrom(clazz2) && methodName != null && methodName.equals("getName")) {
            return true;
        }
        String className = clazz2.getName();
        if (className.startsWith("[L") && className.endsWith(";")) {
            className = className.substring(2, className.length() - 1);
        }
        String packageName = (dotPos = className.lastIndexOf(46)) == -1 ? "" : className.substring(0, dotPos);
        int size2 = this.badPackages.length;
        for (i = 0; i < size2; ++i) {
            if (!packageName.equals(this.badPackages[i])) continue;
            return false;
        }
        size2 = this.badClasses.length;
        for (i = 0; i < size2; ++i) {
            if (!className.equals(this.badClasses[i])) continue;
            return false;
        }
        return true;
    }
}

