/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import org.apache.velocity.runtime.RuntimeLogger;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.runtime.log.RuntimeLoggerLog;
import org.apache.velocity.util.introspection.IntrospectorBase;
import org.apache.velocity.util.introspection.MethodMap;

public class Introspector
extends IntrospectorBase {
    public Introspector(Log log2) {
        super(log2);
    }

    public Introspector(RuntimeLogger logger) {
        this(new RuntimeLoggerLog(logger));
    }

    public Method getMethod(Class c, String name2, Object[] params2) throws IllegalArgumentException {
        try {
            return super.getMethod(c, name2, params2);
        }
        catch (MethodMap.AmbiguousException ae) {
            StringBuffer msg = new StringBuffer("Introspection Error : Ambiguous method invocation ").append(name2).append("(");
            for (int i = 0; i < params2.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                if (params2[i] == null) {
                    msg.append("null");
                    continue;
                }
                msg.append(params2[i].getClass().getName());
            }
            msg.append(") for class ").append(c);
            this.log.debug(msg.toString());
            return null;
        }
    }
}

