/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class MapFactory {
    private static Constructor concurrentHashMapConstructor;

    public static Map create(boolean allowNullKeys) {
        return MapFactory.create(16, 0.75f, 16, allowNullKeys);
    }

    public static Map create(int size2, float loadFactor, int concurrencyLevel, boolean allowNullKeys) {
        Map map2 = null;
        if (concurrencyLevel <= 1) {
            map2 = new HashMap(size2, loadFactor);
        } else if (concurrentHashMapConstructor != null) {
            try {
                map2 = (Map)concurrentHashMapConstructor.newInstance(new Integer(size2), new Float(loadFactor), new Integer(concurrencyLevel));
            }
            catch (Exception ex) {
                throw new RuntimeException("this should not happen", ex);
            }
        } else {
            map2 = allowNullKeys ? Collections.synchronizedMap(new HashMap(size2, loadFactor)) : new Hashtable(size2, loadFactor);
        }
        return map2;
    }

    static {
        try {
            concurrentHashMapConstructor = Class.forName("java.util.concurrent.ConcurrentHashMap").getConstructor(Integer.TYPE, Float.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

