/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util;

import java.io.InputStream;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.node.ASTMethod;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.IntrospectionCacheData;
import org.apache.velocity.util.introspection.VelMethod;

public class ClassUtils {
    private ClassUtils() {
    }

    public static Class getClass(String clazz2) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                return Class.forName(clazz2, true, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(clazz2);
    }

    public static Object getNewInstance(String clazz2) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ClassUtils.getClass(clazz2).newInstance();
    }

    public static InputStream getResourceAsStream(Class claz, String name2) {
        InputStream result2 = null;
        while (name2.startsWith("/")) {
            name2 = name2.substring(1);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = claz.getClassLoader();
            result2 = classLoader.getResourceAsStream(name2);
        } else {
            result2 = classLoader.getResourceAsStream(name2);
            if (result2 == null && (classLoader = claz.getClassLoader()) != null) {
                result2 = classLoader.getResourceAsStream(name2);
            }
        }
        return result2;
    }

    public static VelMethod getMethod(String methodName, Object[] params2, Class[] paramClasses, Object o, InternalContextAdapter context, SimpleNode node, boolean strictRef) {
        VelMethod method = null;
        try {
            ASTMethod.MethodCacheKey mck = new ASTMethod.MethodCacheKey(methodName, paramClasses);
            IntrospectionCacheData icd = context.icacheGet(mck);
            if (icd != null && o != null && icd.contextData == o.getClass()) {
                method = (VelMethod)icd.thingy;
            } else {
                method = node.getRuntimeServices().getUberspect().getMethod(o, methodName, params2, new Info(node.getTemplateName(), node.getLine(), node.getColumn()));
                if (method != null && o != null) {
                    icd = new IntrospectionCacheData();
                    icd.contextData = o.getClass();
                    icd.thingy = method;
                    context.icachePut(mck, icd);
                }
            }
            if (method == null) {
                if (strictRef) {
                    StringBuffer plist = new StringBuffer();
                    for (int i = 0; i < params2.length; ++i) {
                        Class param2 = paramClasses[i];
                        plist.append(param2 == null ? "null" : param2.getName());
                        if (i >= params2.length - 1) continue;
                        plist.append(", ");
                    }
                    throw new MethodInvocationException("Object '" + o.getClass().getName() + "' does not contain method " + methodName + "(" + plist + ")", null, methodName, node.getTemplateName(), node.getLine(), node.getColumn());
                }
                return null;
            }
        }
        catch (MethodInvocationException mie) {
            throw mie;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "ASTMethod.execute() : exception from introspection";
            throw new VelocityException(msg, e);
        }
        return method;
    }
}

