/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class URLResourceLoader
extends ResourceLoader {
    private String[] roots = null;
    protected HashMap templateRoots = null;
    private int timeout = -1;
    private Method[] timeoutMethods;

    public void init(ExtendedProperties configuration) {
        this.log.trace("URLResourceLoader : initialization starting.");
        this.roots = configuration.getStringArray("root");
        if (this.log.isDebugEnabled()) {
            for (int i = 0; i < this.roots.length; ++i) {
                this.log.debug("URLResourceLoader : adding root '" + this.roots[i] + "'");
            }
        }
        this.timeout = configuration.getInt("timeout", -1);
        if (this.timeout > 0) {
            try {
                Class[] types2 = new Class[]{Integer.TYPE};
                Method conn = URLConnection.class.getMethod("setConnectTimeout", types2);
                Method read2 = URLConnection.class.getMethod("setReadTimeout", types2);
                this.timeoutMethods = new Method[]{conn, read2};
                this.log.debug("URLResourceLoader : timeout set to " + this.timeout);
            }
            catch (NoSuchMethodException nsme) {
                this.log.debug("URLResourceLoader : Java 1.5+ is required to customize timeout!", nsme);
                this.timeout = -1;
            }
        }
        this.templateRoots = new HashMap();
        this.log.trace("URLResourceLoader : initialization complete.");
    }

    public synchronized InputStream getResourceStream(String name2) throws ResourceNotFoundException {
        if (StringUtils.isEmpty(name2)) {
            throw new ResourceNotFoundException("URLResourceLoader : No template name provided");
        }
        InputStream inputStream = null;
        Throwable exception = null;
        for (int i = 0; i < this.roots.length; ++i) {
            try {
                URL u = new URL(this.roots[i] + name2);
                URLConnection conn = u.openConnection();
                this.tryToSetTimeout(conn);
                inputStream = conn.getInputStream();
                if (inputStream == null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("URLResourceLoader: Found '" + name2 + "' at '" + this.roots[i] + "'");
                }
                this.templateRoots.put(name2, this.roots[i]);
                break;
            }
            catch (IOException ioe) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("URLResourceLoader: Exception when looking for '" + name2 + "' at '" + this.roots[i] + "'", ioe);
                }
                if (exception != null) continue;
                exception = ioe;
            }
        }
        if (inputStream == null) {
            String msg = exception == null ? "URLResourceLoader : Resource '" + name2 + "' not found." : exception.getMessage();
            throw new ResourceNotFoundException(msg);
        }
        return inputStream;
    }

    public boolean isSourceModified(Resource resource) {
        long fileLastModified = this.getLastModified(resource);
        return fileLastModified == 0L || fileLastModified != resource.getLastModified();
    }

    public long getLastModified(Resource resource) {
        String name2 = resource.getName();
        String root2 = (String)this.templateRoots.get(name2);
        try {
            URL u = new URL(root2 + name2);
            URLConnection conn = u.openConnection();
            this.tryToSetTimeout(conn);
            return conn.getLastModified();
        }
        catch (IOException ioe) {
            String msg = "URLResourceLoader: '" + name2 + "' is no longer reachable at '" + root2 + "'";
            this.log.error(msg, ioe);
            throw new ResourceNotFoundException(msg, ioe);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    private void tryToSetTimeout(URLConnection conn) {
        if (this.timeout > 0) {
            Object[] arg = new Object[]{new Integer(this.timeout)};
            try {
                this.timeoutMethods[0].invoke((Object)conn, arg);
                this.timeoutMethods[1].invoke((Object)conn, arg);
            }
            catch (Exception e) {
                String msg = "Unexpected exception while setting connection timeout for " + conn;
                this.log.error(msg, e);
                throw new VelocityException(msg, e);
            }
        }
    }
}

