/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.runtime.parser.node.SetExecutor;
import org.apache.velocity.util.introspection.Introspector;

public class SetPropertyExecutor
extends SetExecutor {
    private final Introspector introspector;

    public SetPropertyExecutor(Log log2, Introspector introspector, Class clazz2, String property, Object arg) {
        this.log = log2;
        this.introspector = introspector;
        if (StringUtils.isNotEmpty(property)) {
            this.discover(clazz2, property, arg);
        }
    }

    protected Introspector getIntrospector() {
        return this.introspector;
    }

    protected void discover(Class clazz2, String property, Object arg) {
        Object[] params2 = new Object[]{arg};
        try {
            StrBuilder sb = new StrBuilder("set");
            sb.append(property);
            this.setMethod(this.introspector.getMethod(clazz2, sb.toString(), params2));
            if (!this.isAlive()) {
                char c = sb.charAt(3);
                if (Character.isLowerCase(c)) {
                    sb.setCharAt(3, Character.toUpperCase(c));
                } else {
                    sb.setCharAt(3, Character.toLowerCase(c));
                }
                this.setMethod(this.introspector.getMethod(clazz2, sb.toString(), params2));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Exception while looking for property setter for '" + property;
            this.log.error(msg, e);
            throw new VelocityException(msg, e);
        }
    }

    public Object execute(Object o, Object value2) throws IllegalAccessException, InvocationTargetException {
        Object[] params2 = new Object[]{value2};
        return this.isAlive() ? this.getMethod().invoke(o, params2) : null;
    }
}

