/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.app.tools;

import java.lang.reflect.Array;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.apache.velocity.context.Context;

public class VelocityFormatter {
    Context context = null;

    public VelocityFormatter(Context context) {
        this.context = context;
    }

    public String formatShortDate(Date date) {
        return DateFormat.getDateInstance(3).format(date);
    }

    public String formatLongDate(Date date) {
        return DateFormat.getDateInstance(1).format(date);
    }

    public String formatShortDateTime(Date date) {
        return DateFormat.getDateTimeInstance(3, 3).format(date);
    }

    public String formatLongDateTime(Date date) {
        return DateFormat.getDateTimeInstance(1, 1).format(date);
    }

    public String formatArray(Object array2) {
        return this.formatArray(array2, ", ", " and ");
    }

    public String formatArray(Object array2, String delim) {
        return this.formatArray(array2, delim, delim);
    }

    public String formatArray(Object array2, String delim, String finaldelim) {
        StringBuffer sb = new StringBuffer();
        int arrayLen = Array.getLength(array2);
        for (int i = 0; i < arrayLen; ++i) {
            sb.append(Array.get(array2, i).toString());
            if (i < arrayLen - 2) {
                sb.append(delim);
                continue;
            }
            if (i >= arrayLen - 1) continue;
            sb.append(finaldelim);
        }
        return sb.toString();
    }

    public String formatVector(List list2) {
        return this.formatVector(list2, ", ", " and ");
    }

    public String formatVector(List list2, String delim) {
        return this.formatVector(list2, delim, delim);
    }

    public String formatVector(List list2, String delim, String finaldelim) {
        StringBuffer sb = new StringBuffer();
        int size2 = list2.size();
        for (int i = 0; i < size2; ++i) {
            sb.append(list2.get(i));
            if (i < size2 - 2) {
                sb.append(delim);
                continue;
            }
            if (i >= size2 - 1) continue;
            sb.append(finaldelim);
        }
        return sb.toString();
    }

    public String limitLen(int maxlen, String string2) {
        return this.limitLen(maxlen, string2, "...");
    }

    public String limitLen(int maxlen, String string2, String suffix) {
        String ret = string2;
        if (string2.length() > maxlen) {
            ret = string2.substring(0, maxlen - suffix.length()) + suffix;
        }
        return ret;
    }

    public String makeAlternator(String name2, String alt1, String alt2) {
        String[] alternates = new String[]{alt1, alt2};
        this.context.put(name2, new VelocityAlternator(alternates));
        return "";
    }

    public String makeAlternator(String name2, String alt1, String alt2, String alt3) {
        String[] alternates = new String[]{alt1, alt2, alt3};
        this.context.put(name2, new VelocityAlternator(alternates));
        return "";
    }

    public String makeAlternator(String name2, String alt1, String alt2, String alt3, String alt4) {
        String[] alternates = new String[]{alt1, alt2, alt3, alt4};
        this.context.put(name2, new VelocityAlternator(alternates));
        return "";
    }

    public String makeAutoAlternator(String name2, String alt1, String alt2) {
        String[] alternates = new String[]{alt1, alt2};
        this.context.put(name2, new VelocityAutoAlternator(alternates));
        return "";
    }

    public Object isNull(Object o, Object dflt) {
        if (o == null) {
            return dflt;
        }
        return o;
    }

    public class VelocityAutoAlternator
    extends VelocityAlternator {
        public VelocityAutoAlternator(String[] alternates) {
            super(alternates);
        }

        public final String toString() {
            String s2 = this.alternates[this.current];
            this.alternate();
            return s2;
        }
    }

    public class VelocityAlternator {
        protected String[] alternates = null;
        protected int current = 0;

        public VelocityAlternator(String[] alternates) {
            this.alternates = alternates;
        }

        public String alternate() {
            ++this.current;
            this.current %= this.alternates.length;
            return "";
        }

        public String toString() {
            return this.alternates[this.current];
        }
    }
}

