/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.app;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.log.Log;

public class Velocity
implements RuntimeConstants {
    public static void init() {
        RuntimeSingleton.init();
    }

    public static void init(String propsFilename) {
        RuntimeSingleton.init(propsFilename);
    }

    public static void init(Properties p) {
        RuntimeSingleton.init(p);
    }

    public static void setProperty(String key, Object value2) {
        RuntimeSingleton.setProperty(key, value2);
    }

    public static void addProperty(String key, Object value2) {
        RuntimeSingleton.addProperty(key, value2);
    }

    public static void clearProperty(String key) {
        RuntimeSingleton.clearProperty(key);
    }

    public static void setExtendedProperties(ExtendedProperties configuration) {
        RuntimeSingleton.setConfiguration(configuration);
    }

    public static Object getProperty(String key) {
        return RuntimeSingleton.getProperty(key);
    }

    public static boolean evaluate(Context context, Writer out, String logTag, String instring) throws ParseErrorException, MethodInvocationException, ResourceNotFoundException {
        return RuntimeSingleton.getRuntimeServices().evaluate(context, out, logTag, instring);
    }

    public static boolean evaluate(Context context, Writer writer, String logTag, InputStream instream) throws ParseErrorException, MethodInvocationException, ResourceNotFoundException {
        BufferedReader br = null;
        String encoding = null;
        try {
            encoding = RuntimeSingleton.getString("input.encoding", "ISO-8859-1");
            br = new BufferedReader(new InputStreamReader(instream, encoding));
        }
        catch (UnsupportedEncodingException uce) {
            String msg = "Unsupported input encoding : " + encoding + " for template " + logTag;
            throw new ParseErrorException(msg);
        }
        return Velocity.evaluate(context, writer, logTag, br);
    }

    public static boolean evaluate(Context context, Writer writer, String logTag, Reader reader) throws ParseErrorException, MethodInvocationException, ResourceNotFoundException {
        return RuntimeSingleton.getRuntimeServices().evaluate(context, writer, logTag, reader);
    }

    public static boolean invokeVelocimacro(String vmName, String logTag, String[] params2, Context context, Writer writer) {
        return RuntimeSingleton.getRuntimeServices().invokeVelocimacro(vmName, logTag, params2, context, writer);
    }

    public static boolean mergeTemplate(String templateName, Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        return Velocity.mergeTemplate(templateName, RuntimeSingleton.getString("input.encoding", "ISO-8859-1"), context, writer);
    }

    public static boolean mergeTemplate(String templateName, String encoding, Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Template template = RuntimeSingleton.getTemplate(templateName, encoding);
        if (template == null) {
            String msg = "Velocity.mergeTemplate() was unable to load template '" + templateName + "'";
            Velocity.getLog().error(msg);
            throw new ResourceNotFoundException(msg);
        }
        template.merge(context, writer);
        return true;
    }

    public static Template getTemplate(String name2) throws ResourceNotFoundException, ParseErrorException {
        return RuntimeSingleton.getTemplate(name2);
    }

    public static Template getTemplate(String name2, String encoding) throws ResourceNotFoundException, ParseErrorException {
        return RuntimeSingleton.getTemplate(name2, encoding);
    }

    public static boolean resourceExists(String resourceName) {
        return RuntimeSingleton.getLoaderNameForResource(resourceName) != null;
    }

    public static Log getLog() {
        return RuntimeSingleton.getLog();
    }

    public static void warn(Object message) {
        Velocity.getLog().warn(message);
    }

    public static void info(Object message) {
        Velocity.getLog().info(message);
    }

    public static void error(Object message) {
        Velocity.getLog().error(message);
    }

    public static void debug(Object message) {
        Velocity.getLog().debug(message);
    }

    public static void setApplicationAttribute(Object key, Object value2) {
        RuntimeSingleton.getRuntimeInstance().setApplicationAttribute(key, value2);
    }

    public static boolean templateExists(String resourceName) {
        return Velocity.resourceExists(resourceName);
    }

    public void removeDirective(String name2) {
        RuntimeSingleton.removeDirective(name2);
    }

    public void loadDirective(String directiveClass) {
        RuntimeSingleton.loadDirective(directiveClass);
    }
}

