/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.thrift.TNonblockingMultiFetchStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TNonblockingMultiFetchClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TNonblockingMultiFetchClient.class.getName());
    private int maxRecvBufBytesPerServer;
    private int fetchTimeoutSeconds;
    private ByteBuffer requestBuf;
    private ByteBuffer requestBufDuplication;
    private List<InetSocketAddress> servers;
    private TNonblockingMultiFetchStats stats;
    private ByteBuffer[] recvBuf;

    public TNonblockingMultiFetchClient(int maxRecvBufBytesPerServer, int fetchTimeoutSeconds, ByteBuffer requestBuf, List<InetSocketAddress> servers) {
        this.maxRecvBufBytesPerServer = maxRecvBufBytesPerServer;
        this.fetchTimeoutSeconds = fetchTimeoutSeconds;
        this.requestBuf = requestBuf;
        this.servers = servers;
        this.stats = new TNonblockingMultiFetchStats();
        this.recvBuf = null;
    }

    public synchronized int getMaxRecvBufBytesPerServer() {
        return this.maxRecvBufBytesPerServer;
    }

    public synchronized int getFetchTimeoutSeconds() {
        return this.fetchTimeoutSeconds;
    }

    public synchronized ByteBuffer getRequestBuf() {
        if (this.requestBuf == null) {
            return null;
        }
        if (this.requestBufDuplication == null) {
            this.requestBufDuplication = this.requestBuf.duplicate();
        }
        return this.requestBufDuplication;
    }

    public synchronized List<InetSocketAddress> getServerList() {
        if (this.servers == null) {
            return null;
        }
        return Collections.unmodifiableList(this.servers);
    }

    public synchronized TNonblockingMultiFetchStats getFetchStats() {
        return this.stats;
    }

    public synchronized ByteBuffer[] fetch() {
        this.recvBuf = null;
        this.stats.clear();
        if (this.servers == null || this.servers.size() == 0 || this.requestBuf == null || this.fetchTimeoutSeconds <= 0) {
            return this.recvBuf;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        MultiFetch multiFetch = new MultiFetch();
        FutureTask<Object> task = new FutureTask<Object>(multiFetch, null);
        executor.execute(task);
        try {
            task.get(this.fetchTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            task.cancel(true);
            LOGGER.error("interrupted during fetch: " + ie.toString());
        }
        catch (ExecutionException ee) {
            task.cancel(true);
            LOGGER.error("exception during fetch: " + ee.toString());
        }
        catch (TimeoutException te) {
            task.cancel(true);
            LOGGER.error("timeout for fetch: " + te.toString());
        }
        executor.shutdownNow();
        multiFetch.close();
        return this.recvBuf;
    }

    static /* synthetic */ ByteBuffer[] access$302(TNonblockingMultiFetchClient x0, ByteBuffer[] x1) {
        x0.recvBuf = x1;
        return x1;
    }

    private class MultiFetch
    implements Runnable {
        private Selector selector;

        private MultiFetch() {
        }

        @Override
        public void run() {
            long t1 = System.currentTimeMillis();
            int numTotalServers = TNonblockingMultiFetchClient.this.servers.size();
            TNonblockingMultiFetchClient.this.stats.setNumTotalServers(numTotalServers);
            TNonblockingMultiFetchClient.access$302(TNonblockingMultiFetchClient.this, new ByteBuffer[numTotalServers]);
            ByteBuffer[] sendBuf = new ByteBuffer[numTotalServers];
            long[] numBytesRead = new long[numTotalServers];
            int[] frameSize = new int[numTotalServers];
            boolean[] hasReadFrameSize = new boolean[numTotalServers];
            try {
                this.selector = Selector.open();
            }
            catch (IOException e) {
                LOGGER.error("selector opens error: " + e.toString());
                return;
            }
            for (int i = 0; i < numTotalServers; ++i) {
                sendBuf[i] = TNonblockingMultiFetchClient.this.requestBuf.duplicate();
                ((TNonblockingMultiFetchClient)TNonblockingMultiFetchClient.this).recvBuf[i] = ByteBuffer.allocate(4);
                TNonblockingMultiFetchClient.this.stats.incTotalRecvBufBytes(4);
                InetSocketAddress server = (InetSocketAddress)TNonblockingMultiFetchClient.this.servers.get(i);
                SocketChannel s2 = null;
                SelectionKey key = null;
                try {
                    s2 = SocketChannel.open();
                    s2.configureBlocking(false);
                    s2.connect(server);
                    key = s2.register(this.selector, s2.validOps());
                    key.attach(i);
                    continue;
                }
                catch (Exception e) {
                    TNonblockingMultiFetchClient.this.stats.incNumConnectErrorServers();
                    String err2 = String.format("set up socket to server %s error: %s", server.toString(), e.toString());
                    LOGGER.error(err2);
                    if (s2 != null) {
                        try {
                            s2.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (key == null) continue;
                    key.cancel();
                }
            }
            while (TNonblockingMultiFetchClient.this.stats.getNumReadCompletedServers() + TNonblockingMultiFetchClient.this.stats.getNumConnectErrorServers() < TNonblockingMultiFetchClient.this.stats.getNumTotalServers()) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                try {
                    this.selector.select();
                }
                catch (Exception e) {
                    LOGGER.error("selector selects error: " + e.toString());
                    continue;
                }
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SocketChannel sChannel;
                    SelectionKey selKey = it.next();
                    it.remove();
                    int index2 = (Integer)selKey.attachment();
                    if (selKey.isValid() && selKey.isConnectable()) {
                        try {
                            sChannel = (SocketChannel)selKey.channel();
                            sChannel.finishConnect();
                        }
                        catch (Exception e) {
                            TNonblockingMultiFetchClient.this.stats.incNumConnectErrorServers();
                            String err3 = String.format("socket %d connects to server %s error: %s", index2, ((InetSocketAddress)TNonblockingMultiFetchClient.this.servers.get(index2)).toString(), e.toString());
                            LOGGER.error(err3);
                        }
                    }
                    if (selKey.isValid() && selKey.isWritable() && sendBuf[index2].hasRemaining()) {
                        try {
                            sChannel = (SocketChannel)selKey.channel();
                            sChannel.write(sendBuf[index2]);
                        }
                        catch (Exception e) {
                            String err4 = String.format("socket %d writes to server %s error: %s", index2, ((InetSocketAddress)TNonblockingMultiFetchClient.this.servers.get(index2)).toString(), e.toString());
                            LOGGER.error(err4);
                        }
                    }
                    if (!selKey.isValid() || !selKey.isReadable()) continue;
                    try {
                        sChannel = (SocketChannel)selKey.channel();
                        int bytesRead = sChannel.read(TNonblockingMultiFetchClient.this.recvBuf[index2]);
                        if (bytesRead <= 0) continue;
                        int n = index2;
                        numBytesRead[n] = numBytesRead[n] + (long)bytesRead;
                        if (!hasReadFrameSize[index2] && TNonblockingMultiFetchClient.this.recvBuf[index2].remaining() == 0) {
                            frameSize[index2] = TNonblockingMultiFetchClient.this.recvBuf[index2].getInt(0);
                            if (frameSize[index2] <= 0) {
                                TNonblockingMultiFetchClient.this.stats.incNumInvalidFrameSize();
                                String err5 = String.format("Read an invalid frame size %d from %s. Does the server use TFramedTransport? ", frameSize[index2], ((InetSocketAddress)TNonblockingMultiFetchClient.this.servers.get(index2)).toString());
                                LOGGER.error(err5);
                                sChannel.close();
                                continue;
                            }
                            if (frameSize[index2] + 4 > TNonblockingMultiFetchClient.this.stats.getMaxResponseBytes()) {
                                TNonblockingMultiFetchClient.this.stats.setMaxResponseBytes(frameSize[index2] + 4);
                            }
                            if (frameSize[index2] + 4 > TNonblockingMultiFetchClient.this.maxRecvBufBytesPerServer) {
                                TNonblockingMultiFetchClient.this.stats.incNumOverflowedRecvBuf();
                                String err6 = String.format("Read frame size %d from %s, total buffer size would exceed limit %d", frameSize[index2], ((InetSocketAddress)TNonblockingMultiFetchClient.this.servers.get(index2)).toString(), TNonblockingMultiFetchClient.this.maxRecvBufBytesPerServer);
                                LOGGER.error(err6);
                                sChannel.close();
                                continue;
                            }
                            ((TNonblockingMultiFetchClient)TNonblockingMultiFetchClient.this).recvBuf[index2] = ByteBuffer.allocate(frameSize[index2] + 4);
                            TNonblockingMultiFetchClient.this.recvBuf[index2].putInt(frameSize[index2]);
                            TNonblockingMultiFetchClient.this.stats.incTotalRecvBufBytes(frameSize[index2]);
                            hasReadFrameSize[index2] = true;
                        }
                        if (!hasReadFrameSize[index2] || numBytesRead[index2] < (long)(frameSize[index2] + 4)) continue;
                        sChannel.close();
                        TNonblockingMultiFetchClient.this.stats.incNumReadCompletedServers();
                        long t2 = System.currentTimeMillis();
                        TNonblockingMultiFetchClient.this.stats.setReadTime(t2 - t1);
                    }
                    catch (Exception e) {
                        String err7 = String.format("socket %d reads from server %s error: %s", index2, ((InetSocketAddress)TNonblockingMultiFetchClient.this.servers.get(index2)).toString(), e.toString());
                        LOGGER.error(err7);
                    }
                }
            }
        }

        public void close() {
            try {
                if (this.selector.isOpen()) {
                    for (SelectionKey selKey : this.selector.keys()) {
                        SocketChannel sChannel = (SocketChannel)selKey.channel();
                        sChannel.close();
                    }
                    this.selector.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("free resource error: " + e.toString());
            }
        }
    }
}

