/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.transport.TMemoryInputTransport;

public class TDeserializer {
    private final TProtocol protocol_;
    private final TMemoryInputTransport trans_ = new TMemoryInputTransport();

    public TDeserializer() {
        this(new TBinaryProtocol.Factory());
    }

    public TDeserializer(TProtocolFactory protocolFactory) {
        this.protocol_ = protocolFactory.getProtocol(this.trans_);
    }

    public void deserialize(TBase base, byte[] bytes2) throws TException {
        this.deserialize(base, bytes2, 0, bytes2.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(TBase base, byte[] bytes2, int offset, int length) throws TException {
        try {
            this.trans_.reset(bytes2, offset, length);
            base.read(this.protocol_);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    public void deserialize(TBase base, String data2, String charset) throws TException {
        try {
            this.deserialize(base, data2.getBytes(charset));
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset);
        }
        finally {
            this.protocol_.reset();
        }
    }

    public void partialDeserialize(TBase tb, byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        try {
            if (this.locateField(bytes2, fieldIdPathFirst, fieldIdPathRest) != null) {
                tb.read(this.protocol_);
            }
        }
        catch (Exception e) {
            throw new TException(e);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    public Boolean partialDeserializeBool(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Boolean)this.partialDeserializeField((byte)2, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public Byte partialDeserializeByte(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Byte)this.partialDeserializeField((byte)3, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public Double partialDeserializeDouble(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Double)this.partialDeserializeField((byte)4, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public Short partialDeserializeI16(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Short)this.partialDeserializeField((byte)6, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public Integer partialDeserializeI32(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Integer)this.partialDeserializeField((byte)8, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public Long partialDeserializeI64(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Long)this.partialDeserializeField((byte)10, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public String partialDeserializeString(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (String)this.partialDeserializeField((byte)11, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public ByteBuffer partialDeserializeByteArray(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (ByteBuffer)this.partialDeserializeField((byte)100, bytes2, fieldIdPathFirst, fieldIdPathRest);
    }

    public Short partialDeserializeSetFieldIdInUnion(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        try {
            TField field2 = this.locateField(bytes2, fieldIdPathFirst, fieldIdPathRest);
            if (field2 != null) {
                this.protocol_.readStructBegin();
                Short s2 = this.protocol_.readFieldBegin().id;
                return s2;
            }
            Short s3 = null;
            return s3;
        }
        catch (Exception e) {
            throw new TException(e);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    private Object partialDeserializeField(byte ttype, byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        try {
            TField field2 = this.locateField(bytes2, fieldIdPathFirst, fieldIdPathRest);
            if (field2 != null) {
                if (ttype == field2.type) {
                    switch (ttype) {
                        case 2: {
                            Boolean bl = this.protocol_.readBool();
                            return bl;
                        }
                        case 3: {
                            Byte by2 = this.protocol_.readByte();
                            return by2;
                        }
                        case 4: {
                            Double d = this.protocol_.readDouble();
                            return d;
                        }
                        case 6: {
                            Short s2 = this.protocol_.readI16();
                            return s2;
                        }
                        case 8: {
                            Integer n = this.protocol_.readI32();
                            return n;
                        }
                        case 10: {
                            Long l = this.protocol_.readI64();
                            return l;
                        }
                        case 11: {
                            String string2 = this.protocol_.readString();
                            return string2;
                        }
                    }
                    Object var6_14 = null;
                    return var6_14;
                }
                if (ttype == 100 && field2.type == 11) {
                    ByteBuffer byteBuffer = this.protocol_.readBinary();
                    return byteBuffer;
                }
            }
            Object var6_16 = null;
            return var6_16;
        }
        catch (Exception e) {
            throw new TException(e);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    private TField locateField(byte[] bytes2, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        this.trans_.reset(bytes2);
        TFieldIdEnum[] fieldIdPath = new TFieldIdEnum[fieldIdPathRest.length + 1];
        fieldIdPath[0] = fieldIdPathFirst;
        System.arraycopy(fieldIdPathRest, 0, fieldIdPath, 1, fieldIdPathRest.length);
        int curPathIndex = 0;
        TField field2 = null;
        this.protocol_.readStructBegin();
        while (curPathIndex < fieldIdPath.length) {
            field2 = this.protocol_.readFieldBegin();
            if (field2.type == 0 || field2.id > fieldIdPath[curPathIndex].getThriftFieldId()) {
                return null;
            }
            if (field2.id != fieldIdPath[curPathIndex].getThriftFieldId()) {
                TProtocolUtil.skip(this.protocol_, field2.type);
                this.protocol_.readFieldEnd();
                continue;
            }
            if (++curPathIndex >= fieldIdPath.length) continue;
            this.protocol_.readStructBegin();
        }
        return field2;
    }

    public void fromString(TBase base, String data2) throws TException {
        this.deserialize(base, data2.getBytes());
    }
}

