/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.util.Collections;
import java.util.Map;
import org.apache.thrift.AsyncProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TAsyncProcessor;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TBaseAsyncProcessor<I>
implements TAsyncProcessor,
TProcessor {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass().getName());
    final I iface;
    final Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap;

    public TBaseAsyncProcessor(I iface, Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap) {
        this.iface = iface;
        this.processMap = processMap;
    }

    public Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    @Override
    public void process(AbstractNonblockingServer.AsyncFrameBuffer fb) throws TException {
        TProtocol in = fb.getInputProtocol();
        TProtocol out = fb.getOutputProtocol();
        TMessage msg = in.readMessageBegin();
        AsyncProcessFunction<I, TBase, ?> fn2 = this.processMap.get(msg.name);
        if (fn2 == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            this.LOGGER.debug("Invalid method name", x);
            if (msg.type == 1) {
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb.responseReady();
            return;
        }
        TBase args2 = fn2.getEmptyArgsInstance();
        try {
            args2.read(in);
        }
        catch (TProtocolException e) {
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(7, e.getMessage());
            this.LOGGER.debug("Could not retrieve function arguments", x);
            if (!fn2.isOneway()) {
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb.responseReady();
            return;
        }
        in.readMessageEnd();
        if (fn2.isOneway()) {
            fb.responseReady();
        }
        AsyncMethodCallback<?> resultHandler = fn2.getResultHandler(fb, msg.seqid);
        try {
            fn2.start(this.iface, args2, resultHandler);
        }
        catch (Exception e) {
            this.LOGGER.debug("Exception handling function", e);
            resultHandler.onError(e);
        }
    }

    @Override
    public void process(TProtocol in, TProtocol out) throws TException {
    }
}

