/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

public class EncodingUtils {
    public static final void encodeBigEndian(int integer, byte[] buf) {
        EncodingUtils.encodeBigEndian(integer, buf, 0);
    }

    public static final void encodeBigEndian(int integer, byte[] buf, int offset) {
        buf[offset] = (byte)(0xFF & integer >> 24);
        buf[offset + 1] = (byte)(0xFF & integer >> 16);
        buf[offset + 2] = (byte)(0xFF & integer >> 8);
        buf[offset + 3] = (byte)(0xFF & integer);
    }

    public static final int decodeBigEndian(byte[] buf) {
        return EncodingUtils.decodeBigEndian(buf, 0);
    }

    public static final int decodeBigEndian(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }

    public static final boolean testBit(byte v, int position2) {
        return EncodingUtils.testBit((int)v, position2);
    }

    public static final boolean testBit(short v, int position2) {
        return EncodingUtils.testBit((int)v, position2);
    }

    public static final boolean testBit(int v, int position2) {
        return (v & 1 << position2) != 0;
    }

    public static final boolean testBit(long v, int position2) {
        return (v & 1L << position2) != 0L;
    }

    public static final byte clearBit(byte v, int position2) {
        return (byte)EncodingUtils.clearBit((int)v, position2);
    }

    public static final short clearBit(short v, int position2) {
        return (short)EncodingUtils.clearBit((int)v, position2);
    }

    public static final int clearBit(int v, int position2) {
        return v & ~(1 << position2);
    }

    public static final long clearBit(long v, int position2) {
        return v & (1L << position2 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static final byte setBit(byte v, int position2, boolean value2) {
        return (byte)EncodingUtils.setBit((int)v, position2, value2);
    }

    public static final short setBit(short v, int position2, boolean value2) {
        return (short)EncodingUtils.setBit((int)v, position2, value2);
    }

    public static final int setBit(int v, int position2, boolean value2) {
        if (value2) {
            return v | 1 << position2;
        }
        return EncodingUtils.clearBit(v, position2);
    }

    public static final long setBit(long v, int position2, boolean value2) {
        if (value2) {
            return v | 1L << position2;
        }
        return EncodingUtils.clearBit(v, position2);
    }
}

