/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.projection.amend;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.thrift.ParquetProtocol;
import org.apache.parquet.thrift.projection.amend.DefaultProtocolEventsGenerator;
import org.apache.parquet.thrift.projection.amend.ReadFieldBeginProtocol;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;

class DefaultEventsVisitor
implements ThriftType.StateVisitor<Void, Void> {
    List<ParquetProtocol> dummyEvents = new ArrayList<ParquetProtocol>();

    DefaultEventsVisitor() {
    }

    @Override
    public Void visit(ThriftType.MapType mapType2, Void v) {
        this.dummyEvents.add(new ParquetProtocol("readMapBegin()"){

            @Override
            public TMap readMapBegin() throws TException {
                return new TMap();
            }
        });
        this.dummyEvents.add(new ParquetProtocol("readMapEnd()"){

            @Override
            public void readMapEnd() throws TException {
            }
        });
        return null;
    }

    @Override
    public Void visit(ThriftType.SetType setType, Void v) {
        this.dummyEvents.add(new ParquetProtocol("readSetBegin()"){

            @Override
            public TSet readSetBegin() throws TException {
                return new TSet();
            }
        });
        this.dummyEvents.add(new ParquetProtocol("readSetEnd()"){

            @Override
            public void readSetEnd() throws TException {
            }
        });
        return null;
    }

    @Override
    public Void visit(ThriftType.ListType listType, Void v) {
        this.dummyEvents.add(new ParquetProtocol("readListBegin()"){

            @Override
            public TList readListBegin() throws TException {
                return new TList();
            }
        });
        this.dummyEvents.add(new ParquetProtocol("readListEnd()"){

            @Override
            public void readListEnd() throws TException {
            }
        });
        return null;
    }

    @Override
    public Void visit(ThriftType.StructType structType, Void v) {
        this.dummyEvents.add(new StructBeginProtocol("struct"));
        List<ThriftField> children2 = structType.getChildren();
        for (ThriftField child : children2) {
            this.dummyEvents.add(new ReadFieldBeginProtocol(child));
            child.getType().accept(this, null);
            this.dummyEvents.add(DefaultProtocolEventsGenerator.READ_FIELD_END);
        }
        this.dummyEvents.add(DefaultProtocolEventsGenerator.READ_FIELD_STOP);
        this.dummyEvents.add(DefaultProtocolEventsGenerator.READ_STRUCT_END);
        return null;
    }

    @Override
    public Void visit(ThriftType.EnumType enumType, Void v) {
        this.dummyEvents.add(new ParquetProtocol("readI32() enum"){

            @Override
            public int readI32() throws TException {
                return 0;
            }
        });
        return null;
    }

    @Override
    public Void visit(ThriftType.BoolType boolType, Void v) {
        this.dummyEvents.add(new ParquetProtocol("readBool()"){

            @Override
            public boolean readBool() throws TException {
                return false;
            }
        });
        return null;
    }

    @Override
    public Void visit(ThriftType.ByteType byteType, Void v) {
        this.dummyEvents.add(new ParquetProtocol("readByte() int"){

            @Override
            public byte readByte() throws TException {
                return 0;
            }
        });
        return null;
    }

    @Override
    public Void visit(ThriftType.DoubleType doubleType, Void v) {
        this.dummyEvents.add(new ParquetProtocol("readDouble()"){

            @Override
            public double readDouble() throws TException {
                return 0.0;
            }
        });
        return null;
    }

    @Override
    public Void visit(ThriftType.I16Type i16Type, Void v) {
        this.dummyEvents.add(new ParquetProtocol("readI16()"){

            @Override
            public short readI16() throws TException {
                return 0;
            }
        });
        return null;
    }

    @Override
    public Void visit(ThriftType.I32Type i32Type, Void v) {
        this.dummyEvents.add(new ParquetProtocol("readI32()"){

            @Override
            public int readI32() throws TException {
                return 0;
            }
        });
        return null;
    }

    @Override
    public Void visit(ThriftType.I64Type i64Type, Void v) {
        this.dummyEvents.add(new ParquetProtocol("readI64()"){

            @Override
            public long readI64() throws TException {
                return 0L;
            }
        });
        return null;
    }

    @Override
    public Void visit(ThriftType.StringType stringType, Void v) {
        this.dummyEvents.add(new StringProtocol(""));
        return null;
    }

    public List<ParquetProtocol> getEvents() {
        return this.dummyEvents;
    }

    public static class StringProtocol
    extends ParquetProtocol {
        private final String str;

        public StringProtocol(String str) {
            super("readString() binary");
            this.str = str;
        }

        @Override
        public String readString() throws TException {
            return this.str;
        }

        @Override
        public ByteBuffer readBinary() throws TException {
            return ByteBuffer.wrap("str".getBytes());
        }
    }

    private static class StructBeginProtocol
    extends ParquetProtocol {
        private final String structName;

        public StructBeginProtocol(String structName) {
            super("readStructBegin()");
            this.structName = structName;
        }

        @Override
        public TStruct readStructBegin() throws TException {
            return new TStruct(this.structName);
        }
    }
}

