/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.pig;

import com.twitter.elephantbird.pig.util.PigToThrift;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.thrift.ThriftWriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.pig.data.Tuple;
import org.apache.thrift.TBase;

public class TupleToThriftWriteSupport
extends WriteSupport<Tuple> {
    private final String className;
    private ThriftWriteSupport<TBase<?, ?>> thriftWriteSupport;
    private PigToThrift<TBase<?, ?>> pigToThrift;

    public TupleToThriftWriteSupport(String className) {
        this.className = className;
    }

    @Override
    public WriteSupport.WriteContext init(Configuration configuration) {
        try {
            Class<TBase> clazz2 = configuration.getClassByName(this.className).asSubclass(TBase.class);
            this.thriftWriteSupport = new ThriftWriteSupport<TBase>(clazz2);
            this.pigToThrift = new PigToThrift(clazz2);
            return this.thriftWriteSupport.init(configuration);
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("The thrift class name was not found: " + this.className, e);
        }
        catch (ClassCastException e) {
            throw new BadConfigurationException("The thrift class name should extend TBase: " + this.className, e);
        }
    }

    @Override
    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.thriftWriteSupport.prepareForWrite(recordConsumer);
    }

    @Override
    public void write(Tuple t) {
        this.thriftWriteSupport.write(this.pigToThrift.getThriftObject(t));
    }
}

