/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import com.twitter.elephantbird.thrift.TStructDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.thrift.ThriftSchemaConvertVisitor;
import org.apache.parquet.thrift.projection.FieldProjectionFilter;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.parquet.thrift.struct.ThriftTypeID;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TUnion;

public class ThriftSchemaConverter {
    private final FieldProjectionFilter fieldProjectionFilter;

    public ThriftSchemaConverter() {
        this(FieldProjectionFilter.ALL_COLUMNS);
    }

    public ThriftSchemaConverter(FieldProjectionFilter fieldProjectionFilter) {
        this.fieldProjectionFilter = fieldProjectionFilter;
    }

    public MessageType convert(Class<? extends TBase<?, ?>> thriftClass) {
        return this.convert(ThriftSchemaConverter.toStructType(thriftClass));
    }

    public MessageType convert(ThriftType.StructType struct) {
        MessageType messageType = ThriftSchemaConvertVisitor.convert(struct, this.fieldProjectionFilter);
        this.fieldProjectionFilter.assertNoUnmatchedPatterns();
        return messageType;
    }

    public static <T extends TBase<?, ?>> ThriftType.StructType.StructOrUnionType structOrUnionType(Class<T> klass) {
        return TUnion.class.isAssignableFrom(klass) ? ThriftType.StructType.StructOrUnionType.UNION : ThriftType.StructType.StructOrUnionType.STRUCT;
    }

    public static ThriftType.StructType toStructType(Class<? extends TBase<?, ?>> thriftClass) {
        TStructDescriptor struct = TStructDescriptor.getInstance(thriftClass);
        return ThriftSchemaConverter.toStructType(struct);
    }

    private static ThriftType.StructType toStructType(TStructDescriptor struct) {
        List<TStructDescriptor.Field> fields2 = struct.getFields();
        ArrayList<ThriftField> children2 = new ArrayList<ThriftField>(fields2.size());
        for (TStructDescriptor.Field field2 : fields2) {
            ThriftField.Requirement req = field2.getFieldMetaData() == null ? ThriftField.Requirement.OPTIONAL : ThriftField.Requirement.fromType(field2.getFieldMetaData().requirementType);
            children2.add(ThriftSchemaConverter.toThriftField(field2.getName(), field2, req));
        }
        return new ThriftType.StructType(children2, ThriftSchemaConverter.structOrUnionType(struct.getThriftClass()));
    }

    private static ThriftField toThriftField(String name2, TStructDescriptor.Field field2, ThriftField.Requirement requirement) {
        ThriftType type;
        switch (ThriftTypeID.fromByte(field2.getType())) {
            default: {
                throw new UnsupportedOperationException("can't convert type of " + field2);
            }
            case BOOL: {
                type = new ThriftType.BoolType();
                break;
            }
            case BYTE: {
                type = new ThriftType.ByteType();
                break;
            }
            case DOUBLE: {
                type = new ThriftType.DoubleType();
                break;
            }
            case I16: {
                type = new ThriftType.I16Type();
                break;
            }
            case I32: {
                type = new ThriftType.I32Type();
                break;
            }
            case I64: {
                type = new ThriftType.I64Type();
                break;
            }
            case STRING: {
                type = new ThriftType.StringType();
                break;
            }
            case STRUCT: {
                type = ThriftSchemaConverter.toStructType(field2.gettStructDescriptor());
                break;
            }
            case MAP: {
                TStructDescriptor.Field mapKeyField = field2.getMapKeyField();
                TStructDescriptor.Field mapValueField = field2.getMapValueField();
                type = new ThriftType.MapType(ThriftSchemaConverter.toThriftField(mapKeyField.getName(), mapKeyField, requirement), ThriftSchemaConverter.toThriftField(mapValueField.getName(), mapValueField, requirement));
                break;
            }
            case SET: {
                TStructDescriptor.Field setElemField = field2.getSetElemField();
                type = new ThriftType.SetType(ThriftSchemaConverter.toThriftField(setElemField.getName(), setElemField, requirement));
                break;
            }
            case LIST: {
                TStructDescriptor.Field listElemField = field2.getListElemField();
                type = new ThriftType.ListType(ThriftSchemaConverter.toThriftField(listElemField.getName(), listElemField, requirement));
                break;
            }
            case ENUM: {
                Collection<TEnum> enumValues = field2.getEnumValues();
                ArrayList<ThriftType.EnumValue> values2 = new ArrayList<ThriftType.EnumValue>();
                for (TEnum tEnum : enumValues) {
                    values2.add(new ThriftType.EnumValue(tEnum.getValue(), tEnum.toString()));
                }
                type = new ThriftType.EnumType(values2);
            }
        }
        return new ThriftField(name2, field2.getId(), requirement, type);
    }
}

