/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.thrift.ParquetProtocol;
import org.apache.parquet.thrift.ParquetReadProtocol;
import org.apache.parquet.thrift.ThriftReader;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.projection.amend.ProtocolEventsAmender;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.parquet.thrift.struct.ThriftTypeID;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;

public class ThriftRecordConverter<T>
extends RecordMaterializer<T> {
    final ParquetProtocol readFieldEnd = new ParquetProtocol("readFieldEnd()"){

        @Override
        public void readFieldEnd() throws TException {
        }
    };
    private final ThriftType.StructType thriftType;
    private final ThriftReader<T> thriftReader;
    private final ParquetReadProtocol protocol;
    private final GroupConverter structConverter;
    private List<TProtocol> rootEvents = new ArrayList<TProtocol>();
    private boolean missingRequiredFieldsInProjection = false;

    public ThriftRecordConverter(ThriftReader<T> thriftReader, String name2, MessageType requestedParquetSchema, ThriftType.StructType thriftType) {
        this.thriftReader = thriftReader;
        this.protocol = new ParquetReadProtocol();
        this.thriftType = thriftType;
        MessageType fullSchema = new ThriftSchemaConverter().convert(thriftType);
        this.missingRequiredFieldsInProjection = this.hasMissingRequiredFieldInGroupType(requestedParquetSchema, fullSchema);
        this.structConverter = new StructConverter(this.rootEvents, requestedParquetSchema, new ThriftField(name2, 0, ThriftField.Requirement.REQUIRED, thriftType));
    }

    private boolean hasMissingRequiredFieldInGroupType(GroupType requested, GroupType fullSchema) {
        for (Type field2 : fullSchema.getFields()) {
            if (requested.containsField(field2.getName())) {
                Type requestedType = requested.getType(field2.getName());
                if (field2.isPrimitive() || !this.hasMissingRequiredFieldInGroupType(requestedType.asGroupType(), field2.asGroupType())) continue;
                return true;
            }
            if (field2.getRepetition() != Type.Repetition.REQUIRED) continue;
            return true;
        }
        return false;
    }

    @Override
    public T getCurrentRecord() {
        try {
            if (this.missingRequiredFieldsInProjection) {
                List<TProtocol> fixedEvents = new ProtocolEventsAmender(this.rootEvents).amendMissingRequiredFields(this.thriftType);
                this.protocol.addAll(fixedEvents);
            } else {
                this.protocol.addAll(this.rootEvents);
            }
            this.rootEvents.clear();
            return this.thriftReader.readOneRecord(this.protocol);
        }
        catch (TException e) {
            this.protocol.clear();
            this.rootEvents.clear();
            throw new RecordMaterializer.RecordMaterializationException("Could not read thrift object from protocol", e);
        }
    }

    @Override
    public void skipCurrentRecord() {
        this.rootEvents.clear();
    }

    @Override
    public GroupConverter getRootConverter() {
        return this.structConverter;
    }

    private Converter newConverter(List<TProtocol> events2, Type type, ThriftField field2) {
        switch (field2.getType().getType()) {
            case LIST: {
                return new ListConverter(events2, type.asGroupType(), field2);
            }
            case SET: {
                return new SetConverter(events2, type.asGroupType(), field2);
            }
            case MAP: {
                return new MapConverter(events2, type.asGroupType(), field2);
            }
            case STRUCT: {
                return new StructConverter(events2, type.asGroupType(), field2);
            }
            case STRING: {
                return new FieldStringConverter(events2, field2);
            }
            case ENUM: {
                return new FieldEnumConverter(events2, field2);
            }
        }
        return new FieldPrimitiveConverter(events2, field2);
    }

    class StructConverter
    extends GroupConverter {
        private final int schemaSize;
        private final Converter[] converters;
        private final ThriftType.StructType thriftType;
        private final String name;
        private final TStruct tStruct;
        private final List<TProtocol> events;
        final ParquetProtocol readStructBegin = new ParquetProtocol("readStructBegin()"){

            @Override
            public TStruct readStructBegin() throws TException {
                return StructConverter.this.tStruct;
            }
        };
        private final ParquetProtocol readFieldStop = new ParquetProtocol("readFieldBegin() => STOP"){
            final TField stop;
            {
                this.stop = new TField("", 0, 0);
            }

            @Override
            public TField readFieldBegin() throws TException {
                return this.stop;
            }
        };
        private final ParquetProtocol readStructEnd = new ParquetProtocol("readStructEnd()"){

            @Override
            public void readStructEnd() throws TException {
            }
        };

        private StructConverter(List<TProtocol> events2, GroupType parquetSchema, ThriftField field2) {
            this.events = events2;
            this.name = field2.getName();
            this.tStruct = new TStruct(this.name);
            this.thriftType = (ThriftType.StructType)field2.getType();
            this.schemaSize = parquetSchema.getFieldCount();
            this.converters = new Converter[this.schemaSize];
            List<ThriftField> thriftChildren = this.thriftType.getChildren();
            for (int i = 0; i < this.schemaSize; ++i) {
                Type schemaType = parquetSchema.getType(i);
                String fieldName = schemaType.getName();
                ThriftField matchingThrift = null;
                for (ThriftField childField : thriftChildren) {
                    String thriftChildName = childField.getName();
                    if (thriftChildName == null || !thriftChildName.equalsIgnoreCase(fieldName)) continue;
                    matchingThrift = childField;
                    break;
                }
                if (matchingThrift == null) continue;
                this.converters[i] = schemaType.isPrimitive() ? new PrimitiveFieldHandler(ThriftRecordConverter.this.newConverter(events2, schemaType, matchingThrift).asPrimitiveConverter(), matchingThrift, events2) : new GroupFieldhandler(ThriftRecordConverter.this.newConverter(events2, schemaType, matchingThrift).asGroupConverter(), matchingThrift, events2);
            }
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return this.converters[fieldIndex];
        }

        @Override
        public void start() {
            this.events.add(this.readStructBegin);
        }

        @Override
        public void end() {
            this.events.add(this.readFieldStop);
            this.events.add(this.readStructEnd);
        }
    }

    abstract class CollectionConverter
    extends GroupConverter {
        private final Converter child;
        private final Counter childCounter;
        private List<TProtocol> listEvents = new ArrayList<TProtocol>();
        private final List<TProtocol> parentEvents;
        private ThriftTypeID valuesType;
        private final Type nestedType;

        CollectionConverter(List<TProtocol> parentEvents, GroupType parquetSchema, ThriftField values2) {
            this.parentEvents = parentEvents;
            if (parquetSchema.getFieldCount() != 1) {
                throw new IllegalArgumentException("lists have only one field. " + parquetSchema + " size = " + parquetSchema.getFieldCount());
            }
            this.nestedType = parquetSchema.getType(0);
            this.valuesType = values2.getType().getType();
            if (this.nestedType.isPrimitive()) {
                PrimitiveCounter counter2 = new PrimitiveCounter(ThriftRecordConverter.this.newConverter(this.listEvents, this.nestedType, values2).asPrimitiveConverter());
                this.child = counter2;
                this.childCounter = counter2;
            } else {
                GroupCounter counter3 = new GroupCounter(ThriftRecordConverter.this.newConverter(this.listEvents, this.nestedType, values2).asGroupConverter());
                this.child = counter3;
                this.childCounter = counter3;
            }
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            if (fieldIndex != 0) {
                throw new IllegalArgumentException("lists have only one field. can't reach " + fieldIndex);
            }
            return this.child;
        }

        @Override
        public void start() {
            this.childCounter.startCounting();
        }

        @Override
        public void end() {
            int count2 = this.childCounter.getCount();
            this.collectionStart(count2, this.valuesType.getThriftType());
            this.parentEvents.addAll(this.listEvents);
            this.listEvents.clear();
            this.collectionEnd();
        }

        abstract void collectionStart(int var1, byte var2);

        abstract void collectionEnd();
    }

    class ListConverter
    extends CollectionConverter {
        final ParquetProtocol readListEnd;
        private final List<TProtocol> parentEvents;

        ListConverter(List<TProtocol> parentEvents, GroupType parquetSchema, ThriftField field2) {
            super(parentEvents, parquetSchema, ((ThriftType.ListType)field2.getType()).getValues());
            this.readListEnd = new ParquetProtocol("readListEnd()"){

                @Override
                public void readListEnd() throws TException {
                }
            };
            this.parentEvents = parentEvents;
        }

        @Override
        void collectionStart(final int count2, final byte type) {
            this.parentEvents.add(new ParquetProtocol("readListBegin()"){

                @Override
                public TList readListBegin() throws TException {
                    return new TList(type, count2);
                }
            });
        }

        @Override
        void collectionEnd() {
            this.parentEvents.add(this.readListEnd);
        }
    }

    class SetConverter
    extends CollectionConverter {
        final ParquetProtocol readSetEnd;
        private final List<TProtocol> parentEvents;

        public SetConverter(List<TProtocol> parentEvents, GroupType parquetSchema, ThriftField field2) {
            super(parentEvents, parquetSchema, ((ThriftType.SetType)field2.getType()).getValues());
            this.readSetEnd = new ParquetProtocol("readSetEnd()"){

                @Override
                public void readSetEnd() throws TException {
                }
            };
            this.parentEvents = parentEvents;
        }

        @Override
        void collectionStart(final int count2, final byte type) {
            this.parentEvents.add(new ParquetProtocol("readSetBegin()"){

                @Override
                public TSet readSetBegin() throws TException {
                    return new TSet(type, count2);
                }
            });
        }

        @Override
        void collectionEnd() {
            this.parentEvents.add(this.readSetEnd);
        }
    }

    class MapKeyValueConverter
    extends GroupConverter {
        private Converter keyConverter;
        private Converter valueConverter;

        public MapKeyValueConverter(List<TProtocol> mapEvents, Type nestedType, ThriftField key, ThriftField value2) {
            this.keyConverter = ThriftRecordConverter.this.newConverter(mapEvents, nestedType.asGroupType().getType(0), key);
            this.valueConverter = ThriftRecordConverter.this.newConverter(mapEvents, nestedType.asGroupType().getType(1), value2);
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            switch (fieldIndex) {
                case 0: {
                    return this.keyConverter;
                }
                case 1: {
                    return this.valueConverter;
                }
            }
            throw new IllegalArgumentException("only key (0) and value (1) are supported. got " + fieldIndex);
        }

        @Override
        public void start() {
        }

        @Override
        public void end() {
        }
    }

    class MapConverter
    extends GroupConverter {
        private final GroupCounter child;
        private final List<TProtocol> mapEvents = new ArrayList<TProtocol>();
        private final List<TProtocol> parentEvents;
        private final byte keyType;
        private final byte valueType;
        final ParquetProtocol readMapEnd = new ParquetProtocol("readMapEnd()"){

            @Override
            public void readMapEnd() throws TException {
            }
        };

        MapConverter(List<TProtocol> parentEvents, GroupType parquetSchema, ThriftField field2) {
            this.parentEvents = parentEvents;
            if (parquetSchema.getFieldCount() != 1) {
                throw new IllegalArgumentException("maps have only one field. " + parquetSchema + " size = " + parquetSchema.getFieldCount());
            }
            Type nestedType = parquetSchema.getType(0);
            ThriftField key = ((ThriftType.MapType)field2.getType()).getKey();
            this.keyType = key.getType().getType().getThriftType();
            ThriftField value2 = ((ThriftType.MapType)field2.getType()).getValue();
            this.valueType = value2.getType().getType().getThriftType();
            this.child = new GroupCounter(new MapKeyValueConverter(this.mapEvents, nestedType, key, value2));
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            if (fieldIndex != 0) {
                throw new IllegalArgumentException("lists have only one field. can't reach " + fieldIndex);
            }
            return this.child;
        }

        @Override
        public void start() {
            this.child.startCounting();
        }

        @Override
        public void end() {
            final int count2 = this.child.getCount();
            this.parentEvents.add(new ParquetProtocol("readMapBegin()"){

                @Override
                public TMap readMapBegin() throws TException {
                    return new TMap(MapConverter.this.keyType, MapConverter.this.valueType, count2);
                }
            });
            this.parentEvents.addAll(this.mapEvents);
            this.mapEvents.clear();
            this.parentEvents.add(this.readMapEnd);
        }
    }

    class FieldEnumConverter
    extends PrimitiveConverter {
        private final List<TProtocol> events;
        private Map<Binary, Integer> enumLookup = new HashMap<Binary, Integer>();

        public FieldEnumConverter(List<TProtocol> events2, ThriftField field2) {
            this.events = events2;
            Iterable<ThriftType.EnumValue> values2 = ((ThriftType.EnumType)field2.getType()).getValues();
            for (ThriftType.EnumValue enumValue : values2) {
                this.enumLookup.put(Binary.fromString(enumValue.getName()), enumValue.getId());
            }
        }

        @Override
        public void addBinary(Binary value2) {
            final int id = this.enumLookup.get(value2);
            this.events.add(new ParquetProtocol("readI32() enum"){

                @Override
                public int readI32() throws TException {
                    return id;
                }
            });
        }
    }

    class FieldStringConverter
    extends PrimitiveConverter {
        private final List<TProtocol> events;

        public FieldStringConverter(List<TProtocol> events2, ThriftField field2) {
            this.events = events2;
        }

        @Override
        public void addBinary(final Binary value2) {
            this.events.add(new ParquetProtocol("readString() binary"){

                @Override
                public String readString() throws TException {
                    return value2.toStringUsingUTF8();
                }

                @Override
                public ByteBuffer readBinary() throws TException {
                    return value2.toByteBuffer();
                }
            });
        }
    }

    class FieldPrimitiveConverter
    extends PrimitiveConverter {
        private final List<TProtocol> events;
        private ThriftTypeID type;

        public FieldPrimitiveConverter(List<TProtocol> events2, ThriftField field2) {
            this.events = events2;
            this.type = field2.getType().getType();
        }

        @Override
        public void addBoolean(final boolean value2) {
            this.events.add(new ParquetProtocol("readBool()"){

                @Override
                public boolean readBool() throws TException {
                    return value2;
                }
            });
        }

        @Override
        public void addDouble(final double value2) {
            this.events.add(new ParquetProtocol("readDouble()"){

                @Override
                public double readDouble() throws TException {
                    return value2;
                }
            });
        }

        @Override
        public void addFloat(final float value2) {
            this.events.add(new ParquetProtocol("readDouble() float"){

                @Override
                public double readDouble() throws TException {
                    return value2;
                }
            });
        }

        @Override
        public void addInt(final int value2) {
            switch (this.type) {
                case BYTE: {
                    this.events.add(new ParquetProtocol("readByte() int"){

                        @Override
                        public byte readByte() throws TException {
                            return (byte)value2;
                        }
                    });
                    break;
                }
                case I16: {
                    this.events.add(new ParquetProtocol("readI16()"){

                        @Override
                        public short readI16() throws TException {
                            return (short)value2;
                        }
                    });
                    break;
                }
                case I32: {
                    this.events.add(new ParquetProtocol("readI32()"){

                        @Override
                        public int readI32() throws TException {
                            return value2;
                        }
                    });
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("not convertible type " + (Object)((Object)this.type));
                }
            }
        }

        @Override
        public void addLong(final long value2) {
            this.events.add(new ParquetProtocol("readI64()"){

                @Override
                public long readI64() throws TException {
                    return value2;
                }
            });
        }
    }

    class PrimitiveCounter
    extends PrimitiveConverter
    implements Counter {
        private final PrimitiveConverter delegate;
        private int count;

        public PrimitiveCounter(PrimitiveConverter delegate) {
            this.delegate = delegate;
        }

        @Override
        public void addBinary(Binary value2) {
            this.delegate.addBinary(value2);
            ++this.count;
        }

        @Override
        public void addBoolean(boolean value2) {
            this.delegate.addBoolean(value2);
            ++this.count;
        }

        @Override
        public void addDouble(double value2) {
            this.delegate.addDouble(value2);
            ++this.count;
        }

        @Override
        public void addFloat(float value2) {
            this.delegate.addFloat(value2);
            ++this.count;
        }

        @Override
        public void addInt(int value2) {
            this.delegate.addInt(value2);
            ++this.count;
        }

        @Override
        public void addLong(long value2) {
            this.delegate.addLong(value2);
            ++this.count;
        }

        @Override
        public void startCounting() {
            this.count = 0;
        }

        @Override
        public int getCount() {
            return this.count;
        }
    }

    class GroupCounter
    extends GroupConverter
    implements Counter {
        private final GroupConverter delegate;
        private int count;

        public GroupCounter(GroupConverter delegate) {
            this.delegate = delegate;
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return this.delegate.getConverter(fieldIndex);
        }

        @Override
        public void start() {
            this.delegate.start();
        }

        @Override
        public void end() {
            this.delegate.end();
            ++this.count;
        }

        @Override
        public void startCounting() {
            this.count = 0;
        }

        @Override
        public int getCount() {
            return this.count;
        }
    }

    static interface Counter {
        public void startCounting();

        public int getCount();
    }

    class GroupFieldhandler
    extends GroupConverter {
        private final GroupConverter delegate;
        private final List<TProtocol> events;
        private final ParquetProtocol readFieldBegin;

        public GroupFieldhandler(GroupConverter delegate, final ThriftField field2, List<TProtocol> events2) {
            this.delegate = delegate;
            this.events = events2;
            this.readFieldBegin = new ParquetProtocol("readFieldBegin()"){

                @Override
                public TField readFieldBegin() throws TException {
                    return new TField(field2.getName(), field2.getType().getType().getThriftType(), field2.getFieldId());
                }
            };
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return this.delegate.getConverter(fieldIndex);
        }

        @Override
        public void start() {
            this.events.add(this.readFieldBegin);
            this.delegate.start();
        }

        @Override
        public void end() {
            this.delegate.end();
            this.events.add(ThriftRecordConverter.this.readFieldEnd);
        }
    }

    class PrimitiveFieldHandler
    extends PrimitiveConverter {
        private final PrimitiveConverter delegate;
        private final List<TProtocol> events;
        private final ParquetProtocol readFieldBegin;

        private void startField() {
            this.events.add(this.readFieldBegin);
        }

        private void endField() {
            this.events.add(ThriftRecordConverter.this.readFieldEnd);
        }

        public PrimitiveFieldHandler(PrimitiveConverter delegate, final ThriftField field2, List<TProtocol> events2) {
            this.delegate = delegate;
            this.events = events2;
            final byte thriftType = field2.getType().getType() == ThriftTypeID.ENUM ? ThriftTypeID.I32.getThriftType() : field2.getType().getType().getThriftType();
            this.readFieldBegin = new ParquetProtocol("readFieldBegin()"){

                @Override
                public TField readFieldBegin() throws TException {
                    return new TField(field2.getName(), thriftType, field2.getFieldId());
                }
            };
        }

        @Override
        public void addBinary(Binary value2) {
            this.startField();
            this.delegate.addBinary(value2);
            this.endField();
        }

        @Override
        public void addBoolean(boolean value2) {
            this.startField();
            this.delegate.addBoolean(value2);
            this.endField();
        }

        @Override
        public void addDouble(double value2) {
            this.startField();
            this.delegate.addDouble(value2);
            this.endField();
        }

        @Override
        public void addFloat(float value2) {
            this.startField();
            this.delegate.addFloat(value2);
            this.endField();
        }

        @Override
        public void addInt(int value2) {
            this.startField();
            this.delegate.addInt(value2);
            this.endField();
        }

        @Override
        public void addLong(long value2) {
            this.startField();
            this.delegate.addLong(value2);
            this.endField();
        }
    }
}

