/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import java.nio.ByteBuffer;
import org.apache.parquet.Log;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.thrift.ParquetProtocol;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;

public class ParquetWriteProtocol
extends ParquetProtocol {
    private static final Log LOG = Log.getLog(ParquetWriteProtocol.class);
    private final RecordConsumer recordConsumer;
    private TProtocol currentProtocol;

    private String toString(TStruct struct) {
        return "<TStruct name:" + struct.name + ">";
    }

    private String toString(TList list2) {
        return "<TList elemType:" + list2.elemType + " size:" + list2.size + ">";
    }

    private String toString(TMap map2) {
        return "<TMap keyType:" + map2.keyType + " valueType:" + map2.valueType + " size:" + map2.size + ">";
    }

    public ParquetWriteProtocol(RecordConsumer recordConsumer, MessageColumnIO schema, ThriftType.StructType thriftType) {
        this.currentProtocol = new MessageWriteProtocol(schema, thriftType);
        this.recordConsumer = recordConsumer;
    }

    @Override
    public void writeMessageBegin(TMessage message) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeMessageBegin(" + message + ")");
        }
        this.currentProtocol.writeMessageBegin(message);
    }

    @Override
    public void writeMessageEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeMessageEnd()");
        }
        this.currentProtocol.writeMessageEnd();
    }

    @Override
    public void writeStructBegin(TStruct struct) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeStructBegin(" + this.toString(struct) + ")");
        }
        this.currentProtocol.writeStructBegin(struct);
    }

    @Override
    public void writeStructEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeStructEnd()");
        }
        this.currentProtocol.writeStructEnd();
    }

    @Override
    public void writeFieldBegin(TField field2) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeFieldBegin(" + field2 + ")");
        }
        this.currentProtocol.writeFieldBegin(field2);
    }

    @Override
    public void writeFieldEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeFieldEnd()");
        }
        this.currentProtocol.writeFieldEnd();
    }

    @Override
    public void writeFieldStop() throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeFieldStop()");
        }
        this.currentProtocol.writeFieldStop();
    }

    @Override
    public void writeMapBegin(TMap map2) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeMapBegin(" + this.toString(map2) + ")");
        }
        this.currentProtocol.writeMapBegin(map2);
    }

    @Override
    public void writeMapEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeMapEnd()");
        }
        this.currentProtocol.writeMapEnd();
    }

    @Override
    public void writeListBegin(TList list2) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeListBegin(" + this.toString(list2) + ")");
        }
        this.currentProtocol.writeListBegin(list2);
    }

    @Override
    public void writeListEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeListEnd()");
        }
        this.currentProtocol.writeListEnd();
    }

    @Override
    public void writeSetBegin(TSet set2) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeSetBegin(" + set2 + ")");
        }
        this.currentProtocol.writeSetBegin(set2);
    }

    @Override
    public void writeSetEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeSetEnd()");
        }
        this.currentProtocol.writeSetEnd();
    }

    @Override
    public void writeBool(boolean b) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeBool(" + b + ")");
        }
        this.currentProtocol.writeBool(b);
    }

    @Override
    public void writeByte(byte b) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeByte(" + b + ")");
        }
        this.currentProtocol.writeByte(b);
    }

    @Override
    public void writeI16(short i16) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeI16(" + i16 + ")");
        }
        this.currentProtocol.writeI16(i16);
    }

    @Override
    public void writeI32(int i32) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeI32(" + i32 + ")");
        }
        this.currentProtocol.writeI32(i32);
    }

    @Override
    public void writeI64(long i64) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeI64(" + i64 + ")");
        }
        this.currentProtocol.writeI64(i64);
    }

    @Override
    public void writeDouble(double dub) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeDouble(" + dub + ")");
        }
        this.currentProtocol.writeDouble(dub);
    }

    @Override
    public void writeString(String str) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeString(" + str + ")");
        }
        this.currentProtocol.writeString(str);
    }

    @Override
    public void writeBinary(ByteBuffer buf) throws TException {
        if (Log.DEBUG) {
            LOG.debug("writeBinary(" + buf + ")");
        }
        this.currentProtocol.writeBinary(buf);
    }

    private void writeBinaryToRecordConsumer(ByteBuffer buf) {
        this.recordConsumer.addBinary(Binary.fromReusedByteArray(buf.array(), buf.position(), buf.limit() - buf.position()));
    }

    private void writeStringToRecordConsumer(String str) {
        this.recordConsumer.addBinary(Binary.fromString(str));
    }

    private TProtocol getProtocol(ThriftField field2, ColumnIO columnIO, Events returnClause) {
        FieldBaseWriteProtocol p;
        ThriftType type = field2.getType();
        switch (type.getType()) {
            default: {
                throw new UnsupportedOperationException("can't convert type of " + field2);
            }
            case BOOL: 
            case BYTE: 
            case DOUBLE: 
            case I16: 
            case I32: 
            case I64: 
            case STRING: {
                p = new PrimitiveWriteProtocol((PrimitiveColumnIO)columnIO, returnClause);
                break;
            }
            case STRUCT: {
                p = new StructWriteProtocol((GroupColumnIO)columnIO, (ThriftType.StructType)type, returnClause);
                break;
            }
            case MAP: {
                p = new MapWriteProtocol((GroupColumnIO)columnIO, (ThriftType.MapType)type, returnClause);
                break;
            }
            case SET: {
                p = new ListWriteProtocol((GroupColumnIO)columnIO, ((ThriftType.SetType)type).getValues(), returnClause);
                break;
            }
            case LIST: {
                p = new ListWriteProtocol((GroupColumnIO)columnIO, ((ThriftType.ListType)type).getValues(), returnClause);
                break;
            }
            case ENUM: {
                p = new EnumWriteProtocol((PrimitiveColumnIO)columnIO, (ThriftType.EnumType)type, returnClause);
            }
        }
        return p;
    }

    class MessageWriteProtocol
    extends StructWriteProtocol {
        public MessageWriteProtocol(MessageColumnIO schema, ThriftType.StructType thriftType) {
            super(schema, thriftType, null);
        }

        @Override
        public void writeStructBegin(TStruct struct) throws TException {
            ParquetWriteProtocol.this.recordConsumer.startMessage();
        }

        @Override
        public void writeStructEnd() throws TException {
            ParquetWriteProtocol.this.recordConsumer.endMessage();
        }
    }

    class StructWriteProtocol
    extends FieldBaseWriteProtocol {
        private final GroupColumnIO schema;
        private final ThriftType.StructType thriftType;
        private final TProtocol[] children;
        private ColumnIO currentType;
        private ColumnIO[] thriftFieldIdToParquetField;

        public StructWriteProtocol(GroupColumnIO schema, ThriftType.StructType thriftType, Events returnClause) {
            super(returnClause);
            if (schema == null) {
                throw new NullPointerException("schema");
            }
            this.thriftType = thriftType;
            int maxFieldId = 0;
            for (ThriftField field2 : thriftType.getChildren()) {
                maxFieldId = Math.max(maxFieldId, field2.getFieldId());
            }
            this.thriftFieldIdToParquetField = new ColumnIO[maxFieldId + 1];
            for (int i = 0; i < thriftType.getChildren().size(); ++i) {
                this.thriftFieldIdToParquetField[thriftType.getChildren().get((int)i).getFieldId()] = schema.getChild(i);
            }
            for (ThriftField field2 : thriftType.getChildren()) {
            }
            this.schema = schema;
            this.children = new TProtocol[thriftType.getChildren().size()];
            for (int i = 0; i < this.children.length; ++i) {
                ThriftField field2;
                field2 = thriftType.getChildren().get(i);
                ColumnIO columnIO = schema.getChild(field2.getName());
                if (columnIO == null) {
                    throw new RuntimeException("Could not find " + field2.getName() + " in " + schema);
                }
                try {
                    TProtocol p;
                    this.children[i] = p = ParquetWriteProtocol.this.getProtocol(field2, columnIO, new Events(){

                        @Override
                        public void start() {
                        }

                        @Override
                        public void end() {
                            ParquetWriteProtocol.this.currentProtocol = StructWriteProtocol.this;
                        }
                    });
                    continue;
                }
                catch (RuntimeException e) {
                    throw new ParquetEncodingException("Could not create Protocol for " + field2 + " to " + columnIO, e);
                }
            }
        }

        @Override
        public void writeStructBegin(TStruct struct) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.startGroup();
        }

        @Override
        public void writeStructEnd() throws TException {
            ParquetWriteProtocol.this.recordConsumer.endGroup();
            this.end();
        }

        @Override
        public void writeFieldBegin(TField field2) throws TException {
            if (field2.type == 0) {
                return;
            }
            try {
                this.currentType = this.thriftFieldIdToParquetField[field2.id];
                if (this.currentType == null) {
                    throw new ParquetEncodingException("field " + field2.id + " was not found in " + this.thriftType + " and " + this.schema.getType());
                }
                int index2 = this.currentType.getIndex();
                ParquetWriteProtocol.this.recordConsumer.startField(this.currentType.getName(), index2);
                ParquetWriteProtocol.this.currentProtocol = this.children[index2];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ParquetEncodingException("field " + field2.id + " was not found in " + this.thriftType + " and " + this.schema.getType());
            }
        }

        @Override
        public void writeFieldStop() throws TException {
        }

        @Override
        public void writeFieldEnd() throws TException {
            ParquetWriteProtocol.this.recordConsumer.endField(this.currentType.getName(), this.currentType.getIndex());
        }
    }

    class PrimitiveWriteProtocol
    extends FieldBaseWriteProtocol {
        public PrimitiveWriteProtocol(PrimitiveColumnIO columnIO, Events returnClause) {
            super(returnClause);
        }

        @Override
        public void writeBool(boolean b) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.addBoolean(b);
            this.end();
        }

        @Override
        public void writeByte(byte b) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.addInteger(b);
            this.end();
        }

        @Override
        public void writeI16(short i16) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.addInteger(i16);
            this.end();
        }

        @Override
        public void writeI32(int i32) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.addInteger(i32);
            this.end();
        }

        @Override
        public void writeI64(long i64) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.addLong(i64);
            this.end();
        }

        @Override
        public void writeDouble(double dub) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.addDouble(dub);
            this.end();
        }

        @Override
        public void writeString(String str) throws TException {
            this.start();
            ParquetWriteProtocol.this.writeStringToRecordConsumer(str);
            this.end();
        }

        @Override
        public void writeBinary(ByteBuffer buf) throws TException {
            this.start();
            ParquetWriteProtocol.this.writeBinaryToRecordConsumer(buf);
            this.end();
        }
    }

    class MapWriteProtocol
    extends FieldBaseWriteProtocol {
        private GroupColumnIO mapContent;
        private ColumnIO key;
        private ColumnIO value;
        private TProtocol keyProtocol;
        private TProtocol valueProtocol;
        private int countToConsume;

        public MapWriteProtocol(GroupColumnIO columnIO, ThriftType.MapType type, Events returnClause) {
            super(returnClause);
            this.mapContent = (GroupColumnIO)columnIO.getChild(0);
            this.key = this.mapContent.getChild(0);
            this.value = this.mapContent.getChild(1);
            this.keyProtocol = ParquetWriteProtocol.this.getProtocol(type.getKey(), this.key, new Events(){

                @Override
                public void start() {
                    ParquetWriteProtocol.this.recordConsumer.startGroup();
                    ParquetWriteProtocol.this.recordConsumer.startField(MapWriteProtocol.this.key.getName(), MapWriteProtocol.this.key.getIndex());
                }

                @Override
                public void end() {
                    ParquetWriteProtocol.this.recordConsumer.endField(MapWriteProtocol.this.key.getName(), MapWriteProtocol.this.key.getIndex());
                    ParquetWriteProtocol.this.currentProtocol = MapWriteProtocol.this.valueProtocol;
                }
            });
            this.valueProtocol = ParquetWriteProtocol.this.getProtocol(type.getValue(), this.value, new Events(){
                int consumed;

                @Override
                public void start() {
                    ParquetWriteProtocol.this.recordConsumer.startField(MapWriteProtocol.this.value.getName(), MapWriteProtocol.this.value.getIndex());
                }

                @Override
                public void end() {
                    ++this.consumed;
                    ParquetWriteProtocol.this.recordConsumer.endField(MapWriteProtocol.this.value.getName(), MapWriteProtocol.this.value.getIndex());
                    ParquetWriteProtocol.this.recordConsumer.endGroup();
                    if (this.consumed == MapWriteProtocol.this.countToConsume) {
                        ParquetWriteProtocol.this.currentProtocol = MapWriteProtocol.this;
                        this.consumed = 0;
                    } else {
                        ParquetWriteProtocol.this.currentProtocol = MapWriteProtocol.this.keyProtocol;
                    }
                }
            });
        }

        @Override
        public void writeMapBegin(TMap map2) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.startGroup();
            this.countToConsume = map2.size;
            if (this.countToConsume > 0) {
                ParquetWriteProtocol.this.recordConsumer.startField(this.mapContent.getType().getName(), 0);
                ParquetWriteProtocol.this.currentProtocol = this.keyProtocol;
            }
        }

        @Override
        public void writeMapEnd() throws TException {
            if (this.countToConsume > 0) {
                ParquetWriteProtocol.this.recordConsumer.endField(this.mapContent.getType().getName(), 0);
            }
            ParquetWriteProtocol.this.recordConsumer.endGroup();
            this.end();
        }
    }

    class ListWriteProtocol
    extends FieldBaseWriteProtocol {
        private ColumnIO listContent;
        private TProtocol contentProtocol;
        private int size;

        public ListWriteProtocol(GroupColumnIO columnIO, ThriftField values2, Events returnClause) {
            super(returnClause);
            this.listContent = columnIO.getChild(0);
            this.contentProtocol = ParquetWriteProtocol.this.getProtocol(values2, this.listContent, new Events(){
                int consumedRecords = 0;

                @Override
                public void start() {
                }

                @Override
                public void end() {
                    ++this.consumedRecords;
                    if (this.consumedRecords == ListWriteProtocol.this.size) {
                        ParquetWriteProtocol.this.currentProtocol = ListWriteProtocol.this;
                        this.consumedRecords = 0;
                    }
                }
            });
        }

        private void startListWrapper() {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.startGroup();
            if (this.size > 0) {
                ParquetWriteProtocol.this.recordConsumer.startField(this.listContent.getType().getName(), 0);
                ParquetWriteProtocol.this.currentProtocol = this.contentProtocol;
            }
        }

        private void endListWrapper() {
            if (this.size > 0) {
                ParquetWriteProtocol.this.recordConsumer.endField(this.listContent.getType().getName(), 0);
            }
            ParquetWriteProtocol.this.recordConsumer.endGroup();
            this.end();
        }

        @Override
        public void writeListBegin(TList list2) throws TException {
            this.size = list2.size;
            this.startListWrapper();
        }

        @Override
        public void writeListEnd() throws TException {
            this.endListWrapper();
        }

        @Override
        public void writeSetBegin(TSet set2) throws TException {
            this.size = set2.size;
            this.startListWrapper();
        }

        @Override
        public void writeSetEnd() throws TException {
            this.endListWrapper();
        }
    }

    class EnumWriteProtocol
    extends FieldBaseWriteProtocol {
        private final ThriftType.EnumType type;
        private PrimitiveColumnIO columnIO;

        public EnumWriteProtocol(PrimitiveColumnIO columnIO, ThriftType.EnumType type, Events returnClause) {
            super(returnClause);
            this.columnIO = columnIO;
            this.type = type;
        }

        @Override
        public void writeI32(int i32) throws TException {
            this.start();
            ThriftType.EnumValue value2 = this.type.getEnumValueById(i32);
            if (value2 == null) {
                throw new ParquetEncodingException("Can not find enum value of index " + i32 + " for field:" + this.columnIO.toString());
            }
            ParquetWriteProtocol.this.recordConsumer.addBinary(Binary.fromString(value2.getName()));
            this.end();
        }
    }

    abstract class FieldBaseWriteProtocol
    extends ParquetProtocol {
        private final Events returnClause;

        public FieldBaseWriteProtocol(Events returnClause) {
            this.returnClause = returnClause;
        }

        void start() {
            this.returnClause.start();
        }

        void end() {
            this.returnClause.end();
        }
    }

    static interface Events {
        public void start();

        public void end();
    }
}

