/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.parquet.Log;
import org.apache.parquet.thrift.ParquetProtocol;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;

class ParquetReadProtocol
extends ParquetProtocol {
    private static final Log LOG = Log.getLog(ParquetReadProtocol.class);
    private Deque<TProtocol> events = new LinkedList<TProtocol>();

    ParquetReadProtocol() {
        super("read");
    }

    public void add(TProtocol p) {
        this.events.addLast(p);
    }

    public void addAll(Collection<TProtocol> events2) {
        this.events.addAll(events2);
    }

    public void clear() {
        this.events.clear();
    }

    private TProtocol next() {
        return this.events.removeFirst();
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readMessageBegin()");
        }
        return this.next().readMessageBegin();
    }

    @Override
    public void readMessageEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readMessageEnd()");
        }
        this.next().readMessageEnd();
    }

    @Override
    public TStruct readStructBegin() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readStructBegin()");
        }
        return this.next().readStructBegin();
    }

    @Override
    public void readStructEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readStructEnd()");
        }
        this.next().readStructEnd();
    }

    @Override
    public TField readFieldBegin() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readFieldBegin()");
        }
        return this.next().readFieldBegin();
    }

    @Override
    public void readFieldEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readFieldEnd()");
        }
        this.next().readFieldEnd();
    }

    @Override
    public TMap readMapBegin() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readMapBegin()");
        }
        return this.next().readMapBegin();
    }

    @Override
    public void readMapEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readMapEnd()");
        }
        this.next().readMapEnd();
    }

    @Override
    public TList readListBegin() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readListBegin()");
        }
        return this.next().readListBegin();
    }

    @Override
    public void readListEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readListEnd()");
        }
        this.next().readListEnd();
    }

    @Override
    public TSet readSetBegin() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readSetBegin()");
        }
        return this.next().readSetBegin();
    }

    @Override
    public void readSetEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readSetEnd()");
        }
        this.next().readSetEnd();
    }

    @Override
    public boolean readBool() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readBool()");
        }
        return this.next().readBool();
    }

    @Override
    public byte readByte() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readByte()");
        }
        return this.next().readByte();
    }

    @Override
    public short readI16() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readI16()");
        }
        return this.next().readI16();
    }

    @Override
    public int readI32() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readI32()");
        }
        return this.next().readI32();
    }

    @Override
    public long readI64() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readI64()");
        }
        return this.next().readI64();
    }

    @Override
    public double readDouble() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readDouble()");
        }
        return this.next().readDouble();
    }

    @Override
    public String readString() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readString()");
        }
        return this.next().readString();
    }

    @Override
    public ByteBuffer readBinary() throws TException {
        if (Log.DEBUG) {
            LOG.debug("readBinary()");
        }
        return this.next().readBinary();
    }
}

