/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.parquet.ShouldNeverHappenException;
import org.apache.parquet.thrift.DecodingSchemaMismatchException;
import org.apache.parquet.thrift.FieldIgnoredHandler;
import org.apache.parquet.thrift.ProtocolPipe;
import org.apache.parquet.thrift.ProtocolReadToWrite;
import org.apache.parquet.thrift.SkippableException;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.parquet.thrift.struct.ThriftTypeID;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;

public class BufferedProtocolReadToWrite
implements ProtocolPipe {
    private static final Action STRUCT_END = new Action(){

        @Override
        public void write(TProtocol out) throws TException {
            out.writeFieldStop();
            out.writeStructEnd();
        }

        @Override
        public String toDebugString() {
            return ")";
        }
    };
    private static final Action FIELD_END = new Action(){

        @Override
        public void write(TProtocol out) throws TException {
            out.writeFieldEnd();
        }

        @Override
        public String toDebugString() {
            return ";";
        }
    };
    private static final Action MAP_END = new Action(){

        @Override
        public void write(TProtocol out) throws TException {
            out.writeMapEnd();
        }

        @Override
        public String toDebugString() {
            return "]";
        }
    };
    private static final Action LIST_END = new Action(){

        @Override
        public void write(TProtocol out) throws TException {
            out.writeListEnd();
        }

        @Override
        public String toDebugString() {
            return "}";
        }
    };
    private static final Action SET_END = new Action(){

        @Override
        public void write(TProtocol out) throws TException {
            out.writeSetEnd();
        }

        @Override
        public String toDebugString() {
            return "*}";
        }
    };
    private final FieldIgnoredHandler errorHandler;
    private final ThriftType.StructType thriftType;

    public BufferedProtocolReadToWrite(ThriftType.StructType thriftType) {
        this(thriftType, null);
    }

    public BufferedProtocolReadToWrite(ThriftType.StructType thriftType, FieldIgnoredHandler errorHandler) {
        this.thriftType = thriftType;
        this.errorHandler = errorHandler;
    }

    @Override
    public void readOne(TProtocol in, TProtocol out) throws TException {
        LinkedList<Action> buffer2 = new LinkedList<Action>();
        try {
            boolean hasFieldsIgnored = this.readOneStruct(in, buffer2, this.thriftType);
            if (hasFieldsIgnored) {
                this.notifyRecordHasFieldIgnored();
            }
        }
        catch (Exception e) {
            throw new SkippableException(this.error("Error while reading", buffer2), e);
        }
        try {
            for (Action a : buffer2) {
                a.write(out);
            }
        }
        catch (Exception e) {
            throw new TException(this.error("Can not write record", buffer2), e);
        }
    }

    private void notifyRecordHasFieldIgnored() {
        if (this.errorHandler != null) {
            this.errorHandler.handleRecordHasFieldIgnored();
        }
    }

    private void notifyIgnoredFieldsOfRecord(TField field2) {
        if (this.errorHandler != null) {
            this.errorHandler.handleFieldIgnored(field2);
        }
    }

    private String error(String message, List<Action> buffer2) {
        StringBuilder sb = new StringBuilder(message).append(": ");
        for (Action action2 : buffer2) {
            sb.append(action2.toDebugString());
        }
        return sb.toString();
    }

    private boolean readOneValue(TProtocol in, byte type, List<Action> buffer2, ThriftType expectedType) throws TException {
        if (expectedType != null && expectedType.getType().getSerializedThriftType() != type) {
            throw new DecodingSchemaMismatchException("the data type does not match the expected thrift structure: expected " + expectedType + " got " + this.typeName(type));
        }
        boolean hasFieldsIgnored = false;
        switch (type) {
            case 15: {
                hasFieldsIgnored = this.readOneList(in, buffer2, (ThriftType.ListType)expectedType);
                break;
            }
            case 13: {
                hasFieldsIgnored = this.readOneMap(in, buffer2, (ThriftType.MapType)expectedType);
                break;
            }
            case 14: {
                hasFieldsIgnored = this.readOneSet(in, buffer2, (ThriftType.SetType)expectedType);
                break;
            }
            case 12: {
                hasFieldsIgnored = this.readOneStruct(in, buffer2, (ThriftType.StructType)expectedType);
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                boolean bool2 = in.readBool();
                this.writeBoolAction(buffer2, bool2);
                break;
            }
            case 3: {
                byte b = in.readByte();
                this.writeByteAction(buffer2, b);
                break;
            }
            case 4: {
                double d = in.readDouble();
                this.writeDoubleAction(buffer2, d);
                break;
            }
            case 6: {
                short s2 = in.readI16();
                this.writeShortAction(buffer2, s2);
                break;
            }
            case 8: 
            case 16: {
                int i = in.readI32();
                this.checkEnum(expectedType, i);
                this.writeIntAction(buffer2, i);
                break;
            }
            case 10: {
                long l = in.readI64();
                this.writeLongAction(buffer2, l);
                break;
            }
            case 11: {
                ByteBuffer bin = in.readBinary();
                this.writeStringAction(buffer2, bin);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new TException("Unknown type: " + type);
            }
        }
        return hasFieldsIgnored;
    }

    private void writeStringAction(List<Action> buffer2, final ByteBuffer bin) {
        buffer2.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeBinary(bin);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(bin);
            }
        });
    }

    private void writeLongAction(List<Action> buffer2, final long l) {
        buffer2.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeI64(l);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(l);
            }
        });
    }

    private void writeIntAction(List<Action> buffer2, final int i) {
        buffer2.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeI32(i);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(i);
            }
        });
    }

    private void writeShortAction(List<Action> buffer2, final short s2) {
        buffer2.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeI16(s2);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(s2);
            }
        });
    }

    private void writeDoubleAction(List<Action> buffer2, final double d) {
        buffer2.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeDouble(d);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(d);
            }
        });
    }

    private void writeByteAction(List<Action> buffer2, final byte b) {
        buffer2.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeByte(b);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(b);
            }
        });
    }

    private void writeBoolAction(List<Action> buffer2, final boolean bool2) {
        buffer2.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeBool(bool2);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(bool2);
            }
        });
    }

    private String typeName(byte type) {
        try {
            return ThriftTypeID.fromByte(type).name();
        }
        catch (RuntimeException e) {
            return String.valueOf(type);
        }
    }

    private boolean readOneStruct(TProtocol in, List<Action> buffer2, ThriftType.StructType type) throws TException {
        final TStruct struct = in.readStructBegin();
        buffer2.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeStructBegin(struct);
            }

            @Override
            public String toDebugString() {
                return "(";
            }
        });
        boolean hasFieldsIgnored = false;
        int childFieldsPresent = 0;
        while (true) {
            TField field2 = in.readFieldBegin();
            if (field2.type == 0) break;
            final TField currentField = field2;
            ThriftField expectedField = type.getChildById(field2.id);
            if (expectedField == null) {
                this.handleUnrecognizedField(field2, type, in);
                hasFieldsIgnored |= true;
                continue;
            }
            buffer2.add(new Action(){

                @Override
                public void write(TProtocol out) throws TException {
                    out.writeFieldBegin(currentField);
                }

                @Override
                public String toDebugString() {
                    return "f=" + currentField.id + "<t=" + BufferedProtocolReadToWrite.this.typeName(currentField.type) + ">: ";
                }
            });
            boolean wasIgnored = this.readOneValue(in, field2.type, buffer2, expectedField.getType());
            if (!wasIgnored) {
                ++childFieldsPresent;
            }
            hasFieldsIgnored |= wasIgnored;
            in.readFieldEnd();
            buffer2.add(FIELD_END);
        }
        this.assertUnionHasExactlyOneChild(type, childFieldsPresent);
        in.readStructEnd();
        buffer2.add(STRUCT_END);
        return hasFieldsIgnored;
    }

    private void handleUnrecognizedField(TField field2, ThriftType.StructType type, TProtocol in) throws TException {
        switch (type.getStructOrUnionType()) {
            case STRUCT: {
                this.notifyIgnoredFieldsOfRecord(field2);
                new ProtocolReadToWrite().readOneValue(in, new NullProtocol(), field2.type);
                break;
            }
            case UNION: {
                throw new DecodingSchemaMismatchException("Unrecognized union member with id: " + field2.id + " for struct:\n" + type);
            }
            case UNKNOWN: {
                throw BufferedProtocolReadToWrite.unknownStructOrUnion(type);
            }
            default: {
                throw BufferedProtocolReadToWrite.unrecognizedStructOrUnion(type.getStructOrUnionType());
            }
        }
    }

    private void assertUnionHasExactlyOneChild(ThriftType.StructType type, int childFieldsPresent) {
        switch (type.getStructOrUnionType()) {
            case STRUCT: {
                break;
            }
            case UNION: {
                if (childFieldsPresent == 1) break;
                if (childFieldsPresent == 0) {
                    throw new DecodingSchemaMismatchException("Cannot write a TUnion with no set value in :\n" + type);
                }
                throw new DecodingSchemaMismatchException("Cannot write a TUnion with more than 1 set value in :\n" + type);
            }
            case UNKNOWN: {
                throw BufferedProtocolReadToWrite.unknownStructOrUnion(type);
            }
            default: {
                throw BufferedProtocolReadToWrite.unrecognizedStructOrUnion(type.getStructOrUnionType());
            }
        }
    }

    private static ShouldNeverHappenException unrecognizedStructOrUnion(ThriftType.StructType.StructOrUnionType type) {
        return new ShouldNeverHappenException("Unrecognized StructOrUnionType: " + (Object)((Object)type));
    }

    private static ShouldNeverHappenException unknownStructOrUnion(ThriftType.StructType type) {
        return new ShouldNeverHappenException("This should never happen! Don't know if this field is a union, was the deprecated constructor of StructType used?\n" + type);
    }

    private boolean readOneMap(TProtocol in, List<Action> buffer2, ThriftType.MapType mapType2) throws TException {
        final TMap map2 = in.readMapBegin();
        buffer2.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeMapBegin(map2);
            }

            @Override
            public String toDebugString() {
                return "<k=" + map2.keyType + ", v=" + map2.valueType + ", s=" + map2.size + ">[";
            }
        });
        boolean hasFieldIgnored = false;
        for (int i = 0; i < map2.size; ++i) {
            hasFieldIgnored |= this.readOneValue(in, map2.keyType, buffer2, mapType2.getKey().getType());
            hasFieldIgnored |= this.readOneValue(in, map2.valueType, buffer2, mapType2.getValue().getType());
        }
        in.readMapEnd();
        buffer2.add(MAP_END);
        return hasFieldIgnored;
    }

    private boolean readOneSet(TProtocol in, List<Action> buffer2, ThriftType.SetType expectedType) throws TException {
        final TSet set2 = in.readSetBegin();
        buffer2.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeSetBegin(set2);
            }

            @Override
            public String toDebugString() {
                return "<e=" + set2.elemType + ", s=" + set2.size + ">{*";
            }
        });
        boolean hasFieldsIgnored = this.readCollectionElements(in, set2.size, set2.elemType, buffer2, expectedType.getValues().getType());
        in.readSetEnd();
        buffer2.add(SET_END);
        return hasFieldsIgnored;
    }

    private boolean readOneList(TProtocol in, List<Action> buffer2, ThriftType.ListType expectedType) throws TException {
        final TList list2 = in.readListBegin();
        buffer2.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeListBegin(list2);
            }

            @Override
            public String toDebugString() {
                return "<e=" + list2.elemType + ", s=" + list2.size + ">{";
            }
        });
        boolean hasFieldsIgnored = this.readCollectionElements(in, list2.size, list2.elemType, buffer2, expectedType.getValues().getType());
        in.readListEnd();
        buffer2.add(LIST_END);
        return hasFieldsIgnored;
    }

    private boolean readCollectionElements(TProtocol in, int size2, byte elemType, List<Action> buffer2, ThriftType expectedType) throws TException {
        boolean hasFieldIgnored = false;
        for (int i = 0; i < size2; ++i) {
            hasFieldIgnored |= this.readOneValue(in, elemType, buffer2, expectedType);
        }
        return hasFieldIgnored;
    }

    private void checkEnum(ThriftType expectedType, int i) {
        ThriftType.EnumType expectedEnumType;
        if (expectedType.getType() == ThriftTypeID.ENUM && (expectedEnumType = (ThriftType.EnumType)expectedType).getEnumValueById(i) == null) {
            throw new DecodingSchemaMismatchException("can not find index " + i + " in enum " + expectedType);
        }
    }

    class NullProtocol
    extends TProtocol {
        public NullProtocol() {
            super(null);
        }

        @Override
        public void writeMessageBegin(TMessage tMessage) throws TException {
        }

        @Override
        public void writeMessageEnd() throws TException {
        }

        @Override
        public void writeStructBegin(TStruct tStruct) throws TException {
        }

        @Override
        public void writeStructEnd() throws TException {
        }

        @Override
        public void writeFieldBegin(TField tField) throws TException {
        }

        @Override
        public void writeFieldEnd() throws TException {
        }

        @Override
        public void writeFieldStop() throws TException {
        }

        @Override
        public void writeMapBegin(TMap tMap) throws TException {
        }

        @Override
        public void writeMapEnd() throws TException {
        }

        @Override
        public void writeListBegin(TList tList) throws TException {
        }

        @Override
        public void writeListEnd() throws TException {
        }

        @Override
        public void writeSetBegin(TSet tSet) throws TException {
        }

        @Override
        public void writeSetEnd() throws TException {
        }

        @Override
        public void writeBool(boolean b) throws TException {
        }

        @Override
        public void writeByte(byte b) throws TException {
        }

        @Override
        public void writeI16(short i) throws TException {
        }

        @Override
        public void writeI32(int i) throws TException {
        }

        @Override
        public void writeI64(long l) throws TException {
        }

        @Override
        public void writeDouble(double v) throws TException {
        }

        @Override
        public void writeString(String s2) throws TException {
        }

        @Override
        public void writeBinary(ByteBuffer byteBuffer) throws TException {
        }

        @Override
        public TMessage readMessageBegin() throws TException {
            return null;
        }

        @Override
        public void readMessageEnd() throws TException {
        }

        @Override
        public TStruct readStructBegin() throws TException {
            return null;
        }

        @Override
        public void readStructEnd() throws TException {
        }

        @Override
        public TField readFieldBegin() throws TException {
            return null;
        }

        @Override
        public void readFieldEnd() throws TException {
        }

        @Override
        public TMap readMapBegin() throws TException {
            return null;
        }

        @Override
        public void readMapEnd() throws TException {
        }

        @Override
        public TList readListBegin() throws TException {
            return null;
        }

        @Override
        public void readListEnd() throws TException {
        }

        @Override
        public TSet readSetBegin() throws TException {
            return null;
        }

        @Override
        public void readSetEnd() throws TException {
        }

        @Override
        public boolean readBool() throws TException {
            return false;
        }

        @Override
        public byte readByte() throws TException {
            return 0;
        }

        @Override
        public short readI16() throws TException {
            return 0;
        }

        @Override
        public int readI32() throws TException {
            return 0;
        }

        @Override
        public long readI64() throws TException {
            return 0L;
        }

        @Override
        public double readDouble() throws TException {
            return 0.0;
        }

        @Override
        public String readString() throws TException {
            return null;
        }

        @Override
        public ByteBuffer readBinary() throws TException {
            return null;
        }
    }

    private static interface Action {
        public void write(TProtocol var1) throws TException;

        public String toDebugString();
    }
}

