/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.parquet.Log;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class MessageTypeParser {
    private static final Log LOG = Log.getLog(MessageTypeParser.class);

    private MessageTypeParser() {
    }

    public static MessageType parseMessageType(String input2) {
        return MessageTypeParser.parse(input2);
    }

    private static MessageType parse(String schemaString) {
        Tokenizer st = new Tokenizer(schemaString, " ;{}()\n\t");
        Types.MessageTypeBuilder builder = Types.buildMessage();
        String t = st.nextToken();
        MessageTypeParser.check(t, "message", "start with 'message'", st);
        String name2 = st.nextToken();
        MessageTypeParser.addGroupTypeFields(st.nextToken(), st, builder);
        return builder.named(name2);
    }

    private static void addGroupTypeFields(String t, Tokenizer st, Types.GroupBuilder builder) {
        MessageTypeParser.check(t, "{", "start of message", st);
        while (!(t = st.nextToken()).equals("}")) {
            MessageTypeParser.addType(t, st, builder);
        }
    }

    private static void addType(String t, Tokenizer st, Types.GroupBuilder builder) {
        Type.Repetition repetition = MessageTypeParser.asRepetition(t, st);
        String type = st.nextToken();
        if ("group".equalsIgnoreCase(type)) {
            MessageTypeParser.addGroupType(t, st, repetition, builder);
        } else {
            MessageTypeParser.addPrimitiveType(t, st, MessageTypeParser.asPrimitive(type, st), repetition, builder);
        }
    }

    private static void addGroupType(String t, Tokenizer st, Type.Repetition r, Types.GroupBuilder<?> builder) {
        Types.GroupBuilder childBuilder = builder.group(r);
        String name2 = st.nextToken();
        t = st.nextToken();
        OriginalType originalType = null;
        if (t.equalsIgnoreCase("(")) {
            originalType = OriginalType.valueOf(st.nextToken());
            childBuilder.as(originalType);
            MessageTypeParser.check(st.nextToken(), ")", "original type ended by )", st);
            t = st.nextToken();
        }
        if (t.equals("=")) {
            childBuilder.id(Integer.parseInt(st.nextToken()));
            t = st.nextToken();
        }
        try {
            MessageTypeParser.addGroupTypeFields(t, st, childBuilder);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("problem reading type: type = group, name = " + name2 + ", original type = " + (Object)((Object)originalType), e);
        }
        childBuilder.named(name2);
    }

    private static void addPrimitiveType(String t, Tokenizer st, PrimitiveType.PrimitiveTypeName type, Type.Repetition r, Types.GroupBuilder<?> builder) {
        Types.PrimitiveBuilder childBuilder = builder.primitive(type, r);
        if (type == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            t = st.nextToken();
            if (!t.equalsIgnoreCase("(")) {
                throw new IllegalArgumentException("expecting (length) for field of type fixed_len_byte_array");
            }
            childBuilder.length(Integer.parseInt(st.nextToken()));
            MessageTypeParser.check(st.nextToken(), ")", "type length ended by )", st);
        }
        String name2 = st.nextToken();
        t = st.nextToken();
        OriginalType originalType = null;
        if (t.equalsIgnoreCase("(")) {
            originalType = OriginalType.valueOf(st.nextToken());
            childBuilder.as(originalType);
            if (OriginalType.DECIMAL == originalType) {
                t = st.nextToken();
                if (t.equalsIgnoreCase("(")) {
                    childBuilder.precision(Integer.parseInt(st.nextToken()));
                    t = st.nextToken();
                    if (t.equalsIgnoreCase(",")) {
                        childBuilder.scale(Integer.parseInt(st.nextToken()));
                        t = st.nextToken();
                    }
                    MessageTypeParser.check(t, ")", "decimal type ended by )", st);
                    t = st.nextToken();
                }
            } else {
                t = st.nextToken();
            }
            MessageTypeParser.check(t, ")", "original type ended by )", st);
            t = st.nextToken();
        }
        if (t.equals("=")) {
            childBuilder.id(Integer.parseInt(st.nextToken()));
            t = st.nextToken();
        }
        MessageTypeParser.check(t, ";", "field ended by ';'", st);
        try {
            childBuilder.named(name2);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("problem reading type: type = " + (Object)((Object)type) + ", name = " + name2 + ", original type = " + (Object)((Object)originalType), e);
        }
    }

    private static PrimitiveType.PrimitiveTypeName asPrimitive(String t, Tokenizer st) {
        try {
            return PrimitiveType.PrimitiveTypeName.valueOf(t.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("expected one of " + Arrays.toString((Object[])PrimitiveType.PrimitiveTypeName.values()) + " got " + t + " at " + st.getLocationString(), e);
        }
    }

    private static Type.Repetition asRepetition(String t, Tokenizer st) {
        try {
            return Type.Repetition.valueOf(t.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("expected one of " + Arrays.toString((Object[])Type.Repetition.values()) + " got " + t + " at " + st.getLocationString(), e);
        }
    }

    private static void check(String t, String expected, String message, Tokenizer tokenizer) {
        if (!t.equalsIgnoreCase(expected)) {
            throw new IllegalArgumentException(message + ": expected '" + expected + "' but got '" + t + "' at " + tokenizer.getLocationString());
        }
    }

    private static class Tokenizer {
        private StringTokenizer st;
        private int line = 0;
        private StringBuffer currentLine = new StringBuffer();

        public Tokenizer(String schemaString, String string2) {
            this.st = new StringTokenizer(schemaString, " ,;{}()\n\t=", true);
        }

        public String nextToken() {
            while (this.st.hasMoreTokens()) {
                String t = this.st.nextToken();
                if (t.equals("\n")) {
                    ++this.line;
                    this.currentLine.setLength(0);
                } else {
                    this.currentLine.append(t);
                }
                if (this.isWhitespace(t)) continue;
                return t;
            }
            throw new IllegalArgumentException("unexpected end of schema");
        }

        private boolean isWhitespace(String t) {
            return t.equals(" ") || t.equals("\t") || t.equals("\n");
        }

        public String getLocationString() {
            return "line " + this.line + ": " + this.currentLine.toString();
        }
    }
}

