/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.schema.IncompatibleSchemaModificationException;
import org.apache.parquet.schema.InvalidSchemaException;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.TypeConverter;
import org.apache.parquet.schema.TypeVisitor;

public class GroupType
extends Type {
    private final List<Type> fields;
    private final Map<String, Integer> indexByName;

    public GroupType(Type.Repetition repetition, String name2, List<Type> fields2) {
        this(repetition, name2, null, fields2, null);
    }

    public GroupType(Type.Repetition repetition, String name2, Type ... fields2) {
        this(repetition, name2, Arrays.asList(fields2));
    }

    @Deprecated
    public GroupType(Type.Repetition repetition, String name2, OriginalType originalType, Type ... fields2) {
        this(repetition, name2, originalType, Arrays.asList(fields2));
    }

    @Deprecated
    public GroupType(Type.Repetition repetition, String name2, OriginalType originalType, List<Type> fields2) {
        this(repetition, name2, originalType, fields2, null);
    }

    GroupType(Type.Repetition repetition, String name2, OriginalType originalType, List<Type> fields2, Type.ID id) {
        super(name2, repetition, originalType, id);
        if (fields2.isEmpty()) {
            throw new InvalidSchemaException("A group type can not be empty. Parquet does not support empty group without leaves. Empty group: " + name2);
        }
        this.fields = fields2;
        this.indexByName = new HashMap<String, Integer>();
        for (int i = 0; i < fields2.size(); ++i) {
            this.indexByName.put(fields2.get(i).getName(), i);
        }
    }

    @Override
    public GroupType withId(int id) {
        return new GroupType(this.getRepetition(), this.getName(), this.getOriginalType(), this.fields, new Type.ID(id));
    }

    public GroupType withNewFields(List<Type> newFields) {
        return new GroupType(this.getRepetition(), this.getName(), this.getOriginalType(), newFields, this.getId());
    }

    public GroupType withNewFields(Type ... newFields) {
        return this.withNewFields(Arrays.asList(newFields));
    }

    public String getFieldName(int index2) {
        return this.fields.get(index2).getName();
    }

    public boolean containsField(String name2) {
        return this.indexByName.containsKey(name2);
    }

    public int getFieldIndex(String name2) {
        if (!this.indexByName.containsKey(name2)) {
            throw new InvalidRecordException(name2 + " not found in " + this);
        }
        return this.indexByName.get(name2);
    }

    public List<Type> getFields() {
        return this.fields;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public Type getType(String fieldName) {
        return this.getType(this.getFieldIndex(fieldName));
    }

    public Type getType(int index2) {
        return this.fields.get(index2);
    }

    void membersDisplayString(StringBuilder sb, String indent2) {
        for (Type field2 : this.fields) {
            field2.writeToStringBuilder(sb, indent2);
            if (field2.isPrimitive()) {
                sb.append(";");
            }
            sb.append("\n");
        }
    }

    @Override
    public void writeToStringBuilder(StringBuilder sb, String indent2) {
        sb.append(indent2).append(this.getRepetition().name().toLowerCase()).append(" group ").append(this.getName()).append(this.getOriginalType() == null ? "" : " (" + (Object)((Object)this.getOriginalType()) + ")").append(this.getId() == null ? "" : " = " + this.getId()).append(" {\n");
        this.membersDisplayString(sb, indent2 + "  ");
        sb.append(indent2).append("}");
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    @Deprecated
    protected int typeHashCode() {
        return this.hashCode();
    }

    @Override
    @Deprecated
    protected boolean typeEquals(Type other) {
        return this.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.getFields().hashCode();
    }

    @Override
    protected boolean equals(Type otherType) {
        return !otherType.isPrimitive() && super.equals(otherType) && this.getFields().equals(otherType.asGroupType().getFields());
    }

    @Override
    protected int getMaxRepetitionLevel(String[] path, int depth) {
        int myVal;
        int n = myVal = this.isRepetition(Type.Repetition.REPEATED) ? 1 : 0;
        if (depth == path.length) {
            return myVal;
        }
        return myVal + this.getType(path[depth]).getMaxRepetitionLevel(path, depth + 1);
    }

    @Override
    protected int getMaxDefinitionLevel(String[] path, int depth) {
        int myVal;
        int n = myVal = !this.isRepetition(Type.Repetition.REQUIRED) ? 1 : 0;
        if (depth == path.length) {
            return myVal;
        }
        return myVal + this.getType(path[depth]).getMaxDefinitionLevel(path, depth + 1);
    }

    @Override
    protected Type getType(String[] path, int depth) {
        if (depth == path.length) {
            return this;
        }
        return this.getType(path[depth]).getType(path, depth + 1);
    }

    @Override
    protected boolean containsPath(String[] path, int depth) {
        if (depth == path.length) {
            return false;
        }
        return this.containsField(path[depth]) && this.getType(path[depth]).containsPath(path, depth + 1);
    }

    @Override
    protected List<String[]> getPaths(int depth) {
        ArrayList<String[]> result2 = new ArrayList<String[]>();
        for (Type field2 : this.fields) {
            List<String[]> paths = field2.getPaths(depth + 1);
            for (String[] path : paths) {
                path[depth] = field2.getName();
                result2.add(path);
            }
        }
        return result2;
    }

    @Override
    void checkContains(Type subType) {
        super.checkContains(subType);
        this.checkGroupContains(subType);
    }

    void checkGroupContains(Type subType) {
        if (subType.isPrimitive()) {
            throw new InvalidRecordException(subType + " found: expected " + this);
        }
        List<Type> fields2 = subType.asGroupType().getFields();
        for (Type otherType : fields2) {
            Type thisType = this.getType(otherType.getName());
            thisType.checkContains(otherType);
        }
    }

    @Override
    <T> T convert(List<GroupType> path, TypeConverter<T> converter2) {
        ArrayList<GroupType> childrenPath = new ArrayList<GroupType>(path);
        childrenPath.add(this);
        List<T> children2 = this.convertChildren(childrenPath, converter2);
        return converter2.convertGroupType(path, this, children2);
    }

    protected <T> List<T> convertChildren(List<GroupType> path, TypeConverter<T> converter2) {
        ArrayList<T> children2 = new ArrayList<T>(this.fields.size());
        for (Type field2 : this.fields) {
            children2.add(field2.convert(path, converter2));
        }
        return children2;
    }

    @Override
    protected Type union(Type toMerge) {
        return this.union(toMerge, true);
    }

    @Override
    protected Type union(Type toMerge, boolean strict) {
        if (toMerge.isPrimitive()) {
            throw new IncompatibleSchemaModificationException("can not merge primitive type " + toMerge + " into group type " + this);
        }
        return new GroupType(toMerge.getRepetition(), this.getName(), this.mergeFields(toMerge.asGroupType()));
    }

    List<Type> mergeFields(GroupType toMerge) {
        return this.mergeFields(toMerge, true);
    }

    List<Type> mergeFields(GroupType toMerge, boolean strict) {
        ArrayList<Type> newFields = new ArrayList<Type>();
        for (Type type : this.getFields()) {
            Type merged;
            if (toMerge.containsField(type.getName())) {
                Type fieldToMerge = toMerge.getType(type.getName());
                if (fieldToMerge.getRepetition().isMoreRestrictiveThan(type.getRepetition())) {
                    throw new IncompatibleSchemaModificationException("repetition constraint is more restrictive: can not merge type " + fieldToMerge + " into " + type);
                }
                merged = type.union(fieldToMerge, strict);
            } else {
                merged = type;
            }
            newFields.add(merged);
        }
        for (Type type : toMerge.getFields()) {
            if (this.containsField(type.getName())) continue;
            newFields.add(type);
        }
        return newFields;
    }
}

