/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.it.unimi.dsi.fastutil.objects;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Random;
import org.apache.parquet.it.unimi.dsi.fastutil.Arrays;
import org.apache.parquet.it.unimi.dsi.fastutil.Hash;

public class ObjectArrays {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private ObjectArrays() {
    }

    private static <K> K[] newArray(K[] prototype, int length) {
        Class<?> componentType = prototype.getClass().getComponentType();
        if (length == 0 && componentType == Object.class) {
            return EMPTY_ARRAY;
        }
        return (Object[])Array.newInstance(prototype.getClass().getComponentType(), length);
    }

    public static <K> K[] ensureCapacity(K[] array2, int length) {
        if (length > array2.length) {
            K[] t = ObjectArrays.newArray(array2, length);
            System.arraycopy(array2, 0, t, 0, array2.length);
            return t;
        }
        return array2;
    }

    public static <K> K[] ensureCapacity(K[] array2, int length, int preserve) {
        if (length > array2.length) {
            K[] t = ObjectArrays.newArray(array2, length);
            System.arraycopy(array2, 0, t, 0, preserve);
            return t;
        }
        return array2;
    }

    public static <K> K[] grow(K[] array2, int length) {
        if (length > array2.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array2.length, (long)length), 0x7FFFFFF7L);
            K[] t = ObjectArrays.newArray(array2, newLength);
            System.arraycopy(array2, 0, t, 0, array2.length);
            return t;
        }
        return array2;
    }

    public static <K> K[] grow(K[] array2, int length, int preserve) {
        if (length > array2.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array2.length, (long)length), 0x7FFFFFF7L);
            K[] t = ObjectArrays.newArray(array2, newLength);
            System.arraycopy(array2, 0, t, 0, preserve);
            return t;
        }
        return array2;
    }

    public static <K> K[] trim(K[] array2, int length) {
        if (length >= array2.length) {
            return array2;
        }
        K[] t = ObjectArrays.newArray(array2, length);
        System.arraycopy(array2, 0, t, 0, length);
        return t;
    }

    public static <K> K[] setLength(K[] array2, int length) {
        if (length == array2.length) {
            return array2;
        }
        if (length < array2.length) {
            return ObjectArrays.trim(array2, length);
        }
        return ObjectArrays.ensureCapacity(array2, length);
    }

    public static <K> K[] copy(K[] array2, int offset, int length) {
        ObjectArrays.ensureOffsetLength(array2, offset, length);
        K[] a = ObjectArrays.newArray(array2, length);
        System.arraycopy(array2, offset, a, 0, length);
        return a;
    }

    public static <K> K[] copy(K[] array2) {
        return (Object[])array2.clone();
    }

    public static <K> void fill(K[] array2, K value2) {
        int i = array2.length;
        while (i-- != 0) {
            array2[i] = value2;
        }
    }

    public static <K> void fill(K[] array2, int from2, int to2, K value2) {
        ObjectArrays.ensureFromTo(array2, from2, to2);
        if (from2 == 0) {
            while (to2-- != 0) {
                array2[to2] = value2;
            }
        } else {
            for (int i = from2; i < to2; ++i) {
                array2[i] = value2;
            }
        }
    }

    @Deprecated
    public static <K> boolean equals(K[] a1, K[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] != null ? a1[i].equals(a2[i]) : a2[i] == null) continue;
            return false;
        }
        return true;
    }

    public static <K> void ensureFromTo(K[] a, int from2, int to2) {
        Arrays.ensureFromTo(a.length, from2, to2);
    }

    public static <K> void ensureOffsetLength(K[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static <K> void swap(K[] x, int a, int b) {
        K t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static <K> void vecSwap(K[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ObjectArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static <K> int med3(K[] x, int a, int b, int c, Comparator<K> comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static <K> void selectionSort(K[] a, int from2, int to2, Comparator<K> comp) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to2; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            K u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static <K> void insertionSort(K[] a, int from2, int to2, Comparator<K> comp) {
        int i = from2;
        while (++i < to2) {
            K t = a[i];
            int j = i;
            K u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    private static <K> void selectionSort(K[] a, int from2, int to2) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to2; ++j) {
                if (((Comparable)a[j]).compareTo(a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            K u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static <K> void insertionSort(K[] a, int from2, int to2) {
        int i = from2;
        while (++i < to2) {
            K t = a[i];
            int j = i;
            K u = a[j - 1];
            while (((Comparable)t).compareTo(u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static <K> void quickSort(K[] x, int from2, int to2, Comparator<K> comp) {
        int c;
        int a;
        int len = to2 - from2;
        if (len < 7) {
            ObjectArrays.selectionSort(x, from2, to2, comp);
            return;
        }
        int m = from2 + len / 2;
        if (len > 7) {
            int l = from2;
            int n = to2 - 1;
            if (len > 50) {
                int s2 = len / 8;
                l = ObjectArrays.med3(x, l, l + s2, l + 2 * s2, comp);
                m = ObjectArrays.med3(x, m - s2, m, m + s2, comp);
                n = ObjectArrays.med3(x, n - 2 * s2, n - s2, n, comp);
            }
            m = ObjectArrays.med3(x, l, m, n, comp);
        }
        K v = x[m];
        int b = a = from2;
        int d = c = to2 - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ObjectArrays.swap(x, b++, c--);
        }
        int n = to2;
        int s3 = Math.min(a - from2, b - a);
        ObjectArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1);
        ObjectArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            ObjectArrays.quickSort(x, from2, from2 + s3, comp);
        }
        if ((s3 = d - c) > 1) {
            ObjectArrays.quickSort(x, n - s3, n, comp);
        }
    }

    public static <K> void quickSort(K[] x, Comparator<K> comp) {
        ObjectArrays.quickSort(x, 0, x.length, comp);
    }

    private static <K> int med3(K[] x, int a, int b, int c) {
        int ab = ((Comparable)x[a]).compareTo(x[b]);
        int ac = ((Comparable)x[a]).compareTo(x[c]);
        int bc = ((Comparable)x[b]).compareTo(x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    @Deprecated
    public static <K> void quickSort(K[] x, int from2, int to2) {
        int c;
        int a;
        int len = to2 - from2;
        if (len < 7) {
            ObjectArrays.selectionSort(x, from2, to2);
            return;
        }
        int m = from2 + len / 2;
        if (len > 7) {
            int l = from2;
            int n = to2 - 1;
            if (len > 50) {
                int s2 = len / 8;
                l = ObjectArrays.med3(x, l, l + s2, l + 2 * s2);
                m = ObjectArrays.med3(x, m - s2, m, m + s2);
                n = ObjectArrays.med3(x, n - 2 * s2, n - s2, n);
            }
            m = ObjectArrays.med3(x, l, m, n);
        }
        K v = x[m];
        int b = a = from2;
        int d = c = to2 - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = ((Comparable)x[b]).compareTo(v)) <= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = ((Comparable)x[c]).compareTo(v)) >= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ObjectArrays.swap(x, b++, c--);
        }
        int n = to2;
        int s3 = Math.min(a - from2, b - a);
        ObjectArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1);
        ObjectArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            ObjectArrays.quickSort(x, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1) {
            ObjectArrays.quickSort(x, n - s3, n);
        }
    }

    @Deprecated
    public static <K> void quickSort(K[] x) {
        ObjectArrays.quickSort(x, 0, x.length);
    }

    public static <K> void mergeSort(K[] a, int from2, int to2, K[] supp) {
        int len = to2 - from2;
        if (len < 7) {
            ObjectArrays.insertionSort(a, from2, to2);
            return;
        }
        int mid = from2 + to2 >>> 1;
        ObjectArrays.mergeSort(supp, from2, mid, a);
        ObjectArrays.mergeSort(supp, mid, to2, a);
        if (((Comparable)supp[mid - 1]).compareTo(supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to2; ++i) {
            a[i] = q >= to2 || p < mid && ((Comparable)supp[p]).compareTo(supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static <K> void mergeSort(K[] a, int from2, int to2) {
        ObjectArrays.mergeSort(a, from2, to2, (Object[])a.clone());
    }

    public static <K> void mergeSort(K[] a) {
        ObjectArrays.mergeSort(a, 0, a.length);
    }

    public static <K> void mergeSort(K[] a, int from2, int to2, Comparator<K> comp, K[] supp) {
        int len = to2 - from2;
        if (len < 7) {
            ObjectArrays.insertionSort(a, from2, to2, comp);
            return;
        }
        int mid = from2 + to2 >>> 1;
        ObjectArrays.mergeSort(supp, from2, mid, comp, a);
        ObjectArrays.mergeSort(supp, mid, to2, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to2; ++i) {
            a[i] = q >= to2 || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static <K> void mergeSort(K[] a, int from2, int to2, Comparator<K> comp) {
        ObjectArrays.mergeSort(a, from2, to2, comp, (Object[])a.clone());
    }

    public static <K> void mergeSort(K[] a, Comparator<K> comp) {
        ObjectArrays.mergeSort(a, 0, a.length, comp);
    }

    public static <K> int binarySearch(K[] a, int from2, int to2, K key) {
        --to2;
        while (from2 <= to2) {
            int mid = from2 + to2 >>> 1;
            K midVal = a[mid];
            int cmp = ((Comparable)midVal).compareTo(key);
            if (cmp < 0) {
                from2 = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to2 = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from2 + 1);
    }

    public static <K> int binarySearch(K[] a, K key) {
        return ObjectArrays.binarySearch(a, 0, a.length, key);
    }

    public static <K> int binarySearch(K[] a, int from2, int to2, K key, Comparator<K> c) {
        --to2;
        while (from2 <= to2) {
            int mid = from2 + to2 >>> 1;
            K midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from2 = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to2 = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from2 + 1);
    }

    public static <K> int binarySearch(K[] a, K key, Comparator<K> c) {
        return ObjectArrays.binarySearch(a, 0, a.length, key, c);
    }

    public static <K> K[] shuffle(K[] a, int from2, int to2, Random random) {
        int i = to2 - from2;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            K t = a[from2 + i];
            a[from2 + i] = a[from2 + p];
            a[from2 + p] = t;
        }
        return a;
    }

    public static <K> K[] shuffle(K[] a, Random random) {
        int i = a.length;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            K t = a[i];
            a[i] = a[p];
            a[p] = t;
        }
        return a;
    }

    public static <K> K[] reverse(K[] a) {
        int length = a.length;
        int i = length / 2;
        while (i-- != 0) {
            K t = a[length - i - 1];
            a[length - i - 1] = a[i];
            a[i] = t;
        }
        return a;
    }

    private static final class ArrayHashStrategy<K>
    implements Hash.Strategy<K[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(K[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(K[] a, K[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

