/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.it.unimi.dsi.fastutil.longs;

import java.io.Serializable;
import java.util.Random;
import org.apache.parquet.it.unimi.dsi.fastutil.Arrays;
import org.apache.parquet.it.unimi.dsi.fastutil.Hash;
import org.apache.parquet.it.unimi.dsi.fastutil.ints.IntArrays;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongComparator;

public class LongArrays {
    public static final long[] EMPTY_ARRAY = new long[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 8;
    public static final Hash.Strategy<long[]> HASH_STRATEGY = new ArrayHashStrategy();

    private LongArrays() {
    }

    public static long[] ensureCapacity(long[] array2, int length) {
        if (length > array2.length) {
            long[] t = new long[length];
            System.arraycopy(array2, 0, t, 0, array2.length);
            return t;
        }
        return array2;
    }

    public static long[] ensureCapacity(long[] array2, int length, int preserve) {
        if (length > array2.length) {
            long[] t = new long[length];
            System.arraycopy(array2, 0, t, 0, preserve);
            return t;
        }
        return array2;
    }

    public static long[] grow(long[] array2, int length) {
        if (length > array2.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array2.length, (long)length), 0x7FFFFFF7L);
            long[] t = new long[newLength];
            System.arraycopy(array2, 0, t, 0, array2.length);
            return t;
        }
        return array2;
    }

    public static long[] grow(long[] array2, int length, int preserve) {
        if (length > array2.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array2.length, (long)length), 0x7FFFFFF7L);
            long[] t = new long[newLength];
            System.arraycopy(array2, 0, t, 0, preserve);
            return t;
        }
        return array2;
    }

    public static long[] trim(long[] array2, int length) {
        if (length >= array2.length) {
            return array2;
        }
        long[] t = length == 0 ? EMPTY_ARRAY : new long[length];
        System.arraycopy(array2, 0, t, 0, length);
        return t;
    }

    public static long[] setLength(long[] array2, int length) {
        if (length == array2.length) {
            return array2;
        }
        if (length < array2.length) {
            return LongArrays.trim(array2, length);
        }
        return LongArrays.ensureCapacity(array2, length);
    }

    public static long[] copy(long[] array2, int offset, int length) {
        LongArrays.ensureOffsetLength(array2, offset, length);
        long[] a = length == 0 ? EMPTY_ARRAY : new long[length];
        System.arraycopy(array2, offset, a, 0, length);
        return a;
    }

    public static long[] copy(long[] array2) {
        return (long[])array2.clone();
    }

    public static void fill(long[] array2, long value2) {
        int i = array2.length;
        while (i-- != 0) {
            array2[i] = value2;
        }
    }

    public static void fill(long[] array2, int from2, int to2, long value2) {
        LongArrays.ensureFromTo(array2, from2, to2);
        if (from2 == 0) {
            while (to2-- != 0) {
                array2[to2] = value2;
            }
        } else {
            for (int i = from2; i < to2; ++i) {
                array2[i] = value2;
            }
        }
    }

    @Deprecated
    public static boolean equals(long[] a1, long[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(long[] a, int from2, int to2) {
        Arrays.ensureFromTo(a.length, from2, to2);
    }

    public static void ensureOffsetLength(long[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static void swap(long[] x, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecSwap(long[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            LongArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(long[] x, int a, int b, int c, LongComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(long[] a, int from2, int to2, LongComparator comp) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to2; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            long u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(long[] a, int from2, int to2, LongComparator comp) {
        int i = from2;
        while (++i < to2) {
            long t = a[i];
            int j = i;
            long u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    private static void selectionSort(long[] a, int from2, int to2) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to2; ++j) {
                if (a[j] >= a[m]) continue;
                m = j;
            }
            if (m == i) continue;
            long u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(long[] a, int from2, int to2) {
        int i = from2;
        while (++i < to2) {
            long t = a[i];
            int j = i;
            long u = a[j - 1];
            while (t < u) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(long[] x, int from2, int to2, LongComparator comp) {
        int c;
        int a;
        int len = to2 - from2;
        if (len < 7) {
            LongArrays.selectionSort(x, from2, to2, comp);
            return;
        }
        int m = from2 + len / 2;
        if (len > 7) {
            int l = from2;
            int n = to2 - 1;
            if (len > 50) {
                int s2 = len / 8;
                l = LongArrays.med3(x, l, l + s2, l + 2 * s2, comp);
                m = LongArrays.med3(x, m - s2, m, m + s2, comp);
                n = LongArrays.med3(x, n - 2 * s2, n - s2, n, comp);
            }
            m = LongArrays.med3(x, l, m, n, comp);
        }
        long v = x[m];
        int b = a = from2;
        int d = c = to2 - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongArrays.swap(x, b++, c--);
        }
        int n = to2;
        int s3 = Math.min(a - from2, b - a);
        LongArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1);
        LongArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            LongArrays.quickSort(x, from2, from2 + s3, comp);
        }
        if ((s3 = d - c) > 1) {
            LongArrays.quickSort(x, n - s3, n, comp);
        }
    }

    public static void quickSort(long[] x, LongComparator comp) {
        LongArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(long[] x, int a, int b, int c) {
        int bc;
        int ac;
        int ab;
        int n = x[a] < x[b] ? -1 : (ab = x[a] == x[b] ? 0 : 1);
        int n2 = x[a] < x[c] ? -1 : (ac = x[a] == x[c] ? 0 : 1);
        int n3 = x[b] < x[c] ? -1 : (bc = x[b] == x[c] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    @Deprecated
    public static void quickSort(long[] x, int from2, int to2) {
        int c;
        int a;
        int len = to2 - from2;
        if (len < 7) {
            LongArrays.selectionSort(x, from2, to2);
            return;
        }
        int m = from2 + len / 2;
        if (len > 7) {
            int l = from2;
            int n = to2 - 1;
            if (len > 50) {
                int s2 = len / 8;
                l = LongArrays.med3(x, l, l + s2, l + 2 * s2);
                m = LongArrays.med3(x, m - s2, m, m + s2);
                n = LongArrays.med3(x, n - 2 * s2, n - s2, n);
            }
            m = LongArrays.med3(x, l, m, n);
        }
        long v = x[m];
        int b = a = from2;
        int d = c = to2 - 1;
        while (true) {
            int comparison;
            if (b <= c && (x[b] < v ? -1 : (comparison = x[b] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (x[c] < v ? -1 : (comparison = x[c] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongArrays.swap(x, b++, c--);
        }
        int n = to2;
        int s3 = Math.min(a - from2, b - a);
        LongArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1);
        LongArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            LongArrays.quickSort(x, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1) {
            LongArrays.quickSort(x, n - s3, n);
        }
    }

    @Deprecated
    public static void quickSort(long[] x) {
        LongArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(long[] a, int from2, int to2, long[] supp) {
        int len = to2 - from2;
        if (len < 7) {
            LongArrays.insertionSort(a, from2, to2);
            return;
        }
        int mid = from2 + to2 >>> 1;
        LongArrays.mergeSort(supp, from2, mid, a);
        LongArrays.mergeSort(supp, mid, to2, a);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to2; ++i) {
            a[i] = q >= to2 || p < mid && supp[p] <= supp[q] ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(long[] a, int from2, int to2) {
        LongArrays.mergeSort(a, from2, to2, (long[])a.clone());
    }

    public static void mergeSort(long[] a) {
        LongArrays.mergeSort(a, 0, a.length);
    }

    public static void mergeSort(long[] a, int from2, int to2, LongComparator comp, long[] supp) {
        int len = to2 - from2;
        if (len < 7) {
            LongArrays.insertionSort(a, from2, to2, comp);
            return;
        }
        int mid = from2 + to2 >>> 1;
        LongArrays.mergeSort(supp, from2, mid, comp, a);
        LongArrays.mergeSort(supp, mid, to2, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to2; ++i) {
            a[i] = q >= to2 || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(long[] a, int from2, int to2, LongComparator comp) {
        LongArrays.mergeSort(a, from2, to2, comp, (long[])a.clone());
    }

    public static void mergeSort(long[] a, LongComparator comp) {
        LongArrays.mergeSort(a, 0, a.length, comp);
    }

    public static int binarySearch(long[] a, int from2, int to2, long key) {
        --to2;
        while (from2 <= to2) {
            int mid = from2 + to2 >>> 1;
            long midVal = a[mid];
            if (midVal < key) {
                from2 = mid + 1;
                continue;
            }
            if (midVal > key) {
                to2 = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from2 + 1);
    }

    public static int binarySearch(long[] a, long key) {
        return LongArrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(long[] a, int from2, int to2, long key, LongComparator c) {
        --to2;
        while (from2 <= to2) {
            int mid = from2 + to2 >>> 1;
            long midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from2 = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to2 = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from2 + 1);
    }

    public static int binarySearch(long[] a, long key, LongComparator c) {
        return LongArrays.binarySearch(a, 0, a.length, key, c);
    }

    public static void radixSort(long[] a) {
        LongArrays.radixSort(a, 0, a.length);
    }

    public static void radixSort(long[] a, int from2, int to2) {
        int maxLevel = 7;
        int stackSize = 1786;
        int[] offsetStack = new int[1786];
        int offsetPos = 0;
        int[] lengthStack = new int[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        byte[] digit2 = new byte[to2 - from2];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first2 = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                LongArrays.selectionSort(a, first2, first2 + length);
                continue;
            }
            int shift = (7 - level % 8) * 8;
            int i = length;
            while (i-- != 0) {
                digit2[i] = (byte)(a[first2 + i] >>> shift & 0xFFL ^ (long)signMask);
            }
            i = length;
            while (i-- != 0) {
                int n2 = digit2[i] & 0xFF;
                count2[n2] = count2[n2] + 1;
            }
            int lastUsed = -1;
            int p = 0;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                    if (level < 7 && count2[i2] > 1) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count2[i2];
            }
            int end = length - count2[lastUsed];
            count2[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count2[c]) {
                long t = a[i3 + first2];
                c = digit2[i3] & 0xFF;
                while (true) {
                    int n3 = c;
                    int n4 = pos[n3] - 1;
                    pos[n3] = n4;
                    int d = n4;
                    if (n4 <= i3) break;
                    long z2 = t;
                    int zz = c;
                    t = a[d + first2];
                    c = digit2[d] & 0xFF;
                    a[d + first2] = z2;
                    digit2[d] = (byte)zz;
                }
                a[i3 + first2] = t;
                count2[c] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, long[] a, int from2, int to2) {
        int i = from2;
        while (++i < to2) {
            int t = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (a[t] < a[u]) {
                perm[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, long[] a, boolean stable) {
        LongArrays.radixSortIndirect(perm, a, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, long[] a, int from2, int to2, boolean stable) {
        int maxLevel = 7;
        int stackSize = 1786;
        int[] offsetStack = new int[1786];
        int offsetPos = 0;
        int[] lengthStack = new int[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit2 = new byte[to2 - from2];
        while (offsetPos > 0) {
            int i;
            int level;
            int signMask;
            int first2 = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                LongArrays.insertionSortIndirect(perm, a, first2, first2 + length);
                continue;
            }
            int shift = (7 - level % 8) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit2[i2] = (byte)(a[perm[first2 + i2]] >>> shift & 0xFFL ^ (long)signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n2 = digit2[i2] & 0xFF;
                count2[n2] = count2[n2] + 1;
            }
            int lastUsed = -1;
            int p = 0;
            for (i = 0; i < 256; ++i) {
                if (count2[i] != 0) {
                    lastUsed = i;
                    if (level < 7 && count2[i] > 1) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count2[i] = p += count2[i];
                    continue;
                }
                pos[i] = p += count2[i];
            }
            if (stable) {
                i = length;
                while (i-- != 0) {
                    int n3 = digit2[i] & 0xFF;
                    int n4 = count2[n3] - 1;
                    count2[n3] = n4;
                    support[n4] = perm[first2 + i];
                }
                System.arraycopy(support, 0, perm, first2, length);
                IntArrays.fill(count2, 0);
                continue;
            }
            int end = length - count2[lastUsed];
            count2[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count2[c]) {
                int t = perm[i3 + first2];
                c = digit2[i3] & 0xFF;
                while (true) {
                    int n5 = c;
                    int n6 = pos[n5] - 1;
                    pos[n5] = n6;
                    int d = n6;
                    if (n6 <= i3) break;
                    int z2 = t;
                    int zz = c;
                    t = perm[d + first2];
                    c = digit2[d] & 0xFF;
                    perm[d + first2] = z2;
                    digit2[d] = (byte)zz;
                }
                perm[i3 + first2] = t;
                count2[c] = 0;
            }
        }
    }

    private static void selectionSort(long[] a, long[] b, int from2, int to2) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to2; ++j) {
                if (a[j] >= a[m] && (a[j] != a[m] || b[j] >= b[m])) continue;
                m = j;
            }
            if (m == i) continue;
            long t = a[i];
            a[i] = a[m];
            a[m] = t;
            t = b[i];
            b[i] = b[m];
            b[m] = t;
        }
    }

    public static void radixSort(long[] a, long[] b) {
        LongArrays.radixSort(a, b, 0, a.length);
    }

    public static void radixSort(long[] a, long[] b, int from2, int to2) {
        int layers = 2;
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 15;
        int stackSize = 3826;
        int[] offsetStack = new int[3826];
        int offsetPos = 0;
        int[] lengthStack = new int[3826];
        int lengthPos = 0;
        int[] levelStack = new int[3826];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        byte[] digit2 = new byte[to2 - from2];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first2 = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                LongArrays.selectionSort(a, b, first2, first2 + length);
                continue;
            }
            long[] k = level < 8 ? a : b;
            int shift = (7 - level % 8) * 8;
            int i = length;
            while (i-- != 0) {
                digit2[i] = (byte)(k[first2 + i] >>> shift & 0xFFL ^ (long)signMask);
            }
            i = length;
            while (i-- != 0) {
                int n2 = digit2[i] & 0xFF;
                count2[n2] = count2[n2] + 1;
            }
            int lastUsed = -1;
            int p = 0;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                    if (level < 15 && count2[i2] > 1) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count2[i2];
            }
            int end = length - count2[lastUsed];
            count2[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count2[c]) {
                long t = a[i3 + first2];
                long u = b[i3 + first2];
                c = digit2[i3] & 0xFF;
                while (true) {
                    int n3 = c;
                    int n4 = pos[n3] - 1;
                    pos[n3] = n4;
                    int d = n4;
                    if (n4 <= i3) break;
                    long z2 = t;
                    int zz = c;
                    t = a[d + first2];
                    a[d + first2] = z2;
                    z2 = u;
                    u = b[d + first2];
                    b[d + first2] = z2;
                    c = digit2[d] & 0xFF;
                    digit2[d] = (byte)zz;
                }
                a[i3 + first2] = t;
                b[i3 + first2] = u;
                count2[c] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, long[] a, long[] b, int from2, int to2) {
        int i = from2;
        while (++i < to2) {
            int t = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (a[t] < a[u] || a[t] == a[u] && b[t] < b[u]) {
                perm[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, long[] a, long[] b, boolean stable) {
        LongArrays.radixSortIndirect(perm, a, b, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, long[] a, long[] b, int from2, int to2, boolean stable) {
        int layers = 2;
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 15;
        int stackSize = 3826;
        int[] offsetStack = new int[3826];
        int offsetPos = 0;
        int[] lengthStack = new int[3826];
        int lengthPos = 0;
        int[] levelStack = new int[3826];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit2 = new byte[to2 - from2];
        while (offsetPos > 0) {
            int i;
            int level;
            int signMask;
            int first2 = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                LongArrays.insertionSortIndirect(perm, a, b, first2, first2 + length);
                continue;
            }
            long[] k = level < 8 ? a : b;
            int shift = (7 - level % 8) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit2[i2] = (byte)(k[perm[first2 + i2]] >>> shift & 0xFFL ^ (long)signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n2 = digit2[i2] & 0xFF;
                count2[n2] = count2[n2] + 1;
            }
            int lastUsed = -1;
            int p = 0;
            for (i = 0; i < 256; ++i) {
                if (count2[i] != 0) {
                    lastUsed = i;
                    if (level < 15 && count2[i] > 1) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count2[i] = p += count2[i];
                    continue;
                }
                pos[i] = p += count2[i];
            }
            if (stable) {
                i = length;
                while (i-- != 0) {
                    int n3 = digit2[i] & 0xFF;
                    int n4 = count2[n3] - 1;
                    count2[n3] = n4;
                    support[n4] = perm[first2 + i];
                }
                System.arraycopy(support, 0, perm, first2, length);
                IntArrays.fill(count2, 0);
                continue;
            }
            int end = length - count2[lastUsed];
            count2[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count2[c]) {
                int t = perm[i3 + first2];
                c = digit2[i3] & 0xFF;
                while (true) {
                    int n5 = c;
                    int n6 = pos[n5] - 1;
                    pos[n5] = n6;
                    int d = n6;
                    if (n6 <= i3) break;
                    int z2 = t;
                    int zz = c;
                    t = perm[d + first2];
                    c = digit2[d] & 0xFF;
                    perm[d + first2] = z2;
                    digit2[d] = (byte)zz;
                }
                perm[i3 + first2] = t;
                count2[c] = 0;
            }
        }
    }

    private static void selectionSort(long[][] a, int from2, int to2, int level) {
        int layers = a.length;
        int firstLayer = level / 8;
        for (int i = from2; i < to2 - 1; ++i) {
            int m = i;
            block1: for (int j = i + 1; j < to2; ++j) {
                for (int p = firstLayer; p < layers; ++p) {
                    if (a[p][j] < a[p][m]) {
                        m = j;
                        continue block1;
                    }
                    if (a[p][j] > a[p][m]) continue block1;
                }
            }
            if (m == i) continue;
            int p = layers;
            while (p-- != 0) {
                long u = a[p][i];
                a[p][i] = a[p][m];
                a[p][m] = u;
            }
        }
    }

    public static void radixSort(long[][] a) {
        LongArrays.radixSort(a, 0, a[0].length);
    }

    public static void radixSort(long[][] a, int from2, int to2) {
        int layers = a.length;
        int maxLevel = 8 * layers - 1;
        int p = layers;
        int l = a[0].length;
        while (p-- != 0) {
            if (a[p].length == l) continue;
            throw new IllegalArgumentException("The array of index " + p + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 8 - 1) + 1;
        int[] offsetStack = new int[stackSize];
        int offsetPos = 0;
        int[] lengthStack = new int[stackSize];
        int lengthPos = 0;
        int[] levelStack = new int[stackSize];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        byte[] digit2 = new byte[to2 - from2];
        long[] t = new long[layers];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first2 = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                LongArrays.selectionSort(a, first2, first2 + length, level);
                continue;
            }
            long[] k = a[level / 8];
            int shift = (7 - level % 8) * 8;
            int i = length;
            while (i-- != 0) {
                digit2[i] = (byte)(k[first2 + i] >>> shift & 0xFFL ^ (long)signMask);
            }
            i = length;
            while (i-- != 0) {
                int n2 = digit2[i] & 0xFF;
                count2[n2] = count2[n2] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                    if (level < maxLevel && count2[i2] > 1) {
                        offsetStack[offsetPos++] = p2 + first2;
                        lengthStack[lengthPos++] = count2[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p2 += count2[i2];
            }
            int end = length - count2[lastUsed];
            count2[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count2[c]) {
                int p3 = layers;
                while (p3-- != 0) {
                    t[p3] = a[p3][i3 + first2];
                }
                c = digit2[i3] & 0xFF;
                while (true) {
                    int n3 = c;
                    int n4 = pos[n3] - 1;
                    pos[n3] = n4;
                    int d = n4;
                    if (n4 <= i3) break;
                    p3 = layers;
                    while (p3-- != 0) {
                        long u = t[p3];
                        t[p3] = a[p3][d + first2];
                        a[p3][d + first2] = u;
                    }
                    int zz = c;
                    c = digit2[d] & 0xFF;
                    digit2[d] = (byte)zz;
                }
                p3 = layers;
                while (p3-- != 0) {
                    a[p3][i3 + first2] = t[p3];
                }
                count2[c] = 0;
            }
        }
    }

    public static long[] shuffle(long[] a, int from2, int to2, Random random) {
        int i = to2 - from2;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            long t = a[from2 + i];
            a[from2 + i] = a[from2 + p];
            a[from2 + p] = t;
        }
        return a;
    }

    public static long[] shuffle(long[] a, Random random) {
        int i = a.length;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            long t = a[i];
            a[i] = a[p];
            a[p] = t;
        }
        return a;
    }

    public static long[] reverse(long[] a) {
        int length = a.length;
        int i = length / 2;
        while (i-- != 0) {
            long t = a[length - i - 1];
            a[length - i - 1] = a[i];
            a[i] = t;
        }
        return a;
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<long[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(long[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(long[] a, long[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

