/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.it.unimi.dsi.fastutil.longs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.apache.parquet.it.unimi.dsi.fastutil.Arrays;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.AbstractLongList;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.AbstractLongListIterator;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongArrays;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongCollection;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongIterator;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongIterators;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongList;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongListIterator;

public class LongArrayList
extends AbstractLongList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected transient long[] a;
    protected int size;
    private static final boolean ASSERTS = false;

    protected LongArrayList(long[] a, boolean dummy) {
        this.a = a;
    }

    public LongArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = new long[capacity];
    }

    public LongArrayList() {
        this(16);
    }

    public LongArrayList(Collection<? extends Long> c) {
        this(c.size());
        this.size = LongIterators.unwrap(LongIterators.asLongIterator(c.iterator()), this.a);
    }

    public LongArrayList(LongCollection c) {
        this(c.size());
        this.size = LongIterators.unwrap(c.iterator(), this.a);
    }

    public LongArrayList(LongList l) {
        this(l.size());
        this.size = l.size();
        l.getElements(0, this.a, 0, this.size);
    }

    public LongArrayList(long[] a) {
        this(a, 0, a.length);
    }

    public LongArrayList(long[] a, int offset, int length) {
        this(length);
        System.arraycopy(a, offset, this.a, 0, length);
        this.size = length;
    }

    public LongArrayList(Iterator<? extends Long> i) {
        this();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public LongArrayList(LongIterator i) {
        this();
        while (i.hasNext()) {
            this.add(i.nextLong());
        }
    }

    public long[] elements() {
        return this.a;
    }

    public static LongArrayList wrap(long[] a, int length) {
        if (length > a.length) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a.length + ")");
        }
        LongArrayList l = new LongArrayList(a, false);
        l.size = length;
        return l;
    }

    public static LongArrayList wrap(long[] a) {
        return LongArrayList.wrap(a, a.length);
    }

    public void ensureCapacity(int capacity) {
        this.a = LongArrays.ensureCapacity(this.a, capacity, this.size);
    }

    private void grow(int capacity) {
        this.a = LongArrays.grow(this.a, capacity, this.size);
    }

    @Override
    public void add(int index2, long k) {
        this.ensureIndex(index2);
        this.grow(this.size + 1);
        if (index2 != this.size) {
            System.arraycopy(this.a, index2, this.a, index2 + 1, this.size - index2);
        }
        this.a[index2] = k;
        ++this.size;
    }

    @Override
    public boolean add(long k) {
        this.grow(this.size + 1);
        this.a[this.size++] = k;
        return true;
    }

    @Override
    public long getLong(int index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index2];
    }

    @Override
    public int indexOf(long k) {
        for (int i = 0; i < this.size; ++i) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long k) {
        int i = this.size;
        while (i-- != 0) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public long removeLong(int index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        long old = this.a[index2];
        --this.size;
        if (index2 != this.size) {
            System.arraycopy(this.a, index2 + 1, this.a, index2, this.size - index2);
        }
        return old;
    }

    @Override
    public boolean rem(long k) {
        int index2 = this.indexOf(k);
        if (index2 == -1) {
            return false;
        }
        this.removeLong(index2);
        return true;
    }

    @Override
    public long set(int index2, long k) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        long old = this.a[index2];
        this.a[index2] = k;
        return old;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void size(int size2) {
        if (size2 > this.a.length) {
            this.ensureCapacity(size2);
        }
        if (size2 > this.size) {
            LongArrays.fill(this.a, this.size, size2, 0L);
        }
        this.size = size2;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int n) {
        if (n >= this.a.length || this.size == this.a.length) {
            return;
        }
        long[] t = new long[Math.max(n, this.size)];
        System.arraycopy(this.a, 0, t, 0, this.size);
        this.a = t;
    }

    @Override
    public void getElements(int from2, long[] a, int offset, int length) {
        LongArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from2, a, offset, length);
    }

    @Override
    public void removeElements(int from2, int to2) {
        Arrays.ensureFromTo(this.size, from2, to2);
        System.arraycopy(this.a, to2, this.a, from2, this.size - to2);
        this.size -= to2 - from2;
    }

    @Override
    public void addElements(int index2, long[] a, int offset, int length) {
        this.ensureIndex(index2);
        LongArrays.ensureOffsetLength(a, offset, length);
        this.grow(this.size + length);
        System.arraycopy(this.a, index2, this.a, index2 + length, this.size - index2);
        System.arraycopy(a, offset, this.a, index2, length);
        this.size += length;
    }

    @Override
    public long[] toLongArray(long[] a) {
        if (a == null || a.length < this.size) {
            a = new long[this.size];
        }
        System.arraycopy(this.a, 0, a, 0, this.size);
        return a;
    }

    @Override
    public boolean addAll(int index2, LongCollection c) {
        this.ensureIndex(index2);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        if (index2 != this.size) {
            System.arraycopy(this.a, index2, this.a, index2 + n, this.size - index2);
        }
        LongIterator i = c.iterator();
        this.size += n;
        while (n-- != 0) {
            this.a[index2++] = i.nextLong();
        }
        return true;
    }

    @Override
    public boolean addAll(int index2, LongList l) {
        this.ensureIndex(index2);
        int n = l.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        if (index2 != this.size) {
            System.arraycopy(this.a, index2, this.a, index2 + n, this.size - index2);
        }
        l.getElements(0, this.a, index2, n);
        this.size += n;
        return true;
    }

    @Override
    public LongListIterator listIterator(final int index2) {
        this.ensureIndex(index2);
        return new AbstractLongListIterator(){
            int pos;
            int last;
            {
                this.pos = index2;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < LongArrayList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return LongArrayList.this.a[this.last];
            }

            @Override
            public long previousLong() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return LongArrayList.this.a[this.pos];
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(long k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                LongArrayList.this.add(this.pos++, k);
                this.last = -1;
            }

            @Override
            public void set(long k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                LongArrayList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                LongArrayList.this.removeLong(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public LongArrayList clone() {
        LongArrayList c = new LongArrayList(this.size);
        System.arraycopy(this.a, 0, c.a, 0, this.size);
        c.size = this.size;
        return c;
    }

    public boolean equals(LongArrayList l) {
        if (l == this) {
            return true;
        }
        int s2 = this.size();
        if (s2 != l.size()) {
            return false;
        }
        long[] a1 = this.a;
        long[] a2 = l.a;
        while (s2-- != 0) {
            if (a1[s2] == a2[s2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(LongArrayList l) {
        int i;
        int s1 = this.size();
        int s2 = l.size();
        long[] a1 = this.a;
        long[] a2 = l.a;
        for (i = 0; i < s1 && i < s2; ++i) {
            int r;
            long e1 = a1[i];
            long e2 = a2[i];
            if ((e1 < e2 ? -1 : (r = e1 == e2 ? 0 : 1)) == 0) continue;
            return r;
        }
        return i < s2 ? -1 : (i < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            s2.writeLong(this.a[i]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.a[i] = s2.readLong();
        }
    }
}

